/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.saleorder;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.SystemParamUtil;

public class SaleReturnAmountHelper {
    public static Map<String, BigDecimal> getLineAmountMapBySaleQty(DynamicObject saleOrder, long srcBillEntryId, long retOrgId, long branchId, BigDecimal newValue) {
        DynamicObjectCollection goodsEntryEntity = saleOrder.getDynamicObjectCollection("goodsentryentity");
        DynamicObject goodsEntry = goodsEntryEntity.stream().filter(s -> CommonUtil.formatObejctToLong((Object)s.getPkValue()) == srcBillEntryId).findFirst().orElse(null);
        if (ObjectUtils.isEmpty((Object)goodsEntry)) {
            return null;
        }
        int amtPrecision = saleOrder.getInt("currencyid.amtprecision");
        return SaleReturnAmountHelper.getRowAmountMapBySaleQty(goodsEntry, retOrgId, branchId, newValue, amtPrecision);
    }

    public static Map<String, BigDecimal> getLineAmountMap(DynamicObject goodsEntry, long retOrgId, long branchId, String fieldName, BigDecimal newValue) {
        HashMap<String, BigDecimal> amountResult = new HashMap<String, BigDecimal>(16);
        boolean isPresent = goodsEntry.getBoolean("ispresent");
        if (isPresent) {
            return amountResult;
        }
        BigDecimal oneHundred = new BigDecimal(100);
        boolean isBook = goodsEntry.getBoolean("isbook");
        BigDecimal manualdiscount = goodsEntry.getBigDecimal("manualdiscount");
        BigDecimal promotiondiscount = goodsEntry.getBigDecimal("promotiondiscount");
        BigDecimal coupondiscount = goodsEntry.getBigDecimal("coupondiscount");
        BigDecimal integraldistamount = goodsEntry.getBigDecimal("integraldistamount");
        BigDecimal giftdiscountamount = goodsEntry.getBigDecimal("giftdiscountamount");
        BigDecimal stddiscountamount = goodsEntry.getBigDecimal("stddiscountamount");
        BigDecimal notincomedisamount = goodsEntry.getBigDecimal("notincomedisamount");
        BigDecimal ticketshareamount = goodsEntry.getBigDecimal("ticketshareamount");
        BigDecimal pushfinalamount = goodsEntry.getBigDecimal("pushfinalamount");
        BigDecimal retailPrice = goodsEntry.getBigDecimal("retailprice");
        BigDecimal discountprice = goodsEntry.getBigDecimal("discountprice");
        BigDecimal amount = goodsEntry.getBigDecimal("amount");
        BigDecimal balamount = goodsEntry.getBigDecimal("balamount");
        BigDecimal discountrate = goodsEntry.getBigDecimal("discountrate");
        BigDecimal finalpayment = goodsEntry.getBigDecimal("finalpayment");
        BigDecimal receivedfinalpayment = goodsEntry.getBigDecimal("receivedfinalpayment");
        BigDecimal norecefinalamount = goodsEntry.getBigDecimal("norecefinalamount");
        BigDecimal expectfinalamount = goodsEntry.getBigDecimal("expectfinalamount");
        BigDecimal receexpectfinalamount = goodsEntry.getBigDecimal("receexpectfinalamount");
        BigDecimal noreceexpectfinalamount = goodsEntry.getBigDecimal("noreceexpectfinalamount");
        BigDecimal deposit = goodsEntry.getBigDecimal("deposit");
        BigDecimal saleQty = goodsEntry.getBigDecimal("saleqty");
        BigDecimal mustretqty = goodsEntry.getBigDecimal("mustretqty");
        BigDecimal depositscale = BigDecimal.ZERO;
        BigDecimal finalpaymentscale = BigDecimal.ZERO;
        BigDecimal mustBalamount = BigDecimal.ZERO;
        switch (fieldName) {
            case "saleqty": {
                saleQty = newValue;
                balamount = discountprice.multiply(saleQty).setScale(2, RoundingMode.HALF_UP);
                amount = retailPrice.multiply(saleQty).setScale(2, RoundingMode.HALF_UP);
                break;
            }
            case "discountprice": {
                discountprice = newValue;
                balamount = discountprice.multiply(saleQty).setScale(2, RoundingMode.HALF_UP);
                stddiscountamount = amount.subtract(balamount).subtract(notincomedisamount).subtract(ticketshareamount).subtract(promotiondiscount);
                break;
            }
            case "stddiscountamount": {
                stddiscountamount = newValue;
                balamount = amount.subtract(notincomedisamount).subtract(stddiscountamount).subtract(ticketshareamount).subtract(promotiondiscount);
                break;
            }
            case "notincomedisamount": {
                notincomedisamount = newValue;
                balamount = amount.subtract(notincomedisamount).subtract(stddiscountamount).subtract(ticketshareamount).subtract(promotiondiscount);
                break;
            }
            case "discountrate": {
                discountrate = newValue;
                balamount = amount.multiply(discountrate).divide(oneHundred, 2, RoundingMode.HALF_UP);
                stddiscountamount = amount.subtract(balamount).subtract(notincomedisamount).subtract(ticketshareamount).subtract(promotiondiscount);
                break;
            }
            case "balamount": {
                balamount = newValue;
                stddiscountamount = amount.subtract(balamount).subtract(notincomedisamount).subtract(ticketshareamount).subtract(promotiondiscount);
                break;
            }
            case "deposit": {
                deposit = newValue;
                break;
            }
            case "depositscale": {
                depositscale = newValue;
                mustBalamount = balamount.subtract(manualdiscount);
                deposit = mustBalamount.multiply(depositscale).divide(oneHundred, 2, RoundingMode.HALF_UP);
                break;
            }
            case "manualdiscount": {
                manualdiscount = newValue;
                break;
            }
            case "ticketshareamount": {
                ticketshareamount = newValue;
                balamount = amount.subtract(notincomedisamount).subtract(stddiscountamount).subtract(ticketshareamount).subtract(promotiondiscount);
                break;
            }
            case "promotiondiscount": {
                promotiondiscount = newValue;
                balamount = amount.subtract(notincomedisamount).subtract(stddiscountamount).subtract(ticketshareamount).subtract(promotiondiscount);
                break;
            }
            case "coupondiscount": {
                coupondiscount = newValue;
                break;
            }
            case "integraldistamount": {
                integraldistamount = newValue;
                break;
            }
            case "giftdiscountamount": {
                giftdiscountamount = newValue;
                break;
            }
            case "finalpayment": {
                finalpayment = newValue;
                norecefinalamount = finalpayment.subtract(receivedfinalpayment);
                break;
            }
            case "finalpaymentscale": {
                finalpaymentscale = newValue;
                mustBalamount = balamount.subtract(manualdiscount);
                finalpayment = mustBalamount.multiply(finalpaymentscale).divide(oneHundred, 2, RoundingMode.HALF_UP);
                norecefinalamount = finalpayment.subtract(receivedfinalpayment);
                break;
            }
            case "expectfinalamount": {
                expectfinalamount = newValue;
                noreceexpectfinalamount = expectfinalamount.subtract(receexpectfinalamount);
                break;
            }
        }
        BigDecimal sumsharediscount = manualdiscount.add(promotiondiscount).add(coupondiscount).add(integraldistamount).add(giftdiscountamount);
        BigDecimal sumdiscountamount = stddiscountamount.add(notincomedisamount).add(promotiondiscount);
        mustBalamount = balamount.subtract(manualdiscount);
        if (isBook) {
            if (!fieldName.equalsIgnoreCase("depositscale")) {
                depositscale = BigDecimal.ZERO;
                depositscale = mustBalamount.compareTo(BigDecimal.ZERO) != 0 ? deposit.multiply(oneHundred).divide(mustBalamount, 2, RoundingMode.HALF_UP) : oneHundred;
            }
        } else if (!fieldName.equalsIgnoreCase("finalpaymentscale")) {
            finalpaymentscale = mustBalamount.compareTo(BigDecimal.ZERO) != 0 ? finalpayment.multiply(oneHundred).divide(mustBalamount, 2, RoundingMode.HALF_UP) : oneHundred;
        }
        if (!fieldName.equalsIgnoreCase("discountprice")) {
            discountprice = saleQty.compareTo(BigDecimal.ZERO) != 0 ? balamount.divide(saleQty, 2, RoundingMode.HALF_UP) : balamount;
        }
        if (!fieldName.equalsIgnoreCase("depositscale")) {
            if (amount.compareTo(BigDecimal.ZERO) != 0) {
                discountrate = balamount.multiply(oneHundred).divide(amount, 2, RoundingMode.HALF_UP);
            } else if (balamount.compareTo(BigDecimal.ZERO) != 0) {
                discountrate = oneHundred;
            }
        }
        if (!fieldName.equalsIgnoreCase("depositscale")) {
            if (mustBalamount.compareTo(BigDecimal.ZERO) != 0) {
                depositscale = deposit.multiply(oneHundred).divide(mustBalamount, 2, RoundingMode.HALF_UP);
            } else if (deposit.compareTo(BigDecimal.ZERO) != 0) {
                depositscale = oneHundred;
            }
        }
        amountResult.put("balamount", balamount);
        amountResult.put("realprice", discountprice);
        amountResult.put("realamount", balamount);
        amountResult.put("manualdiscount", manualdiscount);
        amountResult.put("coupondiscount", coupondiscount);
        amountResult.put("integraldistamount", integraldistamount);
        amountResult.put("promotiondiscount", promotiondiscount);
        amountResult.put("stddiscountamount", stddiscountamount);
        amountResult.put("notincomedisamount", notincomedisamount);
        amountResult.put("giftdiscountamount", giftdiscountamount);
        amountResult.put("ticketshareamount", ticketshareamount);
        amountResult.put("sumsharediscount", sumsharediscount);
        amountResult.put("sumdiscountamount", sumdiscountamount);
        amountResult.put("deposit", deposit);
        amountResult.put("depositscale", depositscale);
        amountResult.put("norecefinalamount", norecefinalamount);
        amountResult.put("noreceexpectfinalamount", noreceexpectfinalamount);
        amountResult.put("expectfinalamount", expectfinalamount);
        amountResult.put("discountprice", discountprice);
        amountResult.put("discountrate", discountrate);
        amountResult.put("amount", amount);
        amountResult.put("finalpayment", finalpayment);
        amountResult.put("finalpaymentscale", finalpaymentscale);
        amountResult.put("pushfinalamount", pushfinalamount);
        BigDecimal retQtyMustRetQtyRatio = BigDecimal.ZERO;
        if (mustretqty.compareTo(BigDecimal.ZERO) != 0) {
            retQtyMustRetQtyRatio = saleQty.divide(mustretqty, 8, RoundingMode.HALF_UP);
        }
        SaleReturnAmountHelper.getLineReceivableAmount(retOrgId, branchId, isBook, retQtyMustRetQtyRatio, amountResult);
        return amountResult;
    }

    private static Map<String, BigDecimal> getRowAmountMapBySaleQty(DynamicObject goodsEntry, long retOrgId, long branchId, BigDecimal returnQty, int amtPrecision) {
        BigDecimal norecefinalamount;
        HashMap<String, BigDecimal> amountResult = new HashMap<String, BigDecimal>(16);
        boolean isPresent = goodsEntry.getBoolean("ispresent");
        if (isPresent) {
            return amountResult;
        }
        BigDecimal retfinalpayment = BigDecimal.ZERO;
        BigDecimal retreceivedfinalpayment = BigDecimal.ZERO;
        BigDecimal retexpectfinalamount = BigDecimal.ZERO;
        BigDecimal retreceexpectfinalamount = BigDecimal.ZERO;
        boolean isBook = goodsEntry.getBoolean("isbook");
        BigDecimal saleQty = goodsEntry.getBigDecimal("saleqty");
        BigDecimal mustRetQty = goodsEntry.getBigDecimal("mustretqty");
        BigDecimal hasPushQty = saleQty.subtract(mustRetQty);
        BigDecimal retamount = goodsEntry.getBigDecimal("amount").negate();
        BigDecimal balamount = goodsEntry.getBigDecimal("balamount");
        BigDecimal retbalamount = hasPushQty.multiply(balamount).divide(saleQty, amtPrecision, RoundingMode.HALF_UP).subtract(balamount);
        BigDecimal realamount = goodsEntry.getBigDecimal("realamount");
        BigDecimal retrealamount = hasPushQty.multiply(realamount).divide(saleQty, amtPrecision, RoundingMode.HALF_UP).subtract(realamount);
        BigDecimal manualdiscount = goodsEntry.getBigDecimal("manualdiscount");
        BigDecimal retmanualdiscount = hasPushQty.multiply(manualdiscount).divide(saleQty, amtPrecision, RoundingMode.HALF_UP).subtract(manualdiscount);
        BigDecimal promotiondiscount = goodsEntry.getBigDecimal("promotiondiscount");
        BigDecimal retpromotiondiscount = hasPushQty.multiply(promotiondiscount).divide(saleQty, amtPrecision, RoundingMode.HALF_UP).subtract(promotiondiscount);
        BigDecimal coupondiscount = goodsEntry.getBigDecimal("coupondiscount");
        BigDecimal retcoupondiscount = hasPushQty.multiply(coupondiscount).divide(saleQty, amtPrecision, RoundingMode.HALF_UP).subtract(coupondiscount);
        BigDecimal integraldistamount = goodsEntry.getBigDecimal("integraldistamount");
        BigDecimal retintegraldistamount = hasPushQty.multiply(integraldistamount).divide(saleQty, amtPrecision, RoundingMode.HALF_UP).subtract(integraldistamount);
        BigDecimal giftdiscountamount = goodsEntry.getBigDecimal("giftdiscountamount");
        BigDecimal retgiftdiscountamount = hasPushQty.multiply(giftdiscountamount).divide(saleQty, amtPrecision, RoundingMode.HALF_UP).subtract(giftdiscountamount);
        BigDecimal stddiscountamount = goodsEntry.getBigDecimal("stddiscountamount");
        BigDecimal retstddiscountamount = hasPushQty.multiply(stddiscountamount).divide(saleQty, amtPrecision, RoundingMode.HALF_UP).subtract(stddiscountamount);
        BigDecimal notincomedisamount = goodsEntry.getBigDecimal("notincomedisamount");
        BigDecimal retnotincomedisamount = hasPushQty.multiply(notincomedisamount).divide(saleQty, amtPrecision, RoundingMode.HALF_UP).subtract(notincomedisamount);
        BigDecimal ticketshareamount = goodsEntry.getBigDecimal("ticketshareamount");
        BigDecimal retticketshareamount = hasPushQty.multiply(ticketshareamount).divide(saleQty, amtPrecision, RoundingMode.HALF_UP).subtract(ticketshareamount);
        BigDecimal deposit = goodsEntry.getBigDecimal("deposit");
        BigDecimal retdepositamount = hasPushQty.multiply(deposit).divide(saleQty, amtPrecision, RoundingMode.HALF_UP).subtract(deposit);
        if (isBook) {
            BigDecimal addeposit = goodsEntry.getBigDecimal("addeposit");
            BigDecimal retdeposit = goodsEntry.getBigDecimal("retdeposit");
            retdepositamount = deposit.subtract(addeposit).add(retdeposit).negate();
            BigDecimal expectfinalamount = goodsEntry.getBigDecimal("expectfinalamount");
            BigDecimal adexpectfinalamount = goodsEntry.getBigDecimal("adexpectfinalamount");
            BigDecimal refundexpectfinalamount = goodsEntry.getBigDecimal("refundexpectfinalamount");
            retexpectfinalamount = expectfinalamount.subtract(adexpectfinalamount).add(refundexpectfinalamount).negate();
            BigDecimal receexpectfinalamount = goodsEntry.getBigDecimal("receexpectfinalamount");
            adexpectfinalamount = goodsEntry.getBigDecimal("adexpectfinalamount");
            BigDecimal adrefundbookfinalamount = goodsEntry.getBigDecimal("adrefundbookfinalamount");
            retreceexpectfinalamount = receexpectfinalamount.subtract(adexpectfinalamount).add(adrefundbookfinalamount).negate();
        } else {
            BigDecimal finalpayment = goodsEntry.getBigDecimal("finalpayment");
            BigDecimal refundfinalamount = goodsEntry.getBigDecimal("refundexpectfinalamount");
            retfinalpayment = finalpayment.add(refundfinalamount).negate();
            BigDecimal receivedfinalpayment = goodsEntry.getBigDecimal("receivedfinalpayment");
            BigDecimal adpushretfinalamount = goodsEntry.getBigDecimal("adpushretfinalamount");
            retreceivedfinalpayment = receivedfinalpayment.add(adpushretfinalamount).negate();
        }
        if (saleQty.compareTo(returnQty.negate()) != 0) {
            BigDecimal retQtySrcSaleQtyRatio = returnQty.divide(saleQty, 8, RoundingMode.HALF_UP).negate();
            retamount = retQtySrcSaleQtyRatio.multiply(retamount).setScale(amtPrecision, RoundingMode.HALF_UP);
        }
        BigDecimal retQtyMustRetQtyRatio = returnQty.divide(mustRetQty, 8, RoundingMode.HALF_UP).negate();
        if (mustRetQty.compareTo(returnQty.negate()) != 0) {
            retbalamount = retQtyMustRetQtyRatio.multiply(retbalamount).setScale(amtPrecision, RoundingMode.HALF_UP);
            retrealamount = retQtyMustRetQtyRatio.multiply(retrealamount).setScale(amtPrecision, RoundingMode.HALF_UP);
            retmanualdiscount = retQtyMustRetQtyRatio.multiply(retmanualdiscount).setScale(amtPrecision, RoundingMode.HALF_UP);
            retpromotiondiscount = retQtyMustRetQtyRatio.multiply(retpromotiondiscount).setScale(amtPrecision, RoundingMode.HALF_UP);
            retcoupondiscount = retQtyMustRetQtyRatio.multiply(retcoupondiscount).setScale(amtPrecision, RoundingMode.HALF_UP);
            retintegraldistamount = retQtyMustRetQtyRatio.multiply(retintegraldistamount).setScale(amtPrecision, RoundingMode.HALF_UP);
            retgiftdiscountamount = retQtyMustRetQtyRatio.multiply(retgiftdiscountamount).setScale(amtPrecision, RoundingMode.HALF_UP);
            retstddiscountamount = retQtyMustRetQtyRatio.multiply(retstddiscountamount).setScale(amtPrecision, RoundingMode.HALF_UP);
            retnotincomedisamount = retQtyMustRetQtyRatio.multiply(retnotincomedisamount).setScale(amtPrecision, RoundingMode.HALF_UP);
            retticketshareamount = retQtyMustRetQtyRatio.multiply(retticketshareamount).setScale(amtPrecision, RoundingMode.HALF_UP);
            retdepositamount = retQtyMustRetQtyRatio.multiply(retdepositamount).setScale(amtPrecision, RoundingMode.HALF_UP);
            if (isBook) {
                retexpectfinalamount = retQtyMustRetQtyRatio.multiply(retexpectfinalamount).setScale(amtPrecision, RoundingMode.HALF_UP);
                retreceexpectfinalamount = retQtyMustRetQtyRatio.multiply(retreceexpectfinalamount).setScale(amtPrecision, RoundingMode.HALF_UP);
            } else {
                retfinalpayment = retQtyMustRetQtyRatio.multiply(retfinalpayment).setScale(amtPrecision, RoundingMode.HALF_UP);
                retreceivedfinalpayment = retQtyMustRetQtyRatio.multiply(retreceivedfinalpayment).setScale(amtPrecision, RoundingMode.HALF_UP);
            }
        }
        BigDecimal retsumsharediscount = retmanualdiscount.add(retpromotiondiscount).add(retcoupondiscount).add(retintegraldistamount).add(retgiftdiscountamount);
        BigDecimal retsumdiscountamount = retstddiscountamount.add(retnotincomedisamount).add(retpromotiondiscount);
        BigDecimal retnorecefinalamount = retfinalpayment.subtract(retreceivedfinalpayment);
        BigDecimal pushfinalamount = norecefinalamount = goodsEntry.getBigDecimal("norecefinalamount");
        amountResult.put("amount", retamount);
        amountResult.put("balamount", retbalamount);
        amountResult.put("realamount", retrealamount);
        amountResult.put("manualdiscount", retmanualdiscount);
        amountResult.put("promotiondiscount", retpromotiondiscount);
        amountResult.put("coupondiscount", retcoupondiscount);
        amountResult.put("integraldistamount", retintegraldistamount);
        amountResult.put("giftdiscountamount", retgiftdiscountamount);
        amountResult.put("stddiscountamount", retstddiscountamount);
        amountResult.put("notincomedisamount", retnotincomedisamount);
        amountResult.put("ticketshareamount", retticketshareamount);
        amountResult.put("sumdiscountamount", retsumdiscountamount);
        amountResult.put("sumsharediscount", retsumsharediscount);
        amountResult.put("finalpayment", retfinalpayment);
        amountResult.put("receivedfinalpayment", retreceivedfinalpayment);
        amountResult.put("norecefinalamount", retnorecefinalamount);
        amountResult.put("expectfinalamount", retexpectfinalamount);
        amountResult.put("receexpectfinalamount", retreceexpectfinalamount);
        amountResult.put("deposit", retdepositamount);
        amountResult.put("pushfinalamount", pushfinalamount);
        SaleReturnAmountHelper.getLineReceivableAmount(retOrgId, branchId, isBook, retQtyMustRetQtyRatio, amountResult);
        return amountResult;
    }

    private static void getLineReceivableAmount(long orgId, long branchId, boolean isBook, BigDecimal retQtyMustRetQtyRatio, Map<String, BigDecimal> amountResult) {
        BigDecimal linereceivableamount = BigDecimal.ZERO;
        BigDecimal deposit = amountResult.get("deposit");
        BigDecimal pushfinalamount = amountResult.get("pushfinalamount");
        BigDecimal retrecefinalamount = BigDecimal.ZERO;
        String retFinalAmtHandleMode = SystemParamUtil.getRetFinalAmtHandleMode((long)orgId, (long)branchId);
        if (!isBook && retFinalAmtHandleMode.equals("1") && retQtyMustRetQtyRatio.compareTo(BigDecimal.ONE) != 0) {
            retrecefinalamount = pushfinalamount.subtract(pushfinalamount.multiply(retQtyMustRetQtyRatio).setScale(2, RoundingMode.HALF_UP));
        }
        if (isBook) {
            BigDecimal receexpectfinalamount = amountResult.get("receexpectfinalamount");
            linereceivableamount = deposit.add(receexpectfinalamount);
        } else {
            BigDecimal balamount = amountResult.get("balamount");
            BigDecimal manualdiscount = amountResult.get("manualdiscount");
            BigDecimal norecefinalamount = amountResult.get("norecefinalamount");
            linereceivableamount = balamount.subtract(manualdiscount).subtract(norecefinalamount);
        }
        if (retFinalAmtHandleMode.equals("1")) {
            if (retrecefinalamount.compareTo(linereceivableamount.negate()) > 0) {
                retrecefinalamount = linereceivableamount.negate();
            }
            linereceivableamount = linereceivableamount.add(retrecefinalamount);
        }
        amountResult.put("retrecefinalamount", retrecefinalamount);
        amountResult.put("linereceivableamount", linereceivableamount);
    }
}

