/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.saleorder;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;

public class SnServiceHelper {
    public static void updateSnStatus(List<Long> snMainFileIds, String status) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bd_snmainfile");
        DynamicObject[] snFiles = BusinessDataServiceHelper.load((Object[])snMainFileIds.toArray(), (DynamicObjectType)type);
        if (snFiles != null && snFiles.length > 0) {
            for (DynamicObject snFile : snFiles) {
                snFile.set("snstatus", (Object)status);
            }
            SaveServiceHelper.save((DynamicObject[])snFiles);
        }
    }

    public static void updateSnMoveTrack(List<JSONObject> params) {
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        List<DynamicObject> snMoveTrack = SnServiceHelper.createSnMoveTrack(params);
        OperationServiceHelper.executeOperate((String)"save", (String)"bd_snmovetrack", (DynamicObject[])snMoveTrack.toArray(new DynamicObject[0]), null);
    }

    public static List<DynamicObject> createSnMoveTrack(List<JSONObject> params) {
        ArrayList<DynamicObject> entities = new ArrayList<DynamicObject>(0);
        for (JSONObject param : params) {
            DynamicObject entity = BusinessDataServiceHelper.newDynamicObject((String)"bd_snmovetrack");
            entity.set("billid", (Object)param.getLongValue("Id"));
            entity.set("biztime", (Object)param.getDate("bizdate"));
            entity.set("billno", (Object)param.getString("billno"));
            entity.set("billstatus", (Object)param.getString("billstatus"));
            entity.set("auditdate", (Object)param.getDate("auditdate"));
            entity.set("billtype", (Object)param.getString("basebilltype"));
            entity.set("customer", (Object)param.getLongValue("customerid"));
            entity.set("snmainfile", (Object)param.getLongValue("snmainfile"));
            entity.set("supplier", (Object)param.getLongValue("supplier"));
            entity.set("org", (Object)param.getLongValue("inventoryorgid"));
            entity.set("warehouse", (Object)param.getLongValue("erpstockid"));
            entity.set("location", (Object)param.getLongValue("erpstockpositionid"));
            entities.add(entity);
        }
        return entities;
    }

    public static List<Long> getLockSnMainFileIdsFromDr(DynamicObject dataEntity) {
        ArrayList<Long> lockSnMainFileIds = new ArrayList<Long>();
        DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        if (!CollectionUtils.isEmpty((Collection)entryEntities)) {
            for (DynamicObject entryEntity : entryEntities) {
                DynamicObjectCollection deliveryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entryEntity, (String)"salesorderdelivery");
                if (CollectionUtils.isEmpty((Collection)deliveryEntities)) continue;
                for (DynamicObject deliveryEntity : deliveryEntities) {
                    long snMainFileId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"snmainfile");
                    if (snMainFileId <= 0L) continue;
                    lockSnMainFileIds.add(snMainFileId);
                }
            }
        }
        return lockSnMainFileIds.stream().distinct().collect(Collectors.toList());
    }

    public static List<Long> getLockSnMainFileIdsFromSend(DynamicObject dataEntity) {
        ArrayList<Long> lockSnMainFileIds = new ArrayList<Long>();
        DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        if (!CollectionUtils.isEmpty((Collection)entryEntities)) {
            for (DynamicObject entryEntity : entryEntities) {
                long snMainFileId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"snmainfile");
                if (snMainFileId <= 0L) continue;
                lockSnMainFileIds.add(snMainFileId);
            }
        }
        return lockSnMainFileIds.stream().distinct().collect(Collectors.toList());
    }

    public static JSONObject buildParam(DynamicObject dataEntity, long supplierId, DynamicObject deliveryEntity) {
        JSONObject param = new JSONObject();
        long billId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity);
        param.put("Id", (Object)billId);
        Date bizDate = DynamicObjectUtils.getDate((DynamicObject)dataEntity, (String)"bizdate");
        param.put("bizdate", (Object)bizDate);
        String billNo = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"billno");
        param.put("billno", (Object)billNo);
        String billStatus = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"billstatus");
        param.put("billstatus", (Object)billStatus);
        Date auditDate = DynamicObjectUtils.getDate((DynamicObject)dataEntity, (String)"auditdate");
        param.put("auditdate", (Object)auditDate);
        String billType = dataEntity.getDataEntityType().getName();
        param.put("basebilltype", (Object)billType);
        long customerId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"customerid");
        param.put("customerid", (Object)customerId);
        long snMainFileId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"snmainfile");
        param.put("snmainfile", (Object)snMainFileId);
        long invOrgId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"inventoryorgid");
        param.put("inventoryorgid", (Object)invOrgId);
        long stockId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"erpstockid");
        param.put("erpstockid", (Object)stockId);
        long locationId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"erpstockpositionid");
        param.put("erpstockpositionid", (Object)locationId);
        param.put("supplier", (Object)supplierId);
        return param;
    }

    public static void updateDeliveryOrder(Object deliveryEntryPkValue, DynamicObject supplySerial) {
        DynamicObjectCollection entryEntity;
        QFilter fFilter;
        DynamicObject deliveryOrderId;
        if (supplySerial == null || deliveryEntryPkValue == null) {
            return;
        }
        QFilter qFilter = new QFilter("entryentity.ribilldelivery.srcdeliveryentryid", "=", deliveryEntryPkValue);
        DynamicObject retailbill = BusinessDataServiceHelper.loadSingle((String)"ocococ_retailbill", (String)"entryentity,srcdeliveryentryid,ribilldelivery,deliveryserialnumber", (QFilter[])qFilter.toArray());
        if (retailbill != null) {
            DynamicObjectCollection entryEntity2 = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)retailbill, (String)"entryentity");
            if (!CollectionUtils.isEmpty((Collection)entryEntity2)) {
                for (DynamicObject entryEntityRow : entryEntity2) {
                    DynamicObjectCollection riBillDelivery = entryEntityRow.getDynamicObjectCollection("ribilldelivery");
                    if (CollectionUtils.isEmpty((Collection)riBillDelivery)) continue;
                    for (DynamicObject riBillDeliveryRow : riBillDelivery) {
                        if (!deliveryEntryPkValue.equals(riBillDeliveryRow.getLong("srcdeliveryentryid"))) continue;
                        riBillDeliveryRow.set("deliveryserialnumber", (Object)supplySerial.getString("number"));
                    }
                }
            }
            SaveServiceHelper.update((DynamicObject)retailbill);
        }
        if ((deliveryOrderId = BusinessDataServiceHelper.loadSingle((String)"ocococ_deliveryorder", (String)"id", (QFilter[])(fFilter = new QFilter("entryentity.corebillentryid", "=", deliveryEntryPkValue)).toArray())) == null) {
            return;
        }
        DynamicObject deliveryOrder = BusinessDataServiceHelper.loadSingle((Object)deliveryOrderId.getLong("id"), (String)"ocococ_deliveryorder");
        if (deliveryOrder != null && !CollectionUtils.isEmpty((Collection)(entryEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)deliveryOrder, (String)"entryentity")))) {
            for (DynamicObject entryEntityRow : entryEntity) {
                if (!deliveryEntryPkValue.equals(entryEntityRow.getLong("corebillentryid"))) continue;
                entryEntityRow.set("deliveryserialnumber", (Object)supplySerial.getString("number"));
                DynamicObjectCollection subEntryEntity = entryEntityRow.getDynamicObjectCollection("subentryentity");
                if (subEntryEntity.size() == 1 && ((DynamicObject)subEntryEntity.get(0)).getString("supplyserialnumber").isEmpty()) {
                    DynamicObject subEntryEntityRow = (DynamicObject)subEntryEntity.get(0);
                    subEntryEntityRow.set("scmserialid", (Object)supplySerial);
                    subEntryEntityRow.set("supplyserialnumber", (Object)supplySerial.getString("number"));
                    continue;
                }
                DynamicObject newRow = new DynamicObject(subEntryEntity.getDynamicObjectType());
                newRow.set("scmserialid", (Object)supplySerial);
                newRow.set("supplyserialnumber", (Object)supplySerial.getString("number"));
                subEntryEntity.add((Object)newRow);
            }
        }
        SaveServiceHelper.update((DynamicObject)deliveryOrder);
    }
}

