/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.saleorder;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.MultiBaseDataUtil;
import kd.occ.ocbase.common.util.PosItemUtil;
import kd.occ.ocbase.common.util.pos.ItemClassNodeUtil;
import kd.occ.ocpos.business.saleorder.SaleOrderAmountHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderHelper;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.DynamicObjectUtil;

public class TicketAmountHelper {
    public static Map<Object, DynamicObject> getTicketInfoByBranchId(long branchId) {
        List<Long> ticketTypeIds = TicketAmountHelper.getTicketTypeIdByBranchId(branchId);
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        qFilter.and("enable", "=", (Object)"1");
        qFilter.and("ticketstatus", "=", (Object)"P");
        qFilter.and("cancelstatus", "=", (Object)"A");
        Date dtNow = TimeServiceHelper.now();
        qFilter.and("starttime", "<", (Object)dtNow);
        qFilter.and("endtime", ">", (Object)dtNow);
        qFilter.and("tickettypeid.id", "in", ticketTypeIds);
        return BusinessDataServiceHelper.loadFromCache((String)"ocdbd_ticketinfo", (String)StringUtils.join((Object[])TicketAmountHelper.getSelectFields(), (char)','), (QFilter[])qFilter.toArray());
    }

    public static List<DynamicObject> getTicketInfo(IFormView view, Map<Object, DynamicObject> map, long branchId, List<DynamicObject> lstGoods, long memberId) {
        String ticketData = view.getPageCache().get(view.getPageId() + "ocdbd_ticketstype");
        DynamicObjectType ticketDyt = (DynamicObjectType)ORM.create().getDataEntityType("ocdbd_ticketinfo");
        if (StringUtils.isEmpty((CharSequence)ticketData)) {
            DynamicObject[] ticketInfos = map.values().toArray(new DynamicObject[0]);
            List<DynamicObject> lstTicketBranchInfo = TicketAmountHelper.getTicketInfosByBranch(ticketInfos, branchId);
            List<DynamicObject> lstFinalTicketBranchInfo = TicketAmountHelper.getTicketInfoByGoods(lstTicketBranchInfo, lstGoods, memberId);
            ticketData = DynamicObjectSerializeUtil.serialize((Object[])lstFinalTicketBranchInfo.toArray(), (DynamicObjectType)ticketDyt);
            view.getPageCache().put(view.getPageId() + "ocdbd_ticketstype", ticketData);
            return lstFinalTicketBranchInfo;
        }
        Object[] ticketInfos = DynamicObjectSerializeUtil.deserialize((String)ticketData, (DynamicObjectType)ticketDyt);
        if (ticketInfos == null || ticketInfos.length == 0) {
            return null;
        }
        ArrayList<DynamicObject> lstTicketInfo = new ArrayList<DynamicObject>(0);
        for (Object ticketInfo : ticketInfos) {
            if (!(ticketInfo instanceof DynamicObject)) continue;
            lstTicketInfo.add((DynamicObject)ticketInfo);
        }
        return lstTicketInfo;
    }

    public static List<DynamicObject> getTicketInfosByBranch(DynamicObject[] ticketInfos, long branchId) {
        ArrayList<DynamicObject> list = new ArrayList(ticketInfos.length);
        if (branchId > 0L) {
            for (DynamicObject ticketInfo : ticketInfos) {
                boolean applyStore;
                DynamicObject ticketType = DynamicObjectUtil.getDynamicObject((DynamicObject)ticketInfo, (String)"tickettypeid");
                String ctrlMethod = DynamicObjectUtil.getString((DynamicObject)ticketType, (String)"controlmethod");
                long saleBranchId = DynamicObjectUtil.getPkValue((DynamicObject)ticketInfo, (String)"publishbranchid");
                DynamicObjectCollection branchs = DynamicObjectUtil.getDynamicObjectCollection((DynamicObject)ticketType, (String)"treeentryentity");
                boolean applyAll = StringUtils.equals((CharSequence)ctrlMethod, (CharSequence)"0");
                boolean isOutLineStore = DynamicObjectUtil.getBoolean((DynamicObject)ticketType, (String)"isoutlinestore");
                if (!isOutLineStore) continue;
                boolean applyPublishStore = StringUtils.equals((CharSequence)ctrlMethod, (CharSequence)"1") && saleBranchId == branchId;
                boolean bl = applyStore = StringUtils.equals((CharSequence)ctrlMethod, (CharSequence)"2") && branchs.stream().anyMatch(x -> DynamicObjectUtil.getPkValue((DynamicObject)x, (String)"branch") == branchId && DynamicObjectUtil.getBoolean((DynamicObject)x, (String)"isapply"));
                if (!applyAll && !applyPublishStore && !applyStore) continue;
                list.add(ticketInfo);
            }
        } else {
            list = Arrays.stream(ticketInfos).collect(Collectors.toList());
        }
        return list;
    }

    public static List<DynamicObject> getTicketInfoByGoods(List<DynamicObject> lstTicketInfos, List<DynamicObject> lstGoods, long memberId) {
        ArrayList<DynamicObject> list = new ArrayList(lstTicketInfos.size());
        if (!CollectionUtils.isEmpty(lstGoods)) {
            for (DynamicObject ticketInfo : lstTicketInfos) {
                long vipId;
                DynamicObject ticketType = DynamicObjectUtil.getDynamicObject((DynamicObject)ticketInfo, (String)"tickettypeid");
                boolean isAllGoods = DynamicObjectUtil.getBoolean((DynamicObject)ticketType, (String)"isallgoods");
                DynamicObjectCollection goodsEntry = DynamicObjectUtil.getDynamicObjectCollection((DynamicObject)ticketType, (String)"tictgoodsentry");
                if (memberId > 0L && (vipId = DynamicObjectUtils.getPkValue((DynamicObject)ticketInfo, (String)"vipid")) > 0L && memberId != vipId) continue;
                if (isAllGoods) {
                    list.add(ticketInfo);
                    continue;
                }
                if (CollectionUtils.isEmpty((Collection)goodsEntry)) continue;
                block13: for (DynamicObject goods : goodsEntry) {
                    DynamicObjectCollection docInvType;
                    String goodsType = DynamicObjectUtils.getString((DynamicObject)goods, (String)"type");
                    long itemLabelId = DynamicObjectUtils.getPkValue((DynamicObject)goods, (String)"itemlabel");
                    long goodsClassifyId = DynamicObjectUtils.getPkValue((DynamicObject)goods, (String)"goodsclassify");
                    Set classIds = ItemClassNodeUtil.queryChildItemClass(new HashSet<Long>(Collections.singleton(goodsClassifyId)));
                    long brandId = DynamicObjectUtils.getPkValue((DynamicObject)goods, (String)"brand");
                    ArrayList<Long> saleAttrIds = new ArrayList(0);
                    ArrayList<Long> invTypeIds = new ArrayList(0);
                    DynamicObjectCollection docSaleAttr = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)goods, (String)"saleattr");
                    if (!CollectionUtils.isEmpty((Collection)docSaleAttr)) {
                        saleAttrIds = MultiBaseDataUtil.getMultiF7PKValueList((DynamicObjectCollection)docSaleAttr);
                    }
                    if (!CollectionUtils.isEmpty((Collection)(docInvType = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)goods, (String)"invttype")))) {
                        invTypeIds = MultiBaseDataUtil.getMultiF7PKValueList((DynamicObjectCollection)docInvType);
                    }
                    switch (goodsType) {
                        case "1": {
                            long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)goods, (String)"goods");
                            if (!lstGoods.stream().noneMatch(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"goodsid") == goodsId)) break;
                            continue block13;
                        }
                        case "2": {
                            if (!TicketAmountHelper.isMatchGoodsClassForPos(classIds, lstGoods)) break;
                            continue block13;
                        }
                        case "3": {
                            if (!lstGoods.stream().noneMatch(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"brand") == brandId)) break;
                            continue block13;
                        }
                        case "5": {
                            if (TicketAmountHelper.isMatchGoodsClass(classIds, lstGoods) && !lstGoods.stream().noneMatch(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"brand") == brandId)) break;
                            continue block13;
                        }
                        default: {
                            continue block13;
                        }
                    }
                    if (!TicketAmountHelper.isMatchSaleAttrOrInvType(saleAttrIds, invTypeIds, lstGoods)) continue;
                    list.add(ticketInfo);
                }
            }
        } else {
            list = lstTicketInfos;
        }
        return list;
    }

    public static BigDecimal calcTicketRetAmount(String cardNo, BigDecimal surplusRetAmount, DynamicObject saleReturn) {
        DynamicObject returnChange;
        String changeItemType;
        if (StringUtils.isEmpty((CharSequence)cardNo)) {
            return surplusRetAmount;
        }
        String entityId = saleReturn.getDynamicObjectType().getName();
        String selectFields = "goodsentryentity.goodsid,goodsentryentity.linereceivableamount,goodsentryentity.goodsclass,goodsentryentity.brand";
        if (StringUtils.equalsIgnoreCase((CharSequence)entityId, (CharSequence)"ocpos_salechange")) {
            selectFields = selectFields + "," + "changeitemtype" + "," + "goodsentryentity" + "." + "saleoption";
        }
        if (StringUtils.equals((CharSequence)(changeItemType = DynamicObjectUtils.getString((DynamicObject)(returnChange = BusinessDataServiceHelper.loadSingle((Object)saleReturn.getPkValue(), (String)entityId, (String)selectFields)), (String)"changeitemtype")), (CharSequence)"1") || StringUtils.equals((CharSequence)changeItemType, (CharSequence)"3")) {
            return surplusRetAmount;
        }
        DynamicObjectCollection goodsEntryEntity = returnChange.getDynamicObjectCollection("goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)goodsEntryEntity)) {
            return surplusRetAmount;
        }
        QFilter filter = new QFilter("number", "=", (Object)cardNo);
        DynamicObjectCollection ticketColl = QueryServiceHelper.query((String)"ocdbd_ticketinfo", (String)"id,tickettypeid.isallgoods as isallgoods,tickettypeid.tictgoodsentry.type as type,tickettypeid.tictgoodsentry.goods as goods,tickettypeid.tictgoodsentry.itemlabel as itemlabel,tickettypeid.tictgoodsentry.goodsclassify as goodsclassify,tickettypeid.tictgoodsentry.brand as brand,tickettypeid.tictgoodsentry.saleattr as saleattr", (QFilter[])filter.toArray());
        if (CollectionUtils.isEmpty((Collection)ticketColl)) {
            return surplusRetAmount;
        }
        boolean isAllGoods = DynamicObjectUtil.getBoolean((DynamicObject)((DynamicObject)ticketColl.get(0)), (String)"isallgoods");
        if (isAllGoods) {
            return surplusRetAmount;
        }
        BigDecimal sumGoodsRetAmount = BigDecimal.ZERO;
        Set<Object> classIds = null;
        block12: for (DynamicObject goodsEntry : goodsEntryEntity) {
            String saleOption = DynamicObjectUtils.getString((DynamicObject)goodsEntry, (String)"saleoption");
            if (StringUtils.equals((CharSequence)saleOption, (CharSequence)"1")) continue;
            BigDecimal linereceivableamount = goodsEntry.getBigDecimal("linereceivableamount");
            ArrayList<DynamicObject> lstGoods = new ArrayList<DynamicObject>(1);
            lstGoods.add(goodsEntry);
            block13: for (DynamicObject ticket : ticketColl) {
                String goodsType = DynamicObjectUtils.getString((DynamicObject)ticket, (String)"type");
                long brandId = DynamicObjectUtils.getLong((DynamicObject)ticket, (String)"brand");
                switch (goodsType) {
                    case "1": {
                        long goodsId = DynamicObjectUtils.getLong((DynamicObject)ticket, (String)"goods");
                        if (!lstGoods.stream().noneMatch(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"goodsid") == goodsId)) break;
                        continue block13;
                    }
                    case "2": {
                        if (classIds == null || classIds.size() == 0) {
                            classIds = TicketAmountHelper.getGoodsClassIds(ticketColl);
                        }
                        if (TicketAmountHelper.isMatchGoodsClass(classIds, lstGoods)) break;
                        continue block13;
                    }
                    case "3": {
                        if (!lstGoods.stream().noneMatch(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"brand") == brandId)) break;
                        continue block13;
                    }
                    case "5": {
                        if (classIds == null || classIds.size() == 0) {
                            classIds = TicketAmountHelper.getGoodsClassIds(ticketColl);
                        }
                        boolean isMatchClass = TicketAmountHelper.isMatchGoodsClass(classIds, lstGoods);
                        boolean isMatchBrand = lstGoods.stream().anyMatch(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"brand") == brandId);
                        if (isMatchClass && isMatchBrand) break;
                        continue block13;
                    }
                    default: {
                        continue block13;
                    }
                }
                sumGoodsRetAmount = sumGoodsRetAmount.add(linereceivableamount);
                continue block12;
            }
        }
        if (surplusRetAmount.compareTo(sumGoodsRetAmount) < 0) {
            surplusRetAmount = sumGoodsRetAmount;
        }
        return surplusRetAmount;
    }

    private static Set<Object> getGoodsClassIds(DynamicObjectCollection ticketColl) {
        List lstGoodsClassifyId = ticketColl.stream().filter(x -> StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"type"), (CharSequence)"2") || StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"type"), (CharSequence)"5") && DynamicObjectUtils.getLong((DynamicObject)x, (String)"goodsclassify") > 0L).map(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"goodsclassify")).distinct().collect(Collectors.toList());
        return ItemClassNodeUtil.queryChildItemClass(new HashSet(lstGoodsClassifyId));
    }

    public static List<Long> getMemberTicketInfo(QFilter filters, List<DynamicObject> lstGoods, long branchId, long memberId, String numberFilter) {
        ArrayList<Long> lstTickets = new ArrayList<Long>(0);
        DynamicObjectCollection ticketColl = QueryServiceHelper.query((String)"ocdbd_ticketinfo", (String)"id,tickettypeid.isallgoods as isallgoods,tickettypeid.controlmethod as controlmethod,publishbranchid,tickettypeid.treeentryentity.isapply as isapply,tickettypeid.treeentryentity.branch as branch,tickettypeid.tictgoodsentry.type as type,tickettypeid.tictgoodsentry.goods as goods,tickettypeid.tictgoodsentry.itemlabel as itemlabel,tickettypeid.tictgoodsentry.goodsclassify as goodsclassify,tickettypeid.tictgoodsentry.brand as brand,tickettypeid.tictgoodsentry.saleattr as saleattr,vipid", (QFilter[])filters.toArray());
        if (ticketColl == null || ticketColl.size() == 0) {
            return lstTickets;
        }
        List lstGoodsClassifyId = ticketColl.stream().filter(x -> StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"type"), (CharSequence)"2") || StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"type"), (CharSequence)"5") && DynamicObjectUtils.getLong((DynamicObject)x, (String)"goodsclassify") > 0L).map(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"goodsclassify")).distinct().collect(Collectors.toList());
        Set classIds = ItemClassNodeUtil.queryChildItemClass(new HashSet(lstGoodsClassifyId));
        block12: for (DynamicObject ticket : ticketColl) {
            boolean applyStore;
            long vipId;
            if (StringUtils.isNotEmpty((CharSequence)numberFilter) && (vipId = DynamicObjectUtils.getLong((DynamicObject)ticket, (String)"vipid")) != 0L && vipId != memberId) continue;
            long ticketId = DynamicObjectUtils.getLong((DynamicObject)ticket, (String)"id");
            boolean isAllGoods = DynamicObjectUtil.getBoolean((DynamicObject)ticket, (String)"isallgoods");
            String ctrlMethod = DynamicObjectUtil.getString((DynamicObject)ticket, (String)"controlmethod");
            long applyBranchId = DynamicObjectUtil.getLong((DynamicObject)ticket, (String)"branch");
            boolean isApply = DynamicObjectUtil.getBoolean((DynamicObject)ticket, (String)"isapply");
            long publishBranchId = DynamicObjectUtil.getLong((DynamicObject)ticket, (String)"publishbranchid");
            boolean applyAll = StringUtils.equals((CharSequence)ctrlMethod, (CharSequence)"0");
            boolean applyPublishStore = StringUtils.equals((CharSequence)ctrlMethod, (CharSequence)"1") && publishBranchId == branchId;
            boolean bl = applyStore = StringUtils.equals((CharSequence)ctrlMethod, (CharSequence)"2") && applyBranchId == branchId && isApply;
            if (!applyAll && !applyPublishStore && !applyStore) continue;
            if (isAllGoods) {
                if (lstTickets.contains(ticketId)) continue;
                lstTickets.add(ticketId);
                continue;
            }
            String goodsType = DynamicObjectUtils.getString((DynamicObject)ticket, (String)"type");
            long itemLabelId = DynamicObjectUtils.getLong((DynamicObject)ticket, (String)"itemlabel");
            long goodsClassifyId = DynamicObjectUtils.getLong((DynamicObject)ticket, (String)"goodsclassify");
            long brandId = DynamicObjectUtils.getLong((DynamicObject)ticket, (String)"brand");
            ArrayList<Long> saleAttrIds = new ArrayList<Long>(0);
            ArrayList<Long> invTypeIds = new ArrayList<Long>(0);
            switch (goodsType) {
                case "1": {
                    long goodsId = DynamicObjectUtils.getLong((DynamicObject)ticket, (String)"goods");
                    if (!lstGoods.stream().noneMatch(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"goodsid") == goodsId)) break;
                    continue block12;
                }
                case "2": {
                    if (TicketAmountHelper.isMatchGoodsClass(classIds, lstGoods)) break;
                    continue block12;
                }
                case "3": {
                    if (!lstGoods.stream().noneMatch(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"brand") == brandId)) break;
                    continue block12;
                }
                case "5": {
                    boolean isMatchClass = TicketAmountHelper.isMatchGoodsClass(classIds, lstGoods);
                    boolean isMatchBrand = lstGoods.stream().anyMatch(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"brand") == brandId);
                    if (isMatchClass && isMatchBrand) break;
                    continue block12;
                }
                default: {
                    continue block12;
                }
            }
            if (!TicketAmountHelper.isMatchSaleAttrOrInvType(saleAttrIds, invTypeIds, lstGoods)) continue;
            lstTickets.add(ticketId);
        }
        return lstTickets;
    }

    public static List<DynamicObject> getTicketsByGoodsForPos(List<DynamicObject> lstTicketInfos, List<Long> lstGoodsId, long memberId) {
        ArrayList<DynamicObject> list = new ArrayList(0);
        if (!CollectionUtils.isEmpty(lstGoodsId)) {
            List<DynamicObject> lstGoods = TicketAmountHelper.getGoodsList(lstGoodsId);
            if (lstGoods.size() == 0) {
                return list;
            }
            for (DynamicObject ticketInfo : lstTicketInfos) {
                long vipId;
                DynamicObject ticketType = DynamicObjectUtil.getDynamicObject((DynamicObject)ticketInfo, (String)"tickettypeid");
                boolean isAllGoods = DynamicObjectUtil.getBoolean((DynamicObject)ticketType, (String)"isallgoods");
                DynamicObjectCollection goodsEntry = DynamicObjectUtil.getDynamicObjectCollection((DynamicObject)ticketType, (String)"tictgoodsentry");
                if (memberId > 0L && (vipId = DynamicObjectUtils.getPkValue((DynamicObject)ticketInfo, (String)"vipid")) > 0L && memberId != vipId) continue;
                if (isAllGoods) {
                    list.add(ticketInfo);
                    continue;
                }
                if (CollectionUtils.isEmpty((Collection)goodsEntry)) continue;
                block13: for (DynamicObject goods : goodsEntry) {
                    String goodsType = DynamicObjectUtils.getString((DynamicObject)goods, (String)"type");
                    long itemLabelId = DynamicObjectUtils.getPkValue((DynamicObject)goods, (String)"itemlabel");
                    long goodsClassifyId = DynamicObjectUtils.getPkValue((DynamicObject)goods, (String)"goodsclassify");
                    Set classIds = ItemClassNodeUtil.queryChildItemClass(new HashSet<Long>(Collections.singleton(goodsClassifyId)));
                    long brandId = DynamicObjectUtils.getPkValue((DynamicObject)goods, (String)"brand");
                    switch (goodsType) {
                        case "1": {
                            long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)goods, (String)"goods");
                            if (lstGoodsId.contains(goodsId)) break;
                            continue block13;
                        }
                        case "2": {
                            if (!TicketAmountHelper.isMatchGoodsClassForPos(classIds, lstGoods)) break;
                            continue block13;
                        }
                        case "3": {
                            if (!lstGoods.stream().noneMatch(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"itembrands.id") == brandId)) break;
                            continue block13;
                        }
                        case "5": {
                            if (!TicketAmountHelper.isMatchGoodsClassForPos(classIds, lstGoods) && !lstGoods.stream().noneMatch(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"itembrands.id") == brandId)) break;
                            continue block13;
                        }
                        default: {
                            continue block13;
                        }
                    }
                    list.add(ticketInfo);
                }
            }
        } else {
            list = lstTicketInfos;
        }
        return list;
    }

    private static List<DynamicObject> getGoodsList(List<Long> lstGoodsId) {
        ArrayList<DynamicObject> lstGoods = new ArrayList<DynamicObject>(0);
        QFilter filter = new QFilter("id", "in", (Object)lstGoodsId.toArray());
        DynamicObjectCollection goodsArray = QueryServiceHelper.query((String)"ocdbd_iteminfo", (String)TicketAmountHelper.getGoodsSelectField(), (QFilter[])filter.toArray());
        DynamicObject classStandardApply = PosItemUtil.getClassStandardApply();
        if (classStandardApply != null && goodsArray != null) {
            long classStandardId = DynamicObjectUtils.getPkValue((DynamicObject)classStandardApply);
            for (DynamicObject goods : goodsArray) {
                long goodsId = DynamicObjectUtils.getLong((DynamicObject)goods, (String)"id");
                long itemClassStandardId = DynamicObjectUtils.getLong((DynamicObject)goods, (String)"classstandardid");
                if (itemClassStandardId == 0L || itemClassStandardId != classStandardId || !lstGoods.stream().noneMatch(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"id") == goodsId)) continue;
                lstGoods.add(goods);
            }
        }
        return lstGoods;
    }

    private static String getGoodsSelectField() {
        return String.join((CharSequence)",", "id", "itembrands.id", "itemclassentity.goodsclasssid.id as goodsclasssid", "itemclassentity.classstandardid.id  as classstandardid");
    }

    public static boolean isMatchGoodsClass(Set<Object> classIds, List<DynamicObject> lstGoods) {
        int cnt = 0;
        if (classIds == null || classIds.size() == 0) {
            return false;
        }
        for (DynamicObject doGoods : lstGoods) {
            Object goodsClassId;
            DynamicObject doGoodsClass = DynamicObjectUtils.getDynamicObject((DynamicObject)doGoods, (String)"goodsclass");
            if (doGoodsClass == null || !classIds.contains(goodsClassId = doGoodsClass.getPkValue())) continue;
            ++cnt;
        }
        return cnt != 0;
    }

    private static boolean isMatchGoodsClassForPos(Set<Object> classIds, List<DynamicObject> lstGoods) {
        int cnt = 0;
        for (DynamicObject doGoods : lstGoods) {
            long goodsClassId = DynamicObjectUtils.getPkValue((DynamicObject)doGoods, (String)"goodsclass");
            if (goodsClassId == 0L || !classIds.contains(goodsClassId)) continue;
            ++cnt;
        }
        return cnt == 0;
    }

    public static boolean isMatchSaleAttrOrInvType(List<Long> saleAttrIds, List<Long> invTypeIds, List<DynamicObject> lstGoods) {
        int cnt = 0;
        if (saleAttrIds != null && saleAttrIds.size() > 0) {
            for (Long saleAttrId : saleAttrIds) {
                if (!lstGoods.stream().anyMatch(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"saleattr") == saleAttrId)) continue;
                ++cnt;
            }
            if (cnt == 0) {
                return false;
            }
        }
        cnt = 0;
        if (invTypeIds != null && invTypeIds.size() > 0) {
            for (Long invTypeId : invTypeIds) {
                if (!lstGoods.stream().anyMatch(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"channelstocktypeid") == invTypeId)) continue;
                ++cnt;
            }
            return cnt <= 0;
        }
        return true;
    }

    public static List<Long> getTicketTypeIdByBranchId(long branchId) {
        ArrayList<Long> ticketTypeIds = new ArrayList<Long>();
        TicketAmountHelper.getTicketTypeByAllBranchId(ticketTypeIds);
        TicketAmountHelper.getTicketTypeByAssignBranchId(ticketTypeIds, branchId);
        return ticketTypeIds.stream().distinct().collect(Collectors.toList());
    }

    public static void getTicketTypeByAllBranchId(List<Long> ticketTypeIds) {
        QFilter filter = new QFilter("controlmethod", "=", (Object)"0");
        filter.and("isoutlinestore", "=", (Object)Boolean.TRUE);
        DynamicObject[] ticketTypeEntity = BusinessDataServiceHelper.load((String)"ocdbd_ticketstype", (String)"id", (QFilter[])filter.toArray());
        Arrays.stream(ticketTypeEntity).forEach(x -> ticketTypeIds.add(x.getLong("id")));
    }

    public static void getTicketTypeByPublishBranchId(List<Long> ticketTypeIds, long branchId) {
        QFilter filter = new QFilter("publishbranchid.id", "=", (Object)branchId);
        filter.and("isoutlinestore", "=", (Object)Boolean.TRUE);
        DynamicObject[] ticketTypeEntity = BusinessDataServiceHelper.load((String)"ocdbd_ticketstype", (String)"id", (QFilter[])filter.toArray());
        Arrays.stream(ticketTypeEntity).forEach(x -> ticketTypeIds.add(x.getLong("id")));
    }

    public static void getTicketTypeByAssignBranchId(List<Long> ticketTypeIds, long branchId) {
        QFilter filter = new QFilter("controlmethod", "=", (Object)"2");
        filter.and("isoutlinestore", "=", (Object)"1");
        DynamicObjectCollection ticketTypeEntry = QueryServiceHelper.query((String)"ocdbd_ticketstype", (String)"id,treeentryentity.branch as branch,treeentryentity.isapply as isapply", (QFilter[])filter.toArray());
        if (CollectionUtils.isEmpty((Collection)ticketTypeEntry)) {
            return;
        }
        Set setTicketTypeId = ticketTypeEntry.stream().filter(s -> branchId == DynamicObjectUtils.getLong((DynamicObject)s, (String)"branch") && DynamicObjectUtil.getBoolean((DynamicObject)s, (String)"isapply")).map(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"id")).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(setTicketTypeId)) {
            return;
        }
        ticketTypeIds.addAll(setTicketTypeId);
    }

    public static String[] getSelectFields() {
        return new String[]{"id", "number", "tickettypeid", "ticketvalue", "minconsumeamount", "ticketcurrencyid", "isinsalesincome", "vipid"};
    }

    public static String getGoodsSeq(List<DynamicObject> docGoodsEntry) {
        ArrayList lstSeq = new ArrayList(0);
        docGoodsEntry.forEach(x -> lstSeq.add(DynamicObjectUtils.getString((DynamicObject)x, (String)"seq")));
        return StringUtils.join((Object[])lstSeq.toArray(), (char)',');
    }

    public static void clearTicket(IFormView view) {
        view.getModel().setValue("ticketid", null);
        view.updateView("ticketid");
    }

    public static boolean currencyMatch(IFormView view, long currencyId, DynamicObject doTicket) {
        boolean rlt = true;
        long ticketCurrencyId = DynamicObjectUtil.getPkValue((DynamicObject)doTicket, (String)"ticketcurrencyid");
        if (currencyId != ticketCurrencyId) {
            view.showErrorNotification(String.format("\u793c\u5238\u7f16\u53f7%s\u5238\u9762\u5e01\u522b\u4e0e\u95e8\u5e97\u5b9a\u4ef7\u5e01\u522b\u4e0d\u5339\u914d\uff0c\u4e0d\u5141\u8bb8\u4f7f\u7528\u3002", doTicket.get("number")));
            TicketAmountHelper.clearTicket(view);
            rlt = false;
        }
        return rlt;
    }

    public static boolean isMinConsumeAmount(IFormView view, BigDecimal sumBalAmount, String ticketNo, BigDecimal minConsumeAmount) {
        boolean rlt = true;
        if (minConsumeAmount.compareTo(BigDecimal.ZERO) > 0 && sumBalAmount.compareTo(minConsumeAmount) < 0) {
            DecimalFormat decimalFormat = new DecimalFormat("0.00");
            view.showErrorNotification(String.format("\u793c\u5238\u7f16\u53f7%s\u6700\u4f4e\u6d88\u8d39\u989d\u4e0d\u80fd\u4f4e\u4e8e%s\uff0c\u4e0d\u5141\u8bb8\u4f7f\u7528\u3002", ticketNo, decimalFormat.format(minConsumeAmount)));
            TicketAmountHelper.clearTicket(view);
            rlt = false;
        }
        return rlt;
    }

    public static BigDecimal getGoodsAmount(List<DynamicObject> lstGoodsEntry, DynamicObject doTicketType) {
        String goodsSeq = "";
        String usageMode = doTicketType.getString("usagemode");
        boolean isAllGoods = doTicketType.getBoolean("isallgoods");
        if (isAllGoods) {
            goodsSeq = TicketAmountHelper.getGoodsSeq(lstGoodsEntry);
        } else {
            Map<String, BigDecimal> mapResult = SaleOrderHelper.calcGoodsAmount(lstGoodsEntry, doTicketType, usageMode);
            if (mapResult.size() > 0) {
                goodsSeq = (String)((Map.Entry)mapResult.entrySet().stream().findFirst().get()).getKey();
            }
        }
        if (StringUtils.isEmpty((CharSequence)goodsSeq)) {
            return BigDecimal.ZERO;
        }
        String[] goodsSeqArray = goodsSeq.split(",");
        if (goodsSeqArray.length == 0) {
            return BigDecimal.ZERO;
        }
        List<String> lstGoodsSeq = Arrays.asList(goodsSeqArray);
        return SaleOrderAmountHelper.getGoodsAmount(lstGoodsSeq, lstGoodsEntry);
    }

    public static String getGoodsSeq(List<DynamicObject> lstGoodsEntry, DynamicObject doTicketType, String newAmtPriceWay) {
        String goodsSeq = "";
        String usageMode = doTicketType.getString("usagemode");
        boolean isAllGoods = doTicketType.getBoolean("isallgoods");
        if (isAllGoods) {
            goodsSeq = TicketAmountHelper.getGoodsSeq(lstGoodsEntry);
        } else {
            Map<String, BigDecimal> mapResult = TicketAmountHelper.getTicketGoodsAmount(lstGoodsEntry, doTicketType, usageMode, newAmtPriceWay);
            if (mapResult.size() > 0) {
                goodsSeq = (String)((Map.Entry)mapResult.entrySet().stream().findFirst().get()).getKey();
            }
        }
        return goodsSeq;
    }

    public static BigDecimal getApplyGoodsAmount(List<DynamicObject> lstGoodsEntry, String newAmtPriceWay, String goodsSeq) {
        if (StringUtils.isEmpty((CharSequence)goodsSeq)) {
            return BigDecimal.ZERO;
        }
        String[] goodsSeqArray = goodsSeq.split(",");
        if (goodsSeqArray.length == 0) {
            return BigDecimal.ZERO;
        }
        List<String> lstGoodsSeq = Arrays.asList(goodsSeqArray);
        return TicketAmountHelper.getApplyGoodsAmount(lstGoodsSeq, lstGoodsEntry, newAmtPriceWay);
    }

    public static BigDecimal getApplyGoodsAmount(List<String> lstGoodsSeq, List<DynamicObject> lstGoodsEntry, String newAmtPriceWay) {
        BigDecimal goodsAmount = BigDecimal.ZERO;
        for (String seq : lstGoodsSeq) {
            DynamicObject doGoodsEntry = lstGoodsEntry.stream().filter(x -> StringUtils.equals((CharSequence)DynamicObjectUtil.getString((DynamicObject)x, (String)"seq"), (CharSequence)seq)).findFirst().orElse(null);
            if (doGoodsEntry == null) continue;
            BigDecimal amount = StringUtils.equals((CharSequence)newAmtPriceWay, (CharSequence)"1") ? DynamicObjectUtil.getBigDecimal((DynamicObject)doGoodsEntry, (String)"amount") : DynamicObjectUtil.getBigDecimal((DynamicObject)doGoodsEntry, (String)"balamount");
            goodsAmount = goodsAmount.add(amount);
        }
        return goodsAmount;
    }

    public static Map<Boolean, String> isMatchSingleItem(List<DynamicObject> lstGoodsEntry, DynamicObject doTicketType, String ticketNo) {
        DynamicObjectCollection ticketTypeGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)doTicketType, (String)"tictgoodsentry");
        HashMap<Boolean, String> mapRlt = new HashMap<Boolean, String>(0);
        if (CollectionUtils.isEmpty((Collection)ticketTypeGoodsEntry)) {
            mapRlt.put(Boolean.FALSE, String.format("\u793c\u5238\u7f16\u53f7%s\u793c\u5238\u7c7b\u578b\u9002\u7528\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a\u3002", ticketNo));
            return mapRlt;
        }
        String usageMode = DynamicObjectUtils.getString((DynamicObject)doTicketType, (String)"usagemode");
        Map<String, BigDecimal> mapResult = SaleOrderHelper.calcGoodsAmount(lstGoodsEntry, doTicketType, usageMode);
        if (mapResult.size() == 0) {
            mapRlt.put(Boolean.FALSE, String.format("\u793c\u5238\u7f16\u53f7%s\u672a\u5339\u914d\u5230\u9002\u7528\u5546\u54c1\u6216\u6240\u9009\u5546\u54c1\u4e0d\u6ee1\u8db3\u6700\u4f4e\u6d88\u8d39\u989d\u3002", ticketNo));
            return mapRlt;
        }
        String goodsSeq = (String)((Map.Entry)mapResult.entrySet().stream().findFirst().get()).getKey();
        if (StringUtils.isEmpty((CharSequence)goodsSeq)) {
            mapRlt.put(Boolean.FALSE, String.format("\u793c\u5238\u7f16\u53f7%s\u672a\u83b7\u53d6\u5230\u5546\u54c1\u5e8f\u53f7\u3002", ticketNo));
            return mapRlt;
        }
        String[] goodsSeqArray = goodsSeq.split(",");
        if (goodsSeq.length() == 0) {
            mapRlt.put(Boolean.FALSE, String.format("\u793c\u5238\u7f16\u53f7%s\u672a\u83b7\u53d6\u5230\u5546\u54c1\u5e8f\u53f7\u3002", ticketNo));
            return mapRlt;
        }
        for (String seq : goodsSeqArray) {
            DynamicObject doGoodsEntry = lstGoodsEntry.stream().filter(x -> StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"seq"), (CharSequence)seq)).findFirst().orElse(null);
            if (doGoodsEntry == null) continue;
            BigDecimal balAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"balamount");
            block13: for (DynamicObject goods : ticketTypeGoodsEntry) {
                String goodsType = DynamicObjectUtils.getString((DynamicObject)goods, (String)"type");
                long goodsClassifyId = DynamicObjectUtils.getPkValue((DynamicObject)goods, (String)"goodsclassify");
                Set classIds = ItemClassNodeUtil.queryChildItemClass(new HashSet<Long>(Collections.singleton(goodsClassifyId)));
                long brandId = DynamicObjectUtils.getPkValue((DynamicObject)goods, (String)"brand");
                switch (goodsType) {
                    case "1": {
                        long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)goods, (String)"goods");
                        if (DynamicObjectUtils.getPkValue((DynamicObject)doGoodsEntry, (String)"goodsid") == goodsId) break;
                        continue block13;
                    }
                    case "2": {
                        if (TicketAmountHelper.isMatchGoodsClass(classIds, Collections.singletonList(doGoodsEntry))) break;
                        continue block13;
                    }
                    case "3": {
                        if (DynamicObjectUtils.getPkValue((DynamicObject)doGoodsEntry, (String)"brand") == brandId) break;
                        continue block13;
                    }
                    case "5": {
                        if (TicketAmountHelper.isMatchGoodsClass(classIds, Collections.singletonList(doGoodsEntry)) && DynamicObjectUtils.getPkValue((DynamicObject)doGoodsEntry, (String)"brand") == brandId) break;
                        continue block13;
                    }
                    default: {
                        continue block13;
                    }
                }
                if (balAmount.compareTo(DynamicObjectUtils.getBigDecimal((DynamicObject)goods, (String)"minconsumeamt")) < 0) continue;
                mapRlt.put(Boolean.TRUE, seq);
                return mapRlt;
            }
        }
        mapRlt.put(Boolean.FALSE, String.format("\u793c\u5238\u7f16\u53f7%s\u5339\u914d\u5546\u54c1\u4e0d\u6ee1\u8db3\u793c\u5238\u7c7b\u578b\u9002\u7528\u5546\u54c1\u6700\u4f4e\u6d88\u8d39\u91d1\u989d\u8bbe\u7f6e\u3002", ticketNo));
        return mapRlt;
    }

    public static Map<Boolean, String> isMatchSingleItemAmt(List<DynamicObject> lstGoodsEntry, DynamicObject doTicketType, String ticketNo, String newAmtPriceWay) {
        DynamicObjectCollection ticketTypeGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)doTicketType, (String)"tictgoodsentry");
        HashMap<Boolean, String> mapRlt = new HashMap<Boolean, String>(0);
        if (CollectionUtils.isEmpty((Collection)ticketTypeGoodsEntry)) {
            mapRlt.put(Boolean.FALSE, String.format("\u793c\u5238\u7f16\u53f7%s\u793c\u5238\u7c7b\u578b\u9002\u7528\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a\u3002", ticketNo));
            return mapRlt;
        }
        String usageMode = DynamicObjectUtils.getString((DynamicObject)doTicketType, (String)"usagemode");
        Map<String, BigDecimal> mapResult = TicketAmountHelper.getTicketGoodsAmount(lstGoodsEntry, doTicketType, usageMode, newAmtPriceWay);
        if (mapResult.size() == 0) {
            mapRlt.put(Boolean.FALSE, String.format("\u793c\u5238\u7f16\u53f7%s\u672a\u5339\u914d\u5230\u9002\u7528\u5546\u54c1\u6216\u6240\u9009\u5546\u54c1\u4e0d\u6ee1\u8db3\u6700\u4f4e\u6d88\u8d39\u989d\u3002", ticketNo));
            return mapRlt;
        }
        String goodsSeq = (String)((Map.Entry)mapResult.entrySet().stream().findFirst().get()).getKey();
        if (StringUtils.isEmpty((CharSequence)goodsSeq)) {
            mapRlt.put(Boolean.FALSE, String.format("\u793c\u5238\u7f16\u53f7%s\u672a\u83b7\u53d6\u5230\u5546\u54c1\u5e8f\u53f7\u3002", ticketNo));
            return mapRlt;
        }
        String[] goodsSeqArray = goodsSeq.split(",");
        if (goodsSeq.length() == 0) {
            mapRlt.put(Boolean.FALSE, String.format("\u793c\u5238\u7f16\u53f7%s\u672a\u83b7\u53d6\u5230\u5546\u54c1\u5e8f\u53f7\u3002", ticketNo));
            return mapRlt;
        }
        for (String seq : goodsSeqArray) {
            DynamicObject doGoodsEntry = lstGoodsEntry.stream().filter(x -> StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"seq"), (CharSequence)seq)).findFirst().orElse(null);
            if (doGoodsEntry == null) continue;
            BigDecimal amount = StringUtils.equals((CharSequence)newAmtPriceWay, (CharSequence)"1") ? DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"amount") : DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"balamount");
            for (DynamicObject goods : ticketTypeGoodsEntry) {
                boolean isMatch = TicketAmountHelper.isMatchGoods(goods, doGoodsEntry);
                if (!isMatch || amount.compareTo(DynamicObjectUtils.getBigDecimal((DynamicObject)goods, (String)"minconsumeamt")) < 0) continue;
                mapRlt.put(Boolean.TRUE, seq);
                return mapRlt;
            }
        }
        mapRlt.put(Boolean.FALSE, String.format("\u793c\u5238\u7f16\u53f7%s\u5339\u914d\u5546\u54c1\u4e0d\u6ee1\u8db3\u793c\u5238\u7c7b\u578b\u9002\u7528\u5546\u54c1\u6700\u4f4e\u6d88\u8d39\u91d1\u989d\u8bbe\u7f6e\u3002", ticketNo));
        return mapRlt;
    }

    public static Map<Boolean, String> isMatchSingleItemQty(List<DynamicObject> lstGoodsEntry, DynamicObject doTicketType, String ticketNo) {
        DynamicObjectCollection ticketTypeGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)doTicketType, (String)"tictgoodsentry");
        HashMap<Boolean, String> mapRlt = new HashMap<Boolean, String>(0);
        if (CollectionUtils.isEmpty((Collection)ticketTypeGoodsEntry)) {
            mapRlt.put(Boolean.FALSE, String.format("\u793c\u5238\u7f16\u53f7%s\u793c\u5238\u7c7b\u578b\u9002\u7528\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a\u3002", ticketNo));
            return mapRlt;
        }
        Map<String, BigDecimal> mapResult = TicketAmountHelper.getTicketGoodsQty(lstGoodsEntry, doTicketType);
        if (mapResult.size() == 0) {
            mapRlt.put(Boolean.FALSE, String.format("\u793c\u5238\u7f16\u53f7%s\u672a\u5339\u914d\u5230\u9002\u7528\u5546\u54c1\u3002", ticketNo));
            return mapRlt;
        }
        String goodsSeq = (String)((Map.Entry)mapResult.entrySet().stream().findFirst().get()).getKey();
        if (StringUtils.isEmpty((CharSequence)goodsSeq)) {
            mapRlt.put(Boolean.FALSE, String.format("\u793c\u5238\u7f16\u53f7%s\u672a\u83b7\u53d6\u5230\u5546\u54c1\u5e8f\u53f7\u3002", ticketNo));
            return mapRlt;
        }
        String[] goodsSeqArray = goodsSeq.split(",");
        if (goodsSeq.length() == 0) {
            mapRlt.put(Boolean.FALSE, String.format("\u793c\u5238\u7f16\u53f7%s\u672a\u83b7\u53d6\u5230\u5546\u54c1\u5e8f\u53f7\u3002", ticketNo));
            return mapRlt;
        }
        for (String seq : goodsSeqArray) {
            DynamicObject doGoodsEntry = lstGoodsEntry.stream().filter(x -> StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"seq"), (CharSequence)seq)).findFirst().orElse(null);
            if (doGoodsEntry == null) continue;
            BigDecimal saleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"saleqty");
            for (DynamicObject goods : ticketTypeGoodsEntry) {
                boolean isMatch = TicketAmountHelper.isMatchGoods(goods, doGoodsEntry);
                if (!isMatch || saleQty.compareTo(DynamicObjectUtils.getBigDecimal((DynamicObject)goods, (String)"qty")) < 0) continue;
                mapRlt.put(Boolean.TRUE, seq);
                return mapRlt;
            }
        }
        mapRlt.put(Boolean.FALSE, String.format("\u793c\u5238\u7f16\u53f7%s\u5339\u914d\u5546\u54c1\u4e0d\u6ee1\u8db3\u793c\u5238\u7c7b\u578b\u9002\u7528\u5546\u54c1\u5355\u54c1\u63a7\u5236\u6570\u91cf\u8bbe\u7f6e\u3002", ticketNo));
        return mapRlt;
    }

    public static Long getTicketQty(List<DynamicObject> lstGoodsEntry, DynamicObject doTicketType, String goodsSeq, String newAmtPriceWay, String singleItemType) {
        if (StringUtils.isEmpty((CharSequence)goodsSeq)) {
            return 0L;
        }
        String[] goodsSeqArray = goodsSeq.split(",");
        if (goodsSeq.length() == 0) {
            return 0L;
        }
        long ticketQty = 0L;
        DynamicObjectCollection ticketTypeGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)doTicketType, (String)"tictgoodsentry");
        for (String seq : goodsSeqArray) {
            DynamicObject doGoodsEntry = lstGoodsEntry.stream().filter(x -> StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"seq"), (CharSequence)seq)).findFirst().orElse(null);
            if (doGoodsEntry == null) continue;
            BigDecimal amount = StringUtils.equals((CharSequence)newAmtPriceWay, (CharSequence)"1") ? DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"amount") : DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"balamount");
            BigDecimal saleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"saleqty");
            for (DynamicObject goods : ticketTypeGoodsEntry) {
                long qty;
                boolean isMatch = TicketAmountHelper.isMatchGoods(goods, doGoodsEntry);
                if (!isMatch) continue;
                if (StringUtils.equals((CharSequence)singleItemType, (CharSequence)"1")) {
                    BigDecimal minConsumeAmt = DynamicObjectUtils.getBigDecimal((DynamicObject)goods, (String)"minconsumeamt");
                    if (minConsumeAmt.compareTo(BigDecimal.ZERO) <= 0 || amount.compareTo(minConsumeAmt) < 0) continue;
                    qty = CommonUtil.formatObejctToLong((Object)amount.divideAndRemainder(minConsumeAmt)[0]);
                    if (ticketQty != 0L && ticketQty <= qty) continue;
                    ticketQty = qty;
                    continue;
                }
                BigDecimal minQty = DynamicObjectUtils.getBigDecimal((DynamicObject)goods, (String)"qty");
                if (minQty.compareTo(BigDecimal.ZERO) <= 0 || saleQty.compareTo(minQty) < 0) continue;
                qty = CommonUtil.formatObejctToLong((Object)saleQty.divideAndRemainder(minQty)[0]);
                if (ticketQty != 0L && ticketQty <= qty) continue;
                ticketQty = qty;
            }
        }
        return ticketQty;
    }

    private static boolean isMatchGoods(DynamicObject tictGoods, DynamicObject doGoodsEntry) {
        DynamicObjectCollection docInvType;
        String goodsType = DynamicObjectUtils.getString((DynamicObject)tictGoods, (String)"type");
        long goodsClassifyId = DynamicObjectUtils.getPkValue((DynamicObject)tictGoods, (String)"goodsclassify");
        Set classIds = ItemClassNodeUtil.queryChildItemClass(new HashSet<Long>(Collections.singleton(goodsClassifyId)));
        long brandId = DynamicObjectUtils.getPkValue((DynamicObject)tictGoods, (String)"brand");
        ArrayList<Long> saleAttrIds = new ArrayList(0);
        ArrayList<Long> invTypeIds = new ArrayList(0);
        DynamicObjectCollection docSaleAttr = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)tictGoods, (String)"saleattr");
        if (!CollectionUtils.isEmpty((Collection)docSaleAttr)) {
            saleAttrIds = MultiBaseDataUtil.getMultiF7PKValueList((DynamicObjectCollection)docSaleAttr);
        }
        if (!CollectionUtils.isEmpty((Collection)(docInvType = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)tictGoods, (String)"invttype")))) {
            invTypeIds = MultiBaseDataUtil.getMultiF7PKValueList((DynamicObjectCollection)docInvType);
        }
        switch (goodsType) {
            case "1": {
                long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)tictGoods, (String)"goods");
                if (DynamicObjectUtils.getPkValue((DynamicObject)doGoodsEntry, (String)"goodsid") == goodsId) break;
                return false;
            }
            case "2": {
                if (TicketAmountHelper.isMatchGoodsClass(classIds, Collections.singletonList(doGoodsEntry))) break;
                return false;
            }
            case "3": {
                if (DynamicObjectUtils.getPkValue((DynamicObject)doGoodsEntry, (String)"brand") == brandId) break;
                return false;
            }
            case "5": {
                if (!TicketAmountHelper.isMatchGoodsClass(classIds, Collections.singletonList(doGoodsEntry))) {
                    return false;
                }
                if (DynamicObjectUtils.getPkValue((DynamicObject)doGoodsEntry, (String)"brand") == brandId) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return TicketAmountHelper.isMatchSaleAttrOrInvType(saleAttrIds, invTypeIds, Collections.singletonList(doGoodsEntry));
    }

    public static Map<String, BigDecimal> getTicketGoodsAmount(List<DynamicObject> docGoodsEntry, DynamicObject doTicketType, String usageMode, String newAmtPriceWay) {
        String goodsSeq = "";
        BigDecimal sumAmount = BigDecimal.ZERO;
        HashMap<String, BigDecimal> mapResult = new HashMap<String, BigDecimal>(0);
        DynamicObjectCollection docTictGoods = DynamicObjectUtil.getDynamicObjectCollection((DynamicObject)doTicketType, (String)"tictgoodsentry");
        if (CollectionUtils.isEmpty(docGoodsEntry) || CollectionUtils.isEmpty((Collection)docTictGoods)) {
            return mapResult;
        }
        block0: for (DynamicObject doGoodsEntry : docGoodsEntry) {
            String seq = DynamicObjectUtil.getString((DynamicObject)doGoodsEntry, (String)"seq");
            for (DynamicObject goods : docTictGoods) {
                boolean isMatch = TicketAmountHelper.isMatchGoods(goods, doGoodsEntry);
                if (!isMatch) continue;
                if (StringUtils.equals((CharSequence)"0", (CharSequence)usageMode) || StringUtils.equals((CharSequence)"1", (CharSequence)usageMode)) {
                    BigDecimal amount = StringUtils.equals((CharSequence)newAmtPriceWay, (CharSequence)"1") ? DynamicObjectUtil.getBigDecimal((DynamicObject)doGoodsEntry, (String)"amount") : DynamicObjectUtil.getBigDecimal((DynamicObject)doGoodsEntry, (String)"balamount");
                    sumAmount = sumAmount.add(amount);
                    if (StringUtils.isEmpty((CharSequence)goodsSeq)) {
                        goodsSeq = seq;
                        continue block0;
                    }
                    goodsSeq = goodsSeq + "," + seq;
                    continue block0;
                }
                if (!StringUtils.equals((CharSequence)"2", (CharSequence)usageMode)) continue;
                BigDecimal balPrice = DynamicObjectUtil.getBigDecimal((DynamicObject)doGoodsEntry, (String)"discountprice");
                sumAmount = sumAmount.add(balPrice);
                mapResult.put(seq, sumAmount);
                return mapResult;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)goodsSeq)) {
            mapResult.put(goodsSeq, sumAmount);
        }
        return mapResult;
    }

    public static Map<String, BigDecimal> getTicketGoodsQty(List<DynamicObject> docGoodsEntry, DynamicObject doTicketType) {
        String goodsSeq = "";
        BigDecimal sumSqlQty = BigDecimal.ZERO;
        HashMap<String, BigDecimal> mapResult = new HashMap<String, BigDecimal>(0);
        DynamicObjectCollection docTictGoods = DynamicObjectUtil.getDynamicObjectCollection((DynamicObject)doTicketType, (String)"tictgoodsentry");
        if (CollectionUtils.isEmpty(docGoodsEntry) || CollectionUtils.isEmpty((Collection)docTictGoods)) {
            return mapResult;
        }
        for (DynamicObject doGoodsEntry : docGoodsEntry) {
            String seq = DynamicObjectUtil.getString((DynamicObject)doGoodsEntry, (String)"seq");
            block13: for (DynamicObject goods : docTictGoods) {
                DynamicObjectCollection docInvType;
                String goodsType = DynamicObjectUtils.getString((DynamicObject)goods, (String)"type");
                long goodsClassifyId = DynamicObjectUtils.getPkValue((DynamicObject)goods, (String)"goodsclassify");
                Set classIds = ItemClassNodeUtil.queryChildItemClass(new HashSet<Long>(Collections.singleton(goodsClassifyId)));
                long brandId = DynamicObjectUtils.getPkValue((DynamicObject)goods, (String)"brand");
                ArrayList<Long> saleAttrIds = new ArrayList(0);
                ArrayList<Long> invTypeIds = new ArrayList(0);
                DynamicObjectCollection docSaleAttr = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)goods, (String)"saleattr");
                if (!CollectionUtils.isEmpty((Collection)docSaleAttr)) {
                    saleAttrIds = MultiBaseDataUtil.getMultiF7PKValueList((DynamicObjectCollection)docSaleAttr);
                }
                if (!CollectionUtils.isEmpty((Collection)(docInvType = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)goods, (String)"invttype")))) {
                    invTypeIds = MultiBaseDataUtil.getMultiF7PKValueList((DynamicObjectCollection)docInvType);
                }
                switch (goodsType) {
                    case "1": {
                        long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)goods, (String)"goods");
                        if (DynamicObjectUtils.getPkValue((DynamicObject)doGoodsEntry, (String)"goodsid") == goodsId) break;
                        continue block13;
                    }
                    case "2": {
                        if (TicketAmountHelper.isMatchGoodsClass(classIds, Collections.singletonList(doGoodsEntry))) break;
                        continue block13;
                    }
                    case "3": {
                        if (DynamicObjectUtils.getPkValue((DynamicObject)doGoodsEntry, (String)"brand") == brandId) break;
                        continue block13;
                    }
                    case "5": {
                        if (TicketAmountHelper.isMatchGoodsClass(classIds, Collections.singletonList(doGoodsEntry)) && DynamicObjectUtils.getPkValue((DynamicObject)doGoodsEntry, (String)"brand") == brandId) break;
                        continue block13;
                    }
                }
                if (!TicketAmountHelper.isMatchSaleAttrOrInvType(saleAttrIds, invTypeIds, Collections.singletonList(doGoodsEntry))) continue;
                BigDecimal saleQty = DynamicObjectUtil.getBigDecimal((DynamicObject)doGoodsEntry, (String)"saleqty");
                sumSqlQty = sumSqlQty.add(saleQty);
                if (StringUtils.isEmpty((CharSequence)goodsSeq)) {
                    goodsSeq = seq;
                    continue;
                }
                goodsSeq = goodsSeq + "," + seq;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)goodsSeq)) {
            mapResult.put(goodsSeq, sumSqlQty);
        }
        return mapResult;
    }

    public static boolean isCondition(DynamicObject doTicketType, DynamicObjectCollection docEntry) {
        long cnt;
        boolean rlt = true;
        String condition = DynamicObjectUtil.getString((DynamicObject)doTicketType, (String)"condition");
        if (!StringUtils.isEmpty((CharSequence)condition) && !ObjectUtils.isEmpty((Object)docEntry) && StringUtils.equals((CharSequence)condition, (CharSequence)"1") && (cnt = docEntry.stream().filter(x -> x.getLong("tickettypeid") == DynamicObjectUtil.getPkValue((DynamicObject)doTicketType).longValue()).count()) > 0L) {
            rlt = false;
        }
        return rlt;
    }

    public static boolean validateEndDate(IFormView view, DynamicObject doTicket) {
        boolean rlt = true;
        Object sEndDate = DynamicObjectUtil.get((DynamicObject)doTicket, (String)"endtime");
        if (!ObjectUtils.isEmpty((Object)sEndDate)) {
            try {
                Date endDate = (Date)sEndDate;
                if (endDate.before(TimeServiceHelper.now())) {
                    TicketAmountHelper.clearTicket(view);
                    rlt = false;
                }
            }
            catch (Exception e1) {
                rlt = false;
            }
        }
        return rlt;
    }
}

