/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.report.form;

import java.util.Calendar;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.common.util.OwnerUtil;

public abstract class AbstractAnalysisReportForm
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    public static final String BOS_LIST = "bos_listf7";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        MulBasedataEdit branch = (MulBasedataEdit)this.getView().getControl("branchfilter");
        branch.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit channelType = (MulBasedataEdit)this.getView().getControl("channeltypefilter");
        MulBasedataEdit grade = (MulBasedataEdit)this.getView().getControl("gradefilter");
        channelType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        grade.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Calendar now = Calendar.getInstance();
        this.getModel().setValue("enddate", (Object)now.getTime());
        now.add(5, -30);
        this.getModel().setValue("startdate", (Object)now.getTime());
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        long userId = UserServiceHelper.getCurrentUserId();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if (StringUtils.equals((CharSequence)"branchfilter", (CharSequence)fieldKey)) {
            List branchId = OwnerUtil.getBranchId((long)userId);
            QFilter branchFilter = new QFilter("id", "in", (Object)branchId);
            showParameter.setFormId(BOS_LIST);
            showParameter.getListFilterParameter().setFilter(branchFilter);
        } else if (StringUtils.equals((CharSequence)"channeltypefilter", (CharSequence)fieldKey)) {
            DynamicObjectCollection branch = (DynamicObjectCollection)this.getModel().getValue("branchfilter");
            if (CollectionUtils.isEmpty((Collection)branch)) {
                NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u9009\u62e9\u95e8\u5e97\u3002", (IFormView)this.getView());
                e.setCancel(true);
                return;
            }
            List channelType = OwnerUtil.getChannelType(branch.stream().map(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"fbasedataid")).collect(Collectors.toList()));
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)channelType));
        } else if (StringUtils.equals((CharSequence)"gradefilter", (CharSequence)fieldKey)) {
            DynamicObjectCollection branch = (DynamicObjectCollection)this.getModel().getValue("branchfilter");
            if (CollectionUtils.isEmpty((Collection)branch)) {
                NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u9009\u62e9\u95e8\u5e97\u3002", (IFormView)this.getView());
                e.setCancel(true);
                return;
            }
            List channelGrade = OwnerUtil.getChannelGrade(branch.stream().map(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"fbasedataid")).collect(Collectors.toList()));
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)channelGrade));
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObjectCollection branch = filterInfo.getDynamicObjectCollection("branchfilter");
        if (CollectionUtils.isEmpty((Collection)branch)) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u9009\u62e9\u95e8\u5e97\u3002", (IFormView)this.getView());
            return false;
        }
        return this.customizeVerifyQuery(filterInfo);
    }

    protected abstract boolean customizeVerifyQuery(FilterInfo var1);
}

