/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.report.form;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.occ.ocbase.common.util.OwnerUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.common.util.DynamicObjectUtil;
import kd.occ.ocpos.common.util.OwnerUtil;

public abstract class AbstractPosReportForm
extends AbstractReportFormPlugin {
    public static final String MUL_BASE_DATA = "fbasedataid";
    public static final String BOS_LIST = "bos_listf7";

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
        long branchId = OwnerUtils.getDefaultOwnerId((boolean)true);
        if (branchId > 0L) {
            DynamicObject branch = BusinessDataServiceHelper.loadSingle((Object)branchId, (String)"ocdbd_channel", (String)"currency");
            this.getView().getModel().setItemValueByID("salesbranchid", (Object)branchId);
            this.getView().getModel().setItemValueByID("currency", (Object)DynamicObjectUtil.getPkValue((DynamicObject)branch, (String)"currency"));
        }
        Calendar calendar = Calendar.getInstance();
        Date today = TimeServiceHelper.today();
        this.getModel().setValue("saledaterange_enddate", (Object)today);
        calendar.setTime(today);
        calendar.add(5, -30);
        this.getModel().setValue("saledaterange_startdate", (Object)calendar.getTime());
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        if (filterInfo != null) {
            Date startDate = filterInfo.getDate("saledaterange_startdate");
            if (startDate == null) {
                NotificationUtil.showDefaultTipNotify((String)ResManager.loadKDString((String)"\u9500\u552e\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"AbstractPosReportForm", (String)"ocpos-report", (Object[])new Object[0]), (IFormView)this.getView());
                return false;
            }
            DynamicObjectCollection branchEntry = filterInfo.getDynamicObjectCollection("salesbranchid");
            if (CollectionUtils.isEmpty((Collection)branchEntry)) {
                NotificationUtil.showDefaultTipNotify((String)ResManager.loadKDString((String)"\u9500\u552e\u95e8\u5e97\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"AbstractPosReportForm", (String)"ocpos-report", (Object[])new Object[0]), (IFormView)this.getView());
                return false;
            }
            return this.customizeVerifyQuery(filterInfo);
        }
        return false;
    }

    protected void setColumnHide(List<AbstractReportColumn> columns, boolean showSaleCount) {
        columns.forEach(column -> {
            if (!showSaleCount && column instanceof ReportColumn && "salecount".equals(((ReportColumn)column).getFieldKey())) {
                ((ReportColumn)column).setHide(true);
            }
        });
    }

    protected abstract boolean customizeVerifyQuery(FilterInfo var1);

    public QFilter getSalespersonFilter(Set<Long> branchId) {
        QFilter filter = new QFilter("owner", "in", branchId);
        filter.and("issaler", "=", (Object)"1");
        return filter;
    }

    public QFilter getBranchFilter() {
        List branchIdList = OwnerUtil.getOwnerIds((String[])new String[0]);
        return new QFilter("Id", "in", (Object)branchIdList);
    }
}

