/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.report.form;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterInfo;
import kd.bos.form.IFormView;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.business.commonhelper.CashierHelper;
import kd.occ.ocpos.common.util.OwnerUtil;
import kd.occ.ocpos.report.form.AbstractPosReportForm;

public class CashierReportForm
extends AbstractPosReportForm
implements BeforeF7SelectListener {
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        long branchId = OwnerUtil.getDefaultOwnerId();
        if (branchId == 0L) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u662f\u6536\u94f6\u5458\uff0c\u65e0\u6743\u67e5\u770b\u62a5\u8868\u4fe1\u606f\u3002", (String)"CashierReportForm", (String)"occ-ocpos-report", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        MulBasedataEdit branch = (MulBasedataEdit)this.getView().getControl("salesbranchid");
        branch.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit cashier = (MulBasedataEdit)this.getView().getControl("cashierid");
        cashier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    protected boolean customizeVerifyQuery(FilterInfo filterInfo) {
        return true;
    }

    public QFilter getCashierFilter(Set<Long> branchId) {
        boolean isDirector = CashierHelper.checkCashierAuth((long)1311543339870394368L);
        QFilter filter = new QFilter("owner", "in", branchId);
        filter.and("iscashier", "=", (Object)"1");
        if (!isDirector) {
            filter.and("sysuser", "=", (Object)UserServiceHelper.getCurrentUserId());
        }
        return filter;
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String property = evt.getProperty().getName();
        DynamicObjectCollection branch = this.getModel().getDataEntity(true).getDynamicObjectCollection("salesbranchid");
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        if ("salesbranchid".equals(property)) {
            showParameter.setFormId("bos_listf7");
            showParameter.getListFilterParameter().getQFilters().add(this.getBranchFilter());
        }
        if ("cashierid".equals(property)) {
            if (CollectionUtils.isEmpty((Collection)branch)) {
                NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u5f55\u5165\u9500\u552e\u95e8\u5e97\u3002", (IFormView)this.getView());
                evt.setCancel(true);
            } else {
                Set<Long> branchId = branch.stream().map(a -> DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject("fbasedataid"))).collect(Collectors.toSet());
                showParameter.getListFilterParameter().getQFilters().add(this.getCashierFilter(branchId));
            }
        }
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        List columns = event.getColumns();
        boolean showSaleCount = (Boolean)this.getModel().getValue("showsalecount");
        this.setColumnHide(columns, showSaleCount);
    }
}

