/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.report.form;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.common.util.OwnerUtil;

public class PayCheckReportForm
extends AbstractReportFormPlugin {
    public static final String BOS_LIST = "bos_listf7";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit store = (BasedataEdit)this.getView().getControl("storeparam");
        store.addBeforeF7SelectListener(a -> {
            ListShowParameter formShowParameter = (ListShowParameter)a.getFormShowParameter();
            List branchIdList = OwnerUtil.getOwnerIds((String[])new String[0]);
            formShowParameter.setFormId(BOS_LIST);
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("Id", "in", (Object)branchIdList));
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        QFilter filter = new QFilter("sysuser", "=", (Object)UserServiceHelper.getCurrentUserId());
        filter.and("enable", "=", (Object)"1");
        filter.and("isdefault", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject channelUser = BusinessDataServiceHelper.loadSingle((String)"ocdbd_channeluser", (String)"owner", (QFilter[])filters);
        if (channelUser != null) {
            this.getModel().setItemValueByID("storeparam", channelUser.getDynamicObject("owner").getPkValue());
        }
        this.getModel().setValue("startdateparam", (Object)DateUtil.getBeforeDay((Date)TimeServiceHelper.now(), (int)30));
        this.getModel().setValue("enddateparam", (Object)TimeServiceHelper.now());
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        Date startDate = filterInfo.getDate("startdateparam");
        if (startDate == null) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u9009\u62e9\u5f00\u59cb\u65e5\u671f\u3002", (IFormView)this.getView());
            return false;
        }
        Date endDate = filterInfo.getDate("enddateparam");
        if (endDate == null) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u9009\u62e9\u7ed3\u675f\u65e5\u671f\u3002", (IFormView)this.getView());
            return false;
        }
        DynamicObjectCollection store = filterInfo.getDynamicObjectCollection("storeparam");
        if (CollectionUtils.isEmpty((Collection)store)) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u9009\u62e9\u95e8\u5e97\u3002", (IFormView)this.getView());
            return false;
        }
        return true;
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        DynamicObjectCollection storeTypeParam;
        super.afterCreateColumn(event);
        List columns = event.getColumns();
        DynamicObjectCollection storeClassParam = (DynamicObjectCollection)this.getModel().getValue("storeclassparam");
        if (CollectionUtils.isEmpty((Collection)storeClassParam)) {
            columns.forEach(column -> {
                if (column instanceof ReportColumn && "storeclass".equals(((ReportColumn)column).getFieldKey())) {
                    ((ReportColumn)column).setHide(true);
                }
            });
        }
        if (CollectionUtils.isEmpty((Collection)(storeTypeParam = (DynamicObjectCollection)this.getModel().getValue("storetypeparam")))) {
            columns.forEach(column -> {
                if (column instanceof ReportColumn && "storetype".equals(((ReportColumn)column).getFieldKey())) {
                    ((ReportColumn)column).setHide(true);
                }
            });
        }
    }
}

