/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.report.form;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.business.commonhelper.DataChangeHelper;
import kd.occ.ocpos.business.commonhelper.OrgHelper;
import kd.occ.ocpos.common.util.CommonUtil;

public class StoreInvAnalyseRptPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener {
    protected static final String HAS_PERMISSION_AND_STARTED_INV_ORG = "HasPermissionAndStartedInvOrg";
    public static final int formatDisplayFilterFieldLength = 20;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap", "baritemap", "baritemap1"});
        this.addF7Listener(this, "multiorghead", "multisupplierhead", "multistorehead", "multigoodshead", "multibrandhead", "multigoodsclasshead", "ivntypehead", "multiwarehousehead");
    }

    private Map<String, Object> getHasPermOrgIds() {
        String userHasPermOrgs = this.getPageCache().get("hasPermOrgIds");
        if (userHasPermOrgs == null) {
            long userId = UserServiceHelper.getCurrentUserId();
            HasPermOrgResult userHasPermOrgIds = PermissionServiceHelper.getUserHasPermOrgs((long)userId);
            HashMap<String, Object> hasPermOrgMap = new HashMap<String, Object>(16);
            if (userHasPermOrgIds == null) {
                hasPermOrgMap.put("hasAllPermOrgs", Boolean.TRUE);
            } else {
                hasPermOrgMap.put("hasAllPermOrgs", userHasPermOrgIds.hasAllOrgPerm());
                hasPermOrgMap.put("hasPermOrgs", userHasPermOrgIds.getHasPermOrgs());
            }
            userHasPermOrgs = SerializationUtils.serializeToBase64(hasPermOrgMap);
            this.getPageCache().put("hasPermOrgIds", userHasPermOrgs);
        }
        return (Map)SerializationUtils.deSerializeFromBase64((String)userHasPermOrgs);
    }

    public void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        if (!(form instanceof AbstractFormPlugin)) {
            return;
        }
        AbstractFormPlugin locForm = (AbstractFormPlugin)form;
        for (String s : f7Name) {
            BasedataEdit f7 = (BasedataEdit)locForm.getControl(s);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (key) {
            case "multiorghead": {
                this.beforeF7SelectOrg(showParameter);
                break;
            }
            case "ivntypehead": {
                this.beforeF7SelectByEnable(showParameter);
                break;
            }
            case "multiwarehousehead": {
                this.beforeF7WarehouseFrom(showParameter);
                break;
            }
            case "multistorehead": {
                this.beforeF7ChannelFrom(showParameter);
                break;
            }
            case "multigoodsclasshead": {
                this.beforeF7GoodsClassFrom(showParameter);
                break;
            }
        }
    }

    public void beforeF7WarehouseFrom(ListShowParameter showParameter) {
        Object org = this.getModel().getValue("multiorghead");
        if (org instanceof DynamicObjectCollection) {
            ArrayList<Object> listOrgId = new ArrayList<Object>(0);
            for (DynamicObject dynamicObject : (DynamicObjectCollection)org) {
                listOrgId.add(dynamicObject.get("fbasedataid_id"));
            }
            List<Long> allWhs = this.getAllWarehouse(listOrgId);
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", allWhs));
        }
    }

    public void beforeF7ChannelFrom(ListShowParameter showParameter) {
        QFilter qFilter = new QFilter("sysuser.id", "=", (Object)CommonUtil.formatObejctToLong((Object)RequestContext.get().getUserId()));
        DynamicObjectCollection channelUser = QueryServiceHelper.query((String)"ocdbd_channeluser", (String)"owner.id", (QFilter[])qFilter.toArray(), null);
        List lstChannelId = channelUser.stream().map(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"owner.id")).collect(Collectors.toList());
        QFilter channelFilter = new QFilter("id", "in", lstChannelId);
        showParameter.getListFilterParameter().getQFilters().add(channelFilter);
    }

    public void beforeF7GoodsClassFrom(ListShowParameter showParameter) {
        long classApplyId = 0L;
        QFilter qFilter = new QFilter("applyplatform", "=", (Object)"1");
        DynamicObject classApply = QueryServiceHelper.queryOne((String)"ocdbd_classstdapply", (String)"classstandardid.id", (QFilter[])qFilter.toArray());
        if (classApply != null) {
            classApplyId = DynamicObjectUtils.getLong((DynamicObject)classApply, (String)"classstandardid.id");
        }
        QFilter classFilter = new QFilter("standard.id", "=", (Object)classApplyId);
        showParameter.getListFilterParameter().getQFilters().add(classFilter);
    }

    public List<Long> getAllWarehouse(List<Object> orgIds) {
        List<Long> result = new ArrayList<Long>(0);
        if (CommonUtils.isNull(orgIds)) {
            return result;
        }
        QFilter orgFilter = new QFilter("org", "in", (Object)orgIds.toArray());
        orgFilter.and(new QFilter("startstatus", "=", (Object)"B"));
        String selects = "warehouse.id";
        Map warehouseDycs = BusinessDataServiceHelper.loadFromCache((String)"im_warehousesetup", (String)selects, (QFilter[])orgFilter.toArray());
        Map<Object, DynamicObject> warehouseMap = this.getDynamicObjectMap(selects, warehouseDycs.values().toArray(new DynamicObject[0]));
        result = warehouseMap.keySet().stream().map(CommonUtil::formatObejctToLong).collect(Collectors.toList());
        return result;
    }

    public Map<Object, DynamicObject> getDynamicObjectMap(String key, DynamicObject[] dyc) {
        HashMap<Object, DynamicObject> result = new HashMap<Object, DynamicObject>();
        if (dyc != null && dyc.length > 0) {
            for (DynamicObject item : dyc) {
                result.put(item.get(key), item);
            }
        }
        return result;
    }

    public void beforeF7SelectOrg(ListShowParameter showParameter) {
        String pkSet = (String)this.getView().getFormShowParameter().getCustomParams().get(HAS_PERMISSION_AND_STARTED_INV_ORG);
        showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", SerializationUtils.fromJsonString((String)pkSet, List.class)));
    }

    public void beforeF7SelectByEnable(ListShowParameter showParameter) {
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        showParameter.getListFilterParameter().setFilter(filter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        ReportShowParameter showParameter = (ReportShowParameter)e.getSource();
        String formId = showParameter.getFormId();
        this.doBillPermission(showParameter, formId);
    }

    public void doBillPermission(ReportShowParameter showParameter, String formId) {
        List permissionOrgs = OrgHelper.getPermissionOrgs((String)formId, (String)"05");
        if (CollectionUtils.isEmpty((Collection)permissionOrgs)) {
            return;
        }
        Object[] orgIdList = OrgHelper.getHasPermissionAndStartedInvOrgIds((String)formId, (String)"05");
        if (orgIdList == null || orgIdList.length == 0) {
            return;
        }
        showParameter.getCustomParams().put(HAS_PERMISSION_AND_STARTED_INV_ORG, SerializationUtils.toJsonString((Object)orgIdList));
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        StoreInvAnalyseRptPlugin.initMultiOrg(this.getView(), "multiorghead");
        this.getView().getModel().setValue("startdate", (Object)DateUtil.getFirstDayOfMonth());
        this.getView().getModel().setValue("enddate", (Object)DateUtil.getLastDayOfMonth());
    }

    public static void initMultiOrg(IReportView view, String orgLogo) {
        List orgList;
        long orgId = RequestContext.get().getOrgId();
        String pkSet = (String)view.getFormShowParameter().getCustomParams().get(HAS_PERMISSION_AND_STARTED_INV_ORG);
        if (!CommonUtils.isNull((Object)pkSet) && !CommonUtils.isNull((Object)(orgList = (List)SerializationUtils.fromJsonString((String)pkSet, ArrayList.class)))) {
            boolean isExist = false;
            for (Object o : orgList) {
                if (orgId != Long.parseLong(o.toString())) continue;
                isExist = true;
                break;
            }
            if (!isExist) {
                view.getModel().setValue(orgLogo, (Object)new Object[]{orgList.get(0)});
                return;
            }
        }
        view.getModel().setValue(orgLogo, (Object)new Object[]{orgId});
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        ReportList reportList = (ReportList)evt.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        String key = (String)reportList.getEntryState().getState().get("fieldKey");
        if (StringUtils.equals((CharSequence)"material", (CharSequence)key)) {
            this.showBaseDataForm(rowData, key, "bd_material");
        }
        if (StringUtils.equals((CharSequence)"warehouse", (CharSequence)key)) {
            this.showBaseDataForm(rowData, key, "bd_warehouse");
        }
        if (StringUtils.equals((CharSequence)"goodsid", (CharSequence)key)) {
            this.showBaseDataForm(rowData, key, "ocdbd_iteminfo");
        }
        if (StringUtils.equals((CharSequence)"channelid", (CharSequence)key)) {
            this.showBaseDataForm(rowData, key, "ocdbd_channel");
        }
        if (StringUtils.equals((CharSequence)"reserveqty", (CharSequence)key)) {
            this.showReserveDetail(rowData, key);
        }
        if (StringUtils.equals((CharSequence)"sdeliveryqty", (CharSequence)key)) {
            this.showDeliveryDetail(rowData);
        }
        if (StringUtils.equals((CharSequence)"sinstockqty", (CharSequence)key)) {
            this.showSinstockDetail(rowData, key);
        }
        if (StringUtils.equals((CharSequence)"alwoversaleqty", (CharSequence)key)) {
            this.showOversaleDetail(rowData, key);
        }
    }

    private void showSinstockDetail(DynamicObject rowData, String key) {
        BigDecimal bigdecimal = rowData.getBigDecimal(key);
        if (bigdecimal.compareTo(BigDecimal.ZERO) == 0) {
            NotificationUtil.showDefaultTipNotify((String)"\u8be5\u5546\u54c1\u5f85\u5165\u5e93\u6570\u91cf\u4e3a0,\u65e0\u6cd5\u67e5\u770b\u660e\u7ec6", (IFormView)this.getView());
            return;
        }
        this.showParameter(rowData, "ocpos_instock_detail");
    }

    private void showOversaleDetail(DynamicObject rowData, String key) {
        BigDecimal bigdecimal = rowData.getBigDecimal(key);
        if (bigdecimal.compareTo(BigDecimal.ZERO) == 0) {
            NotificationUtil.showDefaultTipNotify((String)"\u8be5\u5546\u54c1\u5141\u8bb8\u8d1f\u5356\u6570\u91cf\u4e3a0,\u65e0\u6cd5\u67e5\u770b\u660e\u7ec6", (IFormView)this.getView());
            return;
        }
        this.showParameter(rowData, "ocpos_oversale_detail");
    }

    private void showDeliveryDetail(DynamicObject rowData) {
        FormShowParameter param = FormShowUtils.openNewForm(null, (String)"ocpos_delivery_detail", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.VIEW, this.getCustomParam(rowData));
        param.setCloseCallBack(null);
        this.getView().showForm(param);
    }

    private void showLotNumDetail(ReportList report) {
        int[] indexs = report.getEntryState().getSelectedRows();
        DynamicObject rowData = report.getReportModel().getRowData(indexs[0]);
        this.showParameter(rowData, "ocpos_lotno_detail");
    }

    private void showReserveDetail(DynamicObject rowData, String key) {
        BigDecimal reserve = rowData.getBigDecimal(key);
        if (reserve.compareTo(BigDecimal.ZERO) == 0) {
            NotificationUtil.showDefaultTipNotify((String)"\u8be5\u5546\u54c1\u9884\u7559\u6570\u91cf\u4e3a0,\u65e0\u6cd5\u67e5\u770b\u660e\u7ec6", (IFormView)this.getView());
            return;
        }
        FormShowParameter param = FormShowUtils.openNewForm(null, (String)"ocpos_reserve_detail", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.VIEW, this.getCustomParam(rowData));
        param.setCloseCallBack(null);
        this.getView().showForm(param);
    }

    private void showSnmainfileDetail(ReportList report) {
        int[] indexs = report.getEntryState().getSelectedRows();
        DynamicObject rowData = report.getReportModel().getRowData(indexs[0]);
        this.showParameter(rowData, "ocpos_snmainfile_detail");
    }

    private void showParameter(DynamicObject rowData, String formId) {
        FormShowParameter param = FormShowUtils.openNewForm(null, (String)formId, (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.VIEW, this.getCustomParam(rowData));
        param.setCloseCallBack(null);
        this.getView().showForm(param);
    }

    private Map<String, Object> getCustomParam(DynamicObject rowData) {
        HashMap<String, Object> customsParams = new HashMap<String, Object>(16);
        customsParams.put("goodsid", DynamicObjectUtils.getPkValue((DynamicObject)rowData.getDynamicObject("goodsid")));
        customsParams.put("channelid", DynamicObjectUtils.getPkValue((DynamicObject)rowData.getDynamicObject("channelid")));
        customsParams.put("project", DynamicObjectUtils.getPkValue((DynamicObject)rowData.getDynamicObject("project")));
        customsParams.put("org", DynamicObjectUtils.getPkValue((DynamicObject)rowData.getDynamicObject("org")));
        customsParams.put("warehouse", DynamicObjectUtils.getPkValue((DynamicObject)rowData.getDynamicObject("warehouse")));
        customsParams.put("location", DynamicObjectUtils.getPkValue((DynamicObject)rowData.getDynamicObject("location")));
        customsParams.put("material", DynamicObjectUtils.getPkValue((DynamicObject)rowData.getDynamicObject("material")));
        customsParams.put("invtype", DynamicObjectUtils.getPkValue((DynamicObject)rowData.getDynamicObject("invtype")));
        customsParams.put("invstatus", DynamicObjectUtils.getPkValue((DynamicObject)rowData.getDynamicObject("invstatus")));
        customsParams.put("ownertype", rowData.get("ownertype"));
        customsParams.put("owner", rowData.getDynamicObject("owner").getPkValue());
        customsParams.put("keepertype", rowData.get("keepertype"));
        customsParams.put("keeper", rowData.getDynamicObject("keeper").getPkValue());
        customsParams.put("unit", rowData.getDynamicObject("unit").getPkValue());
        customsParams.put("baseunit", rowData.getDynamicObject("baseunit").getPkValue());
        DynamicObject unit2nd = rowData.getDynamicObject("unit2nd");
        customsParams.put("unit2nd", unit2nd == null ? Long.valueOf(0L) : unit2nd.getPkValue());
        String sinstocksourcebill = this.getView().getModel().getDataEntity(true).getString("sinstocksourcebill");
        customsParams.put("sinstocksourcebill", sinstocksourcebill);
        return customsParams;
    }

    public void afterSetModelValue(DynamicObject scheme) {
        if (scheme == null) {
            return;
        }
        this.setOrgByScheme(scheme);
        DataEntityPropertyCollection dataEntityPropertyCollection = scheme.getDataEntityType().getProperties();
        for (IDataEntityProperty property : dataEntityPropertyCollection) {
            String name = property.getName();
            if (StringUtils.equals((CharSequence)"multiorghead", (CharSequence)name)) continue;
            DataChangeHelper.setValue((IDataModel)this.getModel(), (String)name, (Object)scheme.get(name), (boolean)false);
        }
    }

    private void setOrgByScheme(DynamicObject scheme) {
        Object orgs = scheme.get("multiorghead");
        Map<String, Object> hasPermOrgResult = this.getHasPermOrgIds();
        List hasPermOrgIds = (List)hasPermOrgResult.get("hasPermOrgs");
        if (!(orgs instanceof DynamicObjectCollection) || ((Boolean)hasPermOrgResult.get("hasAllPermOrgs")).booleanValue()) {
            this.getModel().setValue("multiorghead", orgs);
        } else {
            DynamicObjectCollection orgCollection = (DynamicObjectCollection)orgs;
            Iterator orgIterator = orgCollection.iterator();
            DynamicObject orgCopy = null;
            while (orgIterator.hasNext()) {
                Long pkValue;
                DynamicObject org = (DynamicObject)orgIterator.next();
                if (org == null) {
                    orgIterator.remove();
                    continue;
                }
                if (orgCopy == null) {
                    orgCopy = org;
                }
                if (hasPermOrgIds.contains(pkValue = Long.valueOf(org.getLong("fbasedataid_id")))) continue;
                orgIterator.remove();
            }
            if (orgCollection.isEmpty() && orgCopy != null) {
                QFilter bizOrgFilter = OrgUnitServiceHelper.getBizOrgFilter((String)"05");
                bizOrgFilter.and("id", "in", (Object)hasPermOrgIds);
                Map orgMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])bizOrgFilter.toArray());
                DynamicObject org = (DynamicObject)orgMap.values().iterator().next();
                orgCopy.set("fbasedataid_id", org.getPkValue());
                orgCopy.set("fbasedataid", (Object)org);
                orgCollection.add((Object)orgCopy);
                NotificationUtil.showDefaultTipNotify((String)"\u65b9\u6848\u4e2d\u5e93\u5b58\u7ec4\u7ec7\u65e0\u6743\u9650\uff0c\u8bf7\u4fee\u6539\u65b9\u6848\u3002", (IFormView)this.getView());
            }
            this.getModel().setValue("multiorghead", (Object)orgCollection);
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        FilterInfo filter = queryParam.getFilter();
        DynamicObjectCollection channelDycs = filter.getDynamicObjectCollection("multistorehead");
        if (channelDycs == null || channelDycs.size() == 0) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u9009\u62e9\u67e5\u8be2\u95e8\u5e97\u3002", (IFormView)this.getView());
            return false;
        }
        return true;
    }

    public void formatDisplayFilterField(FormatShowFilterEvent e) {
        this.fieldFormatDisplayFilter(e);
    }

    public void fieldFormatDisplayFilter(FormatShowFilterEvent e) {
        String formatedFilterString = e.getFormatedFilterString();
        if (StringUtils.isEmpty((CharSequence)formatedFilterString)) {
            return;
        }
        String[] formatedSplit = formatedFilterString.split(";  ");
        StringBuilder sb = new StringBuilder();
        for (String formated : formatedSplit) {
            String groupFormatedKey = formated.split("\uff1a")[0];
            String[] groupFormatedValue = formated.split("\uff1a")[1].split(";");
            if (groupFormatedValue.length > 20) {
                String[] newGroupFormated = new String[20];
                System.arraycopy(groupFormatedValue, 0, newGroupFormated, 0, 20);
                sb.append(groupFormatedKey);
                sb.append('\uff1a');
                for (String s : newGroupFormated) {
                    sb.append(s);
                    sb.append(';');
                }
                sb.append("......");
                continue;
            }
            sb.append(formated);
            sb.append(';');
        }
        e.setFormatedFilterString(sb.toString());
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        ReportList report = (ReportList)this.getView().getControl("reportlistap");
        if ("baritemap".equals(evt.getItemKey())) {
            if (this.check(report)) {
                this.showSnmainfileDetail(report);
            }
        } else if ("baritemap1".equals(evt.getItemKey()) && this.check(report)) {
            this.showLotNumDetail(report);
        }
    }

    private boolean check(ReportList report) {
        int[] indexs = report.getEntryState().getSelectedRows();
        if (indexs == null || indexs.length == 0) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u67e5\u770b\u660e\u7ec6", (IFormView)this.getView());
            return false;
        }
        if (indexs.length > 1) {
            NotificationUtil.showDefaultTipNotify((String)"\u4e0d\u652f\u6301\u540c\u65f6\u67e5\u770b\u591a\u6761\u660e\u7ec6", (IFormView)this.getView());
            return false;
        }
        return true;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }

    private void showBaseDataForm(DynamicObject rowData, String key, String entityId) {
        DynamicObject object = (DynamicObject)rowData.get(key);
        Object pkValue = object.getPkValue();
        this.createBaseDataView(pkValue, entityId);
    }

    private void createBaseDataView(Object pkValue, String entityId) {
        IReportView view = this.getView();
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setPkId(pkValue);
        parameter.getOpenStyle().setTargetKey("tabap");
        parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        parameter.setStatus(OperationStatus.VIEW);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setAppId(null);
        parameter.setFormId(entityId);
        this.getView().showForm((FormShowParameter)parameter);
    }
}

