/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.report.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.business.commonhelper.OrgHelper;

public class VipConsumeSumReportForm
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, "exclusiveconsultantfilter", "brandfilter", "goodsclassfilter", "viptagfilter", "viplevelfilter", "departfilter", "branchfilter");
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        ReportShowParameter showParameter = (ReportShowParameter)e.getSource();
        String formId = showParameter.getFormId();
        this.doBillPermission(showParameter, formId);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String startDateStr = DateUtil.getDateFormat((Date)DateUtil.getFirstDayOfMonth());
        Date dtStartDate = DateUtil.formatDate((String)startDateStr, (String)"yyyy-MM-dd");
        this.getView().getModel().setValue("startdate", (Object)dtStartDate);
        String endDateStr = DateUtil.getDateFormat((Date)DateUtil.getLastDayOfMonth());
        Date dtEndDate = DateUtil.formatDate((String)endDateStr, (String)"yyyy-MM-dd");
        this.getView().getModel().setValue("enddate", (Object)dtEndDate);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        Date dtStartDate = filterInfo.getDate("startdate");
        Date dtEndDate = filterInfo.getDate("enddate");
        if (dtStartDate == null) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u8303\u56f4\u5f00\u59cb\u65e5\u671f\u3002", (IFormView)this.getView());
            return false;
        }
        if (dtEndDate == null) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u8303\u56f4\u7ed3\u675f\u65e5\u671f\u3002", (IFormView)this.getView());
            return false;
        }
        String summaryDimension = filterInfo.getString("summarydimensionfilter");
        if (StringUtils.isEmpty((Object)summaryDimension)) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u9009\u62e9\u6c47\u603b\u7ef4\u5ea6\u3002", (IFormView)this.getView());
            return false;
        }
        return true;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        switch (key) {
            case "departfilter": {
                this.beforeF7DeptSelect(showParameter);
                break;
            }
            case "branchfilter": {
                this.beforeF7BranchSelect(showParameter);
                break;
            }
        }
    }

    public void doBillPermission(ReportShowParameter showParameter, String formId) {
        List permissionOrgs = OrgHelper.getPermissionOrgs((String)formId, (String)"01");
        if (CollectionUtils.isEmpty((Collection)permissionOrgs)) {
            return;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(0);
        for (Map tempOrg : permissionOrgs) {
            orgIds.add(Long.valueOf((String)tempOrg.get("id")));
        }
        showParameter.getCustomParams().put("HasPermissionAndAdminOrg", SerializationUtils.toJsonString(orgIds));
    }

    public void beforeF7BranchSelect(ListShowParameter showParameter) {
        QFilter qFilter = new QFilter("sysuser", "=", (Object)RequestContext.get().getCurrUserId());
        DynamicObjectCollection channelUser = QueryServiceHelper.query((String)"ocdbd_channeluser", (String)"owner", (QFilter[])qFilter.toArray(), null);
        QFilter channelFilter = new QFilter("id", "in", (Object)channelUser.stream().map(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"owner")).toArray());
        showParameter.getListFilterParameter().getQFilters().add(channelFilter);
    }

    private void beforeF7DeptSelect(ListShowParameter showParameter) {
        String pkSet = (String)this.getView().getFormShowParameter().getCustomParams().get("HasPermissionAndAdminOrg");
        showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", SerializationUtils.fromJsonString((String)pkSet, List.class)));
    }

    public void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        if (!(form instanceof AbstractFormPlugin)) {
            return;
        }
        AbstractFormPlugin locForm = (AbstractFormPlugin)form;
        for (String s : f7Name) {
            BasedataEdit f7 = (BasedataEdit)locForm.getControl(s);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }
}

