/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.report.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.pos.PosUnit;
import kd.occ.ocpos.common.enums.DateTypeEnum;
import kd.occ.ocpos.common.vo.PosQueryParam;

public abstract class AbstractPosReportQuery
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(AbstractPosReportQuery.class);

    public DataSet query(ReportQueryParam queryParam, Object args) throws Throwable {
        try {
            return this.query(queryParam);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
    }

    public DataSet query(ReportQueryParam reportQueryParam) {
        PosQueryParam posQueryParam = this.getParam(reportQueryParam);
        QFilter queryFilters = this.getQueryFilter(posQueryParam);
        DataSet headColumnDataset = this.getHeadColumnDataset(reportQueryParam, queryFilters);
        DataSet finentityDataset = this.getFinentityDataset(reportQueryParam, queryFilters);
        DataSet itemDataset = this.getItemDataset(reportQueryParam, queryFilters);
        return this.getFinalDataset(headColumnDataset, finentityDataset, itemDataset, reportQueryParam);
    }

    public boolean isSettleType(ReportQueryParam reportQueryParam) {
        String dateType = reportQueryParam.getFilter().getString("datetype");
        return DateTypeEnum.SETTLE_TYPE.getValue().equals(dateType);
    }

    protected void sumGroupDataset(GroupbyDataSet groupbyDataSet, List<String> sumFields) {
        sumFields.forEach(arg_0 -> ((GroupbyDataSet)groupbyDataSet).sum(arg_0));
    }

    protected DataSet getUnionDataset(QFilter queryFilters, String queryFields) {
        DataSet saleOrder = this.getSaleOrderDataSet(queryFilters, "ocpos_saleorder", queryFields);
        DataSet receiveOrder = this.getSaleOrderDataSet(queryFilters, "ocpos_saleorder_final", queryFields);
        DataSet returnOrder = this.getSaleOrderDataSet(queryFilters, "ocpos_saleorder_return", queryFields);
        return this.getTargetDataset(saleOrder, receiveOrder, returnOrder);
    }

    protected List<String> getCommonGroupByField(boolean isSettleType) {
        List<String> commonGroupByField = this.getCommonField(isSettleType);
        this.customizeCommonGroupByField(commonGroupByField);
        return commonGroupByField;
    }

    protected List<String> getHeadSelectFields(boolean isSettleType) {
        List<String> headSelectFields = this.getCommonField(isSettleType);
        return this.customizeHeadSelectField(headSelectFields);
    }

    protected List<String> getCommonField(boolean isSettleType) {
        ArrayList<String> commonFields = new ArrayList<String>();
        commonFields.add("orgid");
        if (isSettleType) {
            commonFields.add("saledates");
        } else {
            commonFields.add("saledate");
        }
        commonFields.add("branchid");
        return commonFields;
    }

    private DataSet getSaleOrderDataSet(QFilter queryFilters, String entityName, String queryFields) {
        return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entityName, (String)queryFields, (QFilter[])queryFilters.toArray(), null);
    }

    public PosQueryParam getParam(ReportQueryParam reportQueryParam) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        PosQueryParam posQueryParam = new PosQueryParam();
        posQueryParam.setBranch(filterInfo.getDynamicObjectCollection("salesbranchid"));
        posQueryParam.setStartDate(filterInfo.getDate("saledaterange_startdate"));
        posQueryParam.setEndDate(filterInfo.getDate("saledaterange_enddate"));
        posQueryParam.setCurrency(filterInfo.getDynamicObject("currency"));
        this.addCustomParam(posQueryParam, filterInfo);
        return posQueryParam;
    }

    private QFilter getQueryFilter(PosQueryParam posQueryParam) {
        QFilter filters = new QFilter("billstatus", "=", (Object)"C");
        filters.and("salestatus", "!=", (Object)"A");
        filters.and("bizdate", ">=", (Object)posQueryParam.getStartDate());
        filters.and("bizdate", "<=", (Object)posQueryParam.getEndDate());
        if (posQueryParam.getCurrency() != null) {
            filters.and("locurrencyid", "=", posQueryParam.getCurrency().getPkValue());
        }
        if (!CollectionUtils.isEmpty((Collection)posQueryParam.getBranch())) {
            filters.and("salebranchid", "in", (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)posQueryParam.getBranch()));
        }
        this.addCustomFilter(filters, posQueryParam);
        return filters;
    }

    public QFilter getSettleTimeFilter(PosQueryParam posQueryParam) {
        QFilter filters = new QFilter("billstatus", "=", (Object)"C");
        filters.and("salestatus", "!=", (Object)"A");
        filters.and("finentity.paytime", ">=", (Object)posQueryParam.getStartDate());
        filters.and("finentity.paytime", "<=", (Object)PosUnit.getDayAfter((Date)posQueryParam.getEndDate()));
        if (posQueryParam.getCurrency() != null) {
            filters.and("locurrencyid", "=", posQueryParam.getCurrency().getPkValue());
        }
        if (!CollectionUtils.isEmpty((Collection)posQueryParam.getBranch())) {
            filters.and("salebranchid", "in", (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)posQueryParam.getBranch()));
        }
        this.addCustomFilter(filters, posQueryParam);
        return filters;
    }

    protected List<String> getCommonQueryFields(boolean isSettleType) {
        ArrayList<String> queryFields = new ArrayList<String>();
        queryFields.add("bizorgid as orgid");
        if (isSettleType) {
            queryFields.add("to_char(bizdate,'yyyy-MM-dd') as saledates");
        } else {
            queryFields.add("bizdate as saledate");
        }
        queryFields.add("salebranchid as branchid");
        queryFields.add("sumbalamount as receipts");
        return queryFields;
    }

    protected abstract List<String> customizeCommonGroupByField(List<String> var1);

    protected abstract void addCustomParam(PosQueryParam var1, FilterInfo var2);

    protected abstract void addCustomFilter(QFilter var1, PosQueryParam var2);

    protected abstract List<String> customizeItemSumField();

    protected abstract List<String> customizeHeadSumField();

    protected abstract List<String> customizeHeadSelectField(List<String> var1);

    protected abstract DataSet getFilterDataset(DataSet var1, ReportQueryParam var2);

    protected abstract DataSet getTargetDataset(DataSet var1, DataSet var2, DataSet var3);

    protected abstract DataSet getFinalDataset(DataSet var1, DataSet var2, DataSet var3, ReportQueryParam var4);

    abstract DataSet getItemDataset(ReportQueryParam var1, QFilter var2);

    abstract DataSet getFinentityDataset(ReportQueryParam var1, QFilter var2);

    abstract DataSet preHeadDataset(ReportQueryParam var1, DataSet var2);

    protected abstract DataSet getHeadColumnDataset(ReportQueryParam var1, QFilter var2);
}

