/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.report.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.DecimalReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocpos.common.vo.PosQueryParam;
import kd.occ.ocpos.report.query.AbstractPosReportQuery;

public abstract class AbstractShopReportQuery
extends AbstractPosReportQuery {
    protected DataSet preDataset;
    protected PosQueryParam queryParam;
    protected DynamicObject[] payType;
    protected boolean currency = false;

    @Override
    protected DataSet getTargetDataset(DataSet saleOrder, DataSet receiveOrder, DataSet returnOrder) {
        return saleOrder.union(new DataSet[]{receiveOrder, returnOrder});
    }

    private void initPayTypeValue(DataSet dataSet) {
        this.preDataset = dataSet;
        this.payType = this.getPayWayTypes(this.queryParam, this.preDataset);
    }

    @Override
    protected DataSet getFilterDataset(DataSet preDataSet, ReportQueryParam reportQueryParam) {
        return preDataSet;
    }

    @Override
    protected void addCustomFilter(QFilter filter, PosQueryParam posQueryParam) {
        filter.and("basebilltype", "!=", (Object)1041368841512679424L);
        if (!CollectionUtils.isEmpty((Collection)posQueryParam.getReceivetype())) {
            filter.and("receivingtype", "in", (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)posQueryParam.getReceivetype()));
        }
    }

    protected List<String> customizeFinentitySelectField(List<String> entrySelectField) {
        entrySelectField.add("receivetype");
        if (this.payType != null) {
            for (DynamicObject payWay : this.payType) {
                entrySelectField.add(this.getNewString(payWay.getString("number")) + "key");
                if (!this.currency) continue;
                entrySelectField.add(this.getNewString(payWay.getString("number")) + "keys");
            }
        }
        return entrySelectField;
    }

    @Override
    protected List<String> customizeHeadSelectField(List<String> headSelectFields) {
        headSelectFields.add("receipts");
        headSelectFields.add("payable");
        headSelectFields.add("receivetype");
        headSelectFields.add("count salecount");
        return headSelectFields;
    }

    @Override
    protected List<String> customizeHeadSumField() {
        ArrayList<String> headSumField = new ArrayList<String>();
        headSumField.add("payable");
        headSumField.add("receipts");
        return headSumField;
    }

    @Override
    protected List<String> customizeCommonGroupByField(List<String> commonGroupByField) {
        commonGroupByField.add("receivetype");
        return commonGroupByField;
    }

    protected void customizeHeadQueryField(List<String> headQueryFields) {
        headQueryFields.add("receivingtype as receivetype");
        headQueryFields.add("sumamount as payable");
    }

    @Override
    protected void addCustomParam(PosQueryParam posQueryParam, FilterInfo filterInfo) {
        this.queryParam = posQueryParam;
        posQueryParam.setReceivetype(filterInfo.getDynamicObjectCollection("receivingtypeid"));
        posQueryParam.setNotShowNull(filterInfo.getBoolean("notshownull"));
        posQueryParam.setShowCurrency(filterInfo.getBoolean("showcurrency"));
        posQueryParam.setShowsalecount(filterInfo.getBoolean("showsalecount"));
    }

    protected List<String> customizeFinentityQueryField(List<String> entryQueryFields) {
        entryQueryFields.add("receivingtype as receivetype");
        entryQueryFields.add("finentity.paywaytypeid as payway");
        entryQueryFields.add("finentity.settleamount as settleamount");
        entryQueryFields.add("finentity.stmamount as stmamount");
        entryQueryFields.add("to_char(finentity.paytime,'yyyy-MM-dd') as saledates");
        return entryQueryFields;
    }

    protected List<String> customizeFinentityPreSelectField(List<String> preSelectFields) {
        preSelectFields.add("receivetype");
        preSelectFields.add("payway");
        preSelectFields.add("settleamount");
        preSelectFields.add("stmamount");
        if (this.payType != null) {
            for (DynamicObject payWayType : this.payType) {
                preSelectFields.add("case when payway =" + payWayType.getLong("id") + " then settleamount else 0 end as " + this.getNewString(payWayType.getString("number")) + "key");
                if (!this.currency) continue;
                preSelectFields.add("case when payway =" + payWayType.getLong("id") + " then stmamount else 0 end as " + this.getNewString(payWayType.getString("number")) + "keys");
            }
        }
        return preSelectFields;
    }

    public String getNewString(String old) {
        String regEx = "[\n`~!@#$%^&*()+=|{}':;,\\[\\].<>/?\uff01\uffe5\u2026\u2014\\-\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c \u3001\uff1f]";
        return old.replaceAll(regEx, "");
    }

    protected List<String> getPayTypeFields() {
        ArrayList<String> payTypeFields = new ArrayList<String>();
        if (this.payType != null) {
            for (DynamicObject payWayType : this.payType) {
                payTypeFields.add(this.getNewString(payWayType.getString("number")) + "key");
                if (!this.currency) continue;
                payTypeFields.add(this.getNewString(payWayType.getString("number")) + "keys");
            }
        }
        return payTypeFields;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        return this.createDynamicColumns(columns);
    }

    private List<AbstractReportColumn> createDynamicColumns(List<AbstractReportColumn> columns) {
        if (this.payType != null) {
            for (DynamicObject payWayType : this.payType) {
                LocaleString caption = new LocaleString(payWayType.getString("name"));
                DecimalReportColumn localCol = new DecimalReportColumn();
                localCol.setCaption(caption);
                localCol.setSummary(1);
                localCol.setFieldKey(this.getNewString(payWayType.getString("number")) + "key");
                localCol.setFieldType("amount");
                localCol.setScale(2);
                if (this.currency) {
                    LocaleString groupCaption = new LocaleString(payWayType.getString("name"));
                    LocaleString currencyCaption = new LocaleString(payWayType.getString("name") + "(\u672c\u4f4d\u5e01)");
                    ReportColumnGroup groupCol = new ReportColumnGroup();
                    groupCol.setCaption(groupCaption);
                    DecimalReportColumn currencyCol = new DecimalReportColumn();
                    currencyCol.setCaption(currencyCaption);
                    currencyCol.setSummary(1);
                    currencyCol.setFieldKey(this.getNewString(payWayType.getString("number")) + "keys");
                    currencyCol.setFieldType("amount");
                    currencyCol.setScale(2);
                    groupCol.setFieldKey(this.getNewString(payWayType.getString("number")) + "group");
                    groupCol.getChildren().add(localCol);
                    groupCol.getChildren().add(currencyCol);
                    columns.add((AbstractReportColumn)groupCol);
                    continue;
                }
                columns.add((AbstractReportColumn)localCol);
            }
        }
        return columns;
    }

    private DynamicObject[] getPayWayTypes(PosQueryParam param, DataSet preDataSet) {
        boolean notShowNull = param.isNotShowNull();
        this.currency = param.isShowCurrency();
        DataSet payWayDataSet = preDataSet.groupBy(new String[]{"payway"}).sum("settleamount").finish().filter("payway<>0");
        DynamicObjectCollection payWayEntry = ORM.create().toPlainDynamicObjectCollection(payWayDataSet);
        if (CollectionUtils.isEmpty((Collection)payWayEntry)) {
            return null;
        }
        if (notShowNull) {
            List paywayIds = payWayEntry.stream().map(a -> DynamicObjectUtils.getLong((DynamicObject)a, (String)"payway")).collect(Collectors.toList());
            QFilter filter = new QFilter("id", "in", paywayIds);
            return BusinessDataServiceHelper.load((String)"ocdbd_paywaytype", (String)"id,number,name", (QFilter[])filter.toArray());
        }
        QFilter commonFilter = new QFilter("enable", "=", (Object)"1");
        return BusinessDataServiceHelper.load((String)"ocdbd_paywaytype", (String)"id,number,name", (QFilter[])commonFilter.toArray());
    }

    protected List<String> getFinalHeadField(boolean isSettleType) {
        List<String> headFields = this.getCommonField(isSettleType);
        headFields.add("receivetype");
        headFields.add("payable");
        headFields.add("receipts");
        headFields.add("salecount");
        return headFields;
    }

    @Override
    protected DataSet getHeadColumnDataset(ReportQueryParam reportQueryParam, QFilter queryFilters) {
        boolean isSettleType = this.isSettleType(reportQueryParam);
        DataSet headDataset = this.getUnionDataset(queryFilters, this.getHeadQueryFields(isSettleType));
        DataSet preHeadDataset = this.preHeadDataset(reportQueryParam, headDataset);
        List<String> headGroupByField = this.getCommonGroupByField(isSettleType);
        GroupbyDataSet headGroupByDataSet = preHeadDataset.groupBy(headGroupByField.toArray(new String[0]));
        List<String> sumField = this.customizeHeadSumField();
        if (!CollectionUtils.isEmpty(sumField)) {
            this.sumGroupDataset(headGroupByDataSet, sumField);
        }
        return headGroupByDataSet.count().finish().select(String.join((CharSequence)",", this.getHeadSelectFields(isSettleType)));
    }

    private String getHeadQueryFields(boolean isSettleType) {
        List<String> headQueryFields = this.getCommonQueryFields(isSettleType);
        this.customizeHeadQueryField(headQueryFields);
        return String.join((CharSequence)",", headQueryFields);
    }

    @Override
    protected DataSet getFinentityDataset(ReportQueryParam reportQueryParam, QFilter queryFilters) {
        DataSet unionDataset;
        boolean isSettleType = this.isSettleType(reportQueryParam);
        if (isSettleType) {
            PosQueryParam posQueryParam = this.getParam(reportQueryParam);
            QFilter filter = this.getSettleTimeFilter(posQueryParam);
            String settleTimeQueryFields = this.getSettleTimeQueryFields();
            unionDataset = this.getUnionDataset(filter, settleTimeQueryFields);
        } else {
            unionDataset = this.getUnionDataset(queryFilters, this.getFinentityQueryFields());
        }
        this.initPayTypeValue(unionDataset.copy());
        DataSet preDataSet = unionDataset.select(String.join((CharSequence)",", this.getFinentityPreSelectFields(isSettleType)));
        DataSet filterDataset = this.getFilterDataset(preDataSet, reportQueryParam);
        List<String> commonGroupByField = this.getCommonGroupByField(isSettleType);
        GroupbyDataSet entryGroupByDataSet = filterDataset.groupBy(commonGroupByField.toArray(new String[0]));
        this.sumGroupDataset(entryGroupByDataSet, this.getPayTypeFields());
        return entryGroupByDataSet.finish().select(String.join((CharSequence)",", this.getFinentitySelectFields(isSettleType)));
    }

    private String getFinentityQueryFields() {
        List<String> finentityQueryField = this.getCommonQueryFields(false);
        return String.join((CharSequence)",", this.customizeFinentityQueryField(finentityQueryField));
    }

    private String getSettleTimeQueryFields() {
        ArrayList<String> queryFields = new ArrayList<String>(0);
        queryFields.add("bizorgid as orgid");
        queryFields.add("salebranchid as branchid");
        queryFields.add("sumbalamount as receipts");
        return String.join((CharSequence)",", this.customizeFinentityQueryField(queryFields));
    }

    private List<String> getFinentitySelectFields(boolean isSettleType) {
        List<String> entrySelectFields = this.getCommonField(isSettleType);
        return this.customizeFinentitySelectField(entrySelectFields);
    }

    private List<String> getFinentityPreSelectFields(boolean isSettleType) {
        List<String> finentityPreSelectFields = this.getCommonField(isSettleType);
        return this.customizeFinentityPreSelectField(finentityPreSelectFields);
    }

    @Override
    DataSet preHeadDataset(ReportQueryParam reportQueryParam, DataSet headDataset) {
        return headDataset;
    }
}

