/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.report.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocpos.business.commonhelper.CashierHelper;
import kd.occ.ocpos.business.commonhelper.DataSetHelper;
import kd.occ.ocpos.common.vo.PosQueryParam;
import kd.occ.ocpos.report.query.AbstractShopReportQuery;

public class CashierReportQuery
extends AbstractShopReportQuery {
    @Override
    protected void addCustomParam(PosQueryParam posQueryParam, FilterInfo filterInfo) {
        super.addCustomParam(posQueryParam, filterInfo);
        posQueryParam.setCashier(filterInfo.getDynamicObjectCollection("cashierid"));
    }

    @Override
    protected void addCustomFilter(QFilter filter, PosQueryParam posQueryParam) {
        super.addCustomFilter(filter, posQueryParam);
        if (!CollectionUtils.isEmpty((Collection)posQueryParam.getCashier())) {
            filter.and("cashier", "in", (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)posQueryParam.getCashier()));
        } else {
            boolean isDirector = CashierHelper.checkCashierAuth((long)1311543339870394368L);
            if (!isDirector) {
                long cashierId = this.getCashierId(posQueryParam);
                filter.and("cashier", "=", (Object)cashierId);
            }
        }
    }

    private long getCashierId(PosQueryParam posQueryParam) {
        QFilter filter1 = new QFilter("owner", "in", (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)posQueryParam.getBranch()));
        filter1.and("iscashier", "=", (Object)"1");
        filter1.and("sysuser", "=", (Object)UserServiceHelper.getCurrentUserId());
        DynamicObject cashier = QueryServiceHelper.queryOne((String)"ocdbd_channeluser", (String)"id", (QFilter[])filter1.toArray());
        return cashier.getLong("id");
    }

    @Override
    protected List<String> customizeFinentityQueryField(List<String> queryFields) {
        List<String> cashierQueryFields = super.customizeFinentityQueryField(queryFields);
        cashierQueryFields.add("cashier");
        return cashierQueryFields;
    }

    @Override
    protected List<String> customizeHeadSumField() {
        List<String> headSumFields = super.customizeHeadSumField();
        headSumFields.add("balanceamount");
        return headSumFields;
    }

    @Override
    protected List<String> customizeItemSumField() {
        ArrayList<String> itemSumField = new ArrayList<String>();
        itemSumField.add("preferamount");
        return itemSumField;
    }

    private List<String> getItemQueryFields(boolean isSettleType) {
        List<String> itemQueryFields = this.getCommonQueryFields(isSettleType);
        itemQueryFields.add("receivingtype as receivetype");
        itemQueryFields.add("cashier");
        itemQueryFields.add("goodsentryentity.integraldistamount as integraldistamount");
        itemQueryFields.add("goodsentryentity.coupondiscount as coupondiscount");
        itemQueryFields.add("goodsentryentity.manualdiscount as manualdiscount");
        return itemQueryFields;
    }

    @Override
    protected void customizeHeadQueryField(List<String> headQueryFields) {
        super.customizeHeadQueryField(headQueryFields);
        headQueryFields.add("cashier");
        headQueryFields.add("endpayamount as balanceamount");
    }

    @Override
    protected List<String> customizeCommonGroupByField(List<String> commonGroupByField) {
        List<String> cashierGroupByField = super.customizeCommonGroupByField(commonGroupByField);
        cashierGroupByField.add("cashier");
        cashierGroupByField.add("receivetype");
        return cashierGroupByField;
    }

    @Override
    protected List<String> customizeFinentitySelectField(List<String> entrySelectField) {
        List<String> finentitySelectField = super.customizeFinentitySelectField(entrySelectField);
        finentitySelectField.add("cashier");
        return finentitySelectField;
    }

    @Override
    protected List<String> customizeHeadSelectField(List<String> headSelectFields) {
        List<String> cashierSelectFields = super.customizeHeadSelectField(headSelectFields);
        cashierSelectFields.add("cashier");
        cashierSelectFields.add("balanceamount");
        return cashierSelectFields;
    }

    @Override
    protected List<String> customizeFinentityPreSelectField(List<String> preSelectFields) {
        List<String> cashierPreSelectFields = super.customizeFinentityPreSelectField(preSelectFields);
        cashierPreSelectFields.add("cashier");
        return cashierPreSelectFields;
    }

    protected List<String> getItemPreSelectField(boolean isSettleType) {
        List<String> preSelectFields = this.getCommonField(isSettleType);
        preSelectFields.add("cashier");
        preSelectFields.add("receivetype");
        preSelectFields.add("(integraldistamount+coupondiscount+manualdiscount) as preferamount");
        return preSelectFields;
    }

    @Override
    protected DataSet getFinalDataset(DataSet head, DataSet finentity, DataSet item, ReportQueryParam reportQueryParam) {
        boolean isSettleType = this.isSettleType(reportQueryParam);
        List<String> finalHeadField = this.getCashierHeadFields(isSettleType);
        List<String> payTypeField = this.getPayTypeFields();
        if (isSettleType) {
            if (this.payType != null) {
                for (DynamicObject payWayType : this.payType) {
                    finalHeadField.add("0 as " + this.getNewString(payWayType.getString("number")) + "key");
                    if (!this.currency) continue;
                    finalHeadField.add("0 as " + this.getNewString(payWayType.getString("number")) + "keys");
                }
            }
            finalHeadField.add("0 as preferamount");
            DataSet select1 = head.select(String.join((CharSequence)",", finalHeadField));
            ArrayList<String> aa = new ArrayList<String>();
            aa.add("orgid");
            aa.add("saledates");
            aa.add("branchid");
            aa.add("receivetype");
            aa.add("0 as payable");
            aa.add("0 as receipts");
            aa.add("0 as salecount");
            aa.add("cashier");
            aa.add("0 as balanceamount");
            if (this.payType != null) {
                for (DynamicObject ab : this.payType) {
                    aa.add(this.getNewString(ab.getString("number")) + "key");
                    if (!this.currency) continue;
                    aa.add(this.getNewString(ab.getString("number")) + "keys");
                }
            }
            aa.add("0 as preferamount");
            DataSet select2 = finentity.select(String.join((CharSequence)",", aa));
            ArrayList<String> bb = new ArrayList<String>();
            bb.add("orgid");
            bb.add("saledates");
            bb.add("branchid");
            bb.add("receivetype");
            bb.add("0 as payable");
            bb.add("0 as receipts");
            bb.add("0 as salecount");
            bb.add("cashier");
            bb.add("0 as balanceamount");
            if (this.payType != null) {
                for (DynamicObject as : this.payType) {
                    bb.add("0 as " + this.getNewString(as.getString("number")) + "key");
                    if (!this.currency) continue;
                    bb.add("0 as " + this.getNewString(as.getString("number")) + "keys");
                }
            }
            bb.add("preferamount");
            DataSet select3 = item.select(String.join((CharSequence)",", bb));
            DataSet union = select1.union(select2).union(select3);
            GroupbyDataSet groupbyDataSet = union.groupBy(new String[]{"orgid", "branchid", "saledates", "receivetype", "cashier"});
            ArrayList<String> sumField = new ArrayList<String>(0);
            sumField.add("payable");
            sumField.add("receipts");
            sumField.add("receipts");
            sumField.add("salecount");
            sumField.add("balanceamount");
            if (this.payType != null) {
                for (DynamicObject cc : this.payType) {
                    sumField.add(this.getNewString(cc.getString("number")) + "key");
                    if (!this.currency) continue;
                    sumField.add(this.getNewString(cc.getString("number")) + "keys");
                }
            }
            sumField.add("preferamount");
            sumField.forEach(arg_0 -> ((GroupbyDataSet)groupbyDataSet).sum(arg_0));
            DataSet finish = groupbyDataSet.finish();
            Set dataSetField = DataSetHelper.getDataSetField((DataSet)finish);
            dataSetField.add("to_date(saledates,'yyyy-MM-dd') as saledate");
            return finish.select(String.join((CharSequence)",", dataSetField)).orderBy(new String[]{"saledate desc"});
        }
        JoinDataSet joinFinentity = head.leftJoin(finentity).on("orgid", "orgid").on("saledate", "saledate").on("branchid", "branchid").on("receivetype", "receivetype").on("cashier", "cashier");
        DataSet finentityJoinSet = joinFinentity.select(finalHeadField.toArray(new String[0]), payTypeField.toArray(new String[0])).finish();
        JoinDataSet joinItem = finentityJoinSet.fullJoin(item).on("orgid", "orgid").on("saledate", "saledate").on("branchid", "branchid").on("receivetype", "receivetype").on("cashier", "cashier");
        List<String> cashierReportFields = this.getCashierReportFields(false);
        DataSet finish = joinItem.select(cashierReportFields.toArray(new String[0]), new String[]{"preferamount"}).finish();
        return finish.orderBy(new String[]{"saledate desc"});
    }

    private List<String> getCashierHeadFields(boolean isSettleType) {
        List<String> finalCashierHeadField = this.getFinalHeadField(isSettleType);
        finalCashierHeadField.add("cashier");
        finalCashierHeadField.add("balanceamount");
        return finalCashierHeadField;
    }

    private List<String> getCashierReportFields(boolean isSettleType) {
        List<String> cashierReportFields = this.getCommonField(isSettleType);
        cashierReportFields.add("cashier");
        cashierReportFields.add("salecount");
        cashierReportFields.add("receivetype");
        cashierReportFields.add("receipts");
        cashierReportFields.add("payable");
        cashierReportFields.add("balanceamount");
        cashierReportFields.addAll(this.getPayTypeFields());
        return cashierReportFields;
    }

    @Override
    protected DataSet getItemDataset(ReportQueryParam reportQueryParam, QFilter queryFilters) {
        boolean isSettleType = this.isSettleType(reportQueryParam);
        String itemQueryFields = String.join((CharSequence)",", this.getItemQueryFields(isSettleType));
        DataSet unionDataset = this.getUnionDataset(queryFilters, itemQueryFields);
        DataSet preDataSet = unionDataset.select(String.join((CharSequence)",", this.getItemPreSelectField(isSettleType)));
        List<String> commonGroupByFields = this.getCommonGroupByField(isSettleType);
        GroupbyDataSet entryGroupByDataSet = preDataSet.groupBy(commonGroupByFields.toArray(new String[0]));
        this.sumGroupDataset(entryGroupByDataSet, this.customizeItemSumField());
        return entryGroupByDataSet.finish().select(String.join((CharSequence)",", this.getItemSelectFields(isSettleType)));
    }

    private List<String> getItemSelectFields(boolean isSettleType) {
        List<String> entrySelectFields = this.getCommonField(isSettleType);
        entrySelectFields.add("receivetype");
        entrySelectFields.add("cashier");
        entrySelectFields.add("preferamount");
        return entrySelectFields;
    }
}

