/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.report.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.occ.ocpos.common.enums.report.ComparisonEnum;
import kd.occ.ocpos.common.util.OwnerUtil;

public class CreditDetailReportQuery
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(CreditDetailReportQuery.class);

    public DataSet query(ReportQueryParam queryParam, Object args) throws Throwable {
        try {
            return this.query(queryParam);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
    }

    public DataSet query(ReportQueryParam reportQueryParam) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        QFilter filter = this.getFilterInfo(filterInfo);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocpos_saleorder", (String)this.getSaleOrderField(), (QFilter[])new QFilter[]{filter}, (String)"bizdate desc");
        DataSet preSelectDataset = dataSet.select(this.getPreSelectField());
        DataSet posDataset = this.getFilterDataset(filterInfo, preSelectDataset);
        DataSet deliveryDataset = this.getDeliveryDataset(filter);
        JoinDataSet joinDataSet = posDataset.leftJoin(deliveryDataset).on("billno", "billno");
        DataSet posResult = joinDataSet.select(new String[]{"bizorg", "bizdate", "billno", "branch", "member", "customerphone", "remainingdays", "entryid", "settlecurrid", "debitopr", "notsettleamount", "alrsettleamount", "receivabledate", "settleamount"}, new String[]{"undelieverqty", "delieverqty", "sign", "partsign", "unsign"}).finish();
        DataSet creditAdjustDataset = this.getCreditAdjustDataset();
        JoinDataSet creditJoinset = posResult.leftJoin(creditAdjustDataset).on("entryid", "entryid");
        DataSet result = creditJoinset.select(new String[]{"bizorg", "bizdate", "billno", "branch", "member", "customerphone", "unsign", "sign", "partsign", "undelieverqty", "delieverqty", "remainingdays", "settlecurrid", "debitopr", "notsettleamount", "alrsettleamount", "receivabledate", "settleamount"}, new String[]{"adjustQty"}).finish();
        DataSet report = result.select(this.getReportFields());
        return this.getPresentTypeFilterSet(report, reportQueryParam);
    }

    private DataSet getFilterDataset(FilterInfo filterInfo, DataSet preSelectDataset) {
        String dropDownValue = filterInfo.getString("comparison");
        String comparisonSymbol = ComparisonEnum.getComparisonSymbol((String)dropDownValue);
        int remainingday = filterInfo.getInt("remainingdayfilter");
        if (StringUtils.isEmpty((Object)dropDownValue)) {
            return preSelectDataset;
        }
        return preSelectDataset.filter("remainingdays" + comparisonSymbol + " " + remainingday);
    }

    private DataSet getDeliveryDataset(QFilter filter) {
        DataSet deliveryDataset = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocpos_saleorder", (String)"billno,goodsentryentity.salesorderdelivery.deliverystatus.id as deliverystatusid,goodsentryentity.salesorderdelivery.signstatus as signstatus", (QFilter[])new QFilter[]{filter}, (String)"bizdate");
        return deliveryDataset.select(this.getAdjustPreSelectFields()).groupBy(new String[]{"billno"}).sum("undelieverqty").sum("delieverqty").sum("unsign").sum("sign").sum("partsign").finish();
    }

    private String getReportFields() {
        List<String> repotField = this.getCommonField();
        repotField.add("remainingdays");
        repotField.add("case when undelieverqty = 0 then 'A' when delieverqty = 0  then 'B' else 'C' end as deliverystatus");
        repotField.add("case when unsign = 0 and partsign = 0 then 'C' when sign = 0  and partsign = 0 then 'A' else 'B' end as signallstatus");
        repotField.add("case when adjustQty > 0 then true  else false end as isdelay");
        repotField.add("case when remainingdays < 0 then 'A' else 'B' end as overType");
        return String.join((CharSequence)",", repotField);
    }

    private String getAdjustPreSelectFields() {
        ArrayList<String> preSelectFields = new ArrayList<String>(16);
        preSelectFields.add("billno");
        preSelectFields.add("case when deliverystatusid =1026065142993238016L then 1 else 0 end as undelieverqty");
        preSelectFields.add("case when deliverystatusid in(1026078976696892416L,1026079259451832320L) then 1 else 0 end as delieverqty");
        preSelectFields.add("case when signstatus in('A','B') then 1 else 0 end as unsign");
        preSelectFields.add("case when signstatus ='C' then 1 else 0 end as partsign");
        preSelectFields.add("case when signstatus ='D' then 1 else 0 end as sign");
        return String.join((CharSequence)",", preSelectFields);
    }

    private DataSet getCreditAdjustDataset() {
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocpos_custcreditadjust", (String)"entryentity.finentryid as entryid", (QFilter[])new QFilter[]{filter}, null);
        return dataSet.groupBy(new String[]{"entryid"}).count("adjustQty").finish();
    }

    private QFilter getFilterInfo(FilterInfo filterInfo) {
        Date revieveenddate;
        Date recievestartdate;
        Date endDate;
        Date startDate;
        DynamicObjectCollection vipTypes;
        DynamicObjectCollection members;
        DynamicObjectCollection grades;
        DynamicObjectCollection branchs;
        QFilter filter = new QFilter("finentity.setllementid.id", "=", (Object)15L);
        DynamicObjectCollection orgs = filterInfo.getDynamicObjectCollection("orgfilter");
        if (!CollectionUtils.isEmpty((Collection)orgs)) {
            filter.and("bizorgid.id", "in", orgs.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty((Collection)(branchs = filterInfo.getDynamicObjectCollection("branchfilter")))) {
            filter.and("salebranchid.id", "in", branchs.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        } else {
            List branchId = OwnerUtil.getBranchId((long)UserServiceHelper.getCurrentUserId());
            filter.and("salebranchid.id", "in", (Object)branchId);
        }
        DynamicObjectCollection channelTypes = filterInfo.getDynamicObjectCollection("channeltypefilter");
        if (!CollectionUtils.isEmpty((Collection)channelTypes)) {
            filter.and("salebranchid.channeltype.id", "in", channelTypes.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty((Collection)(grades = filterInfo.getDynamicObjectCollection("gradefilter")))) {
            filter.and("salebranchid.grade.id", "in", grades.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty((Collection)(members = filterInfo.getDynamicObjectCollection("vipfilter")))) {
            filter.and("member.id", "in", members.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty((Collection)(vipTypes = filterInfo.getDynamicObjectCollection("viptypefilter")))) {
            filter.and("member.viptype.id", "in", vipTypes.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        }
        if ((startDate = filterInfo.getDate("startdate")) != null) {
            filter.and("bizdate", ">=", (Object)startDate);
        }
        if ((endDate = filterInfo.getDate("enddate")) != null) {
            filter.and("bizdate", "<=", (Object)endDate);
        }
        if ((recievestartdate = filterInfo.getDate("recievestartdate")) != null) {
            filter.and("finentity.receivabledate", ">=", (Object)recievestartdate);
        }
        if ((revieveenddate = filterInfo.getDate("recieveenddate")) != null) {
            filter.and("finentity.receivabledate", "<=", (Object)revieveenddate);
        }
        filter.and("salebranchid.isenablecredit", "=", (Object)Boolean.TRUE);
        return filter;
    }

    private String getPreSelectField() {
        List<String> commonField = this.getCommonField();
        commonField.add("entryid");
        commonField.add(this.getRemainingDay());
        return String.join((CharSequence)",", commonField);
    }

    private String getRemainingDay() {
        String receivableDate = "TO_DATE(TO_CHAR(receivabledate,'yyyy-MM-dd'),'yyyy-MM-dd')";
        String sysDate = "TO_DATE(TO_CHAR(Now(),'yyyy-MM-dd'),'yyyy-MM-dd')";
        return "case when notsettleamount > 0 then DATEDIF(" + sysDate + "," + receivableDate + ", 'D') else 0 end as remainingdays";
    }

    private String getSaleOrderField() {
        return "id,bizorgid bizorg,salebranchid branch,member,customerphone,bizdate,billno,finentity.id entryid,finentity.receivabledate receivabledate,finentity.settlecurrid settlecurrid,finentity.alrsettleamount alrsettleamount,finentity.notsettleamount notsettleamount,finentity.settleamount settleamount,debitopr";
    }

    private List<String> getCommonField() {
        ArrayList<String> commonFields = new ArrayList<String>(64);
        commonFields.add("bizorg");
        commonFields.add("branch");
        commonFields.add("member");
        commonFields.add("customerphone");
        commonFields.add("bizdate");
        commonFields.add("billno");
        commonFields.add("settlecurrid");
        commonFields.add("debitopr");
        commonFields.add("notsettleamount");
        commonFields.add("alrsettleamount");
        commonFields.add("receivabledate");
        commonFields.add("settleamount");
        return commonFields;
    }

    private DataSet getPresentTypeFilterSet(DataSet dataSet, ReportQueryParam reportQueryParam) {
        FilterInfo filterinfo = reportQueryParam.getFilter();
        String saletypeid = filterinfo.getString("overdatefilter");
        if (StringUtils.isEmpty((Object)saletypeid)) {
            return dataSet;
        }
        String[] saletypes = saletypeid.split(",");
        List overType = Arrays.stream(saletypes).filter(s -> !"".equals(s)).collect(Collectors.toList());
        HashMap params = new HashMap(16);
        params.put("overDateType", overType);
        return dataSet.filter("overType in overDateType", params).orderBy(new String[]{"bizdate desc"});
    }
}

