/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.report.query;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.enums.StatusEnum;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocpos.common.enums.SaleStatusEnum;

public class CreditInfoReportQuery
extends AbstractReportListDataPlugin {
    private static final Log log = LogFactory.getLog(CreditInfoReportQuery.class, (String)"ocpos");

    public DataSet query(ReportQueryParam param, Object args) throws Throwable {
        try {
            return this.getData(param);
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            throw ex;
        }
    }

    private DataSet getData(ReportQueryParam param) {
        QFilter filter = this.getFilter(param);
        DataSet creditAccountInfo = this.getCreditAccountInfo(filter);
        DataSet saleOrder = this.getSaleOrder();
        return creditAccountInfo.leftJoin(saleOrder).on("id", "creditaccountid").select(this.getCreditAccountFields(), this.getSaleOrderFields()).finish().select(this.getSelectFields());
    }

    private DataSet getCreditAccountInfo(QFilter filter) {
        String selectFields = "id, settleorgid as org, branch, currencyid, credittotal, usedamount, limitbalance, overdueamount, overduetimes as overduenum, 0 as maxoverdueday";
        return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocdbd_credit_accountinfo", (String)selectFields, (QFilter[])filter.toArray(), null);
    }

    private DataSet getSaleOrder() {
        String selectFields = "member.viptypeid as viptypeid, finentity.creditaccountid as creditaccountid, finentity.notsettleamount as notsettleamount, finentity.receivabledate as receivabledate";
        QFilter filter = new QFilter("finentity.setllementid.id", "=", (Object)15L);
        filter.and("member", ">", (Object)0L);
        filter.and("billstatus", "=", (Object)StatusEnum.AUDIT.getValue());
        filter.and("salestatus", "=", (Object)SaleStatusEnum.STATUS_S.getValue());
        filter.and("finentity.notsettleamount", ">", (Object)BigDecimal.ZERO);
        DataSet saleOrders = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocpos_saleorder", (String)selectFields, (QFilter[])filter.toArray(), null);
        DataSet personData = this.getPersonData(saleOrders);
        DataSet companyData = this.getCompanyData(saleOrders);
        return personData.fullJoin(companyData).on("creditaccountid", "creditaccountid").select(this.getLastPersonDataFields(), this.getLastCompanyDataFields()).finish();
    }

    private DataSet getPersonData(DataSet dataSet) {
        return dataSet.where("viptypeid = 1069512944246953984").select(this.getPersonDataFields()).groupBy(new String[]{"creditaccountid"}).sum("pusedamount").sum("poverdueamount").sum("poverduenum").min("pminoverduedate").finish();
    }

    private DataSet getCompanyData(DataSet dataSet) {
        return dataSet.where("viptypeid = 1069513413337666560").select(this.getCompanyDataFields()).groupBy(new String[]{"creditaccountid"}).sum("cusedamount").sum("coverdueamount").sum("coverduenum").min("cminoverduedate").finish();
    }

    private QFilter getFilter(ReportQueryParam param) {
        DynamicObject currency;
        DynamicObjectCollection branchTypes;
        DynamicObjectCollection grades;
        DynamicObjectCollection branches;
        FilterInfo filterInfo = param.getFilter();
        QFilter filter = F7Utils.getCommonStatusFilter();
        DynamicObjectCollection orgs = filterInfo.getDynamicObjectCollection("orgfilter");
        if (!CollectionUtils.isEmpty((Collection)orgs)) {
            List orgIds = DynamicObjectUtils.getIdList((DynamicObjectCollection)orgs);
            filter.and("settleorgid", "in", (Object)orgIds);
        }
        if (!CollectionUtils.isEmpty((Collection)(branches = filterInfo.getDynamicObjectCollection("branchfilter")))) {
            List branchIds = DynamicObjectUtils.getIdList((DynamicObjectCollection)branches);
            filter.and("branch", "in", (Object)branchIds);
        }
        if (!CollectionUtils.isEmpty((Collection)(grades = filterInfo.getDynamicObjectCollection("gradefilter")))) {
            List gradeIds = DynamicObjectUtils.getIdList((DynamicObjectCollection)grades);
            filter.and("branch.grade", "in", (Object)gradeIds);
        }
        if (!CollectionUtils.isEmpty((Collection)(branchTypes = filterInfo.getDynamicObjectCollection("channeltypefilter")))) {
            List branchTypeIds = DynamicObjectUtils.getIdList((DynamicObjectCollection)branchTypes);
            filter.and("branch.channeltype", "in", (Object)branchTypeIds);
        }
        if ((currency = filterInfo.getDynamicObject("currencyfilter")) != null) {
            long currencyId = DynamicObjectUtils.getPkValue((DynamicObject)currency);
            filter.and("currencyid", "=", (Object)currencyId);
        }
        filter.and("branch.isenablecredit", "=", (Object)Boolean.TRUE);
        return filter;
    }

    private String[] getPersonDataFields() {
        ArrayList<String> selectFields = new ArrayList<String>();
        selectFields.add("creditaccountid");
        selectFields.add("notsettleamount as pusedamount");
        selectFields.add(this.getOverdueLimit() + " as poverdueamount");
        selectFields.add(this.getOverdueNum() + " as poverduenum");
        selectFields.add(this.getOverdueDate() + " as pminoverduedate");
        return selectFields.toArray(new String[0]);
    }

    private String[] getCompanyDataFields() {
        ArrayList<String> selectFields = new ArrayList<String>();
        selectFields.add("creditaccountid");
        selectFields.add("notsettleamount as cusedamount");
        selectFields.add(this.getOverdueLimit() + " as coverdueamount");
        selectFields.add(this.getOverdueNum() + " as coverduenum");
        selectFields.add(this.getOverdueDate() + " as cminoverduedate");
        return selectFields.toArray(new String[0]);
    }

    private String[] getLastPersonDataFields() {
        ArrayList<String> selectFields = new ArrayList<String>();
        selectFields.add("creditaccountid");
        selectFields.addAll(this.getPersonFields());
        selectFields.add(this.getMaxOverdueDay("pminoverduedate") + " as pmaxoverdueday");
        return selectFields.toArray(new String[0]);
    }

    private String[] getLastCompanyDataFields() {
        ArrayList<String> selectFields = new ArrayList<String>(this.getCompanyFields());
        selectFields.add(this.getMaxOverdueDay("cminoverduedate") + " as cmaxoverdueday");
        return selectFields.toArray(new String[0]);
    }

    private String[] getSaleOrderFields() {
        ArrayList<String> selectFields = new ArrayList<String>(this.getPersonFields());
        selectFields.add("pmaxoverdueday");
        selectFields.addAll(this.getCompanyFields());
        selectFields.add("cmaxoverdueday");
        return selectFields.toArray(new String[0]);
    }

    private String[] getCreditAccountFields() {
        ArrayList<String> selectFields = new ArrayList<String>(this.getCreditInfoFields());
        selectFields.add("maxoverdueday");
        return selectFields.toArray(new String[0]);
    }

    private String[] getSelectFields() {
        ArrayList<String> selectFields = new ArrayList<String>();
        selectFields.addAll(this.getCreditInfoFields());
        selectFields.addAll(this.getPersonFields());
        selectFields.addAll(this.getCompanyFields());
        selectFields.add("case when pmaxoverdueday >= cmaxoverdueday then pmaxoverdueday else cmaxoverdueday end as maxoverdueday");
        return selectFields.toArray(new String[0]);
    }

    private List<String> getCreditInfoFields() {
        ArrayList<String> selectFields = new ArrayList<String>();
        selectFields.add("org");
        selectFields.add("branch");
        selectFields.add("currencyid");
        selectFields.add("credittotal");
        selectFields.add("usedamount");
        selectFields.add("limitbalance");
        selectFields.add("overdueamount");
        selectFields.add("overduenum");
        return selectFields;
    }

    private List<String> getPersonFields() {
        ArrayList<String> selectFields = new ArrayList<String>();
        selectFields.add("pusedamount");
        selectFields.add("poverdueamount");
        selectFields.add("poverduenum");
        return selectFields;
    }

    private List<String> getCompanyFields() {
        ArrayList<String> selectFields = new ArrayList<String>();
        selectFields.add("cusedamount");
        selectFields.add("coverdueamount");
        selectFields.add("coverduenum");
        return selectFields;
    }

    private String getOverdueLimit() {
        return "case when receivabledate is null then 0 when " + this.getDateFilter() + " then notsettleamount else 0 end";
    }

    private String getOverdueNum() {
        return "case when receivabledate is null then 0 when " + this.getDateFilter() + " then 1 else 0 end";
    }

    private String getOverdueDate() {
        String receivableDate = this.getReceivableDate();
        String sysDate = this.getSysDate();
        return "case when receivabledate is null then " + sysDate + " when " + this.getDateFilter() + " then " + receivableDate + " else " + sysDate + " end";
    }

    private String getDateFilter() {
        String receivableDate = this.getReceivableDate();
        String sysDate = this.getSysDate();
        return receivableDate + " < " + sysDate;
    }

    private String getReceivableDate() {
        return "TO_DATE(TO_CHAR(receivabledate,'yyyy-MM-dd'),'yyyy-MM-dd')";
    }

    private String getSysDate() {
        return "TO_DATE(TO_CHAR(Now(),'yyyy-MM-dd'),'yyyy-MM-dd')";
    }

    private String getMaxOverdueDay(String key) {
        String minOverdueDate = "TO_DATE(TO_CHAR(" + key + ",'yyyy-MM-dd'),'yyyy-MM-dd')";
        String sysDate = this.getSysDate();
        return "DATEDIF( " + minOverdueDate + " ," + sysDate + ", 'D')";
    }
}

