/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.report.query;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.util.OwnerUtil;

public class FinalAnalysisReportQuery
extends AbstractReportListDataPlugin {
    public DataSet query(ReportQueryParam queryParam, Object arg1) {
        FilterInfo filterInfo = queryParam.getFilter();
        QFilter filter = this.getFilterInfo(filterInfo);
        String strField = this.getSaleOrderField();
        List<String> props = this.getGroupByProps();
        DataSet rlt1 = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocpos_saleorder", (String)strField, (QFilter[])new QFilter[]{filter}, (String)"bizdate desc");
        props.add("case when deliverystatusid = 1112809419290298368L then 1 else 0 end as stopdelieverqty");
        props.add("case when deliverystatusid = 1026065142993238016L then 1 else 0 end as undelieverqty");
        props.add("case when deliverystatusid in(1026078976696892416L,1026079259451832320L) then 1 else 0 end as delieverqty");
        props.add("case when signstatus in('A','B','') then 1 else 0 end as unsign");
        props.add("case when signstatus ='C' then 1 else 0 end as partsign");
        props.add("case when signstatus ='D' then 1 else 0 end as sign");
        rlt1 = rlt1.select(props.toArray(new String[0]));
        props = this.getGroupByProps();
        GroupbyDataSet groupByData = rlt1.groupBy(props.toArray(new String[0]));
        groupByData.sum("stopdelieverqty").sum("undelieverqty").sum("delieverqty").sum("unsign").sum("sign").sum("partsign");
        rlt1 = groupByData.finish();
        props.add("case when stopdelieverqty > 0 then 'D' when undelieverqty = 0 then 'A' when delieverqty = 0  then 'B' else 'C' end as deliverystatus");
        props.add("case when unsign = 0 and partsign = 0 then 'C' when sign = 0  and partsign = 0 then 'A' else 'B' end as signallstatus");
        rlt1 = rlt1.select(props.toArray(new String[0]));
        DataSet deliveryTypeFilterSet = this.getDeliveryTypeFilterSet(rlt1, filterInfo);
        DataSet signStatusFilterSet = this.getSignStatusFilterSet(deliveryTypeFilterSet, filterInfo);
        return signStatusFilterSet.orderBy(new String[]{"bizdate desc"});
    }

    private DataSet getDeliveryTypeFilterSet(DataSet dataSet, FilterInfo filterinfo) {
        String deliverStatus = filterinfo.getString("deliverstatusfilter");
        if (StringUtils.isEmpty((String)deliverStatus)) {
            return dataSet;
        }
        String[] deliverType = deliverStatus.split(",");
        List selectedSaleType = Arrays.stream(deliverType).filter(s -> !"".equals(s)).collect(Collectors.toList());
        HashMap params = new HashMap(16);
        params.put("selectedSaleType", selectedSaleType);
        return dataSet.filter("deliverystatus in selectedSaleType", params);
    }

    private DataSet getSignStatusFilterSet(DataSet dataSet, FilterInfo filterinfo) {
        String deliverStatus = filterinfo.getString("signstatusfilter");
        if (StringUtils.isEmpty((String)deliverStatus)) {
            return dataSet;
        }
        String[] deliverType = deliverStatus.split(",");
        List selectedSaleType = Arrays.stream(deliverType).filter(s -> !"".equals(s)).collect(Collectors.toList());
        HashMap params = new HashMap(16);
        params.put("selectedSaleType", selectedSaleType);
        return dataSet.filter("signallstatus in selectedSaleType", params);
    }

    private String getSaleOrderField() {
        return "id,bizorgid bizorg,salebranchid branch,member,customerphone,bizdate,billno,cashier,saler,goodsentryentity.id entryid,goodsentryentity.goodsid goods,goodsentryentity.goodsclass goodsclass,goodsentryentity.balamount balamount,goodsentryentity.finalpayment finalpayment,goodsentryentity.norecefinalamount norecefinalamount,goodsentryentity.receivedfinalpayment receivedfinalpayment,goodsentryentity.refundfinalamount refundfinalamount,goodsentryentity.salesorderdelivery.id detailid,goodsentryentity.salesorderdelivery.deliverystatus.id deliverystatusid,goodsentryentity.salesorderdelivery.signstatus as signstatus";
    }

    private List<String> getGroupByProps() {
        ArrayList<String> groupList = new ArrayList<String>();
        groupList.add("bizorg");
        groupList.add("branch");
        groupList.add("member");
        groupList.add("customerphone");
        groupList.add("bizdate");
        groupList.add("billno");
        groupList.add("cashier");
        groupList.add("entryid");
        groupList.add("goods");
        groupList.add("goodsclass");
        groupList.add("balamount");
        groupList.add("finalpayment");
        groupList.add("norecefinalamount");
        groupList.add("receivedfinalpayment");
        groupList.add("refundfinalamount");
        groupList.add("saler");
        return groupList;
    }

    private String getOrderByField() {
        return "bizdate";
    }

    private QFilter getFilterInfo(FilterInfo filterInfo) {
        String billFilter;
        String itemFilter;
        Date endDate;
        Date startDate;
        DynamicObject vipType;
        DynamicObjectCollection saleFilter;
        DynamicObjectCollection members;
        DynamicObjectCollection grades;
        ArrayList<Long> lstBillTypeId = new ArrayList<Long>(0);
        lstBillTypeId.add(BillTypeEnum.RETAIL.getId());
        lstBillTypeId.add(BillTypeEnum.CVTSALE.getId());
        lstBillTypeId.add(BillTypeEnum.GUIDE.getId());
        lstBillTypeId.add(BillTypeEnum.GROUP.getId());
        QFilter filter = new QFilter("basebilltype.id", "in", lstBillTypeId);
        filter.and("goodsentryentity.finalpayment", ">", (Object)BigDecimal.ZERO);
        filter.and("goodsentryentity.isbook", "=", (Object)Boolean.FALSE);
        DynamicObjectCollection orgs = filterInfo.getDynamicObjectCollection("orgfilter");
        if (orgs != null && orgs.size() > 0) {
            filter.and("bizorgid.id", "in", orgs.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        }
        List branchId = OwnerUtil.getBranchId((long)UserServiceHelper.getCurrentUserId());
        DynamicObjectCollection branchs = filterInfo.getDynamicObjectCollection("branchfilter");
        if (branchs != null && branchs.size() > 0) {
            filter.and("salebranchid.id", "in", branchs.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        } else {
            filter.and("salebranchid.id", "in", (Object)branchId);
        }
        DynamicObjectCollection channelTypes = filterInfo.getDynamicObjectCollection("channeltypefilter");
        if (channelTypes != null && channelTypes.size() > 0) {
            filter.and("salebranchid.channeltype.id", "in", channelTypes.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        }
        if ((grades = filterInfo.getDynamicObjectCollection("gradefilter")) != null && grades.size() > 0) {
            filter.and("salebranchid.grade.id", "in", grades.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty((Collection)(members = filterInfo.getDynamicObjectCollection("vipfilter")))) {
            filter.and("member.id", "in", members.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty((Collection)(saleFilter = filterInfo.getDynamicObjectCollection("salerfilter")))) {
            filter.and("saler.id", "in", saleFilter.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        }
        if ((vipType = filterInfo.getDynamicObject("viptypefilter")) != null) {
            filter.and("member.viptype.id", "=", vipType.getPkValue());
        }
        if ((startDate = filterInfo.getDate("startdate")) != null) {
            filter.and("bizdate", ">=", (Object)startDate);
        }
        if ((endDate = filterInfo.getDate("enddate")) != null) {
            filter.and("bizdate", "<=", (Object)endDate);
        }
        if (!StringUtils.isEmpty((String)(itemFilter = filterInfo.getString("itemnofilter")))) {
            filter.and("goodsentryentity.goodsid.number", "=", (Object)itemFilter);
        }
        if (!StringUtils.isEmpty((String)(billFilter = filterInfo.getString("billfilter")))) {
            filter.and("billno", "=", (Object)billFilter);
        }
        filter.and("billstatus", "=", (Object)"C");
        filter.and("salestatus", "=", (Object)"S");
        return filter;
    }
}

