/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.report.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocpos.common.util.DynamicObjectUtil;
import kd.occ.ocpos.common.vo.GiftInfoQueryVO;
import kd.occ.ocpos.report.query.SalerReportQuery;

public class GiftInfoReportQuery
extends AbstractReportListDataPlugin {
    private static final String Select_gift = "gift";
    private static final String Select_member = "member";
    private static final String Select_itemAmount = "itemAmount";
    private static final String Select_itemGetNum = "itemGetNum";
    private static final String Select_newMemberNum = "newMemberNum";
    private static final Log logger = LogFactory.getLog(SalerReportQuery.class);
    private static final String channelclass = "001";

    public DataSet query(ReportQueryParam queryParam, Object args) throws Throwable {
        try {
            return this.query(queryParam);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
    }

    public DataSet query(ReportQueryParam reportQueryParam) {
        GiftInfoQueryVO giftParam = this.getParam(reportQueryParam);
        QFilter queryFilter = this.getQueryFilter(giftParam);
        DataSet resultDateSet = this.getQueryDataset(queryFilter, giftParam);
        return resultDateSet;
    }

    private DataSet getQueryDataset(QFilter queryFilter, GiftInfoQueryVO giftParam) {
        Set<Long> itemSet = this.getItemSet(queryFilter);
        DataSet memberNumDataSet = this.getMemberNumDataSet(queryFilter);
        DataSet itemPriceDateSet = this.getItemPriceDateSet(itemSet, giftParam);
        DataSet itemGetNumDataSet = this.getItemGetNumDateSet(itemSet, giftParam);
        DataSet newMemberDataSet = this.getNewMemberDataSet(giftParam);
        List<String> selectFields = this.getSelectFields(giftParam, Select_gift);
        DataSet tempDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocpos_giftrecbill", (String)String.join((CharSequence)",", this.getGiftRecFields(giftParam)), (QFilter[])queryFilter.toArray(), null).groupBy(selectFields.toArray(new String[selectFields.size()])).sum("itemqty").finish();
        JoinDataSet joinDataSet2 = tempDataSet.fullJoin(memberNumDataSet).on("itemid", "itemid").on("activityname", "activityname");
        List<String> memberDataSetFields = this.getSelectFields(giftParam, Select_member);
        DataSet tempDataSet2 = joinDataSet2.select(memberDataSetFields.toArray(new String[memberDataSetFields.size()])).finish();
        JoinDataSet joinDataSet3 = tempDataSet2.fullJoin(itemPriceDateSet).on("itemid", "itemid");
        List<String> itemAmountFields = this.getSelectFields(giftParam, Select_itemAmount);
        DataSet tempDataSet3 = joinDataSet3.select(itemAmountFields.toArray(new String[itemAmountFields.size()])).finish();
        JoinDataSet joinDataSet4 = tempDataSet3.fullJoin(itemGetNumDataSet).on("itemid", "itemid").on("activityname", "activityname");
        List<String> itemGetFields = this.getSelectFields(giftParam, Select_itemGetNum);
        DataSet tempDataSet4 = joinDataSet4.select(itemGetFields.toArray(new String[itemGetFields.size()])).finish();
        JoinDataSet joinDataSet5 = tempDataSet4.fullJoin(newMemberDataSet).on("storeid", "storeid");
        List<String> newMemberNum = this.getSelectFields(giftParam, Select_newMemberNum);
        DataSet tempDataSet5 = joinDataSet5.select(newMemberNum.toArray(new String[newMemberNum.size()])).finish();
        DataSet tempDataSet6 = tempDataSet5.where(String.join((CharSequence)",", this.getRemoveNullFields()));
        return tempDataSet6;
    }

    private Set<Long> getItemSet(QFilter queryFilter) {
        HashSet<Long> itemSet = new HashSet<Long>();
        DynamicObjectCollection giftBills = QueryServiceHelper.query((String)"ocpos_giftrecbill", (String)"memberid, giftrecentry.receivenum, giftrecentry.itemid", (QFilter[])queryFilter.toArray());
        if (!CollectionUtils.isEmpty((Collection)giftBills)) {
            for (DynamicObject giftBill : giftBills) {
                Long item = DynamicObjectUtil.getLong((DynamicObject)giftBill, (String)"giftrecentry.itemid");
                itemSet.add(item);
            }
        }
        return itemSet;
    }

    private DataSet getNewMemberDataSet(GiftInfoQueryVO giftParam) {
        QFilter qFilter = new QFilter("storeid", "in", (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)giftParam.getStore()));
        DataSet newMemberDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocpos_olstoreshareclick", (String)"storeid, isnewmember", (QFilter[])qFilter.toArray(), null).select(new String[]{"storeid", "isnewmember"}).where("isnewmember is not null").groupBy(new String[]{"storeid"}).count("newmembernum").finish();
        return newMemberDataSet;
    }

    private DataSet getMemberNumDataSet(QFilter queryFilter) {
        DataSet memberNumDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocpos_giftrecbill", (String)"memberid, giftrecentry.itemid as itemid, giftrecentry.activityname as activityname", (QFilter[])queryFilter.toArray(), null).select(true, new String[]{"itemid", "memberid", "activityname"}).groupBy(new String[]{"itemid", "activityname"}).count("membernum").finish();
        return memberNumDataSet;
    }

    private DataSet getItemPriceDateSet(Set<Long> itemSet, GiftInfoQueryVO giftParam) {
        QFilter qFilter = new QFilter("channelid", "in", (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)giftParam.getStore()));
        qFilter.and("itemid", "in", itemSet);
        DataSet itemPriceSumDateSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocdbd_itemsale_content", (String)"itemid, retailprice as itemamount, sellingprice as itemcost", (QFilter[])qFilter.toArray(), null).groupBy(new String[]{"itemid", "itemamount", "itemcost"}).finish();
        return itemPriceSumDateSet;
    }

    private DataSet getItemGetNumDateSet(Set<Long> itemSet, GiftInfoQueryVO giftParam) {
        QFilter qFilter1 = new QFilter("storesetting", "=", (Object)"1");
        qFilter1.and("branchid", "in", (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)giftParam.getStore()));
        qFilter1.and("goodsentry.goodsid", "in", itemSet);
        qFilter1.and("activestatus", "=", (Object)"B");
        qFilter1.and("status", "=", (Object)"C");
        QFilter qFilter2 = new QFilter("storesetting", "=", (Object)"2");
        qFilter2.and("controlmethod", "=", (Object)"0");
        qFilter2.and("goodsentry.goodsid", "in", itemSet);
        qFilter2.and("activestatus", "=", (Object)"B");
        qFilter2.and("status", "=", (Object)"C");
        QFilter qFilter3 = new QFilter("storesetting", "=", (Object)"2");
        qFilter3.and("controlmethod", "=", (Object)"1");
        qFilter3.and("branchentry.branch", "in", (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)giftParam.getStore()));
        qFilter3.and("goodsentry.goodsid", "in", itemSet);
        qFilter3.and("activestatus", "=", (Object)"B");
        qFilter3.and("status", "=", (Object)"C");
        QFilter qFilter4 = qFilter1.or(qFilter2).or(qFilter3);
        DataSet itemGetNumDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocdbd_giftset", (String)"id as activityname, goodsentry.singleqty as itemactivityqty, goodsentry.singleqty as itemactivityallqty, goodsentry.goodsid as itemid", (QFilter[])qFilter4.toArray(), null).groupBy(new String[]{"itemid", "itemactivityqty", "activityname"}).sum("itemactivityallqty").finish();
        return itemGetNumDataSet;
    }

    private DataSet getActivityDataSet(GiftInfoQueryVO giftParam) {
        QFilter qFilter1 = new QFilter("storesetting", "=", (Object)"1");
        qFilter1.and("branchid", "in", (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)giftParam.getStore()));
        qFilter1.and("activestatus", "=", (Object)"B");
        qFilter1.and("status", "=", (Object)"C");
        QFilter qFilter2 = new QFilter("storesetting", "=", (Object)"2");
        qFilter2.and("controlmethod", "=", (Object)"0");
        QFilter qFilter3 = new QFilter("storesetting", "=", (Object)"2");
        qFilter3.and("controlmethod", "=", (Object)"1");
        qFilter3.and("branchentry.branch", "in", (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)giftParam.getStore()));
        QFilter qFilter4 = qFilter1.or(qFilter2).or(qFilter3);
        DataSet activityDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocdbd_giftset", (String)"id as activityname", (QFilter[])qFilter4.toArray(), null);
        return activityDataSet;
    }

    private List<String> getRemoveNullFields() {
        ArrayList<String> selectFields = new ArrayList<String>();
        selectFields.add("storeid is not null");
        return selectFields;
    }

    private List<String> getSelectFields(GiftInfoQueryVO giftParam, String type) {
        ArrayList<String> selectFields = new ArrayList<String>(64);
        selectFields.add("orgid");
        selectFields.add("itemid");
        selectFields.add("storeid");
        selectFields.add("activityname");
        if (!CollectionUtils.isEmpty((Collection)giftParam.getStoreclass())) {
            selectFields.add("channelclass");
        }
        if (!CollectionUtils.isEmpty((Collection)giftParam.getStoretype())) {
            selectFields.add("channeltype");
        }
        if (type.equals(Select_itemAmount)) {
            selectFields.add("itemqty");
            selectFields.add("membernum");
            selectFields.add("itemamount");
            selectFields.add("itemcost");
            selectFields.add("(itemamount * itemqty) as itemallamount");
            selectFields.add("(itemcost * itemqty) as itemallcost");
        } else if (type.equals(Select_itemGetNum)) {
            selectFields.add("itemqty");
            selectFields.add("membernum");
            selectFields.add("itemamount");
            selectFields.add("itemcost");
            selectFields.add("(itemamount * itemqty) as itemallamount");
            selectFields.add("(itemcost * itemqty) as itemallcost");
            selectFields.add("itemactivityqty");
            selectFields.add("itemactivityallqty");
            selectFields.add("(itemactivityallqty - itemqty) as surplusqty");
        } else if (type.equals(Select_member)) {
            selectFields.add("membernum");
            selectFields.add("itemqty");
        } else if (type.equals(Select_newMemberNum)) {
            selectFields.add("itemqty");
            selectFields.add("membernum");
            selectFields.add("itemamount");
            selectFields.add("itemcost");
            selectFields.add("(itemamount * itemqty) as itemallamount");
            selectFields.add("(itemcost * itemqty) as itemallcost");
            selectFields.add("itemactivityqty");
            selectFields.add("itemactivityallqty");
            selectFields.add("(itemactivityallqty - itemqty) as surplusqty");
            selectFields.add("newmembernum");
        }
        return selectFields;
    }

    private List<String> getGiftRecFields(GiftInfoQueryVO giftParam) {
        ArrayList<String> giftRecFieldsList = new ArrayList<String>();
        giftRecFieldsList.add("orgid");
        giftRecFieldsList.add("storeid");
        giftRecFieldsList.add("giftrecentry.activityname as activityname");
        giftRecFieldsList.add("giftrecentry.itemid as itemid");
        giftRecFieldsList.add("giftrecentry.receivenum as itemqty");
        giftRecFieldsList.add("memberid");
        if (!CollectionUtils.isEmpty((Collection)giftParam.getStoreclass())) {
            giftRecFieldsList.add("storeid.channelclassentity.channelclass as channelclass");
        }
        if (!CollectionUtils.isEmpty((Collection)giftParam.getStoretype())) {
            giftRecFieldsList.add("storeid.channeltype as channeltype");
        }
        return giftRecFieldsList;
    }

    private QFilter getQueryFilter(GiftInfoQueryVO giftParam) {
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        if (!CollectionUtils.isEmpty((Collection)giftParam.getOrg())) {
            filter.and("orgid", "in", (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)giftParam.getOrg()));
        }
        if (!CollectionUtils.isEmpty((Collection)giftParam.getStore())) {
            filter.and("storeid", "in", (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)giftParam.getStore()));
        }
        if (!CollectionUtils.isEmpty((Collection)giftParam.getActivity())) {
            filter.and("giftrecentry.activityname", "in", (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)giftParam.getActivity()));
        }
        if (!CollectionUtils.isEmpty((Collection)giftParam.getStoreclass())) {
            filter.and("storeid.channelclassentity.channelclass", "in", (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)giftParam.getStoreclass()));
            filter.and("storeid.channelclassentity.classstandard.number", "=", (Object)channelclass);
        }
        if (!CollectionUtils.isEmpty((Collection)giftParam.getStoretype())) {
            filter.and("storeid.channeltype", "in", (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)giftParam.getStoretype()));
        }
        return filter;
    }

    private GiftInfoQueryVO getParam(ReportQueryParam reportQueryParam) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        GiftInfoQueryVO giftQueryVO = new GiftInfoQueryVO();
        giftQueryVO.setOrg(filterInfo.getDynamicObjectCollection("orgparam"));
        giftQueryVO.setStore(filterInfo.getDynamicObjectCollection("storeparam"));
        giftQueryVO.setActivity(filterInfo.getDynamicObjectCollection("activityparam"));
        giftQueryVO.setStoreclass(filterInfo.getDynamicObjectCollection("storeclassparam"));
        giftQueryVO.setStoretype(filterInfo.getDynamicObjectCollection("storetypeparam"));
        return giftQueryVO;
    }
}

