/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.report.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.occ.ocpos.common.util.OwnerUtil;

public class ItemBookSysReportQuery
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(ItemBookSysReportQuery.class);

    public DataSet query(ReportQueryParam queryParam, Object args) throws Throwable {
        try {
            return this.query(queryParam);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
    }

    public DataSet query(ReportQueryParam reportQueryParam) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        QFilter filter = this.getFilterInfo(filterInfo);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocpos_saleorder", (String)this.getSaleOrderField(), (QFilter[])new QFilter[]{filter}, (String)"bizdate desc");
        DataSet preSelectDataset = dataSet.select(this.getPreSelectFields());
        List<String> groupByFields = this.getGroupByFields();
        GroupbyDataSet groupbyDataSet = preSelectDataset.groupBy(groupByFields.toArray(new String[groupByFields.size()]));
        this.sumGroupDataset(groupbyDataSet, this.getSumFields());
        return groupbyDataSet.finish().select(this.getReportFields()).orderBy(new String[]{"bizdate desc"});
    }

    private void sumGroupDataset(GroupbyDataSet groupbyDataSet, List<String> sumFields) {
        sumFields.forEach(sumField -> groupbyDataSet.sum(sumField));
    }

    private List<String> getSumFields() {
        ArrayList<String> sumFields = new ArrayList<String>();
        sumFields.add("undelieverqty");
        sumFields.add("delieverqty");
        return sumFields;
    }

    private String getReportFields() {
        List<String> repotField = this.getGroupByFields();
        repotField.add("case when undelieverqty = 0 then 'A' when delieverqty = 0  then 'B' else 'C' end as deliverystatus");
        repotField.add("tosalesqty*discountprice as resellamount");
        repotField.add("retqty*discountprice as cancelamount");
        return String.join((CharSequence)",", repotField);
    }

    private String getPreSelectFields() {
        List<String> preSelectFields = this.getGroupByFields();
        preSelectFields.add("case when deliverystatusid =1026065142993238016L then 1 else 0 end as undelieverqty");
        preSelectFields.add("case when deliverystatusid in(1026078976696892416L,1026079259451832320L) then 1 else 0 end as delieverqty");
        return String.join((CharSequence)",", preSelectFields);
    }

    private QFilter getFilterInfo(FilterInfo filterInfo) {
        DynamicObject currency;
        DynamicObjectCollection itemClass;
        DynamicObjectCollection itemBrand;
        DynamicObjectCollection item;
        DynamicObjectCollection sales;
        Date endDate;
        Date startDate;
        DynamicObjectCollection vipTypes;
        DynamicObjectCollection members;
        DynamicObjectCollection grades;
        DynamicObjectCollection branchs;
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        filter.and("goodsentryentity.isbook", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection orgs = filterInfo.getDynamicObjectCollection("orgfilter");
        if (!CollectionUtils.isEmpty((Collection)orgs)) {
            filter.and("bizorgid.id", "in", orgs.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty((Collection)(branchs = filterInfo.getDynamicObjectCollection("branchfilter")))) {
            filter.and("salebranchid.id", "in", branchs.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        } else {
            List branchId = OwnerUtil.getBranchId((long)UserServiceHelper.getCurrentUserId());
            filter.and("salebranchid.id", "in", (Object)branchId);
        }
        DynamicObjectCollection channelTypes = filterInfo.getDynamicObjectCollection("channeltypefilter");
        if (!CollectionUtils.isEmpty((Collection)channelTypes)) {
            filter.and("salebranchid.channeltype.id", "in", channelTypes.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty((Collection)(grades = filterInfo.getDynamicObjectCollection("gradefilter")))) {
            filter.and("salebranchid.grade.id", "in", grades.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty((Collection)(members = filterInfo.getDynamicObjectCollection("vipfilter")))) {
            filter.and("member.id", "in", members.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty((Collection)(vipTypes = filterInfo.getDynamicObjectCollection("viptypefilter")))) {
            filter.and("member.viptype.id", "in", vipTypes.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        }
        if ((startDate = filterInfo.getDate("startdate")) != null) {
            filter.and("bizdate", ">=", (Object)startDate);
        }
        if ((endDate = filterInfo.getDate("enddate")) != null) {
            filter.and("bizdate", "<=", (Object)endDate);
        }
        if (!CollectionUtils.isEmpty((Collection)(sales = filterInfo.getDynamicObjectCollection("salerfilter")))) {
            filter.and("goodsentryentity.goodssaler", "in", sales.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty((Collection)(item = filterInfo.getDynamicObjectCollection("itemfilter")))) {
            filter.and("goodsentryentity.goodsid", "in", item.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty((Collection)(itemBrand = filterInfo.getDynamicObjectCollection("itembrandfilter")))) {
            filter.and("goodsentryentity.brand", "in", itemBrand.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty((Collection)(itemClass = filterInfo.getDynamicObjectCollection("itemclassfilter")))) {
            filter.and("goodsentryentity.goodsclass", "in", itemClass.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        }
        if (null != (currency = filterInfo.getDynamicObject("currencyfilter"))) {
            filter.and("locurrencyid", "=", currency.getPkValue());
        }
        filter.and("basebilltype", "!=", (Object)1041368841512679424L);
        filter.and("goodsentryentity.ispresent", "=", (Object)Boolean.FALSE);
        QFilter ydkdFilter = new QFilter("basebilltype", "=", (Object)1041367443022673920L);
        ydkdFilter.and("notconfirm", "=", (Object)Boolean.FALSE);
        ydkdFilter.or("basebilltype", "!=", (Object)1041367443022673920L);
        return filter.and(ydkdFilter);
    }

    private String getSaleOrderField() {
        return "id,bizorgid bizorg,salebranchid branch,member,customerphone,bizdate,billno,cashier,goodsentryentity.id entryid,goodsentryentity.goodsid goods,goodsentryentity.goodsclass goodsclass,goodsentryentity.balamount balamount,goodsentryentity.discountprice discountprice,goodsentryentity.baseunit baseunit,goodsentryentity.saleqty saleqty,goodsentryentity.deposit deposit,goodsentryentity.expectfinalamount expectfinalamount,goodsentryentity.receexpectfinalamount receexpectfinalamount,goodsentryentity.noreceexpectfinalamount noreceexpectfinalamount,goodsentryentity.goodssaler goodssaler,goodsentryentity.tosalesqty tosalesqty,goodsentryentity.retqty retqty,goodsentryentity.salesorderdelivery.id detailid,goodsentryentity.salesorderdelivery.deliverystatus.id deliverystatusid ";
    }

    private List<String> getGroupByFields() {
        ArrayList<String> groupByFields = new ArrayList<String>(64);
        groupByFields.add("bizorg");
        groupByFields.add("branch");
        groupByFields.add("member");
        groupByFields.add("customerphone");
        groupByFields.add("bizdate");
        groupByFields.add("billno");
        groupByFields.add("cashier");
        groupByFields.add("goods");
        groupByFields.add("balamount");
        groupByFields.add("discountprice");
        groupByFields.add("baseunit");
        groupByFields.add("saleqty");
        groupByFields.add("deposit");
        groupByFields.add("expectfinalamount");
        groupByFields.add("receexpectfinalamount");
        groupByFields.add("noreceexpectfinalamount");
        groupByFields.add("goodssaler");
        groupByFields.add("tosalesqty");
        groupByFields.add("retqty");
        groupByFields.add("detailid");
        groupByFields.add("entryid");
        groupByFields.add("goodsclass");
        return groupByFields;
    }
}

