/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.report.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.DynamicObjectUtil;
import kd.occ.ocpos.common.util.StringUtil;
import kd.occ.ocpos.common.vo.OlinvitationDetailVO;
import kd.occ.ocpos.report.query.PayCheckReportQuery;

public class OlinvitationDetailQuery
extends AbstractReportListDataPlugin {
    private static final String CANCEL = "C";
    private static final String RECYCLE = "R";
    private static final Log logger = LogFactory.getLog(PayCheckReportQuery.class);

    public DataSet query(ReportQueryParam queryParam, Object args) {
        try {
            return this.query(queryParam);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
    }

    public DataSet query(ReportQueryParam reportQueryParam) {
        OlinvitationDetailVO olinvitationDetailVO = this.getParam(reportQueryParam);
        return this.getQueryDataset(olinvitationDetailVO);
    }

    private DataSet getQueryDataset(OlinvitationDetailVO olinvitationDetailVO) {
        DataSet publishData = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocgcm_ticketspublish", (String)String.join((CharSequence)",", this.getTicketsPublishFields()), (QFilter[])this.getTicketsPublishFilter(olinvitationDetailVO).toArray(), null);
        DataSet ticketsPublishDataSet = publishData.copy().groupBy(this.getTicketsPublishGroupByFields().toArray(new String[0])).sum("payamount").finish();
        DataSet ticketsPublishCancelDataSet = publishData.copy().filter("ticketstatus = 'C'").groupBy(this.getTicketsPublishCancelGroupByFields().toArray(new String[0])).finish();
        HashSet<Long> consumeBillIdSet = new HashSet<Long>(0);
        HashSet<Long> recycleBillIdSet = new HashSet<Long>(0);
        this.getBillIds(publishData.copy(), consumeBillIdSet, recycleBillIdSet);
        DataSet saleOrderDataSet = this.getGroupbyDataSet(this.getSaleOrderFields(), this.getSaleOrderGourpByFields(), this.getSaleOrderFilter(consumeBillIdSet), "ocpos_saleorder").finish();
        DataSet saleOrderTicketDataSet = this.getGroupbyDataSet(this.getSaleOrderTicketFields(), this.getSaleOrderTicketGroupByFields(), this.getSaleOrderTicketFilter(consumeBillIdSet), "ocpos_saleorder").sum("saleticket").finish();
        DataSet paymentflowDataSet = this.getGroupbyDataSet(this.getPaymentFlowFields(), this.getPaymentFlowGourpByFields(), this.getRecycleFilter(recycleBillIdSet), "ocdbd_paymentflow").finish();
        DataSet tempDateSet1 = this.joinDataSet(ticketsPublishDataSet, ticketsPublishCancelDataSet, this.getTicketsPublishCancelGroupByFields()).distinct();
        DataSet tempDateSet2 = this.joinDataSetForSaleOrder(tempDateSet1, saleOrderDataSet, this.getTicketAndSaleOrderFields());
        DataSet tempDataSet3 = this.joinDataSetForSaleOrder(tempDateSet2, saleOrderTicketDataSet, this.getSaleOrderAndTicketFields());
        DataSet tempDataSet4 = this.joinDataSetForPaymentFlow(tempDataSet3, paymentflowDataSet, this.getTicketAndPaymentFlowFields());
        DataSet tempDataSet5 = tempDataSet4.groupBy(this.getDeal1Fields().toArray(new String[0])).groupConcat("item").sum("itemnum").finish();
        DataSet tempDataSet6 = tempDataSet5.select(String.join((CharSequence)",", this.getDeal2Fields())).orderBy(new String[]{"date desc"});
        return tempDataSet6.select(String.join((CharSequence)",", this.getDeal3Fields())).orderBy(new String[]{"date desc"});
    }

    private GroupbyDataSet getGroupbyDataSet(List<String> selectFields, List<String> selectGroupByFields, QFilter qFilter, String title) {
        return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)title, (String)String.join((CharSequence)",", selectFields), (QFilter[])qFilter.toArray(), null).groupBy(selectGroupByFields.toArray(new String[0]));
    }

    private DataSet joinDataSet(DataSet leftDataSet, DataSet rightDataSet, List<String> selectFields) {
        JoinDataSet tempDataSet = leftDataSet.leftJoin(rightDataSet).on("olvitation", "olvitation").on("store", "store").on("date", "date").on("user", "user").on("ticketno", "ticketno");
        return tempDataSet.select(selectFields.toArray(new String[0])).finish();
    }

    private DataSet joinDataSetForSaleOrder(DataSet leftDataSet, DataSet rightDataSet, List<String> selectFields) {
        JoinDataSet tempDataSet = leftDataSet.leftJoin(rightDataSet).on("cancelbillno", "cancelbillno");
        return tempDataSet.select(selectFields.toArray(new String[0])).finish();
    }

    private DataSet joinDataSetForPaymentFlow(DataSet leftDataSet, DataSet rightDataSet, List<String> selectFields) {
        JoinDataSet tempDataSet = leftDataSet.leftJoin(rightDataSet).on("refundno", "refundno");
        return tempDataSet.select(selectFields.toArray(new String[0])).finish();
    }

    private List<String> getTicketsPublishFields() {
        ArrayList<String> selectFields = new ArrayList<String>(20);
        selectFields.add("olinvitateid as olvitation");
        selectFields.add("branchid as store");
        selectFields.add("salesmanid as user");
        selectFields.add("createtime as date");
        selectFields.add("entryentity.ticketid as ticketno");
        selectFields.add("entryentity.ticketid.ticketstatus as ticketstatus");
        selectFields.add("entryentity.tickettypeid as tickettype");
        selectFields.add("entryentity.vipid as member");
        selectFields.add("entryentity.vipid.mobile as phone");
        selectFields.add("billno as billno");
        selectFields.add("entryentity.realsaleamount as payamount");
        selectFields.add("case when billtypeid = 1150524802763761664L then 0 else 1 end as ispulish");
        selectFields.add("case when entryentity.ticketid.ticketstatus = 'R' then 1 when entryentity.ticketid.ticketstatus in('W','P') then 0 end as isrefund");
        selectFields.add("case when entryentity.ticketid.ticketstatus = 'C' then entryentity.ticketid.consumebillno end as cancelbillno");
        selectFields.add("entryentity.ticketid.publishbillno as payno");
        selectFields.add("entryentity.ticketid.activateposorderno as activebillno");
        selectFields.add("case when entryentity.ticketid.ticketstatus = 'R' then entryentity.ticketid.recyclebillno end as refundno");
        selectFields.add("TO_CHAR(entryentity.ticketid.consumetime,'yyyy-MM-dd') as canceldate");
        selectFields.add("entryentity.ticketid.consumebranchid as cancelstore");
        selectFields.add("entryentity.ticketid.consumebillid as consumebillid");
        selectFields.add("entryentity.ticketid.recyclebillid as recyclebillid");
        return selectFields;
    }

    private List<String> getSaleOrderTicketFields() {
        ArrayList<String> selectFields = new ArrayList<String>(2);
        selectFields.add("billno as cancelbillno");
        selectFields.add("finentity.settleamount as saleticket");
        return selectFields;
    }

    private List<String> getSaleOrderTicketGroupByFields() {
        ArrayList<String> selectFields = new ArrayList<String>(1);
        selectFields.add("cancelbillno");
        return selectFields;
    }

    private List<String> getSaleOrderFields() {
        ArrayList<String> selectFields = new ArrayList<String>(6);
        selectFields.add("billno as cancelbillno");
        selectFields.add("goodsentryentity.goodsid.name as item");
        selectFields.add("goodsentryentity.saleqty as itemnum");
        selectFields.add("sumbalamount as saleamount");
        selectFields.add("saleendtime as saledate");
        selectFields.add("saler as saler");
        return selectFields;
    }

    private List<String> getPaymentFlowFields() {
        ArrayList<String> selectFields = new ArrayList<String>(3);
        selectFields.add("billno as refundno");
        selectFields.add("paystatus as issuccessrefund");
        selectFields.add("TO_CHAR(paytime,'yyyy-MM-dd') as refunddate");
        return selectFields;
    }

    private List<String> getPaymentFlowGourpByFields() {
        ArrayList<String> selectFields = new ArrayList<String>(3);
        selectFields.add("refundno");
        selectFields.add("issuccessrefund");
        selectFields.add("refunddate");
        return selectFields;
    }

    private List<String> getTicketsPublishCancelFields() {
        List<String> selectFields = this.getTicketsPublishFields();
        selectFields.add("TO_CHAR(entryentity.ticketid.consumetime,'yyyy-MM-dd') as canceldate");
        selectFields.add("entryentity.ticketid.consumebranchid as cancelstore");
        return selectFields;
    }

    private List<String> getTicketsPublishGroupByFields() {
        ArrayList<String> selectFields = new ArrayList<String>(20);
        selectFields.add("olvitation");
        selectFields.add("store");
        selectFields.add("user");
        selectFields.add("date");
        selectFields.add("ticketno");
        selectFields.add("tickettype");
        selectFields.add("ticketstatus");
        selectFields.add("phone");
        selectFields.add("member");
        selectFields.add("billno");
        selectFields.add("ispulish");
        selectFields.add("isrefund");
        selectFields.add("cancelbillno");
        selectFields.add("refundno");
        selectFields.add("payno");
        selectFields.add("activebillno");
        return selectFields;
    }

    private List<String> getSaleOrderGourpByFields() {
        ArrayList<String> selectFields = new ArrayList<String>(6);
        selectFields.add("cancelbillno");
        selectFields.add("item");
        selectFields.add("itemnum");
        selectFields.add("saledate");
        selectFields.add("saler");
        selectFields.add("saleamount");
        return selectFields;
    }

    private List<String> getTicketsPublishCancelGroupByFields() {
        List<String> selectFields = this.getTicketsPublishGroupByFields();
        selectFields.add("payamount");
        selectFields.add("canceldate");
        selectFields.add("cancelstore");
        return selectFields;
    }

    private List<String> getTicketAndSaleOrderFields() {
        List<String> selectFields = this.getTicketsPublishCancelGroupByFields();
        selectFields.add("item");
        selectFields.add("itemnum");
        selectFields.add("saledate");
        selectFields.add("saler");
        selectFields.add("saleamount");
        return selectFields;
    }

    private List<String> getSaleOrderAndTicketFields() {
        List<String> selectFields = this.getTicketAndSaleOrderFields();
        selectFields.add("saleticket");
        return selectFields;
    }

    private List<String> getTicketAndPaymentFlowFields() {
        List<String> selectFields = this.getSaleOrderAndTicketFields();
        selectFields.add("issuccessrefund");
        selectFields.add("refunddate");
        return selectFields;
    }

    private List<String> getDeal1Fields() {
        List<String> selectFields = this.getTicketAndPaymentFlowFields();
        selectFields.remove("item");
        selectFields.remove("itemnum");
        selectFields.add("saleamount - saleticket as salepayamount");
        return selectFields;
    }

    private List<String> getDeal2Fields() {
        List<String> selectFields = this.getDeal1Fields();
        selectFields.add("item");
        selectFields.add("itemnum");
        return selectFields;
    }

    private List<String> getDeal3Fields() {
        List<String> selectFields = this.getDeal2Fields();
        selectFields.add("case when item = 'null' then '' else item end as itemnonull");
        return selectFields;
    }

    private QFilter getTicketsPublishFilter(OlinvitationDetailVO olinvitationDetailVO) {
        QFilter filter = new QFilter("billstatus", "=", (Object)CANCEL);
        filter.and("olinvitateid", "!=", (Object)0);
        if (olinvitationDetailVO.getStartDate() != null) {
            filter.and("createtime", ">=", (Object)olinvitationDetailVO.getStartDate());
        }
        if (olinvitationDetailVO.getEndDate() != null) {
            filter.and("createtime", "<=", (Object)olinvitationDetailVO.getEndDate());
        }
        if (!CollectionUtils.isEmpty((Collection)olinvitationDetailVO.getOlvitation())) {
            filter.and("olinvitateid", "in", (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)olinvitationDetailVO.getOlvitation()));
        }
        if (!CollectionUtils.isEmpty((Collection)olinvitationDetailVO.getStore())) {
            filter.and("branchid", "in", (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)olinvitationDetailVO.getStore()));
        }
        if (!CollectionUtils.isEmpty((Collection)olinvitationDetailVO.getTicketno())) {
            filter.and("entryentity.ticketid", "in", (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)olinvitationDetailVO.getTicketno()));
        }
        if (!CollectionUtils.isEmpty((Collection)olinvitationDetailVO.getTickettype())) {
            filter.and("entryentity.tickettypeid", "in", (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)olinvitationDetailVO.getTickettype()));
        }
        if (StringUtil.isNotNull((String)olinvitationDetailVO.getBillno())) {
            filter.and("billno", "=", (Object)olinvitationDetailVO.getBillno());
        }
        if (StringUtil.isNotNull((String)olinvitationDetailVO.getTicketstatus())) {
            filter.and("entryentity.ticketid.ticketstatus", "=", (Object)olinvitationDetailVO.getTicketstatus());
        }
        if (StringUtil.isNotNull((String)olinvitationDetailVO.getPhone())) {
            filter.and("entryentity.vipid.shortmobile", "=", (Object)olinvitationDetailVO.getPhone());
        }
        return filter;
    }

    private QFilter getSaleOrderFilter(Set<Long> saleBillIds) {
        return new QFilter("Id", "in", saleBillIds);
    }

    private QFilter getSaleOrderTicketFilter(Set<Long> saleBillIds) {
        QFilter qFilter = new QFilter("Id", "in", saleBillIds);
        qFilter.and("finentity.setllementid", "=", (Object)4);
        return qFilter;
    }

    private QFilter getRecycleFilter(Set<Long> recycleBillIdSet) {
        return new QFilter("id", "in", recycleBillIdSet);
    }

    private Set<String> getConsumeBillno() {
        HashSet<String> consumeBillnoSet = new HashSet<String>();
        QFilter qFilter = new QFilter("entryentity.ticketid.ticketstatus", "=", (Object)CANCEL);
        DynamicObjectCollection results = QueryServiceHelper.query((String)"ocgcm_ticketspublish", (String)"entryentity.ticketid.consumebillno", (QFilter[])qFilter.toArray());
        for (DynamicObject result : results) {
            String billno = DynamicObjectUtil.getString((DynamicObject)result, (String)"entryentity.ticketid.consumebillno");
            consumeBillnoSet.add(billno);
        }
        return consumeBillnoSet;
    }

    private Set<String> getRecycleBillno() {
        HashSet<String> consumeBillnoSet = new HashSet<String>();
        QFilter qFilter = new QFilter("entryentity.ticketid.ticketstatus", "=", (Object)RECYCLE);
        DynamicObjectCollection results = QueryServiceHelper.query((String)"ocgcm_ticketspublish", (String)"entryentity.ticketid.recyclebillno", (QFilter[])qFilter.toArray());
        for (DynamicObject result : results) {
            String billno = DynamicObjectUtil.getString((DynamicObject)result, (String)"entryentity.ticketid.recyclebillno");
            consumeBillnoSet.add(billno);
        }
        return consumeBillnoSet;
    }

    private void getBillIds(DataSet publishData, Set<Long> consumeBillIdSet, Set<Long> recycleBillIdSet) {
        for (Row row : publishData) {
            long billId = CommonUtil.formatObejctToLong((Object)row.get("consumebillid"));
            String ticketStatus = CommonUtil.formatStringToEmpty((Object)row.get("ticketstatus"));
            if (StringUtils.equals((CharSequence)ticketStatus, (CharSequence)CANCEL)) {
                consumeBillIdSet.add(billId);
                continue;
            }
            if (!StringUtils.equals((CharSequence)ticketStatus, (CharSequence)RECYCLE)) continue;
            recycleBillIdSet.add(billId);
        }
    }

    private OlinvitationDetailVO getParam(ReportQueryParam reportQueryParam) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        OlinvitationDetailVO olinvitationDetailVO = new OlinvitationDetailVO();
        olinvitationDetailVO.setStartDate(filterInfo.getDate("startdateparam"));
        olinvitationDetailVO.setEndDate(filterInfo.getDate("enddateparam"));
        olinvitationDetailVO.setOlvitation(filterInfo.getDynamicObjectCollection("olvitationparam"));
        olinvitationDetailVO.setStore(filterInfo.getDynamicObjectCollection("storeparam"));
        olinvitationDetailVO.setBillno(filterInfo.getString("billnoparam"));
        olinvitationDetailVO.setTicketno(filterInfo.getDynamicObjectCollection("ticketnoparam"));
        olinvitationDetailVO.setPhone(filterInfo.getString("phoneparam"));
        olinvitationDetailVO.setTickettype(filterInfo.getDynamicObjectCollection("tickettypeparam"));
        olinvitationDetailVO.setTicketstatus(filterInfo.getString("ticketstatusparam"));
        return olinvitationDetailVO;
    }
}

