/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.report.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocpos.common.util.StringUtil;
import kd.occ.ocpos.common.vo.OlinvitationSummaryVO;
import kd.occ.ocpos.report.query.PayCheckReportQuery;

public class OlinvitationSummaryQuery
extends AbstractReportListDataPlugin {
    private static final String RECYCLE = "R";
    private static final String PUBLISH = "P";
    private static final String CANCEL = "C";
    private static final String WAIL = "W";
    private static final Log logger = LogFactory.getLog(PayCheckReportQuery.class);

    public DataSet query(ReportQueryParam queryParam, Object args) {
        try {
            return this.query(queryParam);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
    }

    public DataSet query(ReportQueryParam reportQueryParam) {
        OlinvitationSummaryVO olinvitationSummaryVO = this.getParam(reportQueryParam);
        DataSet resultDateSet = this.getQueryDataset(olinvitationSummaryVO);
        return resultDateSet;
    }

    private DataSet getQueryDataset(OlinvitationSummaryVO olinvitationSummaryVO) {
        DataSet ticketsPublishDataSet = this.getGroupbyDataSet(this.getTicketsPublishFields(), this.getTicketsPublishGroupByFields(), this.getTicketsPublishFilter(olinvitationSummaryVO, null), "ocgcm_ticketspublish").sum("payamount").sum("collectnum").count("peoplenum").finish();
        DataSet ticketsRefundDataSet = this.getGroupbyDataSet(this.getTicketsRefundFields(), this.getTicketsPublishGroupByFields(), this.getTicketsPublishFilter(olinvitationSummaryVO, RECYCLE), "ocgcm_ticketspublish").sum("refundamout").sum("refundticketnum").count("refundnum").finish();
        DataSet ticketsPublishedDataSet = this.getGroupbyDataSet(this.getCommentFields(), this.getTicketsPublishGroupByFields(), this.getTicketsPublishFilter(olinvitationSummaryVO, PUBLISH), "ocgcm_ticketspublish").count("ticketpublishnum").finish();
        DataSet ticketsCancelDataSet = this.getGroupbyDataSet(this.getCommentFields(), this.getTicketsPublishGroupByFields(), this.getTicketsPublishFilter(olinvitationSummaryVO, CANCEL), "ocgcm_ticketspublish").count("ticketcancelnum").finish();
        DataSet ticketsWailDataSet = this.getGroupbyDataSet(this.getCommentFields(), this.getTicketsPublishGroupByFields(), this.getTicketsPublishFilter(olinvitationSummaryVO, WAIL), "ocgcm_ticketspublish").count("waitactivenum").finish();
        DataSet tempDateSet1 = this.joinDataSet(ticketsPublishDataSet, ticketsRefundDataSet, this.getPublishAndRefundGroupByFields());
        DataSet tempDateSet2 = this.joinDataSet(tempDateSet1, ticketsPublishedDataSet, this.getRefundAndPublishedGroupByFields());
        DataSet tempDateSet3 = this.joinDataSet(tempDateSet2, ticketsCancelDataSet, this.getPublishedAndCancelGroupByFields());
        DataSet tempDateSet4 = this.joinDataSet(tempDateSet3, ticketsWailDataSet, this.getPublishedAndWaitGroupByFields());
        return tempDateSet4;
    }

    private GroupbyDataSet getGroupbyDataSet(List<String> selectFields, List<String> selectGroupByFields, QFilter qFilter, String title) {
        DynamicObjectCollection docIds = QueryServiceHelper.query((String)title, (String)"id", (QFilter[])qFilter.toArray());
        Object[] ids = docIds.stream().map(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"id")).toArray();
        QFilter filter = new QFilter("id", "in", (Object)ids);
        GroupbyDataSet groupbyDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)title, (String)String.join((CharSequence)",", selectFields), (QFilter[])filter.toArray(), null).groupBy(selectGroupByFields.toArray(new String[selectGroupByFields.size()]));
        return groupbyDataSet;
    }

    private DataSet joinDataSet(DataSet leftDataSet, DataSet rightDataSet, List<String> selectFields) {
        JoinDataSet tempDataSet = leftDataSet.leftJoin(rightDataSet).on("olvitation", "olvitation").on("store", "store").on("date", "date").on("user", "user");
        DataSet resultDataSet = tempDataSet.select(selectFields.toArray(new String[selectFields.size()])).finish();
        return resultDataSet;
    }

    private List<String> getCommentFields() {
        ArrayList<String> selectFields = new ArrayList<String>();
        selectFields.add("olinvitateid as olvitation");
        selectFields.add("branchid as store");
        selectFields.add("salesmanid as user");
        selectFields.add("TO_CHAR(createtime,'yyyy-MM-dd') as date");
        return selectFields;
    }

    private List<String> getTicketsPublishFields() {
        List<String> selectFields = this.getCommentFields();
        selectFields.add("realamount as payamount");
        selectFields.add("publishqty as collectnum");
        return selectFields;
    }

    private List<String> getTicketsRefundFields() {
        List<String> selectFields = this.getCommentFields();
        selectFields.add("realamount as refundamout");
        selectFields.add("publishqty as refundticketnum");
        return selectFields;
    }

    private List<String> getTicketsPublishGroupByFields() {
        ArrayList<String> selectFields = new ArrayList<String>();
        selectFields.add("olvitation");
        selectFields.add("store");
        selectFields.add("user");
        selectFields.add("date");
        return selectFields;
    }

    private List<String> getPublishAndRefundGroupByFields() {
        List<String> selectFields = this.getTicketsPublishGroupByFields();
        selectFields.add("refundamout");
        selectFields.add("refundticketnum");
        selectFields.add("payamount");
        selectFields.add("collectnum");
        selectFields.add("peoplenum");
        selectFields.add("refundnum");
        return selectFields;
    }

    private List<String> getRefundAndPublishedGroupByFields() {
        List<String> selectFields = this.getPublishAndRefundGroupByFields();
        selectFields.add("ticketpublishnum");
        return selectFields;
    }

    private List<String> getPublishedAndCancelGroupByFields() {
        List<String> selectFields = this.getRefundAndPublishedGroupByFields();
        selectFields.add("ticketcancelnum");
        return selectFields;
    }

    private List<String> getPublishedAndWaitGroupByFields() {
        List<String> selectFields = this.getPublishedAndCancelGroupByFields();
        selectFields.add("waitactivenum");
        return selectFields;
    }

    private QFilter getTicketsPublishFilter(OlinvitationSummaryVO olinvitationSummaryVO, String type) {
        QFilter filter = new QFilter("billstatus", "=", (Object)CANCEL);
        filter.and("olinvitateid", "!=", (Object)0);
        if (olinvitationSummaryVO.getStartDate() != null) {
            filter.and("createtime", ">=", (Object)olinvitationSummaryVO.getStartDate());
        }
        if (olinvitationSummaryVO.getEndDate() != null) {
            filter.and("createtime", "<=", (Object)olinvitationSummaryVO.getEndDate());
        }
        if (!CollectionUtils.isEmpty((Collection)olinvitationSummaryVO.getOlvitation())) {
            filter.and("olinvitateid", "in", (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)olinvitationSummaryVO.getOlvitation()));
        }
        if (!CollectionUtils.isEmpty((Collection)olinvitationSummaryVO.getStore())) {
            filter.and("branchid", "in", (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)olinvitationSummaryVO.getStore()));
        }
        if (!CollectionUtils.isEmpty((Collection)olinvitationSummaryVO.getUser())) {
            filter.and("salesmanid", "in", (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)olinvitationSummaryVO.getUser()));
        }
        if (StringUtil.isNotNull((String)type)) {
            filter.and("entryentity.ticketid.ticketstatus", "=", (Object)type);
        }
        return filter;
    }

    private OlinvitationSummaryVO getParam(ReportQueryParam reportQueryParam) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        OlinvitationSummaryVO olinvitationSummaryVO = new OlinvitationSummaryVO();
        olinvitationSummaryVO.setStartDate(filterInfo.getDate("startdateparam"));
        olinvitationSummaryVO.setEndDate(filterInfo.getDate("enddateparam"));
        olinvitationSummaryVO.setOlvitation(filterInfo.getDynamicObjectCollection("olvitationparam"));
        olinvitationSummaryVO.setStore(filterInfo.getDynamicObjectCollection("storeparam"));
        olinvitationSummaryVO.setUser(filterInfo.getDynamicObjectCollection("userparam"));
        return olinvitationSummaryVO;
    }
}

