/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.report.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.pos.PosUnit;
import kd.occ.ocpos.business.commonhelper.DataSetHelper;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.vo.PayCheckVO;

public class PayCheckReportQuery
extends AbstractReportListDataPlugin {
    private static final String CHANNEL_CLASS = "001";
    private static final String DIRECTION_IN = "in";
    private static final String DIRECTION_OUT = "out";
    private static final Log logger = LogFactory.getLog(PayCheckReportQuery.class);

    public DataSet query(ReportQueryParam queryParam, Object args) throws Throwable {
        try {
            return this.query(queryParam);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
    }

    public DataSet query(ReportQueryParam reportQueryParam) {
        PayCheckVO payCheckVO = this.getParam(reportQueryParam);
        return this.getQueryDataset(payCheckVO);
    }

    private DataSet getQueryDataset(PayCheckVO payCheckVO) {
        String[] groupField = this.getCommonGroupByFields().toArray(new String[0]);
        DataSet posDataset = this.getPosDataset(payCheckVO);
        DataSet paymentDataSet = this.getPaymentDataset(payCheckVO);
        DataSet noBusinessDataSet = this.getNoBusinessDataSet(payCheckVO);
        DataSet receiptDataSet = this.getReceiptDataSet(payCheckVO);
        DataSet adjustDataSet = this.getAdjustDataSet(payCheckVO);
        DataSet s1 = posDataset.select("store,dates,paytype,isneedpay,dateamt,0 as depositamt,0 as beforebalapayamt,0 as beforebalafundamt,0 as refund,0 as nodepositamt");
        DataSet s2 = paymentDataSet.select("store,dates,paytype,isneedpay,0 as dateamt,depositamt,beforebalapayamt,beforebalafundamt,refund,nodepositamt");
        DataSet s3 = s1.union(s2).groupBy(groupField).sum("dateamt").sum("depositamt").sum("beforebalapayamt").sum("beforebalafundamt").sum("refund").sum("nodepositamt").finish();
        DataSet s4 = s3.select("store,dates,paytype,isneedpay,dateamt,depositamt,beforebalapayamt,beforebalafundamt,refund,nodepositamt,0 as nobusinessamt");
        DataSet s5 = noBusinessDataSet.select("store,dates,paytype,isneedpay,0 as dateamt,0 as depositamt,0 as beforebalapayamt,0 as beforebalafundamt,0 as refund,0 as nodepositamt,nobusinessamt");
        DataSet s6 = s4.union(s5).groupBy(groupField).sum("dateamt").sum("depositamt").sum("beforebalapayamt").sum("beforebalafundamt").sum("refund").sum("nodepositamt").sum("nobusinessamt").finish();
        DataSet s7 = s6.select("store,dates,paytype,isneedpay,dateamt,depositamt,beforebalapayamt,beforebalafundamt,refund,nodepositamt,nobusinessamt,0 as receiptamt,0 as serviceamt, 0 as countserviceamt, 0 as shouldreturnamount, 0 as beforebalanceamount");
        DataSet s8 = receiptDataSet.select("store,dates,paytype,isneedpay,0 as dateamt,0 as depositamt,0 as beforebalapayamt,0 as beforebalafundamt,0 as refund,0 as nodepositamt,0 as nobusinessamt,receiptamt,serviceamt,countserviceamt,shouldreturnamount,beforebalanceamount");
        DataSet s9 = s7.union(s8).groupBy(groupField).sum("dateamt").sum("depositamt").sum("beforebalapayamt").sum("beforebalafundamt").sum("refund").sum("nodepositamt").sum("nobusinessamt").sum("receiptamt").sum("serviceamt").sum("countserviceamt").sum("shouldreturnamount").sum("beforebalanceamount").finish();
        DataSet s10 = s9.select("store,dates,paytype,isneedpay,dateamt,depositamt,beforebalapayamt,beforebalafundamt,refund,nodepositamt,nobusinessamt,receiptamt,serviceamt,countserviceamt,shouldreturnamount,beforebalanceamount,0 as adjustamt");
        DataSet s11 = adjustDataSet.select("store,dates,paytype,isneedpay,0 as dateamt,0 as depositamt,0 as beforebalapayamt,0 as beforebalafundamt,0 as refund,0 as nodepositamt,0 as nobusinessamt,0 as receiptamt,0 as serviceamt, 0 as countserviceamt, 0 as shouldreturnamount, 0 as beforebalanceamount,adjustamt");
        DataSet s12 = s10.union(s11).groupBy(groupField).sum("dateamt").sum("depositamt").sum("beforebalapayamt").sum("beforebalafundamt").sum("refund").sum("nodepositamt").sum("nobusinessamt").sum("receiptamt").sum("serviceamt").sum("countserviceamt").sum("shouldreturnamount").sum("beforebalanceamount").sum("adjustamt").finish();
        Set dataSetField = DataSetHelper.getDataSetField((DataSet)s12);
        dataSetField.add("case when isneedpay = true then beforebalapayamt when isneedpay = false then beforebalanceamount else 0 end as beforeretainamt");
        dataSetField.add("case when isneedpay = true then refund when isneedpay = false then shouldreturnamount else 0 end as refundcustomeramt");
        DataSet select1 = s12.select(String.join((CharSequence)",", dataSetField));
        DataSet select2 = select1.select(String.join((CharSequence)",", this.countField(select1)));
        GroupbyDataSet groupbyDataSet = select2.groupBy("store,dates,paytype".split(","));
        Set field = DataSetHelper.getDataSetField((DataSet)select2);
        field.remove("store");
        field.remove("dates");
        field.remove("paytype");
        field.remove("isneedpay");
        field.forEach(arg_0 -> ((GroupbyDataSet)groupbyDataSet).sum(arg_0));
        DataSet dataSet = groupbyDataSet.finish();
        if (!payCheckVO.isZore()) {
            dataSet = dataSet.where("dateamt <> 0");
        }
        if (payCheckVO.isShowDiff()) {
            dataSet = dataSet.where("todaybalapayamt <> 0");
        }
        Set dataSetField1 = DataSetHelper.getDataSetField((DataSet)dataSet);
        dataSetField1.add("to_date(dates,'yyyy-MM-dd') as date");
        return dataSet.select(String.join((CharSequence)",", dataSetField1)).orderBy(new String[]{"date desc"});
    }

    private DataSet getAdjustDataSet(PayCheckVO payCheckVO) {
        List<String> adjustOutFields = this.getAdjustFields(DIRECTION_OUT);
        List<String> adjustOutGroupByFields = this.getCommonGroupByFields();
        QFilter outFilter = this.getAdjustFilter(payCheckVO, DIRECTION_OUT);
        DataSet adjustOutDataSet = this.getGroupByDataSet(adjustOutFields, adjustOutGroupByFields, outFilter, "ocpos_adjustment").sum("adjustamt").finish();
        List<String> adjustInFields = this.getAdjustFields(DIRECTION_IN);
        List<String> adjustInGroupByFields = this.getCommonGroupByFields();
        QFilter inFilter = this.getAdjustFilter(payCheckVO, DIRECTION_IN);
        DataSet adjustInDataSet = this.getGroupByDataSet(adjustInFields, adjustInGroupByFields, inFilter, "ocpos_adjustment").sum("adjustamt").finish();
        return adjustOutDataSet.union(adjustInDataSet).groupBy(this.getCommonGroupByFields().toArray(new String[0])).sum("adjustamt").finish();
    }

    private DataSet getReceiptDataSet(PayCheckVO payCheckVO) {
        List<String> receiptFields = this.getReceiptFields();
        List<String> receiptGroupByFields = this.getCommonGroupByFields();
        QFilter receiptFilter = this.getReceiptFilter(payCheckVO);
        return this.getGroupByDataSet(receiptFields, receiptGroupByFields, receiptFilter, "ocpos_receipt").sum("receiptamt").sum("serviceamt").sum("countserviceamt").sum("shouldreturnamount").sum("beforebalanceamount").finish();
    }

    private DataSet getNoBusinessDataSet(PayCheckVO payCheckVO) {
        List<String> noBusinessFields = this.getNoBusinessFields();
        List<String> noBusinessGroupByFields = this.getCommonGroupByFields();
        QFilter noBusinessFilter = this.getNoBusinessFilter(payCheckVO);
        return this.getGroupByDataSet(noBusinessFields, noBusinessGroupByFields, noBusinessFilter, "ocpos_nobusiness").sum("nobusinessamt").finish();
    }

    private DataSet getPaymentDataset(PayCheckVO payCheckVO) {
        List<String> paymentFields = this.getPaymentFields();
        List<String> paymentGroupByFields = this.getCommonGroupByFields();
        QFilter paymentFilter = this.getPaymentFilter(payCheckVO);
        return this.getGroupByDataSet(paymentFields, paymentGroupByFields, paymentFilter, "ocpos_payment").sum("depositamt").sum("beforebalapayamt").sum("beforebalafundamt").sum("refund").sum("nodepositamt").finish();
    }

    private DataSet getPosDataset(PayCheckVO payCheckVO) {
        DataSet union;
        boolean isCredit;
        QFilter posFilter = this.getPosFilter(payCheckVO);
        DataSet dataSet1 = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocpos_saleorder", (String)String.join((CharSequence)",", this.getPosField()), (QFilter[])posFilter.toArray(), null).where("paytype<>0");
        DataSet dataSet2 = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocpos_saleorder_final", (String)String.join((CharSequence)",", this.getPosField()), (QFilter[])posFilter.toArray(), null);
        DataSet dataSet3 = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocpos_saleorder_return", (String)String.join((CharSequence)",", this.getPosField()), (QFilter[])posFilter.toArray(), null).where("paytype<>0");
        List idList = DynamicObjectUtils.getIdList((DynamicObjectCollection)payCheckVO.getPaytype());
        boolean bl = isCredit = CollectionUtils.isEmpty((Collection)idList) || idList.contains(960800837901388800L);
        if (isCredit) {
            DataSet creditDataSet = this.getCreditDataSet(payCheckVO);
            union = dataSet1.union(dataSet2).union(dataSet3).union(creditDataSet);
        } else {
            union = dataSet1.union(dataSet2).union(dataSet3);
        }
        return union.groupBy(this.getCommonGroupByFields().toArray(new String[0])).sum("dateamt").finish();
    }

    private DataSet getCreditDataSet(PayCheckVO payCheckVO) {
        QFilter qFilter = new QFilter("number", "=", (Object)"ToSettleAccountsType");
        DynamicObject query = QueryServiceHelper.queryOne((String)"ocdbd_paywaytype", (String)"isneedpay", (QFilter[])qFilter.toArray());
        QFilter filter = this.getCreditFilter(payCheckVO);
        DataSet creditDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocpos_saleorder_final", (String)String.join((CharSequence)",", this.getCreditField()), (QFilter[])filter.toArray(), null);
        DataSet receivableDataset = creditDataSet.groupBy("store,dates".split(",")).sum("receivableamount").finish();
        return receivableDataset.select("store,dates,960800837901388800 as paytype," + query.get("isneedpay") + " as isneedpay,receivableamount * -1 as dateamt");
    }

    private GroupbyDataSet getGroupByDataSet(List<String> selectFields, List<String> selectGroupByFields, QFilter qFilter, String title) {
        return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)title, (String)String.join((CharSequence)",", selectFields), (QFilter[])qFilter.toArray(), null).groupBy(selectGroupByFields.toArray(new String[0]));
    }

    private DataSet dealDataSet(DataSet leftDataSet, DataSet rightDataSet, PayCheckVO payCheckVO, List<String> selectFields) {
        JoinDataSet tempDataSet = leftDataSet.fullJoin(rightDataSet).on("store", "store").on("date", "date").on("paytype", "paytype").on("isneedpay", "isneedpay");
        return tempDataSet.select(selectFields.toArray(new String[0])).finish();
    }

    private List<String> nullFilterList() {
        ArrayList<String> selectFields = new ArrayList<String>();
        selectFields.add("store is not null");
        return selectFields;
    }

    private List<String> getCommonGroupByFields() {
        ArrayList<String> selectFields = new ArrayList<String>();
        selectFields.add("store");
        selectFields.add("dates");
        selectFields.add("paytype");
        selectFields.add("isneedpay");
        return selectFields;
    }

    private Set<String> countField(DataSet dataSet) {
        Set selectFieldSet = DataSetHelper.getDataSetField((DataSet)dataSet);
        selectFieldSet.add("serviceamt - countserviceamt as servicediff");
        selectFieldSet.add("beforeretainamt + dateamt + nobusinessamt - receiptamt - serviceamt as retainagediff");
        selectFieldSet.add("depositamt + nodepositamt + beforebalafundamt + receiptamt as alldepositamt");
        selectFieldSet.add("beforeretainamt + dateamt - beforebalafundamt - depositamt- receiptamt - serviceamt + adjustamt as saledepositdiff");
        selectFieldSet.add("nobusinessamt - nodepositamt as noreceiptdiff");
        selectFieldSet.add("dateamt - receiptamt - serviceamt as receiptdiff");
        selectFieldSet.add("beforeretainamt + dateamt + nobusinessamt - beforebalafundamt - depositamt - nodepositamt - receiptamt - serviceamt - refundcustomeramt + adjustamt as todaybalapayamt");
        selectFieldSet.add("dateamt + adjustamt - depositamt - receiptamt as countsaledepositdiss");
        return selectFieldSet;
    }

    private List<String> getAdjustFields(String direction) {
        ArrayList<String> selectFields = new ArrayList<String>();
        selectFields.add("adjustentry.store as store");
        selectFields.add("to_char(adjustentry.adjustdate,'yyyy-MM-dd') as dates");
        if (DIRECTION_IN.equals(direction)) {
            selectFields.add("adjustentry.outamount as adjustamt");
            selectFields.add("adjustentry.inpaytype as paytype");
            selectFields.add("adjustentry.inpaytype.isneedpay as isneedpay");
        }
        if (DIRECTION_OUT.equals(direction)) {
            selectFields.add("adjustentry.outamount * -1 as adjustamt");
            selectFields.add("adjustentry.outpaytype as paytype");
            selectFields.add("adjustentry.outpaytype.isneedpay as isneedpay");
        }
        return selectFields;
    }

    private List<String> getReceiptFields() {
        ArrayList<String> selectFields = new ArrayList<String>();
        selectFields.add("receiptentry.store as store");
        selectFields.add("to_char(receiptentry.receiptdate,'yyyy-MM-dd') as dates");
        selectFields.add("receiptentry.paytype as paytype");
        selectFields.add("receiptentry.paytype.isneedpay as isneedpay");
        selectFields.add("receiptentry.receiptamount as receiptamt");
        selectFields.add("receiptentry.serviceamount as serviceamt");
        selectFields.add("receiptentry.countserviceamt as countserviceamt");
        selectFields.add("receiptentry.shouldreturnamount as shouldreturnamount");
        selectFields.add("receiptentry.beforebalanceamount as beforebalanceamount");
        return selectFields;
    }

    private List<String> getPaymentFields() {
        ArrayList<String> selectFields = new ArrayList<String>();
        selectFields.add("paystore as store");
        selectFields.add("to_char(paymententry.paymentdate,'yyyy-MM-dd') as dates");
        selectFields.add("paymententry.paytype as paytype");
        selectFields.add("paymententry.paytype.isneedpay as isneedpay");
        selectFields.add("paymententry.curbizfundamt as depositamt");
        selectFields.add("paymententry.curbiznofundamt as nodepositamt");
        selectFields.add("paymententry.beforebalafundamt as beforebalafundamt");
        selectFields.add("paymententry.beforebalapayamt as beforebalapayamt");
        selectFields.add("paymententry.refundcustomeramt as refund");
        return selectFields;
    }

    private List<String> getPosField() {
        ArrayList<String> selectFields = new ArrayList<String>();
        selectFields.add("salebranchid as store");
        selectFields.add("to_char(finentity.paytime,'yyyy-MM-dd') as dates");
        selectFields.add("finentity.paywaytypeid as paytype");
        selectFields.add("finentity.paywaytypeid.isneedpay as isneedpay");
        selectFields.add("finentity.settleamount as dateamt");
        return selectFields;
    }

    private List<String> getCreditField() {
        ArrayList<String> selectFields = new ArrayList<String>();
        selectFields.add("salebranchid as store");
        selectFields.add("to_char(bizdate,'yyyy-MM-dd') as dates");
        selectFields.add("receivableamount");
        return selectFields;
    }

    private List<String> getNoBusinessFields() {
        ArrayList<String> selectFields = new ArrayList<String>();
        selectFields.add("branch as store");
        selectFields.add("to_char(bizdate,'yyyy-MM-dd') as dates");
        selectFields.add("nobusinessentry.paytype as paytype");
        selectFields.add("nobusinessentry.paytype.isneedpay as isneedpay");
        selectFields.add("nobusinessentry.payamount as nobusinessamt");
        return selectFields;
    }

    private QFilter getAdjustFilter(PayCheckVO payCheckVO, String direction) {
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        if (payCheckVO.getStartDate() != null) {
            filter.and("adjustentry.adjustdate", ">=", (Object)payCheckVO.getStartDate());
        }
        if (payCheckVO.getStartDate() != null) {
            filter.and("adjustentry.adjustdate", "<=", (Object)payCheckVO.getEndDate());
        }
        if (!CollectionUtils.isEmpty((Collection)payCheckVO.getStore())) {
            filter.and("adjustentry.store", DIRECTION_IN, (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)payCheckVO.getStore()));
        }
        if (!CollectionUtils.isEmpty((Collection)payCheckVO.getStoreclass())) {
            filter.and("adjustentry.store.channelclassentity.channelclass", DIRECTION_IN, (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)payCheckVO.getStoreclass()));
            filter.and("adjustentry.store.channelclassentity.classstandard.number", "=", (Object)CHANNEL_CLASS);
        }
        if (!CollectionUtils.isEmpty((Collection)payCheckVO.getStoretype())) {
            filter.and("adjustentry.store.channeltype", DIRECTION_IN, (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)payCheckVO.getStoretype()));
        }
        if (!CollectionUtils.isEmpty((Collection)payCheckVO.getPaytype())) {
            if (DIRECTION_IN.equals(direction)) {
                filter.and("adjustentry.inpaytype", DIRECTION_IN, (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)payCheckVO.getPaytype()));
            } else {
                filter.and("adjustentry.outpaytype", DIRECTION_IN, (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)payCheckVO.getPaytype()));
            }
        }
        return filter;
    }

    private QFilter getReceiptFilter(PayCheckVO payCheckVO) {
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        if (payCheckVO.getStartDate() != null) {
            filter.and("receiptentry.receiptdate", ">=", (Object)payCheckVO.getStartDate());
        }
        if (payCheckVO.getStartDate() != null) {
            filter.and("receiptentry.receiptdate", "<=", (Object)payCheckVO.getEndDate());
        }
        if (!CollectionUtils.isEmpty((Collection)payCheckVO.getStore())) {
            filter.and("receiptentry.store", DIRECTION_IN, (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)payCheckVO.getStore()));
        }
        if (!CollectionUtils.isEmpty((Collection)payCheckVO.getStoreclass())) {
            filter.and("receiptentry.store.channelclassentity.channelclass", DIRECTION_IN, (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)payCheckVO.getStoreclass()));
            filter.and("receiptentry.store.channelclassentity.classstandard.number", "=", (Object)CHANNEL_CLASS);
        }
        if (!CollectionUtils.isEmpty((Collection)payCheckVO.getStoretype())) {
            filter.and("receiptentry.store.channeltype", DIRECTION_IN, (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)payCheckVO.getStoretype()));
        }
        if (!CollectionUtils.isEmpty((Collection)payCheckVO.getPaytype())) {
            filter.and("receiptentry.paytype", DIRECTION_IN, (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)payCheckVO.getPaytype()));
        }
        return filter;
    }

    private QFilter getNoBusinessFilter(PayCheckVO payCheckVO) {
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        if (payCheckVO.getStartDate() != null) {
            filter.and("bizdate", ">=", (Object)payCheckVO.getStartDate());
        }
        if (payCheckVO.getStartDate() != null) {
            filter.and("bizdate", "<=", (Object)payCheckVO.getEndDate());
        }
        if (!CollectionUtils.isEmpty((Collection)payCheckVO.getStore())) {
            filter.and("branch", DIRECTION_IN, (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)payCheckVO.getStore()));
        }
        if (!CollectionUtils.isEmpty((Collection)payCheckVO.getStoreclass())) {
            filter.and("branch.channelclassentity.channelclass", DIRECTION_IN, (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)payCheckVO.getStoreclass()));
            filter.and("branch.channelclassentity.classstandard.number", "=", (Object)CHANNEL_CLASS);
        }
        if (!CollectionUtils.isEmpty((Collection)payCheckVO.getStoretype())) {
            filter.and("branch.channeltype", DIRECTION_IN, (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)payCheckVO.getStoretype()));
        }
        if (!CollectionUtils.isEmpty((Collection)payCheckVO.getPaytype())) {
            filter.and("nobusinessentry.paytype", DIRECTION_IN, (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)payCheckVO.getPaytype()));
        }
        return filter;
    }

    private QFilter getPaymentFilter(PayCheckVO payCheckVO) {
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        if (payCheckVO.getStartDate() != null) {
            filter.and("paymententry.paymentdate", ">=", (Object)payCheckVO.getStartDate());
        }
        if (payCheckVO.getStartDate() != null) {
            filter.and("paymententry.paymentdate", "<=", (Object)payCheckVO.getEndDate());
        }
        if (!CollectionUtils.isEmpty((Collection)payCheckVO.getStore())) {
            filter.and("paystore", DIRECTION_IN, (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)payCheckVO.getStore()));
        }
        if (!CollectionUtils.isEmpty((Collection)payCheckVO.getStoreclass())) {
            filter.and("paystore.channelclassentity.channelclass", DIRECTION_IN, (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)payCheckVO.getStoreclass()));
            filter.and("paystore.channelclassentity.classstandard.number", "=", (Object)CHANNEL_CLASS);
        }
        if (!CollectionUtils.isEmpty((Collection)payCheckVO.getStoretype())) {
            filter.and("paystore.channeltype", DIRECTION_IN, (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)payCheckVO.getStoretype()));
        }
        if (!CollectionUtils.isEmpty((Collection)payCheckVO.getPaytype())) {
            filter.and("paymententry.paytype", DIRECTION_IN, (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)payCheckVO.getPaytype()));
        }
        return filter;
    }

    private QFilter getPosFilter(PayCheckVO payCheckVO) {
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        filter.and("salestatus", "=", (Object)"S");
        filter.and("finentity.paytime", ">=", (Object)payCheckVO.getStartDate());
        filter.and("finentity.paytime", "<=", (Object)PosUnit.getDayAfter((Date)payCheckVO.getEndDate()));
        filter.and("salebranchid", DIRECTION_IN, (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)payCheckVO.getStore()));
        if (!CollectionUtils.isEmpty((Collection)payCheckVO.getStoreclass())) {
            filter.and("salebranchid.channelclassentity.channelclass", DIRECTION_IN, (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)payCheckVO.getStoreclass()));
            filter.and("salebranchid.channelclassentity.classstandard.number", "=", (Object)CHANNEL_CLASS);
        }
        if (!CollectionUtils.isEmpty((Collection)payCheckVO.getStoretype())) {
            filter.and("salebranchid.channeltype", DIRECTION_IN, (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)payCheckVO.getStoretype()));
        }
        if (!CollectionUtils.isEmpty((Collection)payCheckVO.getPaytype())) {
            filter.and("finentity.paywaytypeid", DIRECTION_IN, (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)payCheckVO.getPaytype()));
        }
        return filter;
    }

    private QFilter getCreditFilter(PayCheckVO payCheckVO) {
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        filter.and("salestatus", "=", (Object)"S");
        if (payCheckVO.getStartDate() != null) {
            filter.and("bizdate", ">=", (Object)payCheckVO.getStartDate());
        }
        if (payCheckVO.getStartDate() != null) {
            filter.and("bizdate", "<=", (Object)payCheckVO.getEndDate());
        }
        if (!CollectionUtils.isEmpty((Collection)payCheckVO.getStore())) {
            filter.and("salebranchid", DIRECTION_IN, (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)payCheckVO.getStore()));
        }
        if (!CollectionUtils.isEmpty((Collection)payCheckVO.getStoreclass())) {
            filter.and("salebranchid.channelclassentity.channelclass", DIRECTION_IN, (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)payCheckVO.getStoreclass()));
            filter.and("salebranchid.channelclassentity.classstandard.number", "=", (Object)CHANNEL_CLASS);
        }
        if (!CollectionUtils.isEmpty((Collection)payCheckVO.getStoretype())) {
            filter.and("salebranchid.channeltype", DIRECTION_IN, (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)payCheckVO.getStoretype()));
        }
        filter.and("basebilltype", "=", (Object)BillTypeEnum.CREDIT.getId());
        return filter;
    }

    private PayCheckVO getParam(ReportQueryParam reportQueryParam) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        PayCheckVO payCheck = new PayCheckVO();
        payCheck.setStartDate(filterInfo.getDate("startdateparam"));
        payCheck.setEndDate(filterInfo.getDate("enddateparam"));
        payCheck.setStore(filterInfo.getDynamicObjectCollection("storeparam"));
        payCheck.setStoreclass(filterInfo.getDynamicObjectCollection("storeclassparam"));
        payCheck.setStoretype(filterInfo.getDynamicObjectCollection("storetypeparam"));
        payCheck.setPaytype(filterInfo.getDynamicObjectCollection("paytypeparam"));
        payCheck.setZore(filterInfo.getBoolean("iszoreparam"));
        payCheck.setShowDiff(filterInfo.getBoolean("isshowdiffparam"));
        return payCheck;
    }
}

