/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.report.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocpos.common.vo.PosQueryParam;

public class SalerReportQuery
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(SalerReportQuery.class);

    public DataSet query(ReportQueryParam queryParam, Object args) throws Throwable {
        try {
            return this.query(queryParam);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
    }

    public DataSet query(ReportQueryParam reportQueryParam) {
        PosQueryParam posQueryParam = this.getParam(reportQueryParam);
        QFilter queryFilter = this.getQueryFilter(posQueryParam);
        return this.getQueryDataset(reportQueryParam, queryFilter);
    }

    private QFilter getQueryFilter(PosQueryParam posQueryParam) {
        QFilter filter1 = new QFilter("billstatus", "=", (Object)"C");
        filter1.and("salestatus", "!=", (Object)"A");
        filter1.and("bizdate", ">=", (Object)posQueryParam.getStartDate());
        filter1.and("bizdate", "<=", (Object)posQueryParam.getEndDate());
        if (posQueryParam.getCurrency() != null) {
            filter1.and("locurrencyid", "=", posQueryParam.getCurrency().getPkValue());
        }
        if (!CollectionUtils.isEmpty((Collection)posQueryParam.getBranch())) {
            filter1.and("salebranchid", "in", (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)posQueryParam.getBranch()));
        }
        if (!CollectionUtils.isEmpty((Collection)posQueryParam.getSaler())) {
            filter1.and("saler", "in", (Object)DynamicObjectUtils.getIdList((DynamicObjectCollection)posQueryParam.getSaler()));
        }
        filter1.and("basebilltype", "!=", (Object)1041368841512679424L);
        filter1.and("goodsentryentity.ispresent", "=", (Object)Boolean.FALSE);
        QFilter filter2 = new QFilter("basebilltype", "=", (Object)1041367443022673920L);
        filter2.and("notconfirm", "=", (Object)Boolean.FALSE);
        QFilter filter3 = new QFilter("basebilltype", "!=", (Object)1041367443022673920L);
        return filter1.and(filter2.or(filter3));
    }

    private DataSet getSaleTypeFilterSet(DataSet preDataSet, ReportQueryParam reportQueryParam) {
        FilterInfo filterinfo = reportQueryParam.getFilter();
        String saleTypeId = filterinfo.getString("saletypeid");
        if (StringUtils.isEmpty((Object)saleTypeId)) {
            return preDataSet;
        }
        String[] saleType = saleTypeId.split(",");
        List selectedSaleType = Arrays.stream(saleType).filter(s -> !"".equals(s)).collect(Collectors.toList());
        HashMap params = new HashMap(16);
        params.put("selectedSaleType", selectedSaleType);
        return preDataSet.filter("saletype in selectedSaleType", params);
    }

    private DataSet getQueryDataset(ReportQueryParam reportQueryParam, QFilter queryFilter) {
        DataSet unionSet = this.getUnionSet(reportQueryParam, queryFilter);
        DataSet saleQtyDataset = this.getSaleQtyDataset(reportQueryParam, queryFilter);
        DataSet returnQtyDataset = this.getReturnQtyDataset(reportQueryParam, queryFilter);
        JoinDataSet saleJoinDataSet = unionSet.fullJoin(saleQtyDataset).on("orgid", "orgid").on("saledate", "saledate").on("branchid", "branchid").on("saler", "saler").on("saletype", "saletype");
        List<String> unionSetField = this.getUnionSetField();
        DataSet saleResultDataset = saleJoinDataSet.select(unionSetField.toArray(new String[0]), new String[]{"saleqty"}).finish();
        JoinDataSet returnJoinDataSet = saleResultDataset.fullJoin(returnQtyDataset).on("orgid", "orgid").on("saledate", "saledate").on("branchid", "branchid").on("saler", "saler").on("saletype", "saletype");
        unionSetField.add("saleqty");
        DataSet resultDataset = returnJoinDataSet.select(unionSetField.toArray(new String[0]), new String[]{"returnqty"}).finish();
        return resultDataset.select(String.join((CharSequence)",", this.getReportSelectField()));
    }

    private List<String> getUnionSetField() {
        List<String> commonGroupbyField = this.getCommonGroupbyField();
        commonGroupbyField.addAll(this.getSalerSumField());
        return commonGroupbyField;
    }

    private DataSet getSaleQtyDataset(ReportQueryParam reportQueryParam, QFilter queryFilter) {
        List<String> commonQueryFields = this.getCommonQueryFields();
        commonQueryFields.add("billno");
        DataSet saleOrder = this.getSaleOrderDataSet(queryFilter, "ocpos_saleorder", String.join((CharSequence)",", commonQueryFields));
        DataSet saleOrderDataset = saleOrder.select(String.join((CharSequence)",", this.getSaleOrderPreSelectFields()));
        DataSet salerOrderFilterSet = this.getSaleTypeFilterSet(saleOrderDataset, reportQueryParam);
        List<String> billnoGroupbyField = this.getCommonGroupbyField();
        billnoGroupbyField.add("billno");
        DataSet saleOrderGroupBydataset = salerOrderFilterSet.groupBy(billnoGroupbyField.toArray(new String[0])).finish();
        List<String> commonGroupbyField = this.getCommonGroupbyField();
        return saleOrderGroupBydataset.groupBy(commonGroupbyField.toArray(new String[0])).count("saleqty").finish();
    }

    private DataSet getReturnQtyDataset(ReportQueryParam reportQueryParam, QFilter queryFilter) {
        List<String> commonQueryFields = this.getCommonQueryFields();
        commonQueryFields.add("billno");
        DataSet returnOrder = this.getSaleOrderDataSet(queryFilter, "ocpos_saleorder_return", String.join((CharSequence)",", commonQueryFields));
        List<String> billnoGroupbyField = this.getCommonGroupbyField();
        billnoGroupbyField.add("billno");
        DataSet returnOrderDataset = returnOrder.select(String.join((CharSequence)",", this.getReturnOrderPreSelectFields()));
        DataSet returnOrderFilterSet = this.getSaleTypeFilterSet(returnOrderDataset, reportQueryParam);
        DataSet returnOrderGroupBydataset = returnOrderFilterSet.groupBy(billnoGroupbyField.toArray(new String[0])).finish();
        List<String> commonGroupbyField = this.getCommonGroupbyField();
        return returnOrderGroupBydataset.groupBy(commonGroupbyField.toArray(new String[0])).count("returnqty").finish();
    }

    private DataSet getUnionSet(ReportQueryParam reportQueryParam, QFilter queryFilter) {
        DataSet unionDataset = this.getUnionDataset(queryFilter, this.getQueryField());
        DataSet preDataSet = unionDataset.select(String.join((CharSequence)",", this.getPreSelectField()));
        DataSet unionFilterDataset = this.getSaleTypeFilterSet(preDataSet, reportQueryParam);
        List<String> commonGroupbyField = this.getCommonGroupbyField();
        GroupbyDataSet groupbyDataSet = unionFilterDataset.groupBy(commonGroupbyField.toArray(new String[0]));
        this.sumGroupDataset(groupbyDataSet, this.getSalerSumField());
        return groupbyDataSet.finish();
    }

    private void sumGroupDataset(GroupbyDataSet groupbyDataSet, List<String> sumFields) {
        sumFields.forEach(arg_0 -> ((GroupbyDataSet)groupbyDataSet).sum(arg_0));
    }

    protected List<String> getCommonGroupbyField() {
        List<String> commonGroupbyField = this.getCommonField();
        commonGroupbyField.add("saletype");
        return commonGroupbyField;
    }

    private DataSet getUnionDataset(QFilter queryFilters, String queryField) {
        DataSet saleOrder = this.getSaleOrderDataSet(queryFilters, "ocpos_saleorder", queryField);
        DataSet returnOrder = this.getSaleOrderDataSet(queryFilters, "ocpos_saleorder_return", queryField);
        return saleOrder.union(returnOrder);
    }

    private DataSet getSaleOrderDataSet(QFilter queryFilters, String entityName, String queryFields) {
        return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entityName, (String)queryFields, (QFilter[])queryFilters.toArray(), null);
    }

    protected List<String> getCommonField() {
        ArrayList<String> commonField = new ArrayList<String>();
        commonField.add("orgid");
        commonField.add("saledate");
        commonField.add("branchid");
        commonField.add("saler");
        return commonField;
    }

    private String getQueryField() {
        List<String> queryFields = this.getCommonQueryFields();
        queryFields.add("goodsentryentity.balamount as balamount");
        queryFields.add("goodsentryentity.saleqty as saleqty");
        queryFields.add("goodsentryentity.linereceivableamount as linereceivableamount");
        queryFields.add("goodsentryentity.receivedfinalpayment as receivedfinalpayment");
        queryFields.add("goodsentryentity.receexpectfinalamount as receexpectfinalamount");
        return String.join((CharSequence)",", queryFields);
    }

    private List<String> getCommonQueryFields() {
        ArrayList<String> queryFields = new ArrayList<String>();
        queryFields.add("bizorgid as orgid");
        queryFields.add("bizdate as saledate");
        queryFields.add("salebranchid as branchid");
        queryFields.add("saler");
        queryFields.add("basebilltype");
        queryFields.add("goodsentryentity.isbook as isbook");
        queryFields.add("ordersource");
        return queryFields;
    }

    private List<String> getSalerSumField() {
        ArrayList<String> sumFields = new ArrayList<String>(0);
        sumFields.add("recieveamount");
        sumFields.add("lssx");
        sumFields.add("ydsx");
        sumFields.add("qdsx");
        sumFields.add("xssx");
        sumFields.add("lsth");
        sumFields.add("ydth");
        sumFields.add("xsth");
        sumFields.add("lstk");
        sumFields.add("ydtk");
        sumFields.add("xstk");
        sumFields.add("lsitemqty");
        sumFields.add("yditemqty");
        sumFields.add("qditemqty");
        sumFields.add("xsitemqty");
        sumFields.add("lsthitemqty");
        sumFields.add("ydthitemqty");
        sumFields.add("xsthitemqty");
        return sumFields;
    }

    private List<String> getReportSelectField() {
        List<String> selectFields = this.getCommonField();
        selectFields.add("saletype");
        selectFields.add("returnqty");
        selectFields.add("saleqty");
        selectFields.add("recieveamount");
        selectFields.add("case when saletype='A' then lssx when saletype='B' then ydsx when saletype='C' then qdsx when saletype='D' then xssx else 0 end as payamount");
        selectFields.add("case when saletype='A' then lsth when saletype='B' then ydth when saletype='D' then xsth else 0 end as returnamount");
        selectFields.add("case when saletype='A' then lstk when saletype='B' then ydtk when saletype='D' then xstk else 0 end as refundamount");
        selectFields.add("case when saletype='A' then lsitemqty when saletype='B' then yditemqty when saletype='C' then qditemqty when saletype='D' then xsitemqty else 0 end as itemqty");
        selectFields.add("case when saletype='A' then lsthitemqty when saletype='B' then ydthitemqty when saletype='D' then xsthitemqty else 0 end as returnitemqty");
        return selectFields;
    }

    private List<String> getPreSelectField() {
        List<String> preSelectFields = this.getCommonField();
        preSelectFields.add("basebilltype");
        preSelectFields.add("case when basebilltype in(1041360915058186240,1041368594703054848,1041368311738529792,1041370880296744960) AND isbook = false and ordersource not in('D','E') then 'A' when basebilltype in(1041360915058186240,1041368594703054848,1041368311738529792,1041367443022673920,1041370880296744960) AND isbook = true and ordersource not in('D','E') then 'B' when basebilltype in(1041368005805996032) and ordersource not in('D','E') then 'C' when ordersource  in('D','E') then 'D' else null end as saletype");
        preSelectFields.add("case when basebilltype in(1041360915058186240,1041368594703054848,1041368311738529792) AND isbook = false and ordersource not in('D','E') then (linereceivableamount + receivedfinalpayment) when basebilltype in(1041360915058186240,1041368594703054848,1041368311738529792,1041367443022673920) AND isbook = true and ordersource not in('D','E') then (linereceivableamount + receexpectfinalamount) when basebilltype in(1041368005805996032) and ordersource not in('D','E') then linereceivableamount when basebilltype in(1041360915058186240,1041368594703054848,1041368311738529792) AND isbook = false and ordersource in('D','E') then (linereceivableamount + receivedfinalpayment)else 0 end as recieveamount");
        preSelectFields.add("case when basebilltype in(1041360915058186240,1041368594703054848,1041368311738529792) AND isbook = false and ordersource not in('D','E') then balamount else 0 end as lssx");
        preSelectFields.add("case when basebilltype in(1041360915058186240,1041368594703054848,1041368311738529792,1041367443022673920) AND isbook = true and ordersource not in('D','E') then balamount else 0 end as ydsx");
        preSelectFields.add("case when basebilltype in(1041368005805996032) and ordersource not in('D','E') then balamount else 0 end as qdsx");
        preSelectFields.add("case when basebilltype in(1041360915058186240,1041368594703054848,1041368311738529792) AND isbook = false and ordersource in('D','E') then balamount else 0 end as xssx");
        preSelectFields.add("case when basebilltype in(1041370880296744960) AND isbook = false and ordersource not in('D','E') then balamount else 0 end as lsth");
        preSelectFields.add("case when basebilltype in(1041370880296744960) AND isbook = true and ordersource not in('D','E') then balamount else 0 end as ydth");
        preSelectFields.add("case when basebilltype in(1041370880296744960) AND isbook = false and ordersource in('D','E') then balamount else 0 end as xsth");
        preSelectFields.add("case when basebilltype in(1041370880296744960) AND isbook = false and ordersource not in('D','E') then linereceivableamount else 0 end as lstk");
        preSelectFields.add("case when basebilltype in(1041370880296744960) AND isbook = true and ordersource not in('D','E') then linereceivableamount else 0 end as ydtk");
        preSelectFields.add("case when basebilltype in(1041370880296744960) AND isbook = false and ordersource in('D','E') then linereceivableamount else 0 end as xstk");
        preSelectFields.add("case when basebilltype in(1041360915058186240,1041368594703054848,1041368311738529792) AND isbook = false and ordersource not in('D','E') then saleqty else 0 end as lsitemqty");
        preSelectFields.add("case when basebilltype in(1041360915058186240,1041368594703054848,1041368311738529792,1041367443022673920) AND isbook = true and ordersource not in('D','E') then saleqty else 0 end as yditemqty");
        preSelectFields.add("case when basebilltype in(1041368005805996032) and ordersource not in('D','E') then saleqty else 0 end as qditemqty");
        preSelectFields.add("case when basebilltype in(1041360915058186240,1041368594703054848,1041368311738529792) AND isbook = false and ordersource in('D','E') then saleqty else 0 end as xsitemqty");
        preSelectFields.add("case when basebilltype in(1041370880296744960) AND isbook = false and ordersource not in('D','E') then saleqty else 0 end as lsthitemqty");
        preSelectFields.add("case when basebilltype in(1041370880296744960) AND isbook = true and ordersource not in('D','E') then saleqty else 0 end as ydthitemqty");
        preSelectFields.add("case when basebilltype in(1041370880296744960) AND isbook = false and ordersource  in('D','E') then saleqty else 0 end as xsthitemqty");
        return preSelectFields;
    }

    private List<String> getSaleOrderPreSelectFields() {
        List<String> fields = this.getCommonField();
        fields.add("billno");
        fields.add("case when basebilltype in(1041360915058186240,1041368594703054848,1041368311738529792) AND isbook = false and ordersource not in('D','E') then 'A' when basebilltype in(1041360915058186240,1041368594703054848,1041368311738529792,1041367443022673920) AND isbook = true and ordersource not in('D','E') then 'B' when basebilltype in(1041368005805996032) and ordersource not in('D','E') then 'C' when ordersource  in('D','E') then 'D' else null end as saletype");
        return fields;
    }

    private List<String> getReturnOrderPreSelectFields() {
        List<String> fields = this.getCommonField();
        fields.add("billno");
        fields.add("case when basebilltype in(1041370880296744960) AND isbook = false and ordersource not in('D','E') then 'A' when basebilltype in(1041370880296744960) AND isbook = true and ordersource not in('D','E') then 'B' when ordersource  in('D','E') then 'D' else null end as saletype");
        return fields;
    }

    private PosQueryParam getParam(ReportQueryParam reportQueryParam) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        PosQueryParam posQueryParam = new PosQueryParam();
        posQueryParam.setBranch(filterInfo.getDynamicObjectCollection("salesbranchid"));
        posQueryParam.setStartDate(filterInfo.getDate("saledaterange_startdate"));
        posQueryParam.setEndDate(filterInfo.getDate("saledaterange_enddate"));
        posQueryParam.setCurrency(filterInfo.getDynamicObject("currency"));
        posQueryParam.setSaler(filterInfo.getDynamicObjectCollection("salerid"));
        return posQueryParam;
    }
}

