/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.report.query;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinHint;
import kd.bos.algo.JoinType;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.occ.ocbase.common.enums.EnableStatusEnum;
import kd.occ.ocbase.common.enums.StatusEnum;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocpos.common.consts.StoreRealInvAccConst;

public class StoreInvAnalyseRptQuery
extends AbstractReportListDataPlugin {
    private final String algoKey = ((Object)((Object)this)).getClass().getName();
    private static final Log logger = LogFactory.getLog(StoreInvAnalyseRptQuery.class);
    protected static final String[] fieldList = new String[]{"warehouse", "invstatus", "invtype", "unit", "baseunit", "org"};
    protected static final String[] idList = new String[]{"location", "project", "unit2nd"};
    protected static final String[] qtyFieldList = new String[]{"avbbtndqty", "reserveunit2ndqty", "avbbaseqty", "reservoeqty", "avbbqty", "reserveqty"};
    protected static final String[] defaultOrderOrg = new String[]{"org", "owner"};

    public DataSet query(ReportQueryParam queryParam, Object arg1) throws Throwable {
        FilterInfo filterInfo = queryParam.getFilter();
        List<QFilter> qFilters = this.buildInvAccPartFilter(filterInfo);
        List<QFilter> headFilters = this.buildHeadFilters(queryParam);
        List<QFilter> addNullFilter = this.addNullFilter(headFilters);
        if (addNullFilter.size() != 0) {
            qFilters.addAll(addNullFilter);
        }
        DataSet invAccDataSet = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)StoreRealInvAccConst.getBalTb(), (String)String.join((CharSequence)",", this.buildSelectorAcc(filterInfo)), (QFilter[])qFilters.toArray(new QFilter[0]), (String)"");
        invAccDataSet = this.getAvbBaseQty(invAccDataSet);
        if (!filterInfo.getBoolean("isshowlotexpirydate")) {
            HashSet<String> groupByFields = new HashSet<String>(0);
            groupByFields.add("org");
            groupByFields.add("warehouse");
            groupByFields.add("location");
            groupByFields.add("invstatus");
            groupByFields.add("invtype");
            groupByFields.add("project");
            groupByFields.add("ownertype");
            groupByFields.add("owner");
            groupByFields.add("keepertype");
            groupByFields.add("keeper");
            groupByFields.add("material");
            groupByFields.add("baseunit");
            groupByFields.add("unit");
            groupByFields.add("summarytype");
            groupByFields.add("unitid");
            groupByFields.add("baseunitid");
            groupByFields.add("auxunitid");
            groupByFields.add("flocationid");
            groupByFields.add("material.number");
            groupByFields.add("warehouseid");
            groupByFields.add("warehouse.number");
            groupByFields.add("materialid");
            groupByFields.add("stockorgid");
            invAccDataSet = invAccDataSet.select(StoreInvAnalyseRptQuery.addFields(this.getDataSetFieldArray(invAccDataSet), new String[0])).groupBy(groupByFields.toArray(new String[0])).sum("qty").sum("baseqty").sum("qty2nd").sum("lockbaseqty").sum("lockqty").sum("lockqty2nd").sum("avbbaseqty").sum("avbqty").sum("avbqty2nd").sum("reserveqty").sum("reservebaseqty").sum("reserveunit2ndqty").sum("avbbaseqty").sum("avbbqty").sum("avbbtndqty").sum("reservoeqty").finish();
        }
        DataSet channelDataSet = this.getChanelDataSet(filterInfo);
        invAccDataSet = channelDataSet.leftJoin(invAccDataSet).on("stockorgid", "stockorgid").select(StoreInvAnalyseRptQuery.addFields(this.getDataSetFieldArray(invAccDataSet), "channelid", "channelname")).finish();
        DataSet goodsDataSet = this.getGoodsDataSet(filterInfo);
        invAccDataSet = goodsDataSet.leftJoin(invAccDataSet).on("materialid", "materialid").select(StoreInvAnalyseRptQuery.addFields(this.getDataSetFieldArray(invAccDataSet), "goodsid", "goodsmodelnum", "brandname", "goodsclassname", "supplerid", "costprice", "retailprice", "qty*costprice as costamount", "qty*retailprice as retailamount")).finish();
        DataSet overSalePolicy = this.getOverSalePolicyDataSet(channelDataSet);
        invAccDataSet = invAccDataSet.leftJoin(overSalePolicy).on("channelid", "channelid").on("warehouseid", "warehouseid").on("materialid", "materialid").on("unitid", "unitid").select(StoreInvAnalyseRptQuery.addFields(this.getDataSetFieldArray(invAccDataSet), "alwoversaleqty", "alwoversalebaseqty", "oversaledqty", "oversaledbaseqty")).finish();
        invAccDataSet = this.getSInStockBaseQty(invAccDataSet, filterInfo);
        invAccDataSet = this.getSDeliveryBaseQty(invAccDataSet, filterInfo);
        invAccDataSet = invAccDataSet.filter("org is not null");
        String sortInfo = queryParam.getSortInfo();
        invAccDataSet = invAccDataSet.orderBy(StoreInvAnalyseRptQuery.orderByMultiOrgQuery(sortInfo));
        String qtyFilterString = this.getQtyFilter(queryParam, filterInfo);
        if (!StringUtils.isEmpty((Object)qtyFilterString)) {
            invAccDataSet = invAccDataSet.filter(qtyFilterString);
        }
        invAccDataSet = invAccDataSet.select(StoreInvAnalyseRptQuery.addFields(this.getDataSetFieldArray(invAccDataSet), new String[0])).groupBy(StoreInvAnalyseRptQuery.addFields(this.getDataSetFieldArray(invAccDataSet), new String[0])).finish();
        return invAccDataSet;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        super.getColumns(columns);
        ReportQueryParam queryParam = this.getQueryParam();
        if (queryParam == null) {
            return columns;
        }
        FilterInfo filterInfo = queryParam.getFilter();
        if (filterInfo == null) {
            return columns;
        }
        if (!filterInfo.getBoolean("isshowlotexpirydate")) {
            for (int i = columns.size() - 1; i >= 0; --i) {
                if (!(columns.get(i) instanceof ReportColumn)) continue;
                ReportColumn column = (ReportColumn)columns.get(i);
                if (column.getFieldKey().equals("lotnum")) {
                    columns.remove(columns.get(i));
                    continue;
                }
                if (column.getFieldKey().equals("producedate")) {
                    columns.remove(columns.get(i));
                    continue;
                }
                if (!column.getFieldKey().equals("expirydate")) continue;
                columns.remove(columns.get(i));
            }
        }
        return columns;
    }

    private DataSet getOverSalePolicyDataSet(DataSet channelDataSet) {
        String selectFields = "resoustockid.stockorg.id as stockorgid, resoustockid.stock.id as warehouseid, policyentity.material.id as materialid, policyentity.unit.id as unitid, policyentity.invtype.id as invtypeid, policyentity.exparrdate as exparrdate,policyentity.alwoversaleqty as alwoversaleqty,policyentity.alwoversalebaseqty as alwoversalebaseqty,policyentity.canoversaleqty as canoversaleqty,policyentity.canoversalebaseqty as canoversalebaseqty,policyentity.oversaledqty as oversaledqty,policyentity.oversaledbaseqty as oversaledbaseqty,shopscopeentity.shopid.id as channelid,shopscope";
        QFilter filter = F7Utils.getCommonStatusFilter();
        filter.and("oversaletype", "=", (Object)"1");
        filter.and("policyentity.iscontrol", "=", (Object)Boolean.TRUE);
        filter.and("policyentity.rowenable", "=", (Object)"1");
        filter.and("policyentity.begindt", "<=", (Object)TimeServiceHelper.now());
        filter.and("policyentity.enddt", ">=", (Object)TimeServiceHelper.now());
        DataSet overSalePolicy = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)"ococic_oversalepolicy", (String)selectFields, (QFilter[])filter.toArray(), (String)"policyentity.exparrdate");
        DataSet allChannelPolicy = overSalePolicy.select("stockorgid,warehouseid,materialid,unitid,invtypeid,exparrdate,alwoversaleqty,alwoversalebaseqty,canoversaleqty,canoversalebaseqty,oversaledqty,oversaledbaseqty,(case when channelid is null then 0 else channelid end) as channelid,shopscope").filter("shopscope = '0'");
        allChannelPolicy = allChannelPolicy.leftJoin(channelDataSet).on("shopscope", "shopscope").select(StoreInvAnalyseRptQuery.addFields(this.getDataSetFieldArray(allChannelPolicy), new String[0]), new String[]{"channelid as branchid"}).finish();
        allChannelPolicy = allChannelPolicy.select("stockorgid,warehouseid,materialid,unitid,invtypeid,exparrdate,alwoversaleqty,alwoversalebaseqty,canoversaleqty,canoversalebaseqty,oversaledqty,oversaledbaseqty,(case when channelid = 0 then branchid else channelid end) as channelid,shopscope");
        overSalePolicy = overSalePolicy.filter("shopscope = '1'").union(allChannelPolicy);
        overSalePolicy = overSalePolicy.select("stockorgid,warehouseid,materialid,unitid,invtypeid,alwoversaleqty,alwoversalebaseqty,canoversaleqty,canoversalebaseqty,oversaledqty,oversaledbaseqty,channelid").groupBy(new String[]{"stockorgid", "warehouseid", "materialid", "unitid", "invtypeid", "channelid"}).sum("alwoversaleqty").sum("alwoversalebaseqty").sum("canoversaleqty").sum("canoversalebaseqty").sum("oversaledqty").sum("oversaledbaseqty").finish();
        return overSalePolicy;
    }

    public static String[] addFields(String[] source, String ... addFiled) {
        return (String[])ArrayUtils.addAll((Object[])source, (Object[])addFiled);
    }

    public DataSet getGoodsDataSet(FilterInfo filterInfo) {
        QFilter qFilter = new QFilter("applyplatform", "=", (Object)"1");
        DynamicObject classApply = QueryServiceHelper.queryOne((String)"ocdbd_classstdapply", (String)"classstandardid.id", (QFilter[])qFilter.toArray());
        long classApplyId = DynamicObjectUtils.getLong((DynamicObject)classApply, (String)"classstandardid.id");
        QFilter goodsFilter = this.buildGoodsFilter(filterInfo, classApplyId);
        return QueryServiceHelper.queryDataSet((String)this.algoKey, (String)"ocdbd_iteminfo", (String)"id as goodsid,number as goodsnumber,name as goodsname,modelnum as goodsmodelnum,material,material.id as materialid,itembrands.name as brandname,supplerid.id as supplerid,supplerid.name as suppliername,itemclassentity.goodsclasssid.name as goodsclassname,costprice,retailprice", (QFilter[])goodsFilter.toArray(), (String)"");
    }

    public DataSet getChanelDataSet(FilterInfo filterInfo) {
        QFilter qFilter = new QFilter("isstore", "=", (Object)Boolean.TRUE);
        qFilter.and("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        qFilter.and("status", "=", (Object)StatusEnum.AUDIT.getValue());
        QFilter channelFilter = this.buildChannelFilter(filterInfo);
        qFilter.and(channelFilter);
        DataSet channelData = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)"ocdbd_channel", (String)"id as channelid,number as channelnumber,name as channelname,saleorg.id as saleorgid", (QFilter[])qFilter.toArray(), (String)"");
        QFilter viewFilter = new QFilter("view.number", "=", (Object)"05");
        DataSet orgStructureDataSet = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)"bos_org_structure", (String)"org.id as orgid", (QFilter[])viewFilter.toArray(), (String)"");
        channelData = channelData.leftJoin(orgStructureDataSet).on("saleorgid", "orgid").select(StoreInvAnalyseRptQuery.addFields(this.getDataSetFieldArray(channelData), "(case when orgid is Null then 0 else orgid end) as invorgid")).finish();
        long relationOrgId = this.getOrgRelationId();
        String selectProperties = "id,toorg.id as toorgid,fromorg.id as fromorgid";
        QFilter relationTypeFilter = new QFilter("typerelation", "=", (Object)relationOrgId);
        DataSet orgRelationData = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)"bos_org_orgrelation", (String)selectProperties, (QFilter[])relationTypeFilter.toArray(), (String)"isdefaulttoorg desc,toorg.number");
        channelData = channelData.leftJoin(orgRelationData).on("saleorgid", "fromorgid").select(StoreInvAnalyseRptQuery.addFields(this.getDataSetFieldArray(channelData), "toorgid", "'0' as shopscope")).finish();
        channelData = channelData.select("channelid,channelnumber,channelname,saleorgid,invorgid,toorgid,(case when invorgid = 0 then toorgid else invorgid end) as stockorgid,shopscope");
        return channelData.select("channelid,channelnumber,channelname,saleorgid,invorgid,stockorgid,shopscope").groupBy(new String[]{"channelid", "channelnumber", "channelname", "saleorgid", "invorgid", "stockorgid", "shopscope"}).finish();
    }

    private long getOrgRelationId() {
        QFilter qFilter = new QFilter("totype", "=", (Object)"05");
        qFilter.and("fromtype", "=", (Object)"03");
        DynamicObject typeRelation = QueryServiceHelper.queryOne((String)"bos_org_typerelation", (String)"id", (QFilter[])qFilter.toArray());
        return ObjectUtils.isEmpty((Object)typeRelation) ? 0L : DynamicObjectUtils.getLong((DynamicObject)typeRelation, (String)"id");
    }

    public DataSet getAvbBaseQty(DataSet ds) {
        DataSet reserveData = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)"msmod_reserve_record", (String)"bal_id as supplybillid,qty as reserveqty,base_qty as reservebaseqty,qty2nd as reserveunit2ndqty", (QFilter[])new QFilter[]{new QFilter("bal_obj.id", "=", (Object)"im_inv_realbalance")}, null);
        DataSet invAccSumReserve = reserveData.select("Cast(supplybillid as Long) supplybillid,reservebaseqty,reserveqty,reserveunit2ndqty").groupBy(new String[]{"supplybillid"}).sum("reservebaseqty").sum("reserveqty").sum("reserveunit2ndqty").finish();
        List<String> invAccFields = this.getDataSetCols(ds);
        List<String> reserveFields = this.getDataSetCols(invAccSumReserve);
        JoinHint hint = new JoinHint();
        hint.setNullAsZero(true);
        DataSet qty = ds.join(invAccSumReserve, JoinType.LEFT).on("id", "supplybillid").hint(hint).select(invAccFields.toArray(new String[0]), reserveFields.toArray(new String[0])).finish();
        invAccFields.add("case when reserveqty is Null then 0 else reserveqty end as reserveqty");
        invAccFields.add("case when reservebaseqty is Null then 0 else reservebaseqty end as reservebaseqty");
        invAccFields.add("case when reserveunit2ndqty is Null then 0 else reserveunit2ndqty end as reserveunit2ndqty");
        DataSet avbBaseQty = qty.select(invAccFields.toArray(new String[0]));
        List<String> invAccFields1 = this.getDataSetCols(avbBaseQty);
        invAccFields1.add("(baseqty-reservebaseqty) as avbbaseqty");
        invAccFields1.add("(qty-reserveqty) as avbbqty");
        invAccFields1.add("(qty2nd-reserveunit2ndqty) as avbbtndqty");
        invAccFields1.add("reservebaseqty as reservoeqty");
        invAccFields1.remove("avbbaseqty");
        return avbBaseQty.select(invAccFields1.toArray(new String[0]));
    }

    public DataSet getSInStockBaseQty(DataSet ds, FilterInfo filterInfo) {
        DataSet inStockDataSet;
        Object saleOrderDataSet = null;
        QFilter filter = new QFilter("billstatus", "=", (Object)StatusEnum.AUDIT.getValue());
        filter.and("billentry.rowclosestatus", "=", (Object)"A");
        if (filterInfo.getDate("startdate") != null && filterInfo.getDate("enddate") != null) {
            Date dtStartDate = filterInfo.getDate("startdate");
            Date dtEndDate = filterInfo.getDate("enddate");
            filter.and("auditdate", ">=", (Object)dtStartDate);
            filter.and("auditdate", "<=", (Object)dtEndDate);
        }
        if ((inStockDataSet = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)"pm_purorderbill", (String)"billentry.material.id as materialid,billentry.unit.id as unitid,billentry.baseunit.id as baseunitid,(billentry.qty - billentry.receiveqty) as sinstockqty,(billentry.baseqty - billentry.receivebaseqty) as sinstockbaseqty,billentry.auxunit.id as auxunitid,billentry.auxqty as sinstock2ndqty,billentry.entryrecorg.id as stockorgid", (QFilter[])filter.toArray(), null)) != null) {
            inStockDataSet = inStockDataSet.select("materialid,unitid,baseunitid,sinstockqty,sinstockbaseqty,auxunitid,sinstock2ndqty,stockorgid").groupBy(new String[]{"materialid", "unitid", "baseunitid", "auxunitid", "stockorgid"}).sum("sinstockqty").sum("sinstockbaseqty").sum("sinstock2ndqty").finish();
            List<String> invAccFields = this.getDataSetCols(ds);
            JoinHint hint = new JoinHint();
            hint.setNullAsZero(true);
            return ds.join(inStockDataSet, JoinType.LEFT).on("materialid", "materialid").on("unitid", "unitid").on("baseunitid", "baseunitid").on("auxunitid", "auxunitid").on("stockorgid", "stockorgid").hint(hint).select(invAccFields.toArray(new String[0]), new String[]{"case when sinstockqty is Null then 0 else sinstockqty end as sinstockqty", "case when sinstockbaseqty is Null then 0 else sinstockbaseqty end as sinstockbaseqty", "case when sinstock2ndqty is Null then 0 else sinstock2ndqty end as sinstock2ndqty"}).finish();
        }
        return ds;
    }

    public DataSet getSDeliveryBaseQty(DataSet ds, FilterInfo filterInfo) {
        QFilter filter = new QFilter("billstatus", "=", (Object)StatusEnum.AUDIT.getValue());
        filter.and("deliveryallstatus.id", "=", (Object)1026065142993238016L);
        if (filterInfo.getDate("startdate") != null && filterInfo.getDate("enddate") != null) {
            Date dtStartDate = filterInfo.getDate("startdate");
            Date dtEndDate = filterInfo.getDate("enddate");
            filter.and("auditdate", ">=", (Object)dtStartDate);
            filter.and("auditdate", "<=", (Object)dtEndDate);
        }
        DataSet deliveryOrderDataSet = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)"ocococ_deliveryorder", (String)"entryentity.material.id as materialid,entryentity.unit.id as unitid,entryentity.baseunit.id as baseunitid,entryentity.qty as sdeliveryqty,entryentity.baseqty as sdeliverybaseqty,entryentity.assistunit.id as auxunitid,entryentity.assistqty as sdelivery2ndqty,entryentity.detailstockorg.id as stockorgid,entryentity.stock.id as warehouseid", (QFilter[])filter.toArray(), null);
        deliveryOrderDataSet = deliveryOrderDataSet.select("materialid,unitid,baseunitid,sdeliveryqty,sdeliverybaseqty,auxunitid,sdelivery2ndqty,stockorgid,warehouseid").groupBy(new String[]{"materialid", "unitid", "baseunitid", "auxunitid", "stockorgid", "warehouseid"}).sum("sdeliveryqty").sum("sdeliverybaseqty").sum("sdelivery2ndqty").finish();
        List<String> invAccFields = this.getDataSetCols(ds);
        JoinHint hint = new JoinHint();
        hint.setNullAsZero(true);
        return ds.join(deliveryOrderDataSet, JoinType.LEFT).on("materialid", "materialid").on("unitid", "unitid").on("baseunitid", "baseunitid").on("auxunitid", "auxunitid").on("stockorgid", "stockorgid").on("warehouseid", "warehouseid").hint(hint).select(invAccFields.toArray(new String[0]), new String[]{"case when sdeliveryqty is Null then 0 else sdeliveryqty end as sdeliveryqty", "case when sdeliverybaseqty is Null then 0 else sdeliverybaseqty end as sdeliverybaseqty", "case when sdelivery2ndqty is Null then 0 else sdelivery2ndqty end as sdelivery2ndqty"}).finish();
    }

    private List<String> getDataSetCols(DataSet ds) {
        RowMeta rowMeta = ds.getRowMeta();
        Field[] fields = rowMeta.getFields();
        int count = fields.length;
        ArrayList<String> list = new ArrayList<String>(count);
        for (Field field : fields) {
            list.add(field.getName().toLowerCase());
        }
        return list;
    }

    private List<QFilter> addNullFilter(List<QFilter> headFilters) {
        ArrayList<QFilter> addNullFilter = new ArrayList<QFilter>(headFilters.size());
        for (QFilter filter : headFilters) {
            String property = filter.getProperty();
            String cp = filter.getCP();
            if (Arrays.asList(idList).contains(property)) {
                List<Object> dynIds;
                if ("is null".equals(cp)) {
                    addNullFilter.add(new QFilter(property, "=", (Object)0));
                    continue;
                }
                if ("is not null".equals(cp)) {
                    addNullFilter.add(new QFilter(property, "!=", (Object)0));
                    continue;
                }
                if (cp.contains("like")) {
                    addNullFilter.add(new QFilter(property + ".name", cp, filter.getValue()));
                    continue;
                }
                Object value = filter.getValue();
                if (value instanceof String) {
                    value = ((String)value).replace("%", "");
                }
                QFilter nameFilter = new QFilter("name", "=", value);
                String entityName = this.getEntity(property);
                DynamicObject[] dyns = BusinessDataServiceHelper.load((String)entityName, (String)"id,name", (QFilter[])nameFilter.toArray());
                if (null == dyns || dyns.length == 0 || (dynIds = this.getIds(dyns)).isEmpty()) continue;
                if (dynIds.size() > 1) {
                    if (cp.equals("=")) {
                        cp = "in";
                    } else if (cp.equals("!=")) {
                        cp = "not in";
                    }
                }
                addNullFilter.add(new QFilter(property, cp, dynIds));
                continue;
            }
            addNullFilter.add(filter);
        }
        return addNullFilter;
    }

    private List<Object> getIds(DynamicObject[] dyns) {
        ArrayList<Object> dynIds = new ArrayList<Object>(dyns.length);
        for (DynamicObject dyn : dyns) {
            dynIds.add(dyn.getPkValue());
        }
        return dynIds;
    }

    private String getEntity(String property) {
        String entityName = "";
        switch (property) {
            case "location": {
                entityName = "bd_location";
                break;
            }
            case "project": {
                entityName = "bd_project";
                break;
            }
            case "unit2nd": {
                entityName = "bd_measureunits";
                break;
            }
        }
        return entityName;
    }

    private String getQtyFilter(ReportQueryParam queryParam, FilterInfo filterInfo) {
        List headFilters = queryParam.getFilter().getHeadFilters();
        StringBuilder buf = new StringBuilder();
        int i = 0;
        for (QFilter filter : headFilters) {
            String property = filter.getProperty();
            if (!Arrays.asList(qtyFieldList).contains(property)) continue;
            String cp = filter.getCP();
            Object value = filter.getValue();
            String singleFilterString = property + cp + value;
            if (i > 0) {
                buf.append(" and ");
            }
            buf.append(singleFilterString);
            ++i;
        }
        if (!filterInfo.getBoolean("iszeroshow")) {
            buf.append(' ').append(this.addInvAccNotZeroFilter());
        }
        return buf.toString();
    }

    private List<QFilter> buildHeadFilters(ReportQueryParam queryParam) {
        List headFilters = queryParam.getFilter().getHeadFilters();
        headFilters.removeIf(filter -> Arrays.asList(qtyFieldList).contains(filter.getProperty()));
        for (QFilter filter2 : headFilters) {
            this.rebuildFilter(filter2);
            List nests = filter2.getNests(true);
            for (QFilter.QFilterNest net : nests) {
                QFilter netFilter = net.getFilter();
                this.rebuildFilter(netFilter);
            }
        }
        return headFilters;
    }

    private void rebuildFilter(QFilter filter) {
        String property = filter.getProperty();
        if (Arrays.asList(fieldList).contains(property)) {
            property = property + ".name";
            filter.__setProperty(property);
        } else if ("producedate".equals(property) || "expirydate".equals(property)) {
            this.dateFormat(filter);
        } else {
            if ("material".equals(property)) {
                property = "material.number";
            }
            filter.__setProperty(property);
        }
    }

    private void dateFormat(QFilter filter) {
        Object dateValue = filter.getValue();
        if (dateValue instanceof String) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                Date date = simpleDateFormat.parse((String)dateValue);
                filter.__setValue((Object)date);
            }
            catch (ParseException e) {
                logger.info("SimpleDateFormat\u8f6c\u6362date\u5f02\u5e38");
            }
        }
    }

    private static String[] orderByMultiOrgQuery(String sortInfo) {
        String[] orderBy = defaultOrderOrg;
        if (null != sortInfo) {
            ArrayList<String> orderByList = new ArrayList<String>(Arrays.asList(orderBy));
            orderByList.add(0, sortInfo);
            orderBy = orderByList.toArray(new String[0]);
        }
        return orderBy;
    }

    protected String[] getDataSetFieldArray(DataSet dataSet) {
        Set<String> fields = this.getDataSetField(dataSet);
        return fields.toArray(new String[0]);
    }

    private Set<String> getDataSetField(DataSet dataSet) {
        Field[] fields = dataSet.getRowMeta().getFields();
        LinkedHashSet<String> fs = new LinkedHashSet<String>(fields.length);
        for (Field field : fields) {
            String fieldName = field.getName();
            fs.add(fieldName);
        }
        return fs;
    }

    private DataSet getSumData(DataSet dataSet) {
        Field[] fields = dataSet.getRowMeta().getFields();
        ArrayList<String> sumFieldsList = new ArrayList<String>();
        ArrayList<String> nullFieldsList = new ArrayList<String>();
        ArrayList<String> allFieldsList = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            if (field.getDataType() instanceof BigDecimalType) {
                sumFieldsList.add(field.getAlias());
            } else if (!"summarytype".equals(field.getName()) && !"goodsname".equals(field.getName())) {
                nullFieldsList.add(field.getAlias());
            }
            allFieldsList.add(field.getAlias());
        }
        String[] groupFields = new String[]{};
        GroupbyDataSet gpRs = dataSet.groupBy(groupFields);
        sumFieldsList.forEach(arg_0 -> ((GroupbyDataSet)gpRs).sum(arg_0));
        dataSet = gpRs.finish();
        for (String string : nullFieldsList) {
            dataSet = dataSet.addNullField(string);
        }
        dataSet = dataSet.addField("'\u5408\u8ba1'", "goodsname");
        dataSet = dataSet.addField(String.format("'%s'", 3), "summarytype");
        dataSet = dataSet.select(allFieldsList.toArray(new String[0]));
        return dataSet;
    }

    private List<String> buildSelectorAcc(FilterInfo filterInfo) {
        ArrayList<String> selectorList = new ArrayList<String>(0);
        Set selectorSet = EntityMetadataCache.getDataEntityType((String)StoreRealInvAccConst.getBalTb()).getAllFields().keySet();
        selectorList.addAll(selectorSet);
        selectorList.add("'0' as summarytype");
        selectorList.add("id");
        selectorList.add("unit.id as unitid");
        selectorList.add("baseunit.id as baseunitid");
        selectorList.add("unit2nd.id as auxunitid");
        selectorList.add("location.id as flocationid");
        selectorList.add("material.number");
        selectorList.add("warehouse.id as warehouseid");
        selectorList.add("warehouse.number");
        selectorList.add("material.id as materialid");
        selectorList.add("org.id as stockorgid");
        return selectorList;
    }

    private List<QFilter> buildInvAccPartFilter(FilterInfo filterInfo) {
        QFilter warehouseFilter;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(0);
        DynamicObjectCollection org = (DynamicObjectCollection)filterInfo.getValue("multiorghead");
        if (org == null || org.size() == 0) {
            return qFilters;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(0);
        for (Object dynamicObject : org) {
            orgIds.add((Long)dynamicObject.getPkValue());
        }
        qFilters.add(new QFilter("org", "in", orgIds));
        DynamicObjectCollection ivnTypeHeads = filterInfo.getDynamicObjectCollection("ivntypehead");
        if (ivnTypeHeads != null && ivnTypeHeads.size() > 0) {
            HashSet<Object> ivnTypeIds = new HashSet<Object>();
            for (DynamicObject ivnType : ivnTypeHeads) {
                ivnTypeIds.add(ivnType.getPkValue());
            }
            QFilter ivnTypeHeadFilter = new QFilter("invtype", "in", ivnTypeIds);
            qFilters.add(ivnTypeHeadFilter);
        }
        if ((warehouseFilter = StoreInvAnalyseRptQuery.getDynamicObjectFilter(filterInfo, "warehouse.id", "multiwarehousehead")) != null) {
            qFilters.add(warehouseFilter);
        }
        return qFilters;
    }

    private QFilter buildChannelFilter(FilterInfo filterInfo) {
        DynamicObjectCollection channelDyc = (DynamicObjectCollection)filterInfo.getValue("multistorehead");
        if (CollectionUtils.isEmpty((Collection)channelDyc)) {
            return new QFilter("sysuser.id", "=", (Object)UserServiceHelper.getCurrentUserId());
        }
        ArrayList<Long> channelIds = new ArrayList<Long>(0);
        for (DynamicObject dynamicObject : channelDyc) {
            channelIds.add(DynamicObjectUtils.getPkValue((DynamicObject)dynamicObject));
        }
        return new QFilter("id", "in", channelIds);
    }

    private QFilter buildGoodsFilter(FilterInfo filterInfo, long classApplyId) {
        DynamicObjectCollection supplierDyc;
        List<Long> lstSupplierId;
        DynamicObjectCollection goodsClassDyc;
        List<Long> lstGoodsClassId;
        DynamicObjectCollection brandDyc;
        List<Long> lstBrandId;
        QFilter qFilter = new QFilter("itemclassentity.classstandardid.id", "=", (Object)classApplyId);
        DynamicObjectCollection goodsDyc = (DynamicObjectCollection)filterInfo.getValue("multigoodshead");
        List<Long> lstGoodsId = this.getDynamicObjectCollectionIds(goodsDyc);
        if (!CollectionUtils.isEmpty(lstGoodsId)) {
            qFilter = qFilter.and("id", "in", lstGoodsId);
        }
        if (!CollectionUtils.isEmpty(lstBrandId = this.getDynamicObjectCollectionIds(brandDyc = (DynamicObjectCollection)filterInfo.getValue("multibrandhead")))) {
            qFilter.and("itembrands.id", "in", lstBrandId);
        }
        if (!CollectionUtils.isEmpty(lstGoodsClassId = this.getDynamicObjectCollectionIds(goodsClassDyc = (DynamicObjectCollection)filterInfo.getValue("multigoodsclasshead")))) {
            this.getGoodsClassId(lstGoodsClassId, null);
            qFilter.and("itemclassentity.goodsclasssid.id", "in", lstGoodsClassId);
        }
        if (!CollectionUtils.isEmpty(lstSupplierId = this.getDynamicObjectCollectionIds(supplierDyc = (DynamicObjectCollection)filterInfo.getValue("multisupplierhead")))) {
            qFilter.and("supplerid.id", "in", lstSupplierId);
        }
        return qFilter;
    }

    private void getGoodsClassId(List<Long> lstGoodsClassId, List<Long> lstChildId) {
        QFilter filter = CollectionUtils.isEmpty(lstChildId) ? new QFilter("parent", "in", lstGoodsClassId) : new QFilter("parent", "in", lstChildId);
        DynamicObjectCollection goodsClassData = QueryServiceHelper.query((String)"mdr_item_class", (String)"id", (QFilter[])filter.toArray());
        if (CollectionUtils.isEmpty((Collection)goodsClassData)) {
            return;
        }
        List<Long> lstId = goodsClassData.stream().map(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"id")).collect(Collectors.toList());
        lstGoodsClassId.addAll(lstId);
        this.getGoodsClassId(lstGoodsClassId, lstId);
    }

    private List<Long> getDynamicObjectCollectionIds(DynamicObjectCollection doc) {
        ArrayList<Long> lstId = new ArrayList<Long>(0);
        if (!CollectionUtils.isEmpty((Collection)doc)) {
            for (DynamicObject item : doc) {
                long id = DynamicObjectUtils.getPkValue((DynamicObject)item);
                if (lstId.contains(id)) continue;
                lstId.add(id);
            }
        }
        return lstId;
    }

    private QFilter addInvAccNotZeroFilter() {
        return new QFilter("baseqty", "<>", (Object)0);
    }

    public static QFilter getDynamicObjectFilter(FilterInfo filterInfo, String queryFiled, String fromKey) {
        QFilter bFilter = null;
        DynamicObjectCollection froms = filterInfo.getDynamicObjectCollection(fromKey);
        if (froms != null && froms.size() != 0) {
            if (froms.size() > 1) {
                HashSet<Object> idSet = new HashSet<Object>();
                for (DynamicObject from : froms) {
                    idSet.add(from.get("id"));
                }
                return new QFilter(queryFiled, "in", idSet);
            }
            DynamicObject from = (DynamicObject)froms.get(0);
            bFilter = new QFilter(queryFiled, "=", from.get("id"));
        }
        return bFilter;
    }
}

