/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.report.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.EnumBillStatus;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocpos.business.commonhelper.OrgHelper;

public class VipConsumeDetailReportQuery
extends AbstractReportListDataPlugin {
    public DataSet query(ReportQueryParam queryParam, Object arg1) {
        FilterInfo filterInfo = queryParam.getFilter();
        QFilter filter = this.getFilterInfo(filterInfo);
        List<String> lstFieldKey = this.getSaleOrderField();
        DataSet dsSaleOrder = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocpos_saleorder", (String)StringUtils.join((Object[])lstFieldKey.toArray(), (char)','), (QFilter[])filter.toArray(), null);
        DataSet dsSaleReturn = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocpos_saleorder_return", (String)StringUtils.join((Object[])lstFieldKey.toArray(), (char)','), (QFilter[])filter.toArray(), null);
        return dsSaleOrder.union(dsSaleReturn).orderBy(new String[]{"consumedate desc "});
    }

    private QFilter getFilterInfo(FilterInfo filterInfo) {
        DynamicObjectCollection departs;
        String dataSource;
        DynamicObjectCollection exclusiveConsultant;
        String memberName;
        QFilter filter = new QFilter("member", ">", (Object)0L);
        filter.and("salebranchid", ">", (Object)0L);
        filter.and("billstatus", "=", (Object)EnumBillStatus.C);
        String mobile = filterInfo.getString("mobilefilter");
        if (StringUtils.isNotEmpty((CharSequence)mobile)) {
            filter.and("member.shortmobile", "=", (Object)mobile);
        }
        if (StringUtils.isNotEmpty((CharSequence)(memberName = filterInfo.getString("memberfilter")))) {
            filter.and("member.name", "=", (Object)memberName);
        }
        if ((exclusiveConsultant = filterInfo.getDynamicObjectCollection("exclusiveconsultantfilter")) != null && exclusiveConsultant.size() > 0) {
            filter.and("cashier", "in", (Object)exclusiveConsultant.stream().map(DataEntityBase::getPkValue).toArray());
        }
        if (!StringUtils.isEmpty((CharSequence)(dataSource = filterInfo.getString("datasourcefilter")))) {
            String[] dataSourceArray = dataSource.split(",");
            List<String> lstDataSource = Arrays.asList(dataSourceArray);
            if (lstDataSource.contains("A") && !lstDataSource.contains("B")) {
                filter.and("ordersource", "in", (Object)new String[]{"A", "B", "C"});
            } else if (!lstDataSource.contains("A") && lstDataSource.contains("B")) {
                filter.and("ordersource", "in", (Object)new String[]{"D", "E"});
            }
        }
        if ((departs = filterInfo.getDynamicObjectCollection("departfilter")) != null && departs.size() > 0) {
            filter.and("goodsentryentity.saledepartment", "in", (Object)departs.stream().map(DataEntityBase::getPkValue).toArray());
        } else {
            List permissionOrgs = OrgHelper.getPermissionOrgs((String)"ocpos_vipconsumedtl_rpt", (String)"01");
            if (!CollectionUtils.isEmpty((Collection)permissionOrgs)) {
                List orgIds = permissionOrgs.stream().map(tempOrg -> Long.valueOf((String)tempOrg.get("id"))).collect(Collectors.toCollection(() -> new ArrayList(0)));
                filter.and("goodsentryentity.saledepartment", "in", (Object)orgIds.toArray());
            }
        }
        DynamicObjectCollection branchs = filterInfo.getDynamicObjectCollection("branchfilter");
        if (branchs != null && branchs.size() > 0) {
            filter.and("salebranchid", "in", (Object)branchs.stream().map(DataEntityBase::getPkValue).toArray());
        }
        Date dtStartDate = filterInfo.getDate("startdate");
        Date dtEndDate = filterInfo.getDate("enddate");
        if (dtStartDate != null && dtEndDate != null) {
            dtEndDate = DateUtil.dayAdd((Date)dtEndDate, (int)1);
            filter.and("auditdate", ">=", (Object)dtStartDate);
            filter.and("auditdate", "<", (Object)dtEndDate);
        }
        return filter;
    }

    private List<String> getSaleOrderField() {
        ArrayList<String> lstField = new ArrayList<String>(0);
        lstField.add("Id");
        lstField.add("member");
        lstField.add("biztype");
        lstField.add("(SUBSTRING(member.shortmobile,0,4)||'****'||SUBSTRING(member.shortmobile,8,4)) as shortmobile");
        lstField.add("currencyid as currency");
        lstField.add("salebranchid as branch");
        lstField.add("auditdate as consumedate");
        lstField.add("billno as orderbillno");
        lstField.add("goodsentryentity.goodsid as goods");
        lstField.add("goodsentryentity.goodsclass as goodsclass");
        lstField.add("goodsentryentity.saledepartment as saledepartment");
        lstField.add("goodsentryentity.brand as brand");
        lstField.add("goodsentryentity.saleqty as saleqty");
        lstField.add("goodsentryentity.unit as unit");
        lstField.add("goodsentryentity.discountprice as balprice");
        lstField.add("goodsentryentity.balamount as balamount");
        lstField.add("goodsentryentity.taxrateid as taxrateid");
        return lstField;
    }
}

