/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.report.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.EnumBillStatus;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocpos.business.commonhelper.OrgHelper;
import kd.occ.ocpos.common.enums.BillTypeEnum;

public class VipConsumeSumReportQuery
extends AbstractReportListDataPlugin {
    public DataSet query(ReportQueryParam queryParam, Object arg1) {
        FilterInfo filterInfo = queryParam.getFilter();
        QFilter filter = new QFilter("billstatus", "=", (Object)EnumBillStatus.C);
        filter.and("basebilltype", "<>", (Object)BillTypeEnum.RESERVE.getId());
        filter.and("goodsentryentity.isbook", "=", (Object)Boolean.FALSE);
        Date dtStartDate = filterInfo.getDate("startdate");
        Date dtEndDate = filterInfo.getDate("enddate");
        if (dtStartDate != null && dtEndDate != null) {
            dtEndDate = DateUtil.dayAdd((Date)dtEndDate, (int)1);
            filter.and("auditdate", ">=", (Object)dtStartDate);
            filter.and("auditdate", "<", (Object)dtEndDate);
        }
        List<String> lstFieldKey = this.getSaleOrderField(false);
        DataSet dsSaleOrder = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocpos_saleorder", (String)StringUtils.join((Object[])lstFieldKey.toArray(), (char)','), (QFilter[])filter.toArray(), null);
        List<String> lstRetFieldKey = this.getSaleOrderField(true);
        DataSet dsSaleReturn = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocpos_saleorder_return", (String)StringUtils.join((Object[])lstRetFieldKey.toArray(), (char)','), (QFilter[])filter.toArray(), null);
        String strWhere = this.getFilterInfo(filterInfo);
        DataSet dsSaleOrderRlt = dsSaleOrder.filter(strWhere);
        DataSet dsSaleReturnRlt = dsSaleReturn.filter(strWhere);
        DataSet dsData = dsSaleOrder.union(dsSaleReturn);
        String summaryDimension = filterInfo.getString("summarydimensionfilter");
        ArrayList<String> lstSelectField = new ArrayList<String>(0);
        ArrayList<String> lstGroupField = new ArrayList<String>(0);
        ArrayList<String> lstReportField = new ArrayList<String>(0);
        ArrayList<String> lstSummaryField = new ArrayList<String>(0);
        this.getDataSetField(summaryDimension, lstSelectField, lstGroupField, lstReportField, lstSummaryField);
        String[] selectFieldArray = lstSelectField.toArray(new String[0]);
        String[] groupFieldArray = lstGroupField.toArray(new String[0]);
        String[] reportFieldArray = lstReportField.toArray(new String[0]);
        String[] summaryFieldArray = lstSummaryField.toArray(new String[0]);
        DataSet groupSaleOrder = dsSaleOrderRlt.select(selectFieldArray).groupBy(groupFieldArray).sum("consumeamount").finish();
        DataSet groupSaleReturn = dsSaleReturnRlt.select(selectFieldArray).groupBy(groupFieldArray).sum("consumeamount").finish();
        DataSet dsFullData = groupSaleOrder.union(groupSaleReturn);
        DataSet dsFinalRlt = dsFullData.select(reportFieldArray).groupBy(summaryFieldArray).sum("consumeamount").sum("consumecnt").sum("returncnt").max("lastconsumedate").finish();
        DataSet dsFinalData = this.getData(summaryDimension, dsData, dsFinalRlt, lstReportField);
        lstReportField.add("(case when amount = 0 OR consumeamount = 0 then 0 else consumeamount/ amount * 100 end) as consumeratio");
        reportFieldArray = lstReportField.toArray(new String[0]);
        dsFinalData = dsFinalData.select(reportFieldArray);
        return dsFinalData;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        FilterInfo filterInfo;
        ReportQueryParam queryParam = this.getQueryParam();
        if (queryParam != null && (filterInfo = queryParam.getFilter()) != null) {
            String summaryDimension;
            switch (summaryDimension = filterInfo.getString("summarydimensionfilter")) {
                case "A": {
                    columns.removeIf(x -> StringUtils.equals((CharSequence)((ReportColumn)x).getFieldKey(), (CharSequence)"brand"));
                    columns.removeIf(x -> StringUtils.equals((CharSequence)((ReportColumn)x).getFieldKey(), (CharSequence)"goodsclass"));
                    columns.removeIf(x -> StringUtils.equals((CharSequence)((ReportColumn)x).getFieldKey(), (CharSequence)"saledepartment"));
                    break;
                }
                case "B": {
                    columns.removeIf(x -> StringUtils.equals((CharSequence)((ReportColumn)x).getFieldKey(), (CharSequence)"brand"));
                    columns.removeIf(x -> StringUtils.equals((CharSequence)((ReportColumn)x).getFieldKey(), (CharSequence)"goodsclass"));
                    columns.removeIf(x -> StringUtils.equals((CharSequence)((ReportColumn)x).getFieldKey(), (CharSequence)"branch"));
                    break;
                }
                case "C": {
                    columns.removeIf(x -> StringUtils.equals((CharSequence)((ReportColumn)x).getFieldKey(), (CharSequence)"branch"));
                    columns.removeIf(x -> StringUtils.equals((CharSequence)((ReportColumn)x).getFieldKey(), (CharSequence)"goodsclass"));
                    columns.removeIf(x -> StringUtils.equals((CharSequence)((ReportColumn)x).getFieldKey(), (CharSequence)"saledepartment"));
                    break;
                }
                case "D": {
                    columns.removeIf(x -> StringUtils.equals((CharSequence)((ReportColumn)x).getFieldKey(), (CharSequence)"branch"));
                    columns.removeIf(x -> StringUtils.equals((CharSequence)((ReportColumn)x).getFieldKey(), (CharSequence)"brand"));
                    columns.removeIf(x -> StringUtils.equals((CharSequence)((ReportColumn)x).getFieldKey(), (CharSequence)"saledepartment"));
                    break;
                }
            }
        }
        return columns;
    }

    private void getDataSetField(String summaryDimension, List<String> lstSelectField, List<String> lstGroupField, List<String> lstReportField, List<String> lstSummaryField) {
        switch (summaryDimension) {
            default: {
                lstSelectField.add("branch");
                lstGroupField.add("branch");
                lstReportField.add("branch");
                lstSummaryField.add("branch");
                break;
            }
            case "B": {
                lstSelectField.add("saledepartment");
                lstGroupField.add("saledepartment");
                lstReportField.add("saledepartment");
                lstSummaryField.add("saledepartment");
                break;
            }
            case "C": {
                lstSelectField.add("brand");
                lstGroupField.add("brand");
                lstReportField.add("brand");
                lstSummaryField.add("brand");
                break;
            }
            case "D": {
                lstSelectField.add("goodsclass");
                lstGroupField.add("goodsclass");
                lstReportField.add("goodsclass");
                lstSummaryField.add("goodsclass");
            }
        }
        lstGroupField.add("Id");
        lstSelectField.add("Id");
        lstGroupField.add("member");
        lstSelectField.add("member");
        lstReportField.add("member");
        lstSummaryField.add("member");
        lstGroupField.add("shortmobile");
        lstSelectField.add("shortmobile");
        lstReportField.add("(SUBSTR(shortmobile,0,4)||'****'||SUBSTR(shortmobile,8,4)) as shortmobile");
        lstSummaryField.add("shortmobile");
        lstSelectField.add("consumeamount");
        lstReportField.add("consumeamount");
        lstGroupField.add("consumecnt");
        lstSelectField.add("consumecnt");
        lstReportField.add("consumecnt");
        lstGroupField.add("returncnt");
        lstSelectField.add("returncnt");
        lstReportField.add("returncnt");
        lstGroupField.add("lastconsumedate");
        lstSelectField.add("lastconsumedate");
        lstReportField.add("lastconsumedate");
    }

    private DataSet getData(String summaryDimension, DataSet dsData, DataSet dsFullRlt, List<String> lstReportField) {
        DataSet dsDataRlt;
        lstReportField.add("amount");
        String[] reportFieldArray = lstReportField.toArray(new String[0]);
        switch (summaryDimension) {
            default: {
                DataSet dsGroupSumData = dsData.select(new String[]{"branch", "consumeamount"}).groupBy(new String[]{"branch"}).sum("consumeamount").finish();
                dsGroupSumData = dsGroupSumData.select(new String[]{"branch", "consumeamount as amount"});
                dsDataRlt = dsFullRlt.leftJoin(dsGroupSumData).on("branch", "branch").select(reportFieldArray).finish();
                break;
            }
            case "B": {
                DataSet dsGroupSumData = dsData.select(new String[]{"saledepartment", "consumeamount"}).groupBy(new String[]{"saledepartment"}).sum("consumeamount").finish();
                dsGroupSumData = dsGroupSumData.select(new String[]{"saledepartment", "consumeamount as amount"});
                dsDataRlt = dsFullRlt.leftJoin(dsGroupSumData).on("saledepartment", "saledepartment").select(reportFieldArray).finish();
                break;
            }
            case "C": {
                DataSet dsGroupSumData = dsData.select(new String[]{"brand", "consumeamount"}).groupBy(new String[]{"brand"}).sum("consumeamount").finish();
                dsGroupSumData = dsGroupSumData.select(new String[]{"brand", "consumeamount as amount"});
                dsDataRlt = dsFullRlt.leftJoin(dsGroupSumData).on("brand", "brand").select(reportFieldArray).finish();
                break;
            }
            case "D": {
                DataSet dsGroupSumData = dsData.select(new String[]{"goodsclass", "consumeamount"}).groupBy(new String[]{"goodsclass"}).sum("consumeamount").finish();
                dsGroupSumData = dsGroupSumData.select(new String[]{"goodsclass", "consumeamount as amount"});
                dsDataRlt = dsFullRlt.leftJoin(dsGroupSumData).on("goodsclass", "goodsclass").select(reportFieldArray).finish();
            }
        }
        return dsDataRlt;
    }

    private String getFilterInfo(FilterInfo filterInfo) {
        DynamicObjectCollection departs;
        String dataSource;
        DynamicObjectCollection branchs;
        DynamicObjectCollection exclusiveConsultant;
        DynamicObjectCollection vipLevels;
        DynamicObjectCollection goodsClass;
        DynamicObjectCollection brands;
        String summaryDimension;
        QFilter filter = new QFilter("member", ">", (Object)0L);
        String shortMobile = filterInfo.getString("mobilefilter");
        if (StringUtils.isNotEmpty((CharSequence)shortMobile)) {
            filter.and("shortmobile", "=", (Object)shortMobile);
        }
        switch (summaryDimension = filterInfo.getString("summarydimensionfilter")) {
            default: {
                filter.and("branch", ">", (Object)0L);
                break;
            }
            case "B": {
                filter.and("saledepartment", ">", (Object)0L);
                break;
            }
            case "C": {
                filter.and("brand", ">", (Object)0L);
                break;
            }
            case "D": {
                filter.and("goodsclass", ">", (Object)0L);
            }
        }
        String memberName = filterInfo.getString("memberfilter");
        if (StringUtils.isNotEmpty((CharSequence)memberName)) {
            filter.and("membername", "=", (Object)memberName);
        }
        if ((brands = filterInfo.getDynamicObjectCollection("brandfilter")) != null && brands.size() > 0) {
            filter.and("brand", "in", (Object)brands.stream().map(DataEntityBase::getPkValue).toArray());
        }
        if ((goodsClass = filterInfo.getDynamicObjectCollection("goodsclassfilter")) != null && goodsClass.size() > 0) {
            List<Long> lstGoodsClassId = this.getDynamicObjectCollectionIds(goodsClass);
            boolean isContainsLower = filterInfo.getBoolean("iscontainslowerfilter");
            if (isContainsLower) {
                this.getGoodsClassId(lstGoodsClassId, null);
            }
            filter.and("goodsclass", "in", (Object)lstGoodsClassId.toArray());
        }
        if ((vipLevels = filterInfo.getDynamicObjectCollection("viplevelfilter")) != null && vipLevels.size() > 0) {
            filter.and("viplevel", "in", (Object)vipLevels.stream().map(DataEntityBase::getPkValue).toArray());
        }
        if ((exclusiveConsultant = filterInfo.getDynamicObjectCollection("exclusiveconsultantfilter")) != null && exclusiveConsultant.size() > 0) {
            filter.and("exclusiveconsultantfilter", "in", (Object)exclusiveConsultant.stream().map(DataEntityBase::getPkValue).toArray());
        }
        if ((branchs = filterInfo.getDynamicObjectCollection("branchfilter")) != null && branchs.size() > 0) {
            filter.and("branch", "in", (Object)branchs.stream().map(DataEntityBase::getPkValue).toArray());
        }
        if (!StringUtils.isEmpty((CharSequence)(dataSource = filterInfo.getString("datasourcefilter")))) {
            String[] dataSourceArray = dataSource.split(",");
            List<String> lstDataSource = Arrays.asList(dataSourceArray);
            if (lstDataSource.contains("A") && !lstDataSource.contains("B")) {
                filter.and("ordersource", "in", (Object)new String[]{"A", "B", "C"});
            } else if (!lstDataSource.contains("A") && lstDataSource.contains("B")) {
                filter.and("ordersource", "in", (Object)new String[]{"D", "E"});
            }
        }
        if ((departs = filterInfo.getDynamicObjectCollection("departfilter")) != null && departs.size() > 0) {
            filter.and("saledepartment", "in", (Object)departs.stream().map(DataEntityBase::getPkValue).toArray());
        } else {
            List permissionOrgs = OrgHelper.getPermissionOrgs((String)"ocpos_vipconsumedtl_rpt", (String)"01");
            if (!CollectionUtils.isEmpty((Collection)permissionOrgs)) {
                List orgIds = permissionOrgs.stream().map(tempOrg -> Long.valueOf((String)tempOrg.get("id"))).collect(Collectors.toCollection(() -> new ArrayList(0)));
                filter.and("saledepartment", "in", (Object)orgIds.toArray());
            }
        }
        return filter.toString();
    }

    private void getGoodsClassId(List<Long> lstGoodsClassId, List<Long> lstChildId) {
        QFilter filter = CollectionUtils.isEmpty(lstChildId) ? new QFilter("parent", "in", lstGoodsClassId) : new QFilter("parent", "in", lstChildId);
        DynamicObjectCollection goodsClassData = QueryServiceHelper.query((String)"mdr_item_class", (String)"id", (QFilter[])filter.toArray());
        if (CollectionUtils.isEmpty((Collection)goodsClassData)) {
            return;
        }
        List<Long> lstId = goodsClassData.stream().map(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"id")).collect(Collectors.toList());
        lstGoodsClassId.addAll(lstId);
        this.getGoodsClassId(lstGoodsClassId, lstId);
    }

    private List<Long> getDynamicObjectCollectionIds(DynamicObjectCollection doc) {
        ArrayList<Long> lstId = new ArrayList<Long>(0);
        if (!CollectionUtils.isEmpty((Collection)doc)) {
            for (DynamicObject item : doc) {
                long id = DynamicObjectUtils.getPkValue((DynamicObject)item);
                if (lstId.contains(id)) continue;
                lstId.add(id);
            }
        }
        return lstId;
    }

    private List<String> getSaleOrderField(boolean isReturn) {
        ArrayList<String> lstField = new ArrayList<String>(0);
        lstField.add("Id");
        lstField.add("member");
        lstField.add("ordersource");
        lstField.add("member.name as membername");
        lstField.add("member.shortmobile as shortmobile");
        lstField.add("member.viplevelid as viplevel");
        lstField.add("currencyid as currency");
        lstField.add("salebranchid as branch");
        if (isReturn) {
            lstField.add("0 as consumecnt");
            lstField.add("1 as returncnt");
            lstField.add("null as lastconsumedate");
        } else {
            lstField.add("1 as consumecnt");
            lstField.add("0 as returncnt");
            lstField.add("auditdate as lastconsumedate");
        }
        lstField.add("goodsentryentity.goodsclass as goodsclass");
        lstField.add("goodsentryentity.saledepartment as saledepartment");
        lstField.add("goodsentryentity.brand as brand");
        lstField.add("(goodsentryentity.linereceivableamount+goodsentryentity.deposit) as consumeamount");
        return lstField;
    }
}

