/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.abnormalorder;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.formplugin.base.OcposListPlugin;

public class AbnormalOrderListPlugin
extends OcposListPlugin {
    private static final String CACHEKEY_ORGCOMBOITEMS = "billtypecomboitems";

    @Override
    protected String[] listBranchCols() {
        return new String[]{"salebranchid.name"};
    }

    @Override
    protected String branchKey() {
        return "salebranchid";
    }

    @Override
    protected String[] listChannelUserCols() {
        return new String[]{"saler.sysuser.name", "cashier.sysuser.name"};
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : filterColumnList) {
            if (!filterColumn.getFieldName().equals("basebilltype.name") || !(filterColumn instanceof CommonFilterColumn)) continue;
            CommonFilterColumn billTypeColumn = (CommonFilterColumn)filterColumn;
            billTypeColumn.getComboItems().clear();
            List<ComboItem> combos = this.buildBillTypeComboItems();
            billTypeColumn.setComboItems(combos);
            break;
        }
        super.filterContainerInit(args);
    }

    private List<ComboItem> buildBillTypeComboItems() {
        String cacheString = this.getPageCache().get(CACHEKEY_ORGCOMBOITEMS);
        if (StringUtils.isNotBlank((CharSequence)cacheString)) {
            return SerializationUtils.fromJsonStringToList((String)cacheString, ComboItem.class);
        }
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(0);
        ORM orm = ORM.create();
        ArrayList<Long> lstId = new ArrayList<Long>(0);
        lstId.add(BillTypeEnum.RETAIL.getId());
        lstId.add(BillTypeEnum.RESERVE.getId());
        lstId.add(BillTypeEnum.CVTSALE.getId());
        lstId.add(BillTypeEnum.STORE.getId());
        lstId.add(BillTypeEnum.GUIDE.getId());
        lstId.add(BillTypeEnum.GROUP.getId());
        lstId.add(BillTypeEnum.RETURN.getId());
        lstId.add(BillTypeEnum.FINAL.getId());
        lstId.add(BillTypeEnum.RESERVEFINAL.getId());
        lstId.add(BillTypeEnum.CREDIT.getId());
        lstId.add(BillTypeEnum.CHANGE.getId());
        DynamicObjectCollection col = orm.query("bos_billtype", "id,name", new QFilter[]{new QFilter("id", "in", lstId)});
        for (DynamicObject billType : col) {
            if (billType == null) continue;
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(billType.getPkValue()));
            item.setCaption(new LocaleString(billType.getString("name")));
            item.setValue(String.valueOf(billType.getPkValue()));
            combos.add(item);
        }
        cacheString = SerializationUtils.toJsonString(combos);
        this.getPageCache().put(CACHEKEY_ORGCOMBOITEMS, cacheString);
        return combos;
    }
}

