/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.accounttreat;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.occ.ocpos.business.fundhelper.AutoPaymentBillHelper;
import kd.occ.ocpos.common.util.OwnerUtil;

public class AdjustmentBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private Long storeId = 0L;
    private static final String IMPORTUNITY = "importentry";
    private static final String CK_ADJUST = "adjust";
    public static final String BOS_LIST = "bos_listf7";
    private static final Log log = LogFactory.getLog(AdjustmentBillPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit cashierEdit = (BasedataEdit)this.getView().getControl("processor");
        cashierEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit store = (BasedataEdit)this.getView().getControl("store");
        store.addBeforeF7SelectListener(a -> {
            ListShowParameter formShowParameter = (ListShowParameter)a.getFormShowParameter();
            List branchIdList = OwnerUtil.getOwnerIds((String[])new String[0]);
            formShowParameter.setFormId(BOS_LIST);
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("Id", "in", (Object)branchIdList));
        });
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject user;
        DynamicObjectCollection part;
        long userId = UserServiceHelper.getCurrentUserId();
        QFilter filter = new QFilter("sysuser", "=", (Object)userId);
        filter.and("enable", "=", (Object)"1");
        filter.and("isdefault", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection channelusers = QueryServiceHelper.query((String)"ocdbd_channeluser", (String)"id, owner, iscashier, sysuser", (QFilter[])filter.toArray());
        if (channelusers.size() > 0) {
            this.storeId = ((DynamicObject)channelusers.get(0)).getLong("owner");
            boolean isCashier = ((DynamicObject)channelusers.get(0)).getBoolean("iscashier");
            if (isCashier) {
                this.getModel().setValue("processor", (Object)((DynamicObject)channelusers.get(0)).getLong("id"));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(part = (user = BusinessDataServiceHelper.loadSingle((Object)userId, (String)"bos_user")).getDynamicObjectCollection("entryentity")))) {
            this.getModel().setValue("processpart", (Object)((DynamicObject)part.get(0)).getDynamicObject("dpt"));
        }
        this.initStoreAndDate(0);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        int row = e.getRowDataEntities()[0].getRowIndex();
        this.initStoreAndDate(row);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        if (e.getProperty().getName().equals("processor") && this.storeId != 0L) {
            QFilter enableFilter = new QFilter("owner", "=", (Object)this.storeId);
            enableFilter.and("iscashier", "=", (Object)Boolean.TRUE);
            listShowParameter.getListFilterParameter().setFilter(enableFilter);
        }
    }

    private void initStoreAndDate(int row) {
        QFilter filter = new QFilter("sysuser", "=", (Object)UserServiceHelper.getCurrentUserId());
        filter.and("enable", "=", (Object)"1");
        filter.and("isdefault", "=", (Object)Boolean.TRUE);
        DynamicObject channelUser = BusinessDataServiceHelper.loadSingle((String)"ocdbd_channeluser", (String)"owner", (QFilter[])filter.toArray());
        if (channelUser != null) {
            DynamicObject owner = channelUser.getDynamicObject("owner");
            this.getModel().setValue("store", (Object)owner, row);
            DynamicObject store = BusinessDataServiceHelper.loadSingle((Object)owner.getPkValue(), (String)"ocdbd_channel");
            this.getModel().setValue("currency", (Object)store.getDynamicObject("currency"), row);
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        this.getModel().setValue("adjustdate", (Object)dataEntity.getDate("bizdate"), row);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        DynamicObjectCollection adjustEntry;
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        String operateKey = op.getOperateKey();
        if (operateKey.equals(IMPORTUNITY)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("ocpos_importadjust");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CK_ADJUST));
            this.getView().showForm(formShowParameter);
        }
        if (!CollectionUtils.isEmpty((Collection)(adjustEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("adjustentry")))) {
            try {
                AutoPaymentBillHelper.handlerAdjustmentBill((String)operateKey, (DynamicObjectCollection)adjustEntry, (IFormView)this.getView());
            }
            catch (Exception exception) {
                log.error(String.format("\u81ea\u5b9a\u4e49\u5f02\u5e38,\u5f02\u5e38\u6d88\u606f\uff1a%s", exception.getMessage()));
                e.setCancel(true);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        List importList;
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)CK_ADJUST) && !CollectionUtils.isEmpty((Collection)(importList = (List)e.getReturnData()))) {
            DynamicObjectCollection receiptEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("adjustentry");
            int index = receiptEntry.size();
            for (JSONObject importInfo : importList) {
                DynamicObject newEntryRow = receiptEntry.addNew();
                newEntryRow.set("seq", (Object)index++);
                newEntryRow.set("outpaytype", importInfo.get((Object)"outpaytype"));
                newEntryRow.set("inpaytype", importInfo.get((Object)"inpaytype"));
                newEntryRow.set("store", importInfo.get((Object)"store"));
                newEntryRow.set("currency", importInfo.get((Object)"currency"));
                newEntryRow.set("adjustdate", importInfo.get((Object)"adjustdate"));
                newEntryRow.set("outamount", importInfo.get((Object)"outamount"));
                newEntryRow.set("adjustcomment", importInfo.get((Object)"adjustcomment"));
            }
            this.getView().updateView("adjustentry");
        }
    }
}

