/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.accounttreat;

import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.occ.ocpos.common.util.DynamicObjectUtil;

public class ImportAdjustEntryPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final int ENTRYFIELDSNUM_MAX = 11;
    private static final int ENTRYFIELDSNUM_MIN = 7;

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"downloadtpl"});
        this.addClickListeners(new String[]{"btnok"});
        Button uploaddata = (Button)this.getControl("uploaddata");
        uploaddata.addUploadListener((UploadListener)this);
    }

    public void click(EventObject e) {
        String key;
        super.click(e);
        Control source = (Control)e.getSource();
        switch (key = source.getKey()) {
            case "downloadtpl": {
                this.downExcelTpl();
                break;
            }
            case "btnok": {
                this.handleBtnokEvent();
                break;
            }
        }
    }

    public void afterUpload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls != null && urls.length > 0) {
            String fileUrl = urls[0].toString();
            this.loadXLSXFile(fileUrl);
        }
    }

    private void handleBtnokEvent() {
        DynamicObjectCollection import_entryentity = this.getModel().getEntryEntity("entryentity");
        DynamicObject receipt = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ocpos_adjustment"));
        ArrayList<JSONObject> importList = new ArrayList<JSONObject>();
        int index = 0;
        try {
            for (DynamicObject importInfo : import_entryentity) {
                ++index;
                String outpaytypeNum = importInfo.getString("outpaytypeid");
                String inpaytypeNum = importInfo.getString("inpaytypeid");
                String storeNum = importInfo.getString("storeid");
                String currencyNum = importInfo.getString("currencyid");
                QFilter qFilter = new QFilter("number", "=", (Object)outpaytypeNum);
                DynamicObject outpaytype = BusinessDataServiceHelper.loadSingle((String)"ocdbd_paywaytype", (String)"id", (QFilter[])qFilter.toArray());
                Long outpaytypeId = DynamicObjectUtil.getLong((DynamicObject)outpaytype, (String)"id");
                qFilter = new QFilter("number", "=", (Object)inpaytypeNum);
                DynamicObject inpaytype = BusinessDataServiceHelper.loadSingle((String)"ocdbd_paywaytype", (String)"id", (QFilter[])qFilter.toArray());
                Long inpaytypeId = DynamicObjectUtil.getLong((DynamicObject)inpaytype, (String)"id");
                qFilter = new QFilter("number", "=", (Object)storeNum);
                DynamicObject store = BusinessDataServiceHelper.loadSingle((String)"ocdbd_channel", (String)"id", (QFilter[])qFilter.toArray());
                Long storeId = DynamicObjectUtil.getLong((DynamicObject)store, (String)"id");
                qFilter = new QFilter("number", "=", (Object)currencyNum);
                DynamicObject currency = BusinessDataServiceHelper.loadSingle((String)"bd_currency", (String)"id", (QFilter[])qFilter.toArray());
                Long currencyId = DynamicObjectUtil.getLong((DynamicObject)currency, (String)"id");
                Date adjustDate = importInfo.getDate("adjustdate");
                BigDecimal outAmount = importInfo.getBigDecimal("outamount");
                String adjustComment = importInfo.getString("adjustcomment");
                JSONObject temp = new JSONObject();
                temp.put("outpaytype", (Object)outpaytype);
                temp.put("outpaytypeid", (Object)outpaytypeId);
                temp.put("inpaytype", (Object)inpaytype);
                temp.put("inpaytypeid", (Object)inpaytypeId);
                temp.put("store", (Object)store);
                temp.put("storeid", (Object)storeId);
                temp.put("currency", (Object)currency);
                temp.put("currencyid", (Object)currencyId);
                temp.put("adjustdate", (Object)adjustDate);
                temp.put("outamount", (Object)outAmount);
                temp.put("adjustcomment", (Object)adjustComment);
                importList.add(temp);
            }
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)("\u7b2c" + index + "\u884c\u5bfc\u5165\u6570\u636e\u683c\u5f0f\u4e0e\u6a21\u7248\u4e0d\u7b26\u5408\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\u5bfc\u5165\u6570\u636e\u683c\u5f0f\u3002"), (String)"ImportReceiptEntryPlugin", (String)"occ-ocpos-formplugin", (Object[])new Object[0]));
        }
        this.getView().returnDataToParent(importList);
        this.getView().close();
    }

    private void loadXLSXFile(String fileUrl) {
        ExcelReader reader = new ExcelReader();
        FileService service = FileServiceFactory.getAttachmentFileService();
        final ArrayList realData = new ArrayList();
        final HashSet setSn = new HashSet();
        try {
            reader.read(service.getInputStream(fileUrl), new SheetHandler(){
                private boolean isOldModel = false;

                public void handleRow(SheetHandler.ParsedRow paramParsedRow) {
                    int rowNum = paramParsedRow.getRowNum() + 1;
                    if (rowNum == 1 || rowNum == 2 || rowNum == 3) {
                        return;
                    }
                    if (rowNum == 4 && !this.isOldModel) {
                        return;
                    }
                    Map mapData = paramParsedRow.getData();
                    String value = (String)mapData.get(0);
                    if (value.isEmpty()) {
                        return;
                    }
                    setSn.add(value);
                    realData.add(mapData);
                }
            });
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        this.getModel().getDataEntity(true);
        this.getModel().beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("storeid", new Object[0]);
        vs.addField("store", new Object[0]);
        vs.addField("adjustdate", new Object[0]);
        vs.addField("outpaytypeid", new Object[0]);
        vs.addField("outpaytype", new Object[0]);
        vs.addField("inpaytypeid", new Object[0]);
        vs.addField("inpaytype", new Object[0]);
        vs.addField("currencyid", new Object[0]);
        vs.addField("currency", new Object[0]);
        vs.addField("outamount", new Object[0]);
        vs.addField("adjustcomment", new Object[0]);
        for (int i = 0; i < realData.size(); ++i) {
            Map realDataMap = (Map)realData.get(i);
            if (realDataMap.size() > 11 || realDataMap.size() < 7) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u683c\u5f0f\u4e0e\u6a21\u7248\u4e0d\u7b26\u5408\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\u5bfc\u5165\u6570\u636e\u683c\u5f0f\u3002", (String)"ImportReceiptEntryPlugin", (String)"occ-ocpos-formplugin", (Object[])new Object[0]));
            }
            vs.addRow(new Object[]{((Map)realData.get(i)).get(0), ((Map)realData.get(i)).get(1), ((Map)realData.get(i)).get(2), ((Map)realData.get(i)).get(5), ((Map)realData.get(i)).get(6), ((Map)realData.get(i)).get(3), ((Map)realData.get(i)).get(4), ((Map)realData.get(i)).get(7), ((Map)realData.get(i)).get(8), ((Map)realData.get(i)).get(9), ((Map)realData.get(i)).get(10)});
        }
        AbstractFormDataModel abstractFormDataModel = (AbstractFormDataModel)this.getModel();
        abstractFormDataModel.batchCreateNewEntryRow("entryentity", vs);
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    private void downExcelTpl() {
        String url;
        String billFormId = "ocpos_modeladjust";
        String extendData = null;
        String t = "1168860564173127680";
        LocalDate now = LocalDate.now();
        String ctxPath = RequestContext.get().getClientFullContextPath();
        DynamicObject templateData = BusinessDataServiceHelper.loadSingle((Object)t, (String)"bos_importtemplate");
        String fileName = "\u9884\u7f6e_" + templateData.get("name");
        try {
            url = ctxPath + (ctxPath.endsWith("/") ? "" : "/") + "form/export.do?templateid=" + t + "&formid=" + billFormId + "&plugin=&filename=" + URLEncoder.encode(fileName + "_" + String.format("%02d", now.getMonthValue()) + String.format("%02d", now.getDayOfMonth()) + ".xlsx", StandardCharsets.UTF_8.name()) + "&extenddata=" + extendData + "&routeappid=" + this.getView().getFormShowParameter().getServiceAppId() + "&a=t";
        }
        catch (UnsupportedEncodingException e) {
            throw new KDBizException(e.getMessage());
        }
        this.getView().download(url);
        this.getView().sendFormAction(this.getView());
    }
}

