/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.accounttreat;

import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.common.util.DynamicObjectUtil;

public class ImportReceiptEntryPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final int ENTRYFIELDSNUM_MAX = 10;
    private static final int ENTRYFIELDSNUM_MIN = 6;

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"downloadtpl"});
        this.addClickListeners(new String[]{"btnok"});
        Button uploaddata = (Button)this.getControl("uploaddata");
        uploaddata.addUploadListener((UploadListener)this);
    }

    public void click(EventObject e) {
        String key;
        super.click(e);
        Control source = (Control)e.getSource();
        switch (key = source.getKey()) {
            case "downloadtpl": {
                this.downExcelTpl();
                break;
            }
            case "btnok": {
                this.handleConfirmEvent();
                break;
            }
        }
    }

    public void afterUpload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls != null && urls.length > 0) {
            String fileUrl = urls[0].toString();
            this.loadFile(fileUrl);
        }
    }

    private void handleConfirmEvent() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        DynamicObject receipt = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ocpos_receipt"));
        ArrayList<JSONObject> importList = new ArrayList<JSONObject>();
        int index = 0;
        try {
            for (DynamicObject importInfo : entryEntity) {
                ++index;
                String payTypeNum = importInfo.getString("paytypeid");
                String storeNum = importInfo.getString("storeid");
                String currencyNum = importInfo.getString("currencyid");
                QFilter qFilter = new QFilter("number", "=", (Object)payTypeNum);
                DynamicObject payType = BusinessDataServiceHelper.loadSingle((String)"ocdbd_paywaytype", (String)"id", (QFilter[])qFilter.toArray());
                long payTypeId = DynamicObjectUtil.getLong((DynamicObject)payType, (String)"id");
                qFilter = new QFilter("number", "=", (Object)storeNum);
                DynamicObject store = BusinessDataServiceHelper.loadSingle((String)"ocdbd_channel", (String)"id", (QFilter[])qFilter.toArray());
                long storeId = DynamicObjectUtil.getLong((DynamicObject)store, (String)"id");
                qFilter = new QFilter("number", "=", (Object)currencyNum);
                DynamicObject currency = BusinessDataServiceHelper.loadSingle((String)"bd_currency", (String)"id", (QFilter[])qFilter.toArray());
                long currencyId = DynamicObjectUtil.getLong((DynamicObject)currency, (String)"id");
                Date receiptDate = importInfo.getDate("receiptdate");
                BigDecimal receiptAmount = importInfo.getBigDecimal("receiptamount");
                BigDecimal serviceAmount = importInfo.getBigDecimal("serviceamount");
                String receiptComment = importInfo.getString("receiptcomment");
                JSONObject temp = new JSONObject();
                temp.put("paytype", (Object)payType);
                temp.put("store", (Object)store);
                temp.put("currency", (Object)currency);
                temp.put("paytypeid", (Object)payTypeId);
                temp.put("storeid", (Object)storeId);
                temp.put("currencyid", (Object)currencyId);
                temp.put("receiptdate", (Object)receiptDate);
                temp.put("receiptamount", (Object)receiptAmount);
                temp.put("serviceamount", (Object)serviceAmount);
                temp.put("receiptcomment", (Object)receiptComment);
                importList.add(temp);
            }
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)("\u7b2c" + index + "\u884c\u5bfc\u5165\u6570\u636e\u683c\u5f0f\u4e0e\u6a21\u7248\u4e0d\u7b26\u5408\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\u5bfc\u5165\u6570\u636e\u683c\u5f0f\u3002"), (String)"ImportReceiptEntryPlugin", (String)"occ-ocpos-formplugin", (Object[])new Object[0]));
        }
        this.getView().returnDataToParent(importList);
        this.getView().close();
    }

    private void loadFile(String fileUrl) {
        ExcelReader reader = new ExcelReader();
        FileService service = FileServiceFactory.getAttachmentFileService();
        final ArrayList realData = new ArrayList();
        final HashSet setSn = new HashSet();
        final HashMap repeat = new HashMap(0);
        try {
            reader.read(service.getInputStream(fileUrl), new SheetHandler(){

                public void handleRow(SheetHandler.ParsedRow paramParsedRow) {
                    int rowNum = paramParsedRow.getRowNum() + 1;
                    if (rowNum == 1 || rowNum == 2 || rowNum == 3 || rowNum == 4) {
                        return;
                    }
                    Map mapData = paramParsedRow.getData();
                    String payType = (String)mapData.get(0);
                    String date = (String)mapData.get(2);
                    String storeNumber = (String)mapData.get(3);
                    if (payType.isEmpty()) {
                        return;
                    }
                    String repeatString = payType + date + storeNumber;
                    if (setSn.contains(repeatString)) {
                        repeat.put(rowNum, repeatString);
                        return;
                    }
                    setSn.add(repeatString);
                    realData.add(mapData);
                }
            });
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        this.getModel().getDataEntity(true);
        this.getModel().beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("paytypeid", new Object[0]);
        vs.addField("paytype", new Object[0]);
        vs.addField("receiptdate", new Object[0]);
        vs.addField("storeid", new Object[0]);
        vs.addField("store", new Object[0]);
        vs.addField("currencyid", new Object[0]);
        vs.addField("currency", new Object[0]);
        vs.addField("receiptamount", new Object[0]);
        vs.addField("serviceamount", new Object[0]);
        vs.addField("receiptcomment", new Object[0]);
        for (Map realDataMap : realData) {
            if (realDataMap.size() > 10 || realDataMap.size() < 6) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u683c\u5f0f\u4e0e\u6a21\u7248\u4e0d\u7b26\u5408\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\u5bfc\u5165\u6570\u636e\u683c\u5f0f\u3002", (String)"ImportReceiptEntryPlugin", (String)"occ-ocpos-formplugin", (Object[])new Object[0]));
            }
            vs.addRow(new Object[]{realDataMap.get(0), realDataMap.get(1), realDataMap.get(2), realDataMap.get(3), realDataMap.get(4), realDataMap.get(5), realDataMap.get(6), realDataMap.get(7), realDataMap.get(8), realDataMap.get(9)});
            if (repeat.isEmpty()) continue;
            NotificationUtil.showDefaultTipNotify((String)"\u5f15\u5165\u6709\u91cd\u590d\u6570\u636e\u3002\u76f8\u540c\u95e8\u5e97\u76f8\u540c\u65e5\u671f\u76f8\u540c\u6536\u6b3e\u65b9\u5f0f\u7c7b\u578b\u53ea\u5141\u8bb8\u7ef4\u62a4\u4e00\u6761\u6570\u636e", (IFormView)this.getView());
        }
        AbstractFormDataModel abstractFormDataModel = (AbstractFormDataModel)this.getModel();
        abstractFormDataModel.batchCreateNewEntryRow("entryentity", vs);
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    private void downExcelTpl() {
        String url;
        String billFormId = "ocpos_modelreceipt";
        String extendData = null;
        String t = "1168860800731873280";
        LocalDate now = LocalDate.now();
        String ctxPath = RequestContext.get().getClientFullContextPath();
        DynamicObject templateData = BusinessDataServiceHelper.loadSingle((Object)t, (String)"bos_importtemplate");
        String fileName = "\u9884\u7f6e_" + templateData.get("name");
        try {
            url = ctxPath + (ctxPath.endsWith("/") ? "" : "/") + "form/export.do?templateid=" + t + "&formid=" + billFormId + "&plugin=&filename=" + URLEncoder.encode(fileName + "_" + String.format("%02d", now.getMonthValue()) + String.format("%02d", now.getDayOfMonth()) + ".xlsx", StandardCharsets.UTF_8.name()) + "&extenddata=" + extendData + "&routeappid=" + this.getView().getFormShowParameter().getServiceAppId() + "&a=t";
        }
        catch (UnsupportedEncodingException e) {
            throw new KDBizException(e.getMessage());
        }
        this.getView().download(url);
        this.getView().sendFormAction(this.getView());
    }
}

