/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.accounttreat;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.occ.ocbase.common.util.PosItemUtil;
import kd.occ.ocpos.business.commonhelper.CurrencyHelper;
import kd.occ.ocpos.common.saleorder.CommonUtils;
import kd.occ.ocpos.common.util.DynamicObjectUtil;
import kd.occ.ocpos.common.util.OwnerUtil;

public class NoBusinessBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public static final String BOS_LIST = "bos_listf7";
    private static final String CURRENCY = "currency";
    private static final String ADD_ROW = "addrow";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit cashierEdit = (BasedataEdit)this.getView().getControl("receiver");
        cashierEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit store = (BasedataEdit)this.getView().getControl("branch");
        store.addBeforeF7SelectListener(a -> {
            ListShowParameter formShowParameter = (ListShowParameter)a.getFormShowParameter();
            List branchIdList = OwnerUtil.getOwnerIds((String[])new String[0]);
            formShowParameter.setFormId(BOS_LIST);
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("Id", "in", (Object)branchIdList));
        });
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject user;
        DynamicObjectCollection part;
        long userId = UserServiceHelper.getCurrentUserId();
        QFilter filter = new QFilter("sysuser", "=", (Object)userId);
        filter.and("enable", "=", (Object)"1");
        filter.and("isdefault", "=", (Object)Boolean.TRUE);
        DynamicObject channelUser = BusinessDataServiceHelper.loadSingle((String)"ocdbd_channeluser", (String)"id, owner, iscashier, sysuser", (QFilter[])filter.toArray());
        if (channelUser != null) {
            DynamicObject owner = channelUser.getDynamicObject("owner");
            this.getModel().setValue("branch", (Object)owner);
            DynamicObject store = BusinessDataServiceHelper.loadSingle((Object)owner.getPkValue(), (String)"ocdbd_channel");
            DynamicObject currency = DynamicObjectUtil.getDynamicObject((DynamicObject)store, (String)CURRENCY);
            boolean isCashier = channelUser.getBoolean("iscashier");
            if (isCashier) {
                this.getModel().setValue("receiver", (Object)channelUser);
            }
            this.getModel().setValue("org", (Object)store.getDynamicObject("saleorg"));
            if (currency != null) {
                this.getModel().setValue(CURRENCY, (Object)currency);
                this.getModel().setValue("paycurrency", (Object)currency, 0);
                this.getModel().setValue("basecurrency", (Object)this.getLocalCurrency(), 0);
                this.getModel().setValue("paydate", this.getModel().getValue("bizdate"), 0);
            }
        }
        if (CollectionUtils.isEmpty((Collection)(part = (user = BusinessDataServiceHelper.loadSingle((Object)userId, (String)"bos_user")).getDynamicObjectCollection("entryentity")))) {
            this.getModel().setValue("paypart", (Object)((DynamicObject)part.get(0)).getDynamicObject("dpt"));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        int row = changeSet[0].getRowIndex();
        switch (key) {
            case "payamount": {
                this.calculateBaseCurrency(row);
                this.updateAllAmount();
                break;
            }
            case "basecurrency": 
            case "paycurrency": {
                this.calculateBaseCurrency(row);
                break;
            }
            case "branch": {
                this.getView().getModel().deleteEntryData("nobusinessentry");
                break;
            }
            case "item": {
                this.queryItemInfo(row);
                break;
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String entry = e.getEntryProp().getName();
        if ("nobusinessentry".equals(entry)) {
            this.updateAllAmount();
        }
    }

    private void updateAllAmount() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("nobusinessentry");
        BigDecimal sum = entryEntity.stream().map(a -> DynamicObjectUtil.getBigDecimal((DynamicObject)a, (String)"payamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.getModel().setValue("allamount", (Object)sum);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        String key = op.getOperateKey();
        if (key.equals(ADD_ROW)) {
            Date payDate;
            int rowIndex = this.getModel().createNewEntryRow("nobusinessentry");
            DynamicObject currency = (DynamicObject)this.getModel().getValue(CURRENCY);
            if (currency != null) {
                this.getModel().setValue("paycurrency", (Object)currency, rowIndex);
                this.getModel().setValue("basecurrency", (Object)this.getLocalCurrency(), rowIndex);
            }
            if ((payDate = (Date)this.getModel().getValue("bizdate")) != null) {
                this.getModel().setValue("paydate", (Object)payDate, rowIndex);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        DynamicObject store;
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        if (e.getProperty().getName().equals("receiver") && (store = (DynamicObject)this.getModel().getValue("branch")) != null) {
            Long storeId = (Long)store.getPkValue();
            QFilter enableFilter = new QFilter("owner", "=", (Object)storeId);
            enableFilter.and("iscashier", "=", (Object)Boolean.TRUE);
            listShowParameter.getListFilterParameter().setFilter(enableFilter);
        }
    }

    private DynamicObject getLocalCurrency() {
        DynamicObject doUseOrg = this.getModel().getDataEntity(true).getDynamicObject("org");
        long orgId = DynamicObjectUtil.getPkValue((DynamicObject)doUseOrg);
        if (orgId <= 0L) {
            return null;
        }
        return CurrencyHelper.getCurrency((Long)orgId);
    }

    private void calculateBaseCurrency(int row) {
        DynamicObject payCurrency = (DynamicObject)this.getModel().getValue("paycurrency", row);
        long payCurrencyId = DynamicObjectUtil.getLong((DynamicObject)payCurrency, (String)"id");
        DynamicObject baseCurrency = (DynamicObject)this.getModel().getValue("basecurrency", row);
        long baseCurrencyId = DynamicObjectUtil.getLong((DynamicObject)baseCurrency, (String)"id");
        BigDecimal payAmount = (BigDecimal)this.getModel().getValue("payamount", row);
        if (payCurrencyId != 0L && baseCurrencyId != 0L && payAmount.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal currencyRate = CommonUtils.getCurrencyRate((long)payCurrencyId, (long)baseCurrencyId);
            if (currencyRate.compareTo(BigDecimal.ZERO) == 0) {
                this.getModel().setValue("baseamount", (Object)payAmount, row);
            } else {
                BigDecimal baseAmout = payAmount.multiply(currencyRate);
                this.getModel().setValue("baseamount", (Object)baseAmout, row);
            }
        }
    }

    private void queryItemInfo(int row) {
        DynamicObject item = (DynamicObject)this.getModel().getValue("item", row);
        if (item != null) {
            DynamicObject itemClass;
            DynamicObject brand = DynamicObjectUtil.getDynamicObject((DynamicObject)item, (String)"itembrands");
            if (brand != null) {
                this.getModel().setValue("itembrandid", (Object)brand);
            }
            if ((itemClass = PosItemUtil.queryItemClass((DynamicObject)item)) != null) {
                this.getModel().setValue("itemclassid", (Object)itemClass);
            }
        }
    }
}

