/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.accounttreat;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocdbd.business.helper.pos.PaymentBillHelper;
import kd.occ.ocpos.common.util.OwnerUtil;

public class PaymentAutoBillFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String STORE = "store";
    public static final String BOS_LIST = "bos_listf7";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"button"});
        BasedataEdit store = (BasedataEdit)this.getView().getControl(STORE);
        store.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        long currentUserId = UserServiceHelper.getCurrentUserId();
        QFilter filter = new QFilter("sysuser", "=", (Object)currentUserId);
        filter.and("enable", "=", (Object)"1");
        filter.and("isdefault", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject channelUser = QueryServiceHelper.queryOne((String)"ocdbd_channeluser", (String)"owner", (QFilter[])filters);
        if (channelUser != null) {
            this.getModel().setValue(STORE, channelUser.get("owner"));
        }
    }

    public void click(EventObject e) {
        super.click(e);
        Control source = (Control)e.getSource();
        if ("button".equals(source.getKey())) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObject store = dataEntity.getDynamicObject(STORE);
            Date date = dataEntity.getDate("date");
            if (store != null && date != null) {
                PaymentBillHelper.autoPaymentBill((long)DynamicObjectUtils.getPkValue((DynamicObject)store), (Date)date);
                this.getView().close();
            } else {
                this.getView().showErrorNotification("\u95e8\u5e97\u4e0e\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String property = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if (STORE.equals(property)) {
            List branchIdList = OwnerUtil.getOwnerIds((String[])new String[0]);
            showParameter.setFormId(BOS_LIST);
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("Id", "in", (Object)branchIdList));
        }
    }
}

