/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.accounttreat;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocdbd.business.helper.pos.QueryFundsHelper;
import kd.occ.ocpos.business.fundhelper.AutoPaymentBillHelper;
import kd.occ.ocpos.common.saleorder.CommonUtils;
import kd.occ.ocpos.common.util.DynamicObjectUtil;
import kd.occ.ocpos.common.util.OwnerUtil;

public class PaymentBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public static final String BOS_LIST = "bos_listf7";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit payer = (BasedataEdit)this.getView().getControl("payer");
        payer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit payType = (BasedataEdit)this.getView().getControl("paytype");
        payType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bankAccount = (BasedataEdit)this.getView().getControl("bankaccountid");
        bankAccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit store = (BasedataEdit)this.getView().getControl("paystore");
        store.addBeforeF7SelectListener(a -> {
            ListShowParameter formShowParameter = (ListShowParameter)a.getFormShowParameter();
            List branchIdList = OwnerUtil.getOwnerIds((String[])new String[0]);
            formShowParameter.setFormId(BOS_LIST);
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("Id", "in", (Object)branchIdList));
        });
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject user;
        DynamicObjectCollection part;
        long userId = UserServiceHelper.getCurrentUserId();
        QFilter filter = new QFilter("sysuser", "=", (Object)userId);
        filter.and("enable", "=", (Object)"1");
        filter.and("isdefault", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject channelUser = BusinessDataServiceHelper.loadSingle((String)"ocdbd_channeluser", (String)"id, owner, iscashier, sysuser", (QFilter[])filters);
        if (channelUser != null) {
            DynamicObject owner = channelUser.getDynamicObject("owner");
            this.getModel().setValue("paystore", (Object)owner);
            boolean isCashier = channelUser.getBoolean("iscashier");
            if (isCashier) {
                this.getModel().setValue("payer", (Object)channelUser);
            }
            DynamicObject store = BusinessDataServiceHelper.loadSingle((Object)owner.getPkValue(), (String)"ocdbd_channel");
            this.getModel().setValue("org", (Object)store.getDynamicObject("saleorg"));
            DynamicObjectCollection paymentEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("paymententry");
            if (!CollectionUtils.isEmpty((Collection)paymentEntry)) {
                QueryFundsHelper.showBankAccount((DynamicObject)((DynamicObject)paymentEntry.get(0)), (long)DynamicObjectUtils.getPkValue((DynamicObject)owner), (long)0L);
                this.getView().updateView("depositenery");
            }
        }
        if (CollectionUtils.isEmpty((Collection)(part = (user = BusinessDataServiceHelper.loadSingle((Object)userId, (String)"bos_user")).getDynamicObjectCollection("entryentity")))) {
            this.getModel().setValue("paypart", (Object)((DynamicObject)part.get(0)).getDynamicObject("dpt"));
        }
        this.queryPayAmountRow(0);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        int row = changeSet[0].getRowIndex();
        switch (key) {
            case "paystore": 
            case "org": {
                this.getModel().deleteEntryData("paymententry");
                this.getModel().createNewEntryRow("paymententry");
                this.queryPayAmountAll();
                break;
            }
            case "paytype": 
            case "paymentdate": {
                this.queryPayAmountRow(row);
                break;
            }
            case "paycurrency": {
                BigDecimal samedaynopayamt;
                BigDecimal samedaypayamt;
                DynamicObject oldCurrency = (DynamicObject)e.getChangeSet()[0].getOldValue();
                DynamicObject newCurrency = (DynamicObject)e.getChangeSet()[0].getNewValue();
                if (oldCurrency == null || newCurrency == null) break;
                Long oldCurrencyId = (Long)oldCurrency.getPkValue();
                Long newCurrencyId = (Long)newCurrency.getPkValue();
                BigDecimal currencyRate = CommonUtils.getCurrencyRate((long)oldCurrencyId, (long)newCurrencyId);
                if (currencyRate.compareTo(BigDecimal.ZERO) == 0) {
                    currencyRate = BigDecimal.ONE;
                }
                if ((samedaypayamt = (BigDecimal)this.getModel().getValue("samedaypayamt", row)) != null) {
                    this.getModel().setValue("samedaypayamt", (Object)samedaypayamt.multiply(currencyRate), row);
                }
                if ((samedaynopayamt = (BigDecimal)this.getModel().getValue("samedaynopayamt", row)) == null) break;
                this.getModel().setValue("samedaynopayamt", (Object)samedaynopayamt.multiply(currencyRate), row);
                break;
            }
            case "depositamt": {
                DynamicObject paymentEntry = (DynamicObject)changeSet[0].getDataEntity().getParent();
                DynamicObjectCollection depositEntry = paymentEntry.getDynamicObjectCollection("depositenery");
                BigDecimal depositAmt = BigDecimal.ZERO;
                for (DynamicObject depositInfo : depositEntry) {
                    BigDecimal tempDeposit = depositInfo.getBigDecimal("depositamt");
                    depositAmt = depositAmt.add(tempDeposit);
                }
                paymentEntry.set("curbizfundamt", (Object)depositAmt);
                paymentEntry.set("todaybalapayamt", (Object)QueryFundsHelper.queryTodayBalancePayAmount((DynamicObject)paymentEntry));
                this.getView().updateView("curbizfundamt", changeSet[0].getParentRowIndex());
                this.getView().updateView("todaybalapayamt", changeSet[0].getParentRowIndex());
                paymentEntry.set("diffpatmentamt", (Object)QueryFundsHelper.queryDifferencePayment((DynamicObject)paymentEntry));
                this.getView().updateView("diffpatmentamt", changeSet[0].getParentRowIndex());
                break;
            }
            case "depositnoamt": {
                DynamicObject paymentEntry = (DynamicObject)changeSet[0].getDataEntity().getParent();
                DynamicObjectCollection depositEntry = paymentEntry.getDynamicObjectCollection("depositenery");
                BigDecimal depositNoAmt = BigDecimal.ZERO;
                for (DynamicObject depositInfo : depositEntry) {
                    BigDecimal tempDeposit = depositInfo.getBigDecimal("depositnoamt");
                    depositNoAmt = depositNoAmt.add(tempDeposit);
                }
                paymentEntry.set("curbiznofundamt", (Object)depositNoAmt);
                paymentEntry.set("todaybalapayamt", (Object)QueryFundsHelper.queryTodayBalancePayAmount((DynamicObject)paymentEntry));
                this.getView().updateView("curbiznofundamt", changeSet[0].getParentRowIndex());
                this.getView().updateView("todaybalapayamt", changeSet[0].getParentRowIndex());
                paymentEntry.set("diffpatmentamt", (Object)QueryFundsHelper.queryDifferencePayment((DynamicObject)paymentEntry));
                this.getView().updateView("diffpatmentamt", changeSet[0].getParentRowIndex());
                break;
            }
            case "beforedepositamt": {
                DynamicObject paymentEntry = (DynamicObject)changeSet[0].getDataEntity().getParent();
                DynamicObjectCollection depositEntry = paymentEntry.getDynamicObjectCollection("depositenery");
                BigDecimal beforeDepositAmt = BigDecimal.ZERO;
                for (DynamicObject depositInfo : depositEntry) {
                    BigDecimal tempDeposit = depositInfo.getBigDecimal("beforedepositamt");
                    beforeDepositAmt = beforeDepositAmt.add(tempDeposit);
                }
                paymentEntry.set("beforebalafundamt", (Object)beforeDepositAmt);
                paymentEntry.set("todaybalapayamt", (Object)QueryFundsHelper.queryTodayBalancePayAmount((DynamicObject)paymentEntry));
                this.getView().updateView("beforebalafundamt", changeSet[0].getParentRowIndex());
                this.getView().updateView("todaybalapayamt", changeSet[0].getParentRowIndex());
                break;
            }
        }
    }

    private void queryPayAmountAll() {
        DynamicObjectCollection paymentEntry = this.getModel().getEntryEntity("paymententry");
        DynamicObject payStore = (DynamicObject)this.getModel().getValue("paystore");
        for (int i = 0; i < paymentEntry.size(); ++i) {
            DynamicObject payType = (DynamicObject)this.getModel().getValue("paytype", i);
            Date paymentDate = (Date)this.getModel().getValue("paymentdate", i);
            if (payType != null && paymentDate != null && payStore != null) {
                this.queryPayAmountRow(i);
            }
            if (payStore == null) continue;
            QueryFundsHelper.showBankAccount((DynamicObject)((DynamicObject)paymentEntry.get(i)), (long)((Long)payStore.getPkValue()), (long)0L);
            this.getView().updateView("depositenery");
        }
    }

    private void queryPayAmountRow(int row) {
        DynamicObject paymentInfo;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject store = dataEntity.getDynamicObject("paystore");
        DynamicObject payType = ((DynamicObject)dataEntity.getDynamicObjectCollection("paymententry").get(row)).getDynamicObject("paytype");
        if (store != null) {
            DynamicObject currency = store.getDynamicObject("currency");
            this.getModel().setValue("paycurrency", (Object)currency, row);
        }
        Date paymentDate = dataEntity.getDate("paydate");
        this.getModel().setValue("paymentdate", (Object)paymentDate, row);
        if (payType != null && paymentDate != null && store != null) {
            this.queryCurrentDayPayAmount(row);
            this.queryNoBusiness(row);
            this.queryBeforeRetainAmount(row);
        }
        if (payType != null && (paymentInfo = (DynamicObject)dataEntity.getDynamicObjectCollection("paymententry").get(row)) != null) {
            DynamicObjectCollection depositEntry = DynamicObjectUtil.getDynamicObjectCollection((DynamicObject)paymentInfo, (String)"depositenery");
            for (DynamicObject depositInfo : depositEntry) {
                depositInfo.set("deposittype", (Object)payType);
            }
            this.getView().updateView("depositenery");
        }
    }

    private void queryBeforeRetainAmount(int row) {
        DynamicObject payStore = (DynamicObject)this.getModel().getValue("paystore");
        Date paymentDate = (Date)this.getModel().getValue("paymentdate", row);
        DynamicObject payType = (DynamicObject)this.getModel().getValue("paytype", row);
        long payStoreId = DynamicObjectUtils.getPkValue((DynamicObject)payStore);
        long payTypeId = DynamicObjectUtils.getPkValue((DynamicObject)payType);
        BigDecimal beforeRetainAmt = QueryFundsHelper.queryBeforeRetainAmount((long)payStoreId, (Date)paymentDate, (long)payTypeId);
        this.getModel().setValue("beforebalapayamt", (Object)beforeRetainAmt, row);
    }

    private void queryCurrentDayPayAmount(int row) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject payStore = dataEntity.getDynamicObject("paystore");
        Date paymentDate = (Date)this.getModel().getValue("paymentdate", row);
        DynamicObject payType = (DynamicObject)this.getModel().getValue("paytype", row);
        long payStoreId = DynamicObjectUtils.getPkValue((DynamicObject)payStore);
        long payTypeId = DynamicObjectUtils.getPkValue((DynamicObject)payType);
        BigDecimal resultAmount = QueryFundsHelper.queryCurrentDayPayAmount((long)payStoreId, (long)payTypeId, (Date)paymentDate);
        this.getModel().setValue("samedaypayamt", (Object)resultAmount, row);
        DynamicObject paymentInfo = (DynamicObject)this.getModel().getEntryEntity("paymententry").get(row);
        this.getModel().setValue("diffpatmentamt", (Object)QueryFundsHelper.queryDifferencePayment((DynamicObject)paymentInfo), row);
    }

    private void queryNoBusiness(int row) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject payStore = dataEntity.getDynamicObject("paystore");
        DynamicObject entry = (DynamicObject)dataEntity.getDynamicObjectCollection("paymententry").get(row);
        Date paymentDate = entry.getDate("paymentdate");
        DynamicObject payType = entry.getDynamicObject("paytype");
        DynamicObject currency = entry.getDynamicObject("paycurrency");
        long payStoreId = DynamicObjectUtils.getPkValue((DynamicObject)payStore);
        long payTypeId = DynamicObjectUtils.getPkValue((DynamicObject)payType);
        long currencyId = DynamicObjectUtils.getPkValue((DynamicObject)currency);
        BigDecimal noBusinessAmount = AutoPaymentBillHelper.queryNoBusinessAmount((long)payStoreId, (Date)paymentDate, (Long)payTypeId, (long)currencyId);
        this.getModel().setValue("samedaynopayamt", (Object)noBusinessAmount, row);
        DynamicObject paymentInfo = (DynamicObject)this.getModel().getEntryEntity("paymententry").get(row);
        this.getModel().setValue("diffpatmentamt", (Object)QueryFundsHelper.queryDifferencePayment((DynamicObject)paymentInfo), row);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        int rowIndex;
        super.afterDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        String key = op.getOperateKey();
        if (key.equals("addrow")) {
            rowIndex = this.getModel().createNewEntryRow("paymententry");
            DynamicObject store = (DynamicObject)this.getModel().getValue("paystore");
            if (store != null) {
                DynamicObject currency = store.getDynamicObject("currency");
                this.getModel().setValue("paycurrency", (Object)currency, rowIndex);
                DynamicObject paymentInfo = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("paymententry").get(rowIndex);
                QueryFundsHelper.showBankAccount((DynamicObject)paymentInfo, (long)((Long)store.getPkValue()), (long)0L);
                this.getView().updateView("depositenery");
            }
        }
        if (key.equals("newentrydeposit")) {
            rowIndex = this.getModel().createNewEntryRow("depositenery");
            DynamicObjectCollection depositEntry = this.getModel().getEntryEntity("depositenery");
            DynamicObject paymentInfo = (DynamicObject)depositEntry.getParent();
            DynamicObject payType = DynamicObjectUtil.getDynamicObject((DynamicObject)paymentInfo, (String)"paytype");
            this.getModel().setValue("deposittype", (Object)payType, rowIndex);
        }
        if (key.equals("deleteentrydeposit")) {
            DynamicObjectCollection depositEntry = this.getModel().getEntryEntity("depositenery");
            DynamicObject paymentInfo = (DynamicObject)depositEntry.getParent();
            BigDecimal depositamt = BigDecimal.ZERO;
            BigDecimal depositnoamt = BigDecimal.ZERO;
            BigDecimal beforedepositamt = BigDecimal.ZERO;
            for (DynamicObject depositInfo : depositEntry) {
                depositamt = depositamt.add(DynamicObjectUtil.getBigDecimal((DynamicObject)depositInfo, (String)"depositamt"));
                depositnoamt = depositnoamt.add(DynamicObjectUtil.getBigDecimal((DynamicObject)depositInfo, (String)"depositnoamt"));
                beforedepositamt = beforedepositamt.add(DynamicObjectUtil.getBigDecimal((DynamicObject)depositInfo, (String)"beforedepositamt"));
            }
            paymentInfo.set("curbizfundamt", (Object)depositamt);
            paymentInfo.set("curbiznofundamt", (Object)depositnoamt);
            paymentInfo.set("beforebalafundamt", (Object)beforedepositamt);
            paymentInfo.set("todaybalapayamt", (Object)QueryFundsHelper.queryTodayBalancePayAmount((DynamicObject)paymentInfo));
            paymentInfo.set("diffpatmentamt", (Object)QueryFundsHelper.queryDifferencePayment((DynamicObject)paymentInfo));
            this.getView().updateView("paymententry");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String name = e.getProperty().getName();
        if ("payer".equals(name)) {
            F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getPayerFilter());
        } else if ("paytype".equals(name)) {
            F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getPayTypeFilter(dataEntity));
        } else if ("bankaccountid".equals(name)) {
            F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getBankAccountFilter(dataEntity));
        }
    }

    private QFilter getPayerFilter() {
        DynamicObject store = (DynamicObject)this.getModel().getValue("paystore");
        QFilter enableFilter = null;
        if (store != null) {
            Long storeId = (Long)store.getPkValue();
            enableFilter = new QFilter("owner", "=", (Object)storeId);
            enableFilter.and("iscashier", "=", (Object)Boolean.TRUE);
        }
        return enableFilter;
    }

    private void deleteBeforeBill() {
        DynamicObject payStore = (DynamicObject)this.getModel().getValue("paystore");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Date paymentDate = (Date)this.getModel().getValue("paydate");
        if (payStore != null && org != null && paymentDate != null) {
            QFilter qFilter = new QFilter("paystore", "=", payStore.getPkValue());
            qFilter.and("org", "=", org.getPkValue());
            qFilter.and("paydate", "=", (Object)paymentDate);
            qFilter.and("id", "!=", this.getModel().getDataEntity().getPkValue());
            DeleteServiceHelper.delete((String)"ocpos_payment", (QFilter[])qFilter.toArray());
        }
    }

    private QFilter getPayTypeFilter(DynamicObject dataEntity) {
        DynamicObjectCollection row = dataEntity.getDynamicObjectCollection("paymententry");
        List payTypeList = row.stream().map(a -> DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject("paytype"))).collect(Collectors.toList());
        return new QFilter("id", "not in", payTypeList);
    }

    private QFilter getBankAccountFilter(DynamicObject dataEntity) {
        DynamicObject store = dataEntity.getDynamicObject("paystore");
        QFilter qFilter = new QFilter("store", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)store));
        DynamicObject bankAccount = BusinessDataServiceHelper.loadSingle((String)"ocdbd_bankaccountcfg", (String)"bankentry, bankentry.bank, bankentry.fundorg", (QFilter[])qFilter.toArray());
        if (bankAccount != null) {
            DynamicObjectCollection bankEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)bankAccount, (String)"bankentry");
            return new QFilter("id", "in", bankEntry.stream().map(a -> DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject("bank"))).collect(Collectors.toSet()));
        }
        return new QFilter("id", "in", (Object)0L);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        String key = op.getOperateKey();
        if (key.equals("save") || key.equals("submit")) {
            String billNoCopy;
            DynamicObject payStore = (DynamicObject)this.getModel().getValue("paystore");
            long payStoreId = DynamicObjectUtil.getLong((DynamicObject)payStore, (String)"id");
            Date date = (Date)this.getModel().getValue("paydate");
            QFilter qFilter = new QFilter("paystore", "=", (Object)payStoreId);
            qFilter.and("paydate", "=", (Object)date);
            DynamicObjectCollection result = QueryServiceHelper.query((String)"ocpos_payment", (String)"billno", (QFilter[])qFilter.toArray());
            String billNo = (String)this.getModel().getValue("billno");
            if (result.size() > 0 && !billNo.equals(billNoCopy = DynamicObjectUtil.getString((DynamicObject)((DynamicObject)result.get(0)), (String)"billno"))) {
                throw new KDBizException(ResManager.loadKDString((String)("\u5df2\u5b58\u5728\u5f53\u65e5\u95e8\u5e97\u7f34\u6b3e\u5355\uff1a" + billNoCopy), (String)"ocpos_payment", (String)"occ-ocpos-formplugin", (Object[])new Object[0]));
            }
            DynamicObjectCollection paymentEntry = this.getModel().getEntryEntity("paymententry");
            if (paymentEntry.size() < 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\"\u6536\u6b3e\u4fe1\u606f\"\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u91cd\u65b0\u7f16\u8f91", (String)"ocpos_payment", (String)"occ-ocpos-formplugin", (Object[])new Object[0]));
            }
            int i = 1;
            StringBuilder msg = new StringBuilder();
            for (DynamicObject payment : paymentEntry) {
                if (payment.getDynamicObject("paytype") == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u4fe1\u606f\u7b2c%s\u884c\u7684\"\u6536\u6b3e\u65b9\u5f0f\u7c7b\u578b\"\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u91cd\u65b0\u7f16\u8f91", (String)"PaymentBillPlugin", (String)"occ-ocpos-formplugin", (Object[])new Object[0]), i));
                }
                BigDecimal guestabjamt = payment.getBigDecimal("guestabjamt");
                if (guestabjamt.compareTo(BigDecimal.ZERO) != 0) {
                    DynamicObjectCollection paymentstring = payment.getDynamicObjectCollection("paymentstring");
                    int rowCount = paymentstring.getRowCount();
                    if (rowCount < 1) {
                        msg.append(String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u4fe1\u606f\u7b2c%s\u884c\u7684\"\u8c03\u6574\u660e\u7ec6\"\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u91cd\u65b0\u7f16\u8f91\u3002", (String)"PaymentBillPlugin", (String)"occ-ocpos-formplugin", (Object[])new Object[0]), i));
                        ++i;
                        continue;
                    }
                    BigDecimal allStringamout = BigDecimal.ZERO;
                    for (DynamicObject stringInfo : paymentstring) {
                        BigDecimal stringamount = stringInfo.getBigDecimal("stringamount");
                        allStringamout = allStringamout.add(stringamount);
                    }
                    if (allStringamout.compareTo(guestabjamt) != 0) {
                        msg.append(String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u4fe1\u606f\u7b2c%s\u884c\u7684\"\u8c03\u6574\u91d1\u989d\"\u4e0e\"\u8c03\u6574\u660e\u7ec6\u603b\u91d1\u989d\"\u4e0d\u76f8\u7b49,\u8bf7\u91cd\u65b0\u7f16\u8f91\u3002", (String)"PaymentBillPlugin", (String)"occ-ocpos-formplugin", (Object[])new Object[0]), i));
                        ++i;
                        continue;
                    }
                }
                ++i;
            }
            String showMsg = msg.toString();
            if (!StringUtils.isEmpty((String)showMsg)) {
                throw new KDBizException(showMsg);
            }
            this.deleteBeforeBill();
        }
    }
}

