/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.accounttreat;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.business.commonhelper.OrgHelper;
import kd.occ.ocpos.common.entity.PaymentEntity;

public class PaymentDetailFormPlugin
extends AbstractFormPlugin {
    private static final Log LOG = LogFactory.getLog(PaymentDetailFormPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"querybutton", "toltalpaystore", "unpaystore"});
        BasedataEdit org = (BasedataEdit)this.getView().getControl("org");
        String entityId = this.getView().getEntityId();
        org.addBeforeF7SelectListener(a -> {
            ListShowParameter showParameter = (ListShowParameter)a.getFormShowParameter();
            String orgViewType = OrgHelper.getOrgViewType();
            List orgList = OrgHelper.getHasPermissionOrg((String)entityId, (String)orgViewType);
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)orgList));
        });
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setDefaultValue();
        this.getView().setVisible(Boolean.FALSE, new String[]{"cardap", "channeap"});
        this.foldPanel(false);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        if ("querybutton".equals(source.getKey())) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            Date startDate = dataEntity.getDate("startdate");
            Date endDate = dataEntity.getDate("enddate");
            DynamicObjectCollection org = dataEntity.getDynamicObjectCollection("org");
            if (startDate == null) {
                NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u8f93\u5165\u5f00\u59cb\u65e5\u671f\u3002", (IFormView)this.getView());
                evt.setCancel(true);
            } else if (endDate == null) {
                NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u8f93\u5165\u7ed3\u675f\u65e5\u671f\u3002", (IFormView)this.getView());
                evt.setCancel(true);
            } else if (CollectionUtils.isEmpty((Collection)org)) {
                NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u8f93\u5165\u9500\u552e\u7ec4\u7ec7\u3002", (IFormView)this.getView());
                evt.setCancel(true);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        switch (source.getKey()) {
            case "querybutton": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"cardap"});
                this.foldPanel(true);
                this.setCardAp(dataEntity);
                break;
            }
            case "toltalpaystore": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"channeap"});
                List<DynamicObject> branchList = this.getSysParamPayment(dataEntity);
                entryEntity.clear();
                this.getView().setVisible(Boolean.FALSE, new String[]{"date"});
                for (DynamicObject branch : branchList) {
                    DynamicObject entry = entryEntity.addNew();
                    entry.set("branch", (Object)branch);
                }
                this.getView().updateView("entryentity");
                break;
            }
            case "unpaystore": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"channeap"});
                entryEntity.clear();
                DynamicObject[] paymentBranch = this.getPaymentBranch(dataEntity);
                ArrayList<PaymentEntity> payRecord = new ArrayList<PaymentEntity>(16);
                if (paymentBranch != null && paymentBranch.length > 0) {
                    for (DynamicObject entity : paymentBranch) {
                        DynamicObject payStore = entity.getDynamicObject("paystore");
                        Date date = entity.getDate("paydate");
                        long pkValue = DynamicObjectUtils.getPkValue((DynamicObject)payStore);
                        payRecord.add(new PaymentEntity(payStore, date, pkValue, true));
                    }
                }
                Date startDate = dataEntity.getDate("startdate");
                Date endDate = dataEntity.getDate("enddate");
                List<Date> dateRange = PaymentDetailFormPlugin.getDateRange(startDate, endDate);
                List<DynamicObject> branch = this.getSysParamPayment(dataEntity);
                for (Date date : dateRange) {
                    for (DynamicObject store : branch) {
                        boolean anyMatch = payRecord.stream().anyMatch(a -> a.getBranch().getPkValue().equals(store.getPkValue()) && date.getTime() == a.getPayDate().getTime());
                        if (anyMatch) continue;
                        long pkValue = DynamicObjectUtils.getPkValue((DynamicObject)store);
                        payRecord.add(new PaymentEntity(store, date, pkValue, false));
                    }
                }
                List unPayList = payRecord.stream().filter(a -> !a.isHasPay()).collect(Collectors.toList());
                if (unPayList.size() > 0) {
                    List sortList = unPayList.stream().sorted(Comparator.comparing(PaymentEntity::getBranchId, Comparator.reverseOrder()).thenComparing(PaymentEntity::getPayDate, Comparator.reverseOrder())).collect(Collectors.toList());
                    this.getView().setVisible(Boolean.TRUE, new String[]{"date"});
                    for (PaymentEntity paymentEntity : sortList) {
                        DynamicObject entry = entryEntity.addNew();
                        entry.set("branch", (Object)paymentEntity.getBranch());
                        entry.set("date", (Object)paymentEntity.getPayDate());
                    }
                }
                this.getView().updateView("entryentity");
                break;
            }
        }
    }

    private List<DynamicObject> getSysParamPayment(DynamicObject dataEntity) {
        QFilter filter = new QFilter("isautopaymentbill", "=", (Object)Boolean.TRUE);
        filter.and("branch", "!=", (Object)0L);
        DynamicObjectCollection org = dataEntity.getDynamicObjectCollection("org");
        List orgId = org.stream().map(a -> DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject("fbasedataid"))).collect(Collectors.toList());
        filter.and("org", "in", orgId);
        DynamicObject[] sysParam = BusinessDataServiceHelper.load((String)"ocpos_store_sysparam", (String)"branch", (QFilter[])filter.toArray());
        return Arrays.stream(sysParam).map(a -> a.getDynamicObject("branch")).collect(Collectors.toList());
    }

    private void foldPanel(boolean isCollapse) {
        Container flexPanelAp = (Container)this.getView().getControl("filterap");
        flexPanelAp.setCollapse(isCollapse);
    }

    private void setCardAp(DynamicObject dataEntity) {
        int totalSize = this.getAutoPayStoreSize(dataEntity);
        this.setLabelValue(totalSize, "total");
        int paymentSize = this.getPaymentStoreSize(dataEntity);
        this.setLabelValue(paymentSize, "count");
        int unPaySize = this.getUnPaySize(dataEntity, totalSize);
        this.setLabelValue(unPaySize, "uncount");
    }

    private int getUnPaySize(DynamicObject dataEntity, int totalSize) {
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        Date startDate = dataEntity.getDate("startdate");
        filter.and("paydate", ">=", (Object)startDate);
        Date endDate = dataEntity.getDate("enddate");
        filter.and("paydate", "<=", (Object)endDate);
        DynamicObjectCollection org = dataEntity.getDynamicObjectCollection("org");
        List orgId = org.stream().map(a -> DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject("fbasedataid"))).collect(Collectors.toList());
        filter.and("org", "in", orgId);
        int intervalDay = (int)((endDate.getTime() - startDate.getTime()) / 3600L / 24L / 1000L);
        DataSet dataset = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocpos_payment", (String)"paystore", (QFilter[])filter.toArray(), null);
        DataSet groupDataset = dataset.groupBy(new String[]{"paystore"}).count().finish();
        DynamicObjectCollection payment = ORM.create().toPlainDynamicObjectCollection(groupDataset);
        int lessSize = (int)payment.stream().filter(a -> a.getInt("count") != intervalDay).count();
        return totalSize - payment.size() + lessSize;
    }

    private int getPaymentStoreSize(DynamicObject dataEntity) {
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        filter.and("paydate", ">=", (Object)dataEntity.getDate("startdate"));
        filter.and("paydate", "<=", (Object)dataEntity.getDate("enddate"));
        DynamicObjectCollection org = dataEntity.getDynamicObjectCollection("org");
        List orgId = org.stream().map(a -> DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject("fbasedataid"))).collect(Collectors.toList());
        filter.and("org", "in", orgId);
        DynamicObjectCollection record = QueryServiceHelper.query((String)"ocpos_payment", (String)String.join((CharSequence)",", "paystore", "paydate"), (QFilter[])filter.toArray());
        return CollectionUtils.isEmpty((Collection)record) ? 0 : record.size();
    }

    private DynamicObject[] getPaymentBranch(DynamicObject dataEntity) {
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        Date startDate = dataEntity.getDate("startdate");
        filter.and("paydate", ">=", (Object)startDate);
        Date endDate = dataEntity.getDate("enddate");
        filter.and("paydate", "<=", (Object)endDate);
        DynamicObjectCollection org = dataEntity.getDynamicObjectCollection("org");
        List orgId = org.stream().map(a -> DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject("fbasedataid"))).collect(Collectors.toList());
        filter.and("org", "in", orgId);
        return BusinessDataServiceHelper.load((String)"ocpos_payment", (String)String.join((CharSequence)",", "paystore", "paydate"), (QFilter[])filter.toArray());
    }

    private int getAutoPayStoreSize(DynamicObject dataEntity) {
        QFilter filter = new QFilter("isautopaymentbill", "=", (Object)Boolean.TRUE);
        filter.and("branch", "!=", (Object)0L);
        DynamicObjectCollection org = dataEntity.getDynamicObjectCollection("org");
        List orgId = org.stream().map(a -> DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject("fbasedataid"))).collect(Collectors.toList());
        filter.and("org", "in", orgId);
        DynamicObjectCollection auto = QueryServiceHelper.query((String)"ocpos_store_sysparam", (String)"branch", (QFilter[])filter.toArray());
        return CollectionUtils.isEmpty((Collection)auto) ? 0 : auto.size();
    }

    private void setDefaultValue() {
        Date today = TimeServiceHelper.today();
        SimpleDateFormat dateInstance = new SimpleDateFormat("yyyy-MM-dd");
        String formatDate = dateInstance.format(today);
        Date date = null;
        try {
            date = dateInstance.parse(formatDate);
        }
        catch (ParseException e) {
            LOG.error(e.getMessage());
        }
        this.getModel().setValue("enddate", (Object)date);
        if (date != null) {
            this.getModel().setValue("startdate", (Object)DateUtil.getBeforeDay((Date)date, (int)30));
        }
    }

    private void setLabelValue(int count, String labelTag) {
        Label label = (Label)this.getView().getControl(labelTag);
        label.setText(String.valueOf(count));
    }

    private static List<Date> getDateRange(Date start, Date end) {
        ArrayList<Date> list = new ArrayList<Date>();
        long endTime = end.getTime();
        long oneDay = 86400000L;
        for (long startTime = start.getTime(); startTime <= endTime; startTime += oneDay) {
            list.add(new Date(startTime));
        }
        return list;
    }
}

