/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.accounttreat;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocpos.common.util.OwnerUtil;

public class PettyCashBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String IMPREST_STORE = "impreststore";
    private static final String IMPRESTDATE = "imprestdate";
    private static final String CURRENCY = "currency";
    private static final String CASHIER = "cashier";
    private static final String IMPREST_AMOUNT = "imprestamount";
    private static final String ORG = "org";
    public static final String BOS_LIST = "bos_listf7";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit cashierEdit = (BasedataEdit)this.getView().getControl(CASHIER);
        cashierEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit store = (BasedataEdit)this.getView().getControl(IMPREST_STORE);
        store.addBeforeF7SelectListener(a -> {
            ListShowParameter formShowParameter = (ListShowParameter)a.getFormShowParameter();
            List branchIdList = OwnerUtil.getOwnerIds((String[])new String[0]);
            formShowParameter.setFormId(BOS_LIST);
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)branchIdList));
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.beforeBindData(e);
        QFilter filter = new QFilter("sysuser", "=", (Object)UserServiceHelper.getCurrentUserId());
        filter.and("enable", "=", (Object)"1");
        filter.and("isdefault", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject channelUser = BusinessDataServiceHelper.loadSingle((String)"ocdbd_channeluser", (String)"owner", (QFilter[])filters);
        if (channelUser != null) {
            DynamicObject store = BusinessDataServiceHelper.loadSingle((Object)channelUser.getDynamicObject("owner").getPkValue(), (String)"ocdbd_channel");
            this.getModel().setValue(IMPREST_STORE, (Object)store);
            this.getModel().setValue(CURRENCY, (Object)store.getDynamicObject(CURRENCY));
            this.getModel().setValue(ORG, (Object)store.getDynamicObject("saleorg"));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        String key = op.getOperateKey();
        if (key.equals("save") || key.equals("submit")) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("imprestentity");
            if (entryEntity.size() < 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\"\u6536\u6b3e\u660e\u7ec6\"\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u91cd\u65b0\u7f16\u8f91", (String)"ocpos_imprest", (String)"occ-ocpos-formplugin", (Object[])new Object[0]));
            }
            int i = 1;
            for (DynamicObject entry : entryEntity) {
                if (entry.getDynamicObject(CASHIER) == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u660e\u7ec6\u7b2c%s\u884c\"\u6536\u94f6\u5458\"\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u91cd\u65b0\u7f16\u8f91", (String)"ImprestBillPlugin", (String)"occ-ocpos-formplugin", (Object[])new Object[0]), i));
                }
                if (entry.getBigDecimal(IMPREST_AMOUNT).compareTo(BigDecimal.ZERO) == 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u660e\u7ec6\u7b2c%s\u884c\"\u91d1\u989d\"\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u91cd\u65b0\u7f16\u8f91", (String)"ImprestBillPlugin", (String)"occ-ocpos-formplugin", (Object[])new Object[0]), i));
                }
                ++i;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        DynamicObject store;
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        if (e.getProperty().getName().equals(CASHIER) && (store = (DynamicObject)this.getModel().getValue(IMPREST_STORE)) != null) {
            long storeId = DynamicObjectUtils.getPkValue((DynamicObject)store);
            QFilter enableFilter = new QFilter("owner", "=", (Object)storeId);
            enableFilter.and("iscashier", "=", (Object)Boolean.TRUE);
            listShowParameter.getListFilterParameter().setFilter(enableFilter);
        }
    }
}

