/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.accounttreat;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocdbd.business.helper.pos.QueryFundsHelper;
import kd.occ.ocepfp.common.util.CollectionUtil;
import kd.occ.ocpos.common.util.OwnerUtil;

public class ReceiptBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final Long STORE_ID = 0L;
    private static final String KEY_IMPORTER = "importentry";
    private static final String CK_RECEIPT = "receipt";
    public static final String BOS_LIST = "bos_listf7";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit cashierEdit = (BasedataEdit)this.getView().getControl("processor");
        cashierEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit store = (BasedataEdit)this.getView().getControl("store");
        store.addBeforeF7SelectListener(a -> {
            ListShowParameter formShowParameter = (ListShowParameter)a.getFormShowParameter();
            List branchIdList = OwnerUtil.getOwnerIds((String[])new String[0]);
            formShowParameter.setFormId(BOS_LIST);
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("Id", "in", (Object)branchIdList));
        });
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObjectCollection dpts;
        QFilter filter = new QFilter("sysuser", "=", (Object)UserServiceHelper.getCurrentUserId());
        filter.and("enable", "=", (Object)"1");
        filter.and("isdefault", "=", (Object)Boolean.TRUE);
        DynamicObject channelUser = BusinessDataServiceHelper.loadSingle((String)"ocdbd_channeluser", (String)"id, owner, iscashier, sysuser", (QFilter[])filter.toArray());
        if (channelUser != null) {
            DynamicObject owner = channelUser.getDynamicObject("owner");
            boolean iscashier = channelUser.getBoolean("iscashier");
            if (iscashier) {
                this.getModel().setValue("processor", (Object)channelUser);
            }
        }
        if ((dpts = QueryServiceHelper.query((String)"bos_user", (String)"entryentity.dpt", (QFilter[])(filter = new QFilter("id", "=", (Object)UserServiceHelper.getCurrentUserId())).toArray())).size() > 0) {
            this.getModel().setValue("processpart", (Object)((DynamicObject)dpts.get(0)).getLong("entryentity.dpt"));
        }
        this.initStoreAndDate();
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        if ("receiptentry".equals(entryName)) {
            RowDataEntity[] rowDataEntities;
            for (RowDataEntity rowDataEntity : rowDataEntities = e.getRowDataEntities()) {
                DynamicObject dataEntity = rowDataEntity.getDataEntity();
                int index = rowDataEntity.getRowIndex();
                DynamicObject upRowEntity = this.getModel().getEntryRowEntity(entryName, index >= 1 ? index - 1 : 0);
                dataEntity.set("store", upRowEntity.get("store"));
                this.getView().updateView("store", index);
                dataEntity.set("currency", upRowEntity.get("currency"));
                this.getView().updateView("currency", index);
                dataEntity.set("receiptdate", upRowEntity.get("receiptdate"));
                this.getView().updateView("receiptdate", index);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        if (e.getProperty().getName().equals("processor") && STORE_ID != 0L) {
            QFilter enableFilter = new QFilter("owner", "=", (Object)STORE_ID);
            enableFilter.and("iscashier", "=", (Object)Boolean.TRUE);
            listShowParameter.getListFilterParameter().setFilter(enableFilter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        DynamicObjectCollection receiptEntry;
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        String key = op.getOperateKey();
        if (key.equals(KEY_IMPORTER)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("ocpos_importreceipt");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CK_RECEIPT));
            this.getView().showForm(formShowParameter);
        }
        if ((key.equals("save") || key.equals("submit")) && !CollectionUtils.isEmpty((Collection)(receiptEntry = this.getModel().getEntryEntity("receiptentry")))) {
            for (int i = 0; i < receiptEntry.size(); ++i) {
                DynamicObject paytype = (DynamicObject)this.getModel().getValue("paytype", i);
                DynamicObject store = (DynamicObject)this.getModel().getValue("store", i);
                for (int j = i + 1; j < receiptEntry.size(); ++j) {
                    DynamicObject paytypeTemp = (DynamicObject)this.getModel().getValue("paytype", j);
                    DynamicObject storeTemp = (DynamicObject)this.getModel().getValue("store", j);
                    if (paytype == null || store == null || paytypeTemp == null || storeTemp == null || paytypeTemp.getPkValue() != paytype.getPkValue() || storeTemp.getPkValue() != store.getPkValue()) continue;
                    int index = j + 1;
                    throw new KDBizException(ResManager.loadKDString((String)("\u5230\u8d26\u4fe1\u606f\u7b2c" + index + "\u884c\u6536\u6b3e\u65b9\u5f0f\u7c7b\u578b\u548c\u95e8\u5e97\u91cd\u590d\u3002"), (String)"ocpos_payment", (String)"occ-ocpos-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        List importList;
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)CK_RECEIPT) && CollectionUtil.isNotNull((List)(importList = (List)e.getReturnData()))) {
            DynamicObjectCollection receiptEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("receiptentry");
            int index = receiptEntry.size();
            for (JSONObject importInfo : importList) {
                DynamicObject newEntryRow = receiptEntry.addNew();
                newEntryRow.set("seq", (Object)index++);
                newEntryRow.set("paytype", importInfo.get((Object)"paytype"));
                newEntryRow.set("store", importInfo.get((Object)"store"));
                newEntryRow.set("currency", importInfo.get((Object)"currency"));
                newEntryRow.set("receiptdate", importInfo.get((Object)"receiptdate"));
                newEntryRow.set("receiptamount", importInfo.get((Object)"receiptamount"));
                newEntryRow.set("receiptcomment", importInfo.get((Object)"receiptcomment"));
                newEntryRow.set("serviceamount", importInfo.get((Object)"serviceamount"));
                this.updatePropertyChangeField(newEntryRow);
            }
            this.getView().updateView("receiptentry");
        }
    }

    private void updatePropertyChangeField(DynamicObject newEntryRow) {
        DynamicObject store = newEntryRow.getDynamicObject("store");
        DynamicObject payType = newEntryRow.getDynamicObject("paytype");
        Date receiptDate = newEntryRow.getDate("receiptdate");
        long payStoreId = DynamicObjectUtils.getPkValue((DynamicObject)store);
        long payTypeId = DynamicObjectUtils.getPkValue((DynamicObject)payType);
        if (payStoreId != 0L && payTypeId != 0L && receiptDate != null) {
            BigDecimal receivableAmount = QueryFundsHelper.queryCurrentDayPayAmount((long)payStoreId, (long)payTypeId, (Date)receiptDate);
            BigDecimal unReceivableAmount = QueryFundsHelper.queryNoBusinessAmount((long)payStoreId, (Date)receiptDate, (long)payTypeId);
            BigDecimal pastReceiptAmount = QueryFundsHelper.queryPastReceiptAmount((long)payStoreId, (long)payTypeId, (Date)receiptDate);
            BigDecimal adjustAmount = QueryFundsHelper.getAdjustAmount((long)payStoreId, (long)payTypeId, (Date)receiptDate);
            BigDecimal receiptAmount = newEntryRow.getBigDecimal("receiptamount");
            BigDecimal serviceAmount = newEntryRow.getBigDecimal("serviceamount");
            BigDecimal todayPayment = receivableAmount.add(unReceivableAmount).add(pastReceiptAmount).subtract(receiptAmount).subtract(serviceAmount).add(adjustAmount);
            newEntryRow.set("receivableamount", (Object)receivableAmount);
            newEntryRow.set("unreceivableamount", (Object)unReceivableAmount);
            newEntryRow.set("beforebalanceamount", (Object)pastReceiptAmount);
            newEntryRow.set("todaybalanceamount", (Object)todayPayment);
            newEntryRow.set("adjustamount", (Object)adjustAmount);
        }
    }

    private void initStoreAndDate() {
        QFilter filter = new QFilter("sysuser", "=", (Object)UserServiceHelper.getCurrentUserId());
        filter.and("enable", "=", (Object)"1");
        filter.and("isdefault", "=", (Object)Boolean.TRUE);
        DynamicObject channelUser = BusinessDataServiceHelper.loadSingle((String)"ocdbd_channeluser", (String)"owner", (QFilter[])filter.toArray());
        if (channelUser != null) {
            DynamicObject owner = channelUser.getDynamicObject("owner");
            this.getModel().setValue("store", (Object)owner, 0);
            DynamicObject store = BusinessDataServiceHelper.loadSingle((Object)owner.getPkValue(), (String)"ocdbd_channel");
            this.getModel().setValue("currency", (Object)store.getDynamicObject("currency"), 0);
        }
        this.getModel().setValue("receiptdate", this.getModel().getValue("bizdate"), 0);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        int row = changeSet[0].getRowIndex();
        switch (key) {
            case "store": {
                DynamicObject currency;
                DynamicObject paystore = (DynamicObject)this.getModel().getValue("store", row);
                if (paystore != null && (currency = paystore.getDynamicObject("currency")) != null) {
                    this.getModel().setValue("currency", (Object)currency, row);
                }
                this.queryPayAmount(row);
                break;
            }
            case "paytype": 
            case "receiptdate": {
                this.queryPayAmount(row);
                break;
            }
            case "serviceamount": 
            case "shouldreturnamount": 
            case "receiptamount": {
                this.updateTodayBalanceAmount();
                break;
            }
        }
    }

    private void updateTodayBalanceAmount() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("receiptentry");
        DynamicObject receiptEntry = this.getModel().getEntryRowEntity("receiptentry", rowIndex);
        BigDecimal beforebalanceamount = receiptEntry.getBigDecimal("beforebalanceamount");
        BigDecimal receivableamount = receiptEntry.getBigDecimal("receivableamount");
        BigDecimal unreceivableamount = receiptEntry.getBigDecimal("unreceivableamount");
        BigDecimal receiptamount = receiptEntry.getBigDecimal("receiptamount");
        BigDecimal serviceamount = receiptEntry.getBigDecimal("serviceamount");
        BigDecimal shouldreturnamount = receiptEntry.getBigDecimal("shouldreturnamount");
        BigDecimal adjustamount = receiptEntry.getBigDecimal("adjustamount");
        BigDecimal todaybalanceamount = unreceivableamount.add(beforebalanceamount).add(receivableamount).subtract(serviceamount).subtract(shouldreturnamount).subtract(receiptamount).add(adjustamount);
        this.getModel().setValue("todaybalanceamount", (Object)todaybalanceamount, rowIndex);
        this.getView().updateView("receiptentry");
    }

    private void queryPayAmount(int row) {
        DynamicObject store = (DynamicObject)this.getModel().getValue("store", row);
        DynamicObject payType = (DynamicObject)this.getModel().getValue("paytype", row);
        Date receiptDate = (Date)this.getModel().getValue("receiptdate", row);
        if (payType != null && receiptDate != null && store != null) {
            this.queryPayAmount(store, payType, receiptDate, row);
        }
    }

    private void queryPayAmount(DynamicObject store, DynamicObject type, Date date, int row) {
        long payStoreId = DynamicObjectUtils.getPkValue((DynamicObject)store);
        long payTypeId = DynamicObjectUtils.getPkValue((DynamicObject)type);
        BigDecimal receivableamount = QueryFundsHelper.queryCurrentDayPayAmount((long)payStoreId, (long)payTypeId, (Date)date);
        BigDecimal unreceivableamount = QueryFundsHelper.queryNoBusinessAmount((long)payStoreId, (Date)date, (long)payTypeId);
        BigDecimal pastReceiptAmount = QueryFundsHelper.queryPastReceiptAmount((long)payStoreId, (long)payTypeId, (Date)date);
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("receiptentry", row);
        BigDecimal serviceamount = entryRowEntity.getBigDecimal("serviceamount");
        BigDecimal shouldreturnamount = entryRowEntity.getBigDecimal("shouldreturnamount");
        BigDecimal adjustamount = QueryFundsHelper.getAdjustAmount((long)payStoreId, (long)payTypeId, (Date)date);
        BigDecimal todaybalanceamount = pastReceiptAmount.add(adjustamount).subtract(serviceamount).subtract(shouldreturnamount);
        this.getModel().setValue("receivableamount", (Object)receivableamount, row);
        this.getModel().setValue("unreceivableamount", (Object)unreceivableamount, row);
        this.getModel().setValue("receiptamount", (Object)receivableamount.add(unreceivableamount), row);
        this.getModel().setValue("beforebalanceamount", (Object)pastReceiptAmount, row);
        this.getModel().setValue("todaybalanceamount", (Object)todaybalanceamount, row);
        this.getModel().setValue("adjustamount", (Object)adjustamount, row);
    }
}

