/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.accounttreat;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.business.fundhelper.AutoPaymentBillHelper;
import kd.occ.ocpos.common.util.OwnerUtil;

public class ReceiptUpdateFormPlugin
extends AbstractFormPlugin {
    public static final String BOS_LIST = "bos_listf7";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        MulBasedataEdit store = (MulBasedataEdit)this.getView().getControl("store");
        store.addBeforeF7SelectListener(a -> {
            ListShowParameter formShowParameter = (ListShowParameter)a.getFormShowParameter();
            List branchIdList = OwnerUtil.getOwnerIds((String[])new String[0]);
            formShowParameter.setFormId(BOS_LIST);
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)branchIdList));
        });
    }

    public void afterCreateNewData(EventObject e) {
        long currentUserId = UserServiceHelper.getCurrentUserId();
        QFilter filter = new QFilter("sysuser", "=", (Object)currentUserId);
        filter.and("enable", "=", (Object)"1");
        filter.and("isdefault", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject channelUser = QueryServiceHelper.queryOne((String)"ocdbd_channeluser", (String)"owner", (QFilter[])filters);
        if (channelUser != null) {
            this.getModel().setItemValueByID("store", (Object)channelUser.getLong("owner"));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate formOperate = (FormOperate)e.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("confirm".equals(operateKey)) {
            Date date;
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection store = dataEntity.getDynamicObjectCollection("store");
            if (CollectionUtils.isEmpty((Collection)store)) {
                NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u8f93\u5165\u95e8\u5e97\u4fe1\u606f", (IFormView)this.getView());
                e.setCancel(true);
            }
            if ((date = dataEntity.getDate("date")) == null) {
                NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u8f93\u5165\u65e5\u671f\u4fe1\u606f", (IFormView)this.getView());
                e.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        boolean isConfirm;
        super.afterDoOperation(e);
        boolean bl = isConfirm = "confirm".equals(e.getOperateKey()) && e.getOperationResult() != null && e.getOperationResult().isSuccess();
        if (isConfirm) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection store = dataEntity.getDynamicObjectCollection("store");
            List branchId = store.stream().map(a -> DynamicObjectUtils.getPkValue((DynamicObject)a, (String)"fbasedataid")).collect(Collectors.toList());
            Date date = dataEntity.getDate("date");
            AutoPaymentBillHelper.updateReceiptList(branchId, (Date)date);
            this.getView().close();
        }
    }
}

