/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.UserUtil;
import kd.occ.ocpos.business.commonhelper.OrgHelper;
import kd.occ.ocpos.common.util.OwnerUtil;

public abstract class OcposListPlugin
extends AbstractListPlugin {
    protected abstract String[] listBranchCols();

    protected abstract String branchKey();

    protected abstract String[] listChannelUserCols();

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e) {
        Object[] channelUserCols;
        String key = e.getFieldName();
        ArrayList<QFilter> filters = e.getCustomQFilters();
        if (filters == null) {
            filters = new ArrayList<QFilter>();
            e.setCustomQFilters(filters);
        }
        List<Long> branchIdList = this.getOwnerIds();
        Object[] branchCols = this.listBranchCols();
        if (ArrayUtils.contains((Object[])branchCols, (Object)key)) {
            filters.add(new QFilter("id", "in", branchIdList));
        }
        if (ArrayUtils.contains((Object[])(channelUserCols = this.listChannelUserCols()), (Object)key)) {
            filters.add(new QFilter("id", "in", this.getChannelUserIds()));
        }
        super.filterContainerBeforeF7Select(e);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        Object[] branchCols = this.listBranchCols();
        if (ArrayUtils.isEmpty((Object[])branchCols)) {
            return;
        }
        for (Object branchCol : branchCols) {
            FilterColumn fc = args.getFilterColumn((String)branchCol);
            if (!(fc instanceof CommonFilterColumn)) continue;
            CommonFilterColumn col = (CommonFilterColumn)fc;
            List<ComboItem> comboItems = this.getComboItems();
            col.setComboItems(comboItems);
        }
    }

    private List<Long> getChannelUserIds() {
        ArrayList<Long> pkIdList = new ArrayList<Long>(0);
        QFilter qFilter = new QFilter("owner", "in", this.getOwnerIds());
        qFilter.and(F7Utils.getEnableStatus());
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocdbd_channeluser", (String)"sysuser.id", (QFilter[])qFilter.toArray(), null);
        while (dataSet.hasNext()) {
            pkIdList.add((Long)dataSet.next().get("sysuser.id"));
        }
        return pkIdList;
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List fs = e.getCustomQFilters();
        String branchKey = this.branchKey();
        QFilter branchFilter = new QFilter(branchKey, "in", this.getOwnerIds());
        fs.add(branchFilter);
    }

    private List<Long> getOwnerIds() {
        List branchIdList = OwnerUtil.getOwnerIds((String[])new String[0]);
        List orgIds = OrgHelper.getHasPermissionOrg((String)((IListView)this.getView()).getListModel().getEntityId(), (String)OrgHelper.getOrgViewType());
        QFilter qFilter = new QFilter("id", "in", (Object)branchIdList);
        qFilter.and("saleorg", "in", (Object)orgIds);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocdbd_channel", (String)"id", (QFilter[])qFilter.toArray(), null);
        ArrayList<Long> result = new ArrayList<Long>(0);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            result.add((Long)row.get("id"));
        }
        return result;
    }

    private List<ComboItem> getComboItems() {
        List orderChannelIds = UserUtil.getChannelIDs();
        if (orderChannelIds == null || orderChannelIds.size() == 0) {
            return new ArrayList<ComboItem>(0);
        }
        Map orderChannel = BusinessDataServiceHelper.loadFromCache((Object[])orderChannelIds.toArray(), (String)"ocdbd_channel");
        if (orderChannel != null && orderChannel.size() > 0) {
            Collection collection = orderChannel.values();
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(collection.size());
            for (DynamicObject object : orderChannel.values()) {
                ComboItem channel = new ComboItem();
                channel.setId(String.valueOf(object.get("id")));
                channel.setValue(String.valueOf(object.get("id")));
                channel.setCaption(new LocaleString(object.getString("name")));
                comboItems.add(channel);
            }
            return comboItems;
        }
        return new ArrayList<ComboItem>(0);
    }
}

