/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.form;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.plugin.AbstractPrintServicePlugin;
import kd.bos.entity.plugin.args.CustomPrintDataEntitiesArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocpos.common.util.BigdecimalUtil;

public class ElectWarrantyPrintPlugin
extends AbstractPrintServicePlugin {
    public void customPrintDataEntities(CustomPrintDataEntitiesArgs e) {
        List dataEntities = e.getDataEntities();
        String dataSourceName = e.getDataSourceName();
        if ("ocpos_electwarranty".equals(dataSourceName)) {
            e.setDataEntities(this.rebuildHeadEntity(dataEntities));
        }
    }

    private List<DynamicObject> rebuildHeadEntity(List<DynamicObject> dataEntities) {
        ArrayList<DynamicObject> customerEntities = new ArrayList<DynamicObject>(dataEntities.size());
        DynamicObject elect = dataEntities.get(0);
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)elect.getPkValue(), (String)elect.getDataEntityType().getName());
        if (bill == null) {
            throw new KDBizException(new ErrorCode("ElectWarrantyPrintPlugin", "\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5"), new Object[0]);
        }
        try {
            DynamicObjectType dataEntityType = (DynamicObjectType)elect.getDataEntityType();
            DynamicObjectType clone = (DynamicObjectType)dataEntityType.clone();
            DynamicSimpleProperty mixamount = new DynamicSimpleProperty("mixamount", String.class, (Object)"");
            clone.registerSimpleProperty(mixamount);
            DynamicSimpleProperty item = new DynamicSimpleProperty("item", String.class, (Object)"");
            clone.registerSimpleProperty(item);
            DynamicObject customerEntity = this.rebuildCustomerEntity(elect, bill, clone);
            customerEntities.add(customerEntity);
        }
        catch (Exception exception) {
            throw new KDBizException(new ErrorCode("ElectWarrantyPrintPlugin", exception.getMessage()), new Object[0]);
        }
        return customerEntities;
    }

    private DynamicObject rebuildCustomerEntity(DynamicObject elect, DynamicObject bill, DynamicObjectType clone) {
        DynamicObject customerEntity = (DynamicObject)new CloneUtils(false, false).clone((IDataEntityType)clone, (Object)elect);
        customerEntity.set("mixamount", (Object)this.getCnAmount(bill));
        customerEntity.set("item", (Object)this.getItemInfo(bill));
        customerEntity.set("effecttime", bill.get("effecttime"));
        customerEntity.set("billno", bill.get("billno"));
        customerEntity.set("saler", bill.get("saler"));
        customerEntity.set("saledepartment", bill.get("saledepartment"));
        customerEntity.set("customername", bill.get("customername"));
        customerEntity.set("customerphone", bill.get("customerphone"));
        customerEntity.set("fulladdress", bill.get("fulladdress"));
        customerEntity.set("content", bill.get("content"));
        return customerEntity;
    }

    private String getCnAmount(DynamicObject bill) {
        BigDecimal balamount = bill.getBigDecimal("balamount").setScale(2);
        String cnMoney = BigdecimalUtil.number2CNMoney((BigDecimal)balamount);
        String cnAmount = balamount + "\u5143(" + cnMoney + ")";
        return cnAmount;
    }

    private String getItemInfo(DynamicObject bill) {
        DynamicObject item = bill.getDynamicObject("goodsid");
        StringBuilder iteminfo = new StringBuilder();
        iteminfo.append(item.getString("number"));
        iteminfo.append(item.getString("name"));
        iteminfo.append(' ');
        iteminfo.append("\u6570\u91cf\uff1a");
        BigDecimal qty = bill.getBigDecimal("saleqty").setScale(2);
        iteminfo.append(qty);
        iteminfo.append(' ');
        iteminfo.append("\u5355\u4ef7\uff1a");
        BigDecimal balamount = bill.getBigDecimal("balamount").setScale(2);
        iteminfo.append(balamount);
        iteminfo.append(' ');
        iteminfo.append("\u5e93\u5b58\u7c7b\u578b\uff1a");
        iteminfo.append(bill.getDynamicObject("invtype").getString("name"));
        return iteminfo.toString();
    }
}

