/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.home;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.pluginnew.GridCardPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.util.OwnerUtil;

public class BranchBookEdit
extends GridCardPlugin
implements BeforeF7SelectListener {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List branchIds = OwnerUtil.getOwnerIds((String[])new String[0]);
        if (!CollectionUtils.isEmpty((Collection)branchIds)) {
            Object[] basedataIds = new Object[]{branchIds.get(0)};
            this.getModel().setValue("branch", (Object)basedataIds);
        }
        this.dataPropertyChanged("A");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit bEdit = (BasedataEdit)this.getView().getControl("branch");
        bEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        QFilter qFilter = new QFilter("id", "in", (Object)OwnerUtil.getOwnerIds((String[])new String[0]));
        if (fieldKey.equals("branch")) {
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeData = e.getChangeSet();
        if (changeData == null || changeData.length <= 0) {
            return;
        }
        this.dataPropertyChanged(this.getModel().getValue("datarange").toString());
    }

    private void dataPropertyChanged(String datarange) {
        DynamicObjectCollection branchs = this.getModel().getDataEntity().getDynamicObjectCollection("branch");
        ArrayList<Long> branchList = new ArrayList<Long>();
        for (Object branch : branchs) {
            branchList.add(Long.parseLong(branch.getDynamicObject("fbasedataid").getPkValue().toString()));
        }
        QFilter qFilter = new QFilter("salestatus", "=", (Object)"S");
        qFilter.and("basebilltype", "=", (Object)BillTypeEnum.RESERVE.getId());
        qFilter.and("bizdate", "<=", (Object)TimeServiceHelper.now());
        if (!branchList.isEmpty()) {
            qFilter.and("salebranchid", "in", branchList);
        }
        switch (datarange) {
            case "A": {
                qFilter.and("bizdate", ">=", (Object)DateUtil.getFirstDayOfMonth((Date)TimeServiceHelper.today()));
                break;
            }
            case "B": {
                qFilter.and("bizdate", ">=", (Object)DateUtil.getBeforeMonth((int)3));
                break;
            }
            case "C": {
                qFilter.and("bizdate", ">=", (Object)DateUtil.getFirstDayOfYear((Date)TimeServiceHelper.today()));
                break;
            }
            case "D": {
                qFilter.and("bizdate", ">=", (Object)DateUtil.getFirstDayOfWeek((Date)TimeServiceHelper.today()));
                break;
            }
            case "E": {
                qFilter.and("bizdate", ">=", (Object)DateUtil.getBeforeDay((Date)DateUtil.getTodayWee()));
                break;
            }
        }
        DynamicObjectCollection dyc = QueryServiceHelper.query((String)"ocpos_saleorder", (String)"id", (QFilter[])qFilter.toArray());
        int bookingnumber = dyc.size();
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocpos_saleorder", (String)this.getSelectFild(), (QFilter[])qFilter.toArray(), null);
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(new String[]{"basebilltype"});
        groupbyDataSet.sum("linereceivableamount");
        groupbyDataSet.sum("expectfinalamount");
        DataSet dataSet1 = groupbyDataSet.finish();
        DynamicObjectCollection dynamicObjectCollection = ORM.create().toPlainDynamicObjectCollection(dataSet1);
        Label label = (Label)this.getView().getControl("bookingnumber");
        Label label1 = (Label)this.getView().getControl("bookingamount");
        Label label2 = (Label)this.getView().getControl("outstandingpayment");
        if (ObjectUtils.isEmpty((Object)dynamicObjectCollection)) {
            String text = Integer.toString(0);
            label.setText(text);
            label1.setText(text);
            label2.setText(text);
        } else {
            DynamicObject dyo = (DynamicObject)dynamicObjectCollection.get(0);
            int bookingamount = new BigDecimal(dyo.get("linereceivableamount").toString()).intValue();
            int outstandingpayment = new BigDecimal(dyo.get("expectfinalamount").toString()).intValue();
            label.setText(Integer.toString(bookingnumber));
            label1.setText(Integer.toString(bookingamount));
            label2.setText(Integer.toString(outstandingpayment));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String datarange = this.getModel().getValue("datarange").toString();
        QFilter qFilter = new QFilter("salestatus", "=", (Object)"S");
        qFilter.and("basebilltype", "=", (Object)BillTypeEnum.RESERVE.getId());
        qFilter.and("bizdate", "<=", (Object)TimeServiceHelper.today());
        switch (datarange) {
            case "A": {
                qFilter.and("bizdate", ">=", (Object)DateUtil.getFirstDayOfMonth((Date)TimeServiceHelper.today()));
                break;
            }
            case "B": {
                qFilter.and("bizdate", ">=", (Object)DateUtil.getBeforeMonth((int)3));
                break;
            }
            case "C": {
                qFilter.and("bizdate", ">=", (Object)DateUtil.getFirstDayOfYear((Date)TimeServiceHelper.today()));
                break;
            }
            case "D": {
                qFilter.and("bizdate", ">=", (Object)DateUtil.getFirstDayOfWeek((Date)TimeServiceHelper.today()));
                break;
            }
            case "E": {
                qFilter.and("bizdate", ">=", (Object)DateUtil.getTodayWee());
                break;
            }
        }
        ListShowParameter listParam = FormShowUtils.openChooseList((String)"\u95e8\u5e97\u9884\u8ba2\u72b6\u51b5\u5217\u8868", (String)"ocpos_saleorder", (ShowType)ShowType.MainNewTabPage, Arrays.asList(qFilter.toArray()), (boolean)true, (boolean)false);
        this.getView().showForm((FormShowParameter)listParam);
    }

    private String getSelectFild() {
        return String.join((CharSequence)",", "basebilltype", "goodsentryentity.linereceivableamount as linereceivableamount", "goodsentryentity.expectfinalamount as expectfinalamount");
    }
}

