/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.home;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.PosItemUtil;
import kd.occ.ocpos.common.util.CommonUtil;

public class SalesRankingList
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map param = parameter.getCustomParams();
        String datarange = param.get("datarange").toString();
        String order = param.get("orderby").toString();
        List branchList = CommonUtil.castList(param.get("branch"), Long.class);
        QFilter qFilter = new QFilter("salestatus", "=", (Object)"S");
        switch (datarange) {
            case "A": {
                qFilter.and("bizdate", ">=", (Object)DateUtil.getFirstDayOfMonth((Date)TimeServiceHelper.today()));
                break;
            }
            case "B": {
                qFilter.and("bizdate", ">=", (Object)DateUtil.getBeforeMonth((int)3));
                break;
            }
            case "C": {
                qFilter.and("bizdate", ">=", (Object)DateUtil.getFirstDayOfYear((Date)TimeServiceHelper.today()));
                break;
            }
            case "D": {
                qFilter.and("bizdate", ">=", (Object)DateUtil.getFirstDayOfWeek((Date)TimeServiceHelper.today()));
                break;
            }
            case "E": {
                qFilter.and("bizdate", ">=", (Object)DateUtil.getBeforeDay((Date)DateUtil.getTodayWee()));
                break;
            }
        }
        if (!branchList.isEmpty()) {
            qFilter.and("salebranchid", "in", (Object)branchList);
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocpos_saleorder", (String)this.getSelectFild(), (QFilter[])qFilter.toArray(), null);
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(new String[]{"goodsid"});
        groupbyDataSet = groupbyDataSet.sum("saleqty");
        groupbyDataSet = groupbyDataSet.sum("linereceivableamount");
        DataSet dataSet1 = groupbyDataSet.finish();
        DataSet top = null;
        switch (order) {
            case "A": {
                top = dataSet1.orderBy(new String[]{"linereceivableamount desc"}).top(10);
                break;
            }
            case "B": {
                top = dataSet1.orderBy(new String[]{"saleqty desc"}).top(10);
                break;
            }
        }
        DynamicObjectCollection dynamicObjectCollection = ORM.create().toPlainDynamicObjectCollection(top);
        DynamicObject brandInfo = null;
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            return;
        }
        int[] xArray = this.getModel().batchCreateNewEntryRow("entryentity", dynamicObjectCollection.size());
        int index = 0;
        for (DynamicObject dyo : dynamicObjectCollection) {
            if (dyo.get("goodsid").equals(0L)) continue;
            if (QueryServiceHelper.exists((String)"ocdbd_iteminfo", (Object)dyo.get("goodsid"))) {
                DynamicObject itemInfo = BusinessDataServiceHelper.loadSingle((Object)dyo.get("goodsid"), (String)"ocdbd_iteminfo");
                brandInfo = itemInfo.getDynamicObject("itembrands");
            }
            this.getModel().setValue("item", dyo.get("goodsid"), xArray[index]);
            this.getModel().setValue("itembrand", (Object)brandInfo, xArray[index]);
            Long classId = PosItemUtil.queryItemClass((Object)dyo.get("goodsid"));
            if (classId.equals(0L)) {
                this.getModel().setValue("itemclass", null, xArray[index]);
            } else {
                this.getModel().setValue("itemclass", (Object)BusinessDataServiceHelper.loadSingle((Object)classId, (String)"mdr_item_class"), xArray[index]);
            }
            this.getModel().setValue("salesvolumes", (Object)new BigDecimal(dyo.get("saleqty").toString()).intValue(), xArray[index]);
            this.getModel().setValue("salesamount", (Object)new BigDecimal(dyo.get("linereceivableamount").toString()), xArray[index]);
            this.getModel().setValue("ranking", (Object)(xArray[index] + 1), xArray[index]);
            ++index;
        }
        this.getView().updateView();
    }

    private String getSelectFild() {
        return String.join((CharSequence)",", "goodsentryentity.goodsid as goodsid", "goodsentryentity.saleqty as saleqty", "goodsentryentity.linereceivableamount as linereceivableamount");
    }
}

