/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.home;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.pluginnew.GridCardPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.util.OwnerUtil;

public class TradeInfoCardEdit
extends GridCardPlugin
implements BeforeF7SelectListener {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List branchIds = OwnerUtil.getOwnerIds((String[])new String[0]);
        if (!CollectionUtils.isEmpty((Collection)branchIds)) {
            Object[] basedataIds = new Object[]{branchIds.get(0)};
            this.getModel().setValue("branch", (Object)basedataIds);
        }
        this.dataPropertyChanged("A");
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals("piechartap")) {
            ChartClickEvent e = (ChartClickEvent)evt;
            this.getView().showMessage("SeriesName:" + e.getSeriesName() + "; Name: " + e.getName() + "; Value: " + e.getValue());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeData = e.getChangeSet();
        if (changeData == null || changeData.length <= 0) {
            return;
        }
        this.dataPropertyChanged(this.getModel().getValue("datarange").toString());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit bEdit = (BasedataEdit)this.getView().getControl("branch");
        bEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        QFilter qFilter = new QFilter("id", "in", (Object)OwnerUtil.getOwnerIds((String[])new String[0]));
        if (fieldKey.equals("branch")) {
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    private void drawChart(BigDecimal sale, BigDecimal booking) {
        PieChart piechart = (PieChart)this.getControl("piechartap");
        piechart.clearData();
        piechart.setShowTooltip(true);
        piechart.setShowTitle(false);
        piechart.setShowLegend(true);
        HashMap<String, String[]> legendData = new HashMap<String, String[]>();
        String[] data = new String[]{"\u9500\u552e", "\u9884\u8ba2"};
        legendData.put("data", data);
        piechart.setLegendPropValue("legend", legendData);
        piechart.setLegendAlign(XAlign.center, YAlign.top);
        PieSeries series = piechart.createSeries("\u9500\u552e\u5360\u6bd4\u56fe");
        ItemValue[] itemValues = new ItemValue[]{new ItemValue("\u9500\u552e", (Number)sale.intValue(), "#648cf9"), new ItemValue("\u9884\u8ba2", (Number)booking.intValue(), "#48a4f6")};
        series.setData(itemValues);
        series.setRadius("60px", "45px");
        this.getView().updateView("piechartap");
    }

    private void dataPropertyChanged(String datarange) {
        DynamicObjectCollection branchs = this.getModel().getDataEntity().getDynamicObjectCollection("branch");
        ArrayList<Long> branchList = new ArrayList<Long>();
        for (DynamicObject branch : branchs) {
            branchList.add(Long.parseLong(branch.getDynamicObject("fbasedataid").getPkValue().toString()));
        }
        QFilter qFilter = new QFilter("salestatus", "=", (Object)"S");
        QFilter filter = new QFilter("basebilltype", "=", (Object)BillTypeEnum.RESERVE.getId());
        filter.or("basebilltype", "=", (Object)BillTypeEnum.RETAIL.getId());
        qFilter.and(filter);
        qFilter.and("bizdate", "<=", (Object)TimeServiceHelper.now());
        if (!branchList.isEmpty()) {
            qFilter.and("salebranchid", "in", branchList);
        }
        switch (datarange) {
            case "A": {
                qFilter.and("bizdate", ">=", (Object)DateUtil.getFirstDayOfMonth((Date)TimeServiceHelper.today()));
                break;
            }
            case "B": {
                qFilter.and("bizdate", ">=", (Object)DateUtil.getBeforeMonth((int)3));
                break;
            }
            case "C": {
                qFilter.and("bizdate", ">=", (Object)DateUtil.getFirstDayOfYear((Date)TimeServiceHelper.today()));
                break;
            }
            case "D": {
                qFilter.and("bizdate", ">=", (Object)DateUtil.getFirstDayOfWeek((Date)TimeServiceHelper.today()));
                break;
            }
            case "E": {
                qFilter.and("bizdate", ">=", (Object)DateUtil.getBeforeDay((Date)DateUtil.getTodayWee()));
                break;
            }
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocpos_saleorder", (String)"basebilltype,sumbalamount", (QFilter[])qFilter.toArray(), null);
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(new String[]{"basebilltype"});
        groupbyDataSet.sum("sumbalamount");
        DataSet dataSet1 = groupbyDataSet.finish();
        DynamicObjectCollection dynamicObjectCollection = ORM.create().toPlainDynamicObjectCollection(dataSet1);
        BigDecimal sale = BigDecimal.ZERO;
        BigDecimal booking = BigDecimal.ZERO;
        for (DynamicObject dyo : dynamicObjectCollection) {
            if (dyo.get("basebilltype").equals(BillTypeEnum.RESERVE.getId())) {
                booking = new BigDecimal(dyo.get("sumbalamount").toString());
                continue;
            }
            if (!dyo.get("basebilltype").equals(BillTypeEnum.RETAIL.getId())) continue;
            sale = new BigDecimal(dyo.get("sumbalamount").toString());
        }
        this.drawChart(sale, booking);
        Label label = (Label)this.getView().getControl("totalamount");
        label.setText(String.valueOf(sale.add(booking).intValue()));
        this.statisticsPaymode(qFilter);
    }

    private void statisticsPaymode(QFilter qFilter) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocpos_saleorder", (String)this.getSelectFild(), (QFilter[])qFilter.toArray(), null);
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(new String[]{"setllementid"});
        groupbyDataSet.sum("settleamount");
        DataSet dataSet1 = groupbyDataSet.finish();
        DynamicObjectCollection dynamicObjectCollection = ORM.create().toPlainDynamicObjectCollection(dataSet1);
        BigDecimal index = BigDecimal.ZERO;
        if (ObjectUtils.isEmpty((Object)dynamicObjectCollection)) {
            Label label = (Label)this.getView().getControl("cashpayment");
            String text = Integer.toString(0);
            label.setText(text);
            label = (Label)this.getView().getControl("wechatpayment");
            label.setText(text);
            label = (Label)this.getView().getControl("alipay");
            label.setText(text);
            label = (Label)this.getView().getControl("installmentpay");
            label.setText(text);
            label = (Label)this.getView().getControl("bankcardpay");
            label.setText(text);
            label = (Label)this.getView().getControl("giftvoucherpay");
            label.setText(text);
            label = (Label)this.getView().getControl("otherpay");
            label.setText(text);
        } else {
            block16: for (DynamicObject dyo : dynamicObjectCollection) {
                Label label;
                String amount = new BigDecimal(dyo.getBigDecimal("settleamount").intValue()).toString();
                switch (dyo.get("setllementid").toString()) {
                    case "3": {
                        label = (Label)this.getView().getControl("cashpayment");
                        label.setText(amount);
                        continue block16;
                    }
                    case "1": {
                        label = (Label)this.getView().getControl("wechatpayment");
                        label.setText(amount);
                        continue block16;
                    }
                    case "2": {
                        label = (Label)this.getView().getControl("alipay");
                        label.setText(amount);
                        continue block16;
                    }
                    case "26": {
                        label = (Label)this.getView().getControl("installmentpay");
                        label.setText(amount);
                        continue block16;
                    }
                    case "5": {
                        label = (Label)this.getView().getControl("bankcardpay");
                        label.setText(amount);
                        continue block16;
                    }
                    case "4": {
                        label = (Label)this.getView().getControl("giftvoucherpay");
                        label.setText(amount);
                        continue block16;
                    }
                }
                index = index.add(new BigDecimal(amount));
                label = (Label)this.getView().getControl("otherpay");
                label.setText(index.toString());
            }
            this.getView().updateView();
        }
    }

    private String getSelectFild() {
        return String.join((CharSequence)",", "finentity.setllementid as setllementid", "finentity.settleamount as settleamount");
    }
}

