/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.inventory;

import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.pos.NotificationUtil;

public class CheckSheetFormPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_query", "btn_confirm"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map customParams = parameter.getCustomParams();
        this.getModel().setValue("startdate", customParams.get("checkdate"));
        this.getModel().setValue("enddate", customParams.get("checkdate"));
        this.getModel().setItemValueByID("org", customParams.get("org"));
    }

    public void click(EventObject e) {
        super.click(e);
        Control ctrl = (Control)e.getSource();
        switch (ctrl.getKey()) {
            case "btn_query": {
                this.query();
                break;
            }
            case "btn_confirm": {
                this.returnDataToParent();
                break;
            }
        }
    }

    private void query() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        QFilter filter = new QFilter("billstatus", "!=", (Object)"C");
        if (!StringUtils.isEmpty((Object)dataEntity.get("countbillno"))) {
            filter.and("billno", "=", dataEntity.get("countbillno"));
        }
        if (dataEntity.get("startdate") != null) {
            filter.and("biztime", ">=", dataEntity.get("startdate"));
            filter.and("biztime", "<", (Object)this.getDayAfter(dataEntity.getDate("enddate")));
        }
        if (dataEntity.get("org") != null) {
            filter.and("org", "=", dataEntity.getDynamicObject("org").getPkValue());
        }
        DynamicObject[] invcountbills = BusinessDataServiceHelper.load((String)"im_invcountbill", (String)this.getCheckSheetField(), (QFilter[])filter.toArray());
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        entryEntity.clear();
        for (DynamicObject invcountbill : invcountbills) {
            DynamicObject entry = new DynamicObject(entryEntity.getDynamicObjectType());
            entry.set("billid", invcountbill.getPkValue());
            entry.set("billno", invcountbill.get("billno"));
            entry.set("schemename", invcountbill.get("schemename"));
            entry.set("schemeid", invcountbill.get("schemeid"));
            entry.set("billstatus", invcountbill.get("billstatus"));
            entry.set("counttype", invcountbill.get("counttype"));
            entry.set("invaccdate", invcountbill.get("invaccdate"));
            entry.set("bizdate", invcountbill.get("biztime"));
            entryEntity.add((Object)entry);
        }
        this.getView().updateView("entryentity");
    }

    private void returnDataToParent() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u9009\u62e9\u8981\u5904\u7406\u7684\u6570\u636e\u3002", (IFormView)this.getView());
        } else if (selectRows.length > 1) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u5904\u7406\u3002", (IFormView)this.getView());
        } else {
            DynamicObject entry = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(selectRows[0]);
            this.getView().returnDataToParent(entry.get("billid"));
            this.getView().close();
        }
    }

    private String getCheckSheetField() {
        return "id,billno,counttype,schemename,schemeid,biztime,billstatus,invaccdate";
    }

    private Date getDayAfter(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int days = calendar.get(5);
        calendar.set(5, days + 1);
        return calendar.getTime();
    }
}

