/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.inventory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.F7Util;
import kd.occ.ocpos.common.util.OwnerUtil;
import org.apache.commons.lang.math.NumberUtils;

public class OrderTrackingEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List branchIds = OwnerUtil.getOwnerIds((String[])new String[0]);
        if (!CollectionUtils.isEmpty((Collection)branchIds)) {
            Object[] baseDataIds = new Object[]{branchIds.get(0)};
            this.getModel().setValue("salebranchfilter", (Object)baseDataIds);
        }
        this.getModel().setValue("endtime", (Object)TimeServiceHelper.now());
        this.getModel().setValue("starttime", (Object)DateUtil.getBeforeDay((Date)TimeServiceHelper.now(), (int)30));
        this.getView().setVisible(Boolean.FALSE, new String[]{"cardap", "tabap"});
        Container flexPanelAp = (Container)this.getView().getControl("filterap");
        flexPanelAp.setCollapse(false);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"querybutton", "billcount", "failedbillcount", "successbillcount"});
        CommonUtil.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"salebranchfilter", "cashierfilter"});
    }

    public void beforeClick(BeforeClickEvent evt) {
        DynamicObjectCollection branch;
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        if ("querybutton".equals(source.getKey()) && CollectionUtils.isEmpty((Collection)(branch = this.getModel().getDataEntity(true).getDynamicObjectCollection("salebranchfilter")))) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u5f55\u5165\u9500\u552e\u95e8\u5e97\u3002", (IFormView)this.getView());
            evt.setCancel(true);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String operationType = this.getView().getModel().getDataEntity(true).getString("operationtype");
        QFilter qFilter = new QFilter("isinitialnode", "=", (Object)Boolean.TRUE);
        if (!StringUtils.equals((CharSequence)operationType, (CharSequence)"C")) {
            QFilter filter = new QFilter("operationtype", "=", (Object)"");
            filter.or("operationtype", "=", (Object)operationType);
            qFilter.and(filter);
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocdbd_botpflowing", (String)"sourcebillid", (QFilter[])qFilter.toArray(), null);
        ArrayList<Long> exist = new ArrayList<Long>(0);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            long sourceBillId = (Long)row.get("sourcebillid");
            exist.add(sourceBillId);
        }
        qFilter = new QFilter("id", "in", exist);
        QFilter changeFilter = qFilter.copy();
        Control source = (Control)evt.getSource();
        switch (source.getKey()) {
            case "querybutton": {
                Container flexPanelAp = (Container)this.getView().getControl("filterap");
                flexPanelAp.setCollapse(true);
                this.getView().setVisible(Boolean.TRUE, new String[]{"cardap", "tabap"});
                this.setBillLabel(qFilter);
                break;
            }
            case "successbillcount": {
                qFilter.and("executestate", "=", (Object)"1");
                changeFilter.and("saleorderexecutestate", "=", (Object)"1");
                changeFilter.and("returnexecutestate", "=", (Object)"1");
                break;
            }
            case "failedbillcount": {
                qFilter.and("executestate", "=", (Object)"0");
                QFilter qFilter1 = new QFilter("saleorderexecutestate", "=", (Object)"0");
                qFilter1.or("returnexecutestate", "=", (Object)"0");
                changeFilter.and(qFilter1);
                break;
            }
        }
        this.showBill(qFilter, changeFilter);
    }

    private void setBillLabel(QFilter qFilter) {
        QFilter fFilter = this.getFilter().and(qFilter);
        long billCount = this.getBillCount(fFilter, "0");
        long failCount = this.getBillCount(fFilter, "1");
        this.setLabelValue(billCount, "billcount");
        this.setLabelValue(failCount, "failedbillcount");
        this.setLabelValue(billCount - failCount, "successbillcount");
    }

    private long getBillCount(QFilter fFilter, String type) {
        HashSet<Object> objectSet = new HashSet<Object>(0);
        switch (type) {
            case "0": {
                this.getIdSet(fFilter, objectSet, "ocpos_saleorder");
                this.getIdSet(fFilter, objectSet, "ocpos_saleorder_return");
                this.getIdSet(fFilter, objectSet, "ocpos_salechange");
                break;
            }
            case "1": {
                QFilter qFilter = fFilter.copy();
                qFilter.and("executestate", "=", (Object)"0");
                this.getIdSet(qFilter, objectSet, "ocpos_saleorder");
                this.getIdSet(qFilter, objectSet, "ocpos_saleorder_return");
                qFilter = new QFilter("saleorderexecutestate", "=", (Object)"0");
                qFilter.or("returnexecutestate", "=", (Object)"0");
                fFilter.and(qFilter);
                this.getIdSet(fFilter, objectSet, "ocpos_salechange");
                break;
            }
        }
        return objectSet.size();
    }

    private void getIdSet(QFilter fFilter, Set<Object> objectSet, String entityId) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entityId, (String)"id", (QFilter[])fFilter.toArray(), null);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            objectSet.add(row.get("id"));
        }
    }

    private QFilter getFilter() {
        DynamicObject dyo = this.getModel().getDataEntity(true);
        List<Long> branchIds = this.getLongs(dyo, "salebranchfilter");
        List<Long> cashierIds = this.getLongs(dyo, "cashierfilter");
        Date startDate = dyo.getDate("starttime");
        Date endDate = dyo.getDate("endtime");
        String billNumber = dyo.getString("billnumber");
        QFilter qFilter = new QFilter("salebranchid", "in", branchIds);
        if (startDate != null) {
            qFilter.and("salestarttime", ">=", (Object)startDate);
        }
        if (endDate != null) {
            qFilter.and("salestarttime", "<=", (Object)endDate);
        }
        if (!CollectionUtils.isEmpty(cashierIds)) {
            qFilter.and("cashier", "in", cashierIds);
        }
        if (!StringUtils.isEmpty((CharSequence)billNumber)) {
            qFilter.and("billno", "like", (Object)("%" + billNumber + "%"));
        }
        return qFilter;
    }

    private List<Long> getLongs(DynamicObject dyo, String key) {
        DynamicObjectCollection branch = dyo.getDynamicObjectCollection(key);
        return branch.stream().map(s -> NumberUtils.toLong((String)s.getDynamicObject("fbasedataid").getPkValue().toString())).collect(Collectors.toList());
    }

    private void setLabelValue(long abnormalBillCount, String labAbnormalBillCount) {
        Label label = (Label)this.getView().getControl(labAbnormalBillCount);
        String abnormalBillCountText = Long.toString(abnormalBillCount);
        label.setText(abnormalBillCountText);
    }

    private void showBill(QFilter qFilter, QFilter changeFilter) {
        qFilter = this.getFilter().and(qFilter);
        changeFilter = this.getFilter().and(changeFilter);
        this.showSaleOrderBill(qFilter, "returnlistap", "ocpos_tracking_return");
        this.showSaleOrderBill(qFilter, "listap", "ocpos_trackinglist");
        this.showSaleOrderBill(changeFilter, "changelistap", "ocpos_tracking_change");
    }

    private void showSaleOrderBill(QFilter qFilter, String flexName, String formId) {
        ListShowParameter param = new ListShowParameter();
        ListFilterParameter filter = param.getListFilterParameter();
        filter.setFilter(qFilter);
        param.setListFilterParameter(filter);
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.setFormId("bos_list");
        param.setShowTitle(false);
        param.setShowFilter(false);
        param.setShowQuickFilter(false);
        param.setBillFormId(formId);
        param.getOpenStyle().setTargetKey(flexName);
        this.getView().showForm((FormShowParameter)param);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ArrayList<Long> branchList = new ArrayList<Long>();
        String key = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        if (key.equals("cashierfilter")) {
            DynamicObjectCollection branchS = this.getModel().getDataEntity(true).getDynamicObjectCollection("salebranchfilter");
            for (DynamicObject branch : branchS) {
                branchList.add(NumberUtils.toLong((String)branch.getDynamicObject("fbasedataid").getPkValue().toString()));
            }
            if (CollectionUtils.isEmpty(branchList)) {
                showParameter.getListFilterParameter().setFilter(F7Utils.getEveFalseFilter());
            } else {
                QFilter filter = this.getCashierFilter(branchList);
                showParameter.getListFilterParameter().setFilter(filter);
            }
        } else if (key.equals("salebranchfilter")) {
            showParameter.getListFilterParameter().setFilter(F7Util.getBranchIdFilter());
        }
    }

    public QFilter getCashierFilter(List<Long> branchIds) {
        QFilter filter = F7Utils.getEnableStatus();
        filter.and("owner", "in", branchIds);
        filter.and("iscashier", "=", (Object)"1");
        return filter;
    }
}

