/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.inventory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.DynamicTextListColumn;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListColumn;
import kd.bos.list.ListOperationColumn;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.business.helper.BotpFlowingHelper;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.business.push.AutoPushHelper;
import kd.occ.ocpos.common.enums.BillStatusEnum;
import kd.occ.ocpos.common.enums.BillTypeEnum;

public class OrderTrackingListPlugin
extends AbstractListPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbhandle"});
    }

    public void afterBindData(EventObject e) {
        String entity;
        super.afterBindData(e);
        ListSelectedRowCollection allRows = this.getCurrentListAllRowCollection();
        Object[] ids = allRows.getPrimaryKeyValues();
        if (ArrayUtils.isEmpty((Object[])ids)) {
            return;
        }
        BillList billList = (BillList)this.getControl("billlistap");
        switch (entity = billList.getEntityId()) {
            case "ocpos_saleorder": 
            case "ocpos_saleorder_return": {
                List result = BotpFlowingHelper.getAllTargetBill((Object[])ids);
                for (ListSelectedRow row : allRows) {
                    this.insertCellData(billList, result, row);
                }
                break;
            }
            case "ocpos_salechange": {
                QFilter qFilter = new QFilter("sourceentitynumber", "=", (Object)"ocpos_salechange");
                qFilter.and("sourcebillid", "in", (Object)ids);
                List result = BotpFlowingHelper.getAllTargetBillByChange((Object[])ids, (String)"ocpos_saleorder");
                List returnResult = BotpFlowingHelper.getAllTargetBillByChange((Object[])ids, (String)"ocpos_saleorder_return");
                for (ListSelectedRow row : allRows) {
                    this.insertCellData(billList, result, returnResult, row);
                }
                break;
            }
        }
        Set idSet = allRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("sourcebillid", "in", idSet);
        qFilter.and("sourceentitynumber", "=", (Object)entity);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)"ocdbd_botpflowing", (String)"operationtype,sourcebillid", (QFilter[])qFilter.toArray(), null);
        for (DynamicObject dyo : dynamicObjectCollection) {
            for (ListSelectedRow row : allRows) {
                if (!ObjectUtils.nullSafeEquals((Object)dyo.get("sourcebillid"), (Object)row.getPrimaryKeyValue())) continue;
                if (ObjectUtils.isEmpty((Object)dyo.get("operationtype")) || ObjectUtils.nullSafeEquals((Object)dyo.get("operationtype"), (Object)"A")) {
                    billList.setCellFieldValue("operationtype", row.getRowKey(), (Object)"\u81ea\u52a8\u751f\u6210");
                    this.setOperationTypeStyle(billList, row.getRowKey());
                    continue;
                }
                if (!ObjectUtils.nullSafeEquals((Object)dyo.get("operationtype"), (Object)"B")) continue;
                billList.setCellFieldValue("operationtype", row.getRowKey(), (Object)"\u624b\u52a8\u5904\u7406");
                this.setListRowStyle(billList, row.getRowKey());
            }
        }
    }

    private void setOperationTypeStyle(BillList billList, int row) {
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(0);
        CellStyle cellStyle = new CellStyle();
        cellStyle.setFieldKey("operationtype");
        cellStyle.setRow(row);
        cellStyle.setForeColor("RoyalBlue");
        cellStyles.add(cellStyle);
        billList.setCellStyle(cellStyles);
    }

    private void insertCellData(BillList billList, List<Map<String, Object>> result, List<Map<String, Object>> returnResult, ListSelectedRow row) {
        String billStatus;
        Object subId = row.getPrimaryKeyValue();
        boolean isFirst = true;
        for (Map<String, Object> objectMap : result) {
            if (!ObjectUtils.nullSafeEquals((Object)objectMap.get("ocpos_salechange"), (Object)subId)) continue;
            if (!objectMap.containsKey("ocpos_saleorder")) {
                this.setCellFieldValueSaleOrder(billList, row, objectMap, ObjectUtils.nullSafeToString((Object)objectMap.get("billstatus")), "\u96f6\u552e\u5f00\u5355", isFirst);
            }
            if (!objectMap.containsKey("ocococ_retailbill")) {
                this.setCellFieldValueSaleOrder(billList, row, objectMap, ObjectUtils.nullSafeToString((Object)objectMap.get("billstatus")), "\u96f6\u552e\u5f00\u5355", isFirst);
            }
            if (!objectMap.containsKey("ocococ_deliveryorder") && objectMap.containsKey("ocococ_retailbill")) {
                this.setCellFieldValueSaleOrder(billList, row, objectMap, ObjectUtils.nullSafeToString((Object)objectMap.get("billstatus")), "\u96f6\u552e\u5355", isFirst);
            }
            if (!objectMap.containsKey("im_saloutbill") && objectMap.containsKey("ocococ_deliveryorder")) {
                this.setCellFieldValueSaleOrder(billList, row, objectMap, ObjectUtils.nullSafeToString((Object)objectMap.get("billstatus")), "\u53d1\u8d27\u5355", isFirst);
            }
            if (objectMap.containsKey("im_saloutbill")) {
                billStatus = ObjectUtils.nullSafeToString((Object)objectMap.get("billstatus"));
                this.setCellFieldValueSaleOrder(billList, row, objectMap, billStatus, "\u9500\u552e\u51fa\u5e93\u5355", isFirst);
            }
            isFirst = false;
        }
        isFirst = true;
        for (Map<String, Object> objectMap : returnResult) {
            if (!ObjectUtils.nullSafeEquals((Object)objectMap.get("ocpos_salechange"), (Object)subId)) continue;
            if (!objectMap.containsKey("ocpos_saleorder")) {
                this.setCellFieldValueReturn(billList, row, objectMap, ObjectUtils.nullSafeToString((Object)objectMap.get("billstatus")), "\u96f6\u552e\u5f00\u5355", isFirst);
            }
            if (!objectMap.containsKey("ocococ_retailbill")) {
                this.setCellFieldValueReturn(billList, row, objectMap, ObjectUtils.nullSafeToString((Object)objectMap.get("billstatus")), "\u96f6\u552e\u5f00\u5355", isFirst);
            }
            if (!objectMap.containsKey("ocococ_deliveryorder") && objectMap.containsKey("ocococ_retailbill")) {
                this.setCellFieldValueReturn(billList, row, objectMap, ObjectUtils.nullSafeToString((Object)objectMap.get("billstatus")), "\u96f6\u552e\u5355", isFirst);
            }
            if (!objectMap.containsKey("im_saloutbill") && objectMap.containsKey("ocococ_deliveryorder")) {
                this.setCellFieldValueReturn(billList, row, objectMap, ObjectUtils.nullSafeToString((Object)objectMap.get("billstatus")), "\u53d1\u8d27\u5355", isFirst);
            }
            if (objectMap.containsKey("im_saloutbill")) {
                billStatus = ObjectUtils.nullSafeToString((Object)objectMap.get("billstatus"));
                this.setCellFieldValueReturn(billList, row, objectMap, billStatus, "\u9500\u552e\u51fa\u5e93\u5355", isFirst);
            }
            isFirst = false;
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "tblclose": {
                this.getView().getParentView().close();
                this.getView().sendFormAction(this.getView().getParentView());
                break;
            }
            case "tbhandle": {
                ListSelectedRowCollection listSelectedRows = this.getSelectedRows();
                if (listSelectedRows.isEmpty()) {
                    NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (IFormView)this.getView());
                    return;
                }
                List idList = listSelectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
                String entity = BillTypeEnum.getEntityIdById((long)listSelectedRows.get(0).getBillTypeID());
                QFilter fFilter = new QFilter("sourcebillid", "in", idList);
                fFilter.and("sourceentitynumber", "=", (Object)entity);
                QFilter qFilter = new QFilter("operationtype", "=", (Object)"");
                qFilter.or("operationtype", "=", (Object)"A");
                fFilter.and(qFilter);
                DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocdbd_botpflowing", (String)"id", (QFilter[])fFilter.toArray(), null);
                if (!dataSet.hasNext()) {
                    NotificationUtil.showDefaultTipNotify((String)"\u5355\u636e\u5df2\u624b\u5de5\u5904\u7406\u5b8c\u6210\uff0c\u65e0\u9700\u91cd\u590d\u6267\u884c\u3002", (IFormView)this.getView());
                    return;
                }
                switch (entity) {
                    case "ocpos_saleorder": 
                    case "ocpos_saleorder_return": {
                        qFilter = new QFilter("id", "in", idList);
                        qFilter.and("executestate", "=", (Object)"0");
                        dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entity, (String)"id", (QFilter[])qFilter.toArray(), null);
                        if (dataSet.hasNext()) break;
                        NotificationUtil.showDefaultTipNotify((String)"\u65e0\u9700\u624b\u52a8\u6267\u884c\u7684\u5355\u636e\u3002", (IFormView)this.getView());
                        return;
                    }
                    case "ocpos_salechange": {
                        qFilter = new QFilter("id", "in", idList);
                        QFilter filter = new QFilter("saleorderexecutestate", "=", (Object)"0");
                        filter.or("returnexecutestate", "=", (Object)"0");
                        qFilter.and(filter);
                        dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entity, (String)"id", (QFilter[])qFilter.toArray(), null);
                        if (dataSet.hasNext()) break;
                        NotificationUtil.showDefaultTipNotify((String)"\u65e0\u9700\u624b\u52a8\u6267\u884c\u7684\u5355\u636e\u3002", (IFormView)this.getView());
                        return;
                    }
                }
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("tbhandle", (IFormPlugin)this);
                this.getView().showConfirm("\u662f\u5426\u624b\u5de5\u5904\u7406\uff1f", MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                break;
            }
        }
    }

    private void insertCellData(BillList billList, List<Map<String, Object>> result, ListSelectedRow row) {
        Object subId = row.getPrimaryKeyValue();
        boolean isFirst = true;
        for (Map<String, Object> objectMap : result) {
            if (!ObjectUtils.nullSafeEquals((Object)objectMap.get("ocpos_saleorder"), (Object)subId)) continue;
            if (!objectMap.containsKey("ocococ_retailbill")) {
                if (objectMap.containsKey("ocococ_orderbill")) {
                    this.setCellFieldValue(billList, row, objectMap, ObjectUtils.nullSafeToString((Object)objectMap.get("billstatus")), "\u9884\u8ba2\u5355", isFirst);
                    break;
                }
                this.setCellFieldValue(billList, row, objectMap, ObjectUtils.nullSafeToString((Object)objectMap.get("billstatus")), "\u96f6\u552e\u5f00\u5355", isFirst);
            }
            if (!objectMap.containsKey("ocococ_deliveryorder") && objectMap.containsKey("ocococ_retailbill")) {
                this.setCellFieldValue(billList, row, objectMap, ObjectUtils.nullSafeToString((Object)objectMap.get("billstatus")), "\u96f6\u552e\u5355", isFirst);
            }
            if (!objectMap.containsKey("im_saloutbill") && objectMap.containsKey("ocococ_deliveryorder")) {
                this.setCellFieldValue(billList, row, objectMap, ObjectUtils.nullSafeToString((Object)objectMap.get("billstatus")), "\u53d1\u8d27\u5355", isFirst);
            }
            if (objectMap.containsKey("im_saloutbill")) {
                String billStatus = ObjectUtils.nullSafeToString((Object)objectMap.get("billstatus"));
                this.setCellFieldValue(billList, row, objectMap, billStatus, "\u9500\u552e\u51fa\u5e93\u5355", isFirst);
            }
            isFirst = false;
        }
    }

    private void setCellFieldValue(BillList billList, ListSelectedRow row, Map<String, Object> objectMap, String billStatus, String entityNumber, boolean isFirst) {
        billList.setCellFieldValue("dwellnode", row.getRowKey(), (Object)entityNumber);
        billList.setCellFieldValue("curexecutestate", row.getRowKey(), (Object)BillStatusEnum.getName((String)billStatus));
        billList.setCellFieldValue("billcomment", row.getRowKey(), objectMap.get("billcomment"));
        billList.setCellFieldValue("targetbillno", row.getRowKey(), objectMap.get("targetbillno"));
        if (!isFirst) {
            if (!StringUtils.equals((CharSequence)entityNumber, (CharSequence)"im_saloutbill")) {
                billList.setCellFieldValue("dwellnode", row.getRowKey(), (Object)entityNumber);
                billList.setCellFieldValue("targetbillno", row.getRowKey(), objectMap.get("targetbillno"));
                billList.setCellFieldValue("curexecutestate", row.getRowKey(), (Object)BillStatusEnum.getName((String)billStatus));
                billList.setCellFieldValue("billcomment", row.getRowKey(), objectMap.get("billcomment"));
            } else if (!StringUtils.equals((CharSequence)BillStatusEnum.C.getValue(), (CharSequence)BillStatusEnum.getName((String)billStatus))) {
                billList.setCellFieldValue("dwellnode", row.getRowKey(), (Object)entityNumber);
                billList.setCellFieldValue("targetbillno", row.getRowKey(), objectMap.get("targetbillno"));
                billList.setCellFieldValue("curexecutestate", row.getRowKey(), (Object)BillStatusEnum.getName((String)billStatus));
                billList.setCellFieldValue("billcomment", row.getRowKey(), objectMap.get("billcomment"));
            }
        }
    }

    private void setCellFieldValueSaleOrder(BillList billList, ListSelectedRow row, Map<String, Object> objectMap, String billStatus, String entityNumber, boolean isFirst) {
        billList.setCellFieldValue("saleorderdwellnode", row.getRowKey(), (Object)entityNumber);
        billList.setCellFieldValue("curexecutestate", row.getRowKey(), (Object)BillStatusEnum.getName((String)billStatus));
        billList.setCellFieldValue("billcomment", row.getRowKey(), objectMap.get("billcomment"));
        billList.setCellFieldValue("saleordertargetbillno", row.getRowKey(), objectMap.get("targetbillno"));
        if (!isFirst) {
            if (!StringUtils.equals((CharSequence)entityNumber, (CharSequence)"im_saloutbill")) {
                billList.setCellFieldValue("saleorderdwellnode", row.getRowKey(), (Object)entityNumber);
                billList.setCellFieldValue("saleordertargetbillno", row.getRowKey(), objectMap.get("targetbillno"));
                billList.setCellFieldValue("curexecutestate", row.getRowKey(), (Object)BillStatusEnum.getName((String)billStatus));
                billList.setCellFieldValue("billcomment", row.getRowKey(), objectMap.get("billcomment"));
            } else if (!StringUtils.equals((CharSequence)BillStatusEnum.C.getValue(), (CharSequence)BillStatusEnum.getName((String)billStatus))) {
                billList.setCellFieldValue("saleorderdwellnode", row.getRowKey(), (Object)entityNumber);
                billList.setCellFieldValue("saleordertargetbillno", row.getRowKey(), objectMap.get("targetbillno"));
                billList.setCellFieldValue("curexecutestate", row.getRowKey(), (Object)BillStatusEnum.getName((String)billStatus));
                billList.setCellFieldValue("billcomment", row.getRowKey(), objectMap.get("billcomment"));
            }
        }
    }

    private void setCellFieldValueReturn(BillList billList, ListSelectedRow row, Map<String, Object> objectMap, String billStatus, String entityNumber, boolean isFirst) {
        billList.setCellFieldValue("returndwellnode", row.getRowKey(), (Object)entityNumber);
        billList.setCellFieldValue("returncurexecutestate", row.getRowKey(), (Object)BillStatusEnum.getName((String)billStatus));
        billList.setCellFieldValue("billcomment", row.getRowKey(), objectMap.get("billcomment"));
        billList.setCellFieldValue("returntargetbillno", row.getRowKey(), objectMap.get("targetbillno"));
        if (!isFirst) {
            if (!StringUtils.equals((CharSequence)entityNumber, (CharSequence)"im_saloutbill")) {
                billList.setCellFieldValue("returndwellnode", row.getRowKey(), (Object)entityNumber);
                billList.setCellFieldValue("returntargetbillno", row.getRowKey(), objectMap.get("targetbillno"));
                billList.setCellFieldValue("returncurexecutestate", row.getRowKey(), (Object)BillStatusEnum.getName((String)billStatus));
                billList.setCellFieldValue("billcomment", row.getRowKey(), objectMap.get("billcomment"));
            } else if (!StringUtils.equals((CharSequence)BillStatusEnum.C.getValue(), (CharSequence)BillStatusEnum.getName((String)billStatus))) {
                billList.setCellFieldValue("returndwellnode", row.getRowKey(), (Object)entityNumber);
                billList.setCellFieldValue("returntargetbillno", row.getRowKey(), objectMap.get("targetbillno"));
                billList.setCellFieldValue("returncurexecutestate", row.getRowKey(), (Object)BillStatusEnum.getName((String)billStatus));
                billList.setCellFieldValue("billcomment", row.getRowKey(), objectMap.get("billcomment"));
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        if (args.getHyperLinkClickEvent() instanceof BillListHyperLinkClickEvent) {
            BillListHyperLinkClickEvent linkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
            Object pkId = linkClickEvent.getCurrentRow().getPrimaryKeyValue();
            switch (args.getFieldName()) {
                case "targetbillno": {
                    args.setCancel(true);
                    Map<String, Object> map = this.getTargetMap(pkId);
                    this.showTargetPage(map);
                    break;
                }
                case "saleordertargetbillno": {
                    args.setCancel(true);
                    Map<String, Object> map = this.getChangeTargetMap(pkId, "ocpos_saleorder");
                    this.showTargetPage(map);
                    break;
                }
                case "returntargetbillno": {
                    args.setCancel(true);
                    Map<String, Object> map = this.getChangeTargetMap(pkId, "ocpos_saleorder_return");
                    this.showTargetPage(map);
                    break;
                }
            }
        }
    }

    private void showTargetPage(Map<String, Object> map) {
        if (map.containsKey("targetentitynumber")) {
            BillShowParameter billShowParameter = new BillShowParameter();
            String formId = (String)map.get("targetentitynumber");
            billShowParameter.setFormId(formId);
            billShowParameter.setPkId(map.get("targetbillid"));
            billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            if (billShowParameter.getFormConfig() == null) {
                billShowParameter.setFormConfig(FormMetadataCache.getFormConfig((String)formId));
            }
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    private Map<String, Object> getChangeTargetMap(Object pkId, String entity) {
        HashMap<String, Object> map = new HashMap<String, Object>(0);
        QFilter qFilter = new QFilter("sourcebillid", "=", pkId);
        qFilter.and("targetentitynumber", "=", (Object)entity);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocdbd_botpflowing", (String)"targetbillid", (QFilter[])qFilter.toArray(), null);
        ArrayList<Object> list = new ArrayList<Object>(0);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            list.add(row.get("targetbillid"));
        }
        if (list.size() == 0) {
            return map;
        }
        if (list.size() > 1) {
            this.getView().showTipNotification("\u5355\u636e\u5b58\u5728\u4e24\u5f20\u6b63\u5411\u4e0b\u6e38\u5355\u636e\uff0c\u8bf7\u624b\u52a8\u4e0b\u67e5\u5904\u7406\u3002");
        } else {
            Row row;
            qFilter = new QFilter("sourcebillid", "in", list);
            qFilter.and("targetentitynumber", "=", (Object)"ocococ_retailbill");
            dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocdbd_botpflowing", (String)"targetbillid", (QFilter[])qFilter.toArray(), null);
            ArrayList<Object> newList = new ArrayList<Object>(0);
            while (dataSet.hasNext()) {
                row = dataSet.next();
                newList.add(row.get("targetbillid"));
            }
            if (newList.size() == 0) {
                map.put("targetentitynumber", entity);
                map.put("targetbillid", list.get(0));
                return map;
            }
            if (newList.size() > 1) {
                if (StringUtils.equals((CharSequence)entity, (CharSequence)"ocpos_saleorder")) {
                    this.getView().showTipNotification("\u5355\u636e\u5b58\u5728\u4e24\u5f20\u6b63\u5411\u4e0b\u6e38\u5355\u636e\uff0c\u8bf7\u624b\u52a8\u4e0b\u67e5\u5904\u7406\u3002");
                } else {
                    this.getView().showTipNotification("\u5355\u636e\u5b58\u5728\u4e24\u5f20\u8d1f\u5411\u4e0b\u6e38\u5355\u636e\uff0c\u8bf7\u624b\u52a8\u4e0b\u67e5\u5904\u7406\u3002");
                }
            } else {
                qFilter = new QFilter("sourcebillid", "in", newList);
                qFilter.and("targetentitynumber", "=", (Object)"ocococ_deliveryorder");
                dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocdbd_botpflowing", (String)"targetbillid", (QFilter[])qFilter.toArray(), null);
                list = new ArrayList(0);
                while (dataSet.hasNext()) {
                    row = dataSet.next();
                    list.add(row.get("targetbillid"));
                }
                if (list.size() == 0) {
                    map.put("targetentitynumber", "ocococ_retailbill");
                    map.put("targetbillid", newList.get(0));
                    return map;
                }
                if (list.size() > 1) {
                    if (StringUtils.equals((CharSequence)entity, (CharSequence)"ocpos_saleorder")) {
                        this.getView().showTipNotification("\u5355\u636e\u5b58\u5728\u4e24\u5f20\u6b63\u5411\u4e0b\u6e38\u5355\u636e\uff0c\u8bf7\u624b\u52a8\u4e0b\u67e5\u5904\u7406\u3002");
                    } else {
                        this.getView().showTipNotification("\u5355\u636e\u5b58\u5728\u4e24\u5f20\u8d1f\u5411\u4e0b\u6e38\u5355\u636e\uff0c\u8bf7\u624b\u52a8\u4e0b\u67e5\u5904\u7406\u3002");
                    }
                } else {
                    qFilter = new QFilter("sourcebillid", "in", list);
                    qFilter.and("targetentitynumber", "=", (Object)"im_saloutbill");
                    dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocdbd_botpflowing", (String)"targetbillid", (QFilter[])qFilter.toArray(), null);
                    newList = new ArrayList(0);
                    while (dataSet.hasNext()) {
                        row = dataSet.next();
                        newList.add(row.get("targetbillid"));
                    }
                    if (newList.size() == 0) {
                        map.put("targetentitynumber", "ocococ_deliveryorder");
                        map.put("targetbillid", list.get(0));
                        return map;
                    }
                    if (newList.size() > 1) {
                        if (StringUtils.equals((CharSequence)entity, (CharSequence)"ocpos_saleorder")) {
                            this.getView().showTipNotification("\u5355\u636e\u5b58\u5728\u4e24\u5f20\u6b63\u5411\u4e0b\u6e38\u5355\u636e\uff0c\u8bf7\u624b\u52a8\u4e0b\u67e5\u5904\u7406\u3002");
                        } else {
                            this.getView().showTipNotification("\u5355\u636e\u5b58\u5728\u4e24\u5f20\u8d1f\u5411\u4e0b\u6e38\u5355\u636e\uff0c\u8bf7\u624b\u52a8\u4e0b\u67e5\u5904\u7406\u3002");
                        }
                    } else {
                        map.put("targetentitynumber", "im_saloutbill");
                        map.put("targetbillid", newList.get(0));
                        return map;
                    }
                }
            }
        }
        return new HashMap<String, Object>(0);
    }

    private Map<String, Object> getTargetMap(Object pkId) {
        HashMap<String, Object> map = new HashMap<String, Object>(0);
        QFilter qFilter = new QFilter("sourcebillid", "=", pkId);
        qFilter.and("targetentitynumber", "=", (Object)"ocococ_retailbill");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocdbd_botpflowing", (String)"targetbillid", (QFilter[])qFilter.toArray(), null);
        ArrayList<Object> list = new ArrayList<Object>(0);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            if (row.get("targetbillid").equals(0L)) continue;
            list.add(row.get("targetbillid"));
        }
        if (list.size() == 0) {
            QFilter fFilter = new QFilter("sourcebillid", "=", pkId);
            fFilter.and("targetentitynumber", "=", (Object)"ocococ_orderbill");
            DataSet dataSet1 = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocdbd_botpflowing", (String)"targetbillid", (QFilter[])fFilter.toArray(), null);
            while (dataSet1.hasNext()) {
                Row row = dataSet1.next();
                list.add(row.get("targetbillid"));
            }
            if (list.size() == 0) {
                return map;
            }
            if (list.size() > 1) {
                this.getView().showTipNotification("\u5355\u636e\u5b58\u5728\u4e24\u5f20\u4e0b\u6e38\u5355\u636e\uff0c\u8bf7\u624b\u52a8\u4e0b\u67e5\u5904\u7406\u3002");
            } else {
                map.put("targetentitynumber", "ocococ_orderbill");
                map.put("targetbillid", list.get(0));
            }
        } else if (list.size() > 1) {
            this.getView().showTipNotification("\u5355\u636e\u5b58\u5728\u4e24\u5f20\u4e0b\u6e38\u5355\u636e\uff0c\u8bf7\u624b\u52a8\u4e0b\u67e5\u5904\u7406\u3002");
        } else {
            Row row;
            qFilter = new QFilter("sourcebillid", "in", list);
            qFilter.and("targetentitynumber", "=", (Object)"ocococ_deliveryorder");
            dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocdbd_botpflowing", (String)"targetbillid", (QFilter[])qFilter.toArray(), null);
            ArrayList<Object> newList = new ArrayList<Object>(0);
            while (dataSet.hasNext()) {
                row = dataSet.next();
                if (row.get("targetbillid").equals(0L)) continue;
                newList.add(row.get("targetbillid"));
            }
            if (CollectionUtils.isEmpty(newList)) {
                map.put("targetentitynumber", "ocococ_retailbill");
                map.put("targetbillid", list.get(0));
            } else if (newList.size() > 1) {
                this.getView().showTipNotification("\u5355\u636e\u5b58\u5728\u4e24\u5f20\u4e0b\u6e38\u5355\u636e\uff0c\u8bf7\u624b\u52a8\u4e0b\u67e5\u5904\u7406\u3002");
            } else {
                qFilter = new QFilter("sourcebillid", "in", newList);
                qFilter.and("targetentitynumber", "=", (Object)"im_saloutbill");
                dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocdbd_botpflowing", (String)"targetbillid", (QFilter[])qFilter.toArray(), null);
                list.clear();
                while (dataSet.hasNext()) {
                    row = dataSet.next();
                    if (row.get("targetbillid").equals(0L)) continue;
                    list.add(row.get("targetbillid"));
                }
                if (CollectionUtils.isEmpty(list)) {
                    map.put("targetentitynumber", "ocococ_deliveryorder");
                    map.put("targetbillid", newList.get(0));
                } else if (list.size() > 1) {
                    this.getView().showTipNotification("\u5355\u636e\u5b58\u5728\u4e24\u5f20\u4e0b\u6e38\u5355\u636e\uff0c\u8bf7\u624b\u52a8\u4e0b\u67e5\u5904\u7406\u3002");
                } else {
                    map.put("targetentitynumber", "im_saloutbill");
                    map.put("targetbillid", list.get(0));
                }
            }
        }
        return map;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String opKey = afterDoOperationEventArgs.getOperateKey();
        if (StringUtils.equals((CharSequence)opKey, (CharSequence)"reexecute")) {
            String entity;
            Donothing donothing = (Donothing)afterDoOperationEventArgs.getSource();
            ListSelectedRowCollection listSelectedData = donothing.getListSelectedData();
            if (CollectionUtils.isEmpty((Collection)listSelectedData)) {
                return;
            }
            Object[] idArray = listSelectedData.getPrimaryKeyValues();
            if (ArrayUtils.isEmpty((Object[])idArray)) {
                return;
            }
            BillList billList = (BillList)this.getControl("billlistap");
            switch (entity = billList.getEntityId()) {
                case "ocpos_saleorder": 
                case "ocpos_saleorder_return": {
                    this.doOperationBySaleOrder(idArray[0]);
                    break;
                }
                case "ocpos_salechange": {
                    this.doOperationByChange(idArray[0]);
                    break;
                }
            }
        }
    }

    private void doOperationByChange(Object pkId1) {
        Map<String, Object> targetMap = this.getChangeTargetMap(pkId1, "ocpos_saleorder");
        if (targetMap.containsKey("targetentitynumber")) {
            String formId = (String)targetMap.get("targetentitynumber");
            Object pkId = targetMap.get("targetbillid");
            QFilter qFilter = new QFilter("id", "=", pkId);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)formId, (String)"billstatus", (QFilter[])qFilter.toArray(), null);
            if (dataSet.hasNext()) {
                Row row = dataSet.next();
                OperationResult operationResult = null;
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", String.valueOf(true));
                DynamicObject dyo = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)formId);
                switch (row.getString("billstatus")) {
                    case "A": {
                        operationResult = OperationServiceHelper.executeOperate((String)"submit", (String)formId, (DynamicObject[])new DynamicObject[]{dyo}, (OperateOption)option);
                        if (!operationResult.isSuccess()) {
                            String errorMessage = ObjectUtils.nullSafeToString((Object)operationResult.getAllErrorOrValidateInfo());
                            if (operationResult.getInteractionContext() != null) {
                                errorMessage = errorMessage + operationResult.getInteractionContext().getSimpleMessage();
                            }
                            this.getView().showMessage(errorMessage);
                            return;
                        }
                        operationResult = OperationServiceHelper.executeOperate((String)"audit", (String)formId, (DynamicObject[])new DynamicObject[]{dyo}, (OperateOption)option);
                        if (operationResult.isSuccess()) break;
                        String errorMessage = ObjectUtils.nullSafeToString((Object)operationResult.getAllErrorOrValidateInfo());
                        if (operationResult.getInteractionContext() != null) {
                            errorMessage = errorMessage + operationResult.getInteractionContext().getSimpleMessage();
                        }
                        this.getView().showMessage(errorMessage);
                        break;
                    }
                    case "B": {
                        operationResult = OperationServiceHelper.executeOperate((String)"audit", (String)formId, (DynamicObject[])new DynamicObject[]{dyo}, (OperateOption)option);
                        if (operationResult.isSuccess()) break;
                        String errorMessage = ObjectUtils.nullSafeToString((Object)operationResult.getAllErrorOrValidateInfo());
                        if (operationResult.getInteractionContext() != null) {
                            errorMessage = errorMessage + operationResult.getInteractionContext().getSimpleMessage();
                        }
                        this.getView().showMessage(errorMessage);
                        break;
                    }
                    case "C": {
                        if (StringUtils.equals((CharSequence)formId, (CharSequence)"ocococ_orderbill") || StringUtils.equals((CharSequence)formId, (CharSequence)"im_saloutbill")) {
                            targetMap = this.getChangeTargetMap(pkId1, "ocpos_saleorder_return");
                            if (!targetMap.containsKey("targetentitynumber")) break;
                            formId = (String)targetMap.get("targetentitynumber");
                            pkId = targetMap.get("targetbillid");
                            qFilter = new QFilter("id", "=", pkId);
                            dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)formId, (String)"billstatus", (QFilter[])qFilter.toArray(), null);
                            if (!dataSet.hasNext()) break;
                            row = dataSet.next();
                            option = OperateOption.create();
                            option.setVariableValue("ishasright", String.valueOf(true));
                            dyo = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)formId);
                            switch (row.getString("billstatus")) {
                                case "A": {
                                    operationResult = OperationServiceHelper.executeOperate((String)"submit", (String)formId, (DynamicObject[])new DynamicObject[]{dyo}, (OperateOption)option);
                                    if (!operationResult.isSuccess()) {
                                        String errorMessage = ObjectUtils.nullSafeToString((Object)operationResult.getAllErrorOrValidateInfo());
                                        if (operationResult.getInteractionContext() != null) {
                                            errorMessage = errorMessage + operationResult.getInteractionContext().getSimpleMessage();
                                        }
                                        this.getView().showMessage(errorMessage);
                                        return;
                                    }
                                    operationResult = OperationServiceHelper.executeOperate((String)"audit", (String)formId, (DynamicObject[])new DynamicObject[]{dyo}, (OperateOption)option);
                                    if (operationResult.isSuccess()) break;
                                    String errorMessage = ObjectUtils.nullSafeToString((Object)operationResult.getAllErrorOrValidateInfo());
                                    if (operationResult.getInteractionContext() != null) {
                                        errorMessage = errorMessage + operationResult.getInteractionContext().getSimpleMessage();
                                    }
                                    this.getView().showMessage(errorMessage);
                                    break;
                                }
                                case "B": {
                                    operationResult = OperationServiceHelper.executeOperate((String)"audit", (String)formId, (DynamicObject[])new DynamicObject[]{dyo}, (OperateOption)option);
                                    if (operationResult.isSuccess()) break;
                                    String errorMessage = ObjectUtils.nullSafeToString((Object)operationResult.getAllErrorOrValidateInfo());
                                    if (operationResult.getInteractionContext() != null) {
                                        errorMessage = errorMessage + operationResult.getInteractionContext().getSimpleMessage();
                                    }
                                    this.getView().showMessage(errorMessage);
                                    break;
                                }
                                case "C": {
                                    if (StringUtils.equals((CharSequence)formId, (CharSequence)"ocococ_orderbill") || StringUtils.equals((CharSequence)formId, (CharSequence)"im_saloutbill")) {
                                        NotificationUtil.showDefaultTipNotify((String)"\u8ba2\u5355\u6d41\u7a0b\u5df2\u6d41\u8f6c\u5b8c\u6210\uff0c\u65e0\u9700\u91cd\u65b0\u64cd\u4f5c\u3002", (IFormView)this.getView());
                                        break;
                                    }
                                    switch (formId) {
                                        case "ocpos_saleorder": 
                                        case "ocpos_saleorder_return": {
                                            operationResult = AutoPushHelper.autoPushBill((Object)pkId, (String)formId, (String)"ocococ_retailbill", (String)"audit");
                                            break;
                                        }
                                        case "ocococ_retailbill": {
                                            operationResult = AutoPushHelper.autoPushBill((Object)pkId, (String)formId, (String)"ocococ_deliveryorder", (String)"audit");
                                            break;
                                        }
                                        case "ocococ_deliveryorder": {
                                            operationResult = AutoPushHelper.autoPushBill((Object)pkId, (String)formId, (String)"im_saloutbill", (String)"audit");
                                            break;
                                        }
                                    }
                                    if (operationResult != null && !operationResult.isSuccess()) {
                                        String errorMessage = ObjectUtils.nullSafeToString((Object)operationResult.getAllErrorOrValidateInfo());
                                        if (operationResult.getInteractionContext() != null) {
                                            errorMessage = errorMessage + operationResult.getInteractionContext().getSimpleMessage();
                                        }
                                        this.getView().showMessage(errorMessage);
                                        break;
                                    }
                                    ((IListView)this.getView()).refresh();
                                    break;
                                }
                            }
                            break;
                        }
                        switch (formId) {
                            case "ocpos_saleorder": 
                            case "ocpos_saleorder_return": {
                                operationResult = AutoPushHelper.autoPushBill((Object)pkId, (String)formId, (String)"ocococ_retailbill", (String)"audit");
                                break;
                            }
                            case "ocococ_retailbill": {
                                operationResult = AutoPushHelper.autoPushBill((Object)pkId, (String)formId, (String)"ocococ_deliveryorder", (String)"audit");
                                break;
                            }
                            case "ocococ_deliveryorder": {
                                operationResult = AutoPushHelper.autoPushBill((Object)pkId, (String)formId, (String)"im_saloutbill", (String)"audit");
                                break;
                            }
                        }
                        if (operationResult != null && !operationResult.isSuccess()) {
                            String errorMessage = ObjectUtils.nullSafeToString((Object)operationResult.getAllErrorOrValidateInfo());
                            if (operationResult.getInteractionContext() != null) {
                                errorMessage = errorMessage + operationResult.getInteractionContext().getSimpleMessage();
                            }
                            this.getView().showMessage(errorMessage);
                            break;
                        }
                        ((IListView)this.getView()).refresh();
                        break;
                    }
                }
            }
        }
    }

    private void doOperationBySaleOrder(Object pkId1) {
        Map<String, Object> targetMap = this.getTargetMap(pkId1);
        if (targetMap.containsKey("targetentitynumber")) {
            String formId = (String)targetMap.get("targetentitynumber");
            Object pkId = targetMap.get("targetbillid");
            QFilter qFilter = new QFilter("id", "=", pkId);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)formId, (String)"billstatus", (QFilter[])qFilter.toArray(), null);
            if (dataSet.hasNext()) {
                Row row = dataSet.next();
                OperationResult operationResult = null;
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", String.valueOf(true));
                DynamicObject dyo = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)formId);
                switch (row.getString("billstatus")) {
                    case "A": {
                        operationResult = OperationServiceHelper.executeOperate((String)"submit", (String)formId, (DynamicObject[])new DynamicObject[]{dyo}, (OperateOption)option);
                        if (!operationResult.isSuccess()) {
                            String errorMessage = ObjectUtils.nullSafeToString((Object)operationResult.getAllErrorOrValidateInfo());
                            if (operationResult.getInteractionContext() != null) {
                                errorMessage = errorMessage + operationResult.getInteractionContext().getSimpleMessage();
                            }
                            this.getView().showMessage(errorMessage);
                            return;
                        }
                        operationResult = OperationServiceHelper.executeOperate((String)"audit", (String)formId, (DynamicObject[])new DynamicObject[]{dyo}, (OperateOption)option);
                        if (operationResult.isSuccess()) break;
                        String errorMessage = ObjectUtils.nullSafeToString((Object)operationResult.getAllErrorOrValidateInfo());
                        if (operationResult.getInteractionContext() != null) {
                            errorMessage = errorMessage + operationResult.getInteractionContext().getSimpleMessage();
                        }
                        this.getView().showMessage(errorMessage);
                        break;
                    }
                    case "B": {
                        operationResult = OperationServiceHelper.executeOperate((String)"audit", (String)formId, (DynamicObject[])new DynamicObject[]{dyo}, (OperateOption)option);
                        if (operationResult.isSuccess()) break;
                        String errorMessage = ObjectUtils.nullSafeToString((Object)operationResult.getAllErrorOrValidateInfo());
                        if (operationResult.getInteractionContext() != null) {
                            errorMessage = errorMessage + operationResult.getInteractionContext().getSimpleMessage();
                        }
                        this.getView().showMessage(errorMessage);
                        break;
                    }
                    case "C": {
                        if (StringUtils.equals((CharSequence)formId, (CharSequence)"ocococ_orderbill") || StringUtils.equals((CharSequence)formId, (CharSequence)"im_saloutbill")) {
                            NotificationUtil.showDefaultTipNotify((String)"\u8ba2\u5355\u6d41\u7a0b\u5df2\u6d41\u8f6c\u5b8c\u6210\uff0c\u65e0\u9700\u91cd\u65b0\u64cd\u4f5c\u3002", (IFormView)this.getView());
                            break;
                        }
                        switch (formId) {
                            case "ocpos_saleorder": 
                            case "ocpos_saleorder_return": {
                                operationResult = AutoPushHelper.autoPushBill((Object)pkId, (String)formId, (String)"ocococ_retailbill", (String)"audit");
                                break;
                            }
                            case "ocococ_retailbill": {
                                operationResult = AutoPushHelper.autoPushBill((Object)pkId, (String)formId, (String)"ocococ_deliveryorder", (String)"audit");
                                break;
                            }
                            case "ocococ_deliveryorder": {
                                operationResult = AutoPushHelper.autoPushBill((Object)pkId, (String)formId, (String)"im_saloutbill", (String)"audit");
                                break;
                            }
                        }
                        if (operationResult != null && !operationResult.isSuccess()) {
                            String errorMessage = ObjectUtils.nullSafeToString((Object)operationResult.getAllErrorOrValidateInfo());
                            if (operationResult.getInteractionContext() != null) {
                                errorMessage = errorMessage + operationResult.getInteractionContext().getSimpleMessage();
                            }
                            this.getView().showMessage(errorMessage);
                            break;
                        }
                        ((IListView)this.getView()).refresh();
                        break;
                    }
                }
            }
        }
    }

    private void setListRowStyle(BillList billList, int row) {
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(0);
        List list = billList.getShowListColumns();
        for (IListColumn iListColumn : list) {
            CellStyle cellStyle = new CellStyle();
            if (iListColumn instanceof ListColumn) {
                String key = ((ListColumn)iListColumn).getFieldKey();
                if (key.contains(".")) {
                    key = key.replace(".", "_");
                }
                cellStyle.setFieldKey(key);
            } else if (iListColumn instanceof ListOperationColumn) {
                cellStyle.setFieldKey(((ListOperationColumn)iListColumn).getKey());
            } else {
                if (!(iListColumn instanceof DynamicTextListColumn)) continue;
                cellStyle.setFieldKey(((DynamicTextListColumn)iListColumn).getKey());
            }
            cellStyle.setRow(row);
            cellStyle.setForeColor("RoyalBlue");
            cellStyles.add(cellStyle);
        }
        billList.setCellStyle(cellStyles);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("No".equals(messageBoxClosedEvent.getResultValue())) {
            return;
        }
        ListSelectedRowCollection listSelectedRows = this.getSelectedRows();
        String callBackId = messageBoxClosedEvent.getCallBackId();
        List idList = listSelectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        ListSelectedRowCollection selectedRowCollection = this.getSelectedRows();
        if (StringUtils.equals((CharSequence)callBackId, (CharSequence)"tbhandle")) {
            String entity = BillTypeEnum.getEntityIdById((long)selectedRowCollection.get(0).getBillTypeID());
            QFilter qFilter = new QFilter("sourcebillid", "in", idList);
            qFilter.and("sourceentitynumber", "=", (Object)entity);
            DynamicObject[] dyoArray = BusinessDataServiceHelper.load((String)"ocdbd_botpflowing", (String)"operationtype,sourcebillid", (QFilter[])qFilter.toArray());
            switch (entity) {
                case "ocpos_saleorder": 
                case "ocpos_saleorder_return": {
                    qFilter = new QFilter("id", "in", idList);
                    qFilter.and("executestate", "=", (Object)"0");
                    DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entity, (String)"id,executestate", (QFilter[])qFilter.toArray(), null);
                    while (dataSet.hasNext()) {
                        Row row = dataSet.next();
                        for (DynamicObject dyo : dyoArray) {
                            if (!ObjectUtils.nullSafeEquals((Object)dyo.get("sourcebillid"), (Object)row.get("id"))) continue;
                            dyo.set("operationtype", (Object)"B");
                        }
                    }
                    SaveServiceHelper.save((DynamicObject[])dyoArray);
                    break;
                }
                case "ocpos_salechange": {
                    qFilter = new QFilter("id", "in", idList);
                    QFilter filter = new QFilter("saleorderexecutestate", "=", (Object)"0");
                    filter.or("returnexecutestate", "=", (Object)"0");
                    qFilter.and(filter);
                    DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entity, (String)"id", (QFilter[])qFilter.toArray(), null);
                    while (dataSet.hasNext()) {
                        Row row = dataSet.next();
                        for (DynamicObject dyo : dyoArray) {
                            if (!ObjectUtils.nullSafeEquals((Object)dyo.get("sourcebillid"), (Object)row.get("id"))) continue;
                            dyo.set("operationtype", (Object)"B");
                        }
                    }
                    SaveServiceHelper.save((DynamicObject[])dyoArray);
                    break;
                }
            }
            NotificationUtil.showDefaultSuccessNotification((String)"\u624b\u5de5\u5904\u7406\u5b8c\u6210\u3002", (IFormView)this.getView());
            this.getView().invokeOperation("refresh");
        }
    }
}

