/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.inventory;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeBindDataEvent;
import kd.bos.form.events.BeforeBindDataListener;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.occ.ocbase.common.util.BigDecimalUtil;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.MultiBaseDataUtil;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.business.saleorder.SaleOrderItemF7Filter;
import kd.occ.ocpos.common.util.F7Util;
import kd.occ.ocpos.common.util.SystemParamUtil;

public class SaleOrderAvaliableInvQueryPlugin
extends AbstractListPlugin
implements ClickListener,
BeforeF7SelectListener,
CreateListDataProviderListener,
BeforeBindDataListener {
    private static final Log LOG = LogFactory.getLog(SaleOrderAvaliableInvQueryPlugin.class, (String)"ocpos");
    private static final String AP_BILL_LIST = "billlistap";
    private static final String BTN_SEARCH = "search";

    public void afterCreateNewData(EventObject e) {
        Object stockOrgId;
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map customParams = parameter.getCustomParams();
        Long channelId = customParams.getOrDefault("owner", 0L);
        this.getModel().setItemValueByID("salechannelid", (Object)channelId);
        DynamicObject saleChannel = (DynamicObject)this.getModel().getValue("salechannelid");
        long saleOrgId = DynamicObjectUtils.getPkValue((DynamicObject)saleChannel, (String)"saleorg");
        this.getModel().setItemValueByID("saleorgid", (Object)saleOrgId);
        Long currencyId = customParams.getOrDefault("currency", 0L);
        this.getModel().setItemValueByID("currency", (Object)currencyId);
        Object itemIds = customParams.getOrDefault("itemIdSet", null);
        if (!ObjectUtils.isEmpty(itemIds) && itemIds instanceof JSONArray) {
            this.getModel().setValue("itemids", (Object)((JSONArray)itemIds).toArray());
        }
        if (!ObjectUtils.isEmpty(stockOrgId = customParams.getOrDefault("stockOrgId", null))) {
            if (stockOrgId instanceof JSONArray) {
                this.getModel().setValue("stockorgs", (Object)((JSONArray)stockOrgId).toArray());
            } else if (stockOrgId instanceof Integer) {
                this.getModel().setValue("stockorgs", (Object)new Object[]{stockOrgId});
            }
        }
        Long warehouseId = customParams.getOrDefault("warehouseId", 0L);
        this.getModel().setValue("stocks", (Object)new Object[]{warehouseId});
        DynamicObjectCollection stockOrgs = (DynamicObjectCollection)this.getModel().getValue("stockorgs");
        if (!CollectionUtils.isEmpty((Collection)stockOrgs) && !ObjectUtils.isEmpty(itemIds)) {
            this.query();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList list = (BillList)this.getView().getControl(AP_BILL_LIST);
        list.addCreateListDataProviderListener((CreateListDataProviderListener)this);
        list.addBeforeBindDataListener((BeforeBindDataListener)this);
        MulBasedataEdit itemsEdit = (MulBasedataEdit)this.getView().getControl("itemids");
        itemsEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit stockOrgsEdit = (MulBasedataEdit)this.getView().getControl("stockorgs");
        stockOrgsEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit stocksEdit = (MulBasedataEdit)this.getView().getControl("stocks");
        stocksEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{BTN_SEARCH});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        switch (key = e.getProperty().getName()) {
            case "itemids": {
                this.beforeItemsF7(e, dataEntity, key);
                break;
            }
            case "stockorgs": {
                this.beforeStockOrgF7(e, dataEntity);
                break;
            }
            case "stocks": {
                this.beforeStockF7(e, dataEntity);
                break;
            }
        }
    }

    public void click(EventObject e) {
        super.click(e);
        Control ctrl = (Control)e.getSource();
        if (StringUtils.equals((CharSequence)ctrl.getKey(), (CharSequence)BTN_SEARCH)) {
            this.query();
        }
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs e) {
        ListDataProvider provider = new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                rows.clear();
                SaleOrderAvaliableInvQueryPlugin.this.fillData(rows);
                return rows;
            }
        };
        e.setListDataProvider((IListDataProvider)provider);
    }

    public void beforeBindData(BeforeBindDataEvent e) {
    }

    private void query() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection items = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"itemids");
        if (CollectionUtils.isEmpty((Collection)items)) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u9009\u62e9\u5546\u54c1\u3002", (IFormView)this.getView());
            return;
        }
        DynamicObjectCollection stockOrgs = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"stockorgs");
        if (CollectionUtils.isEmpty((Collection)stockOrgs)) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u9009\u62e9\u5e93\u5b58\u7ec4\u7ec7\u3002", (IFormView)this.getView());
            return;
        }
        BillList list = (BillList)this.getView().getControl(AP_BILL_LIST);
        list.addCreateListDataProviderListener((CreateListDataProviderListener)this);
        this.getView().updateView();
    }

    private void fillData(DynamicObjectCollection rows) {
        List<Map<String, Object>> data = this.getData();
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        Map<String, List<Map>> map = data.stream().collect(Collectors.groupingBy(x -> StringUtils.join((Object[])this.getGroupFields((Map<String, Object>)x), (char)'_')));
        for (Map.Entry<String, List<Map>> entry : map.entrySet()) {
            List<Map> value = entry.getValue();
            int index = 0;
            value.sort(Comparator.comparing(x -> this.getDate(x.get("exparrdate")), Comparator.nullsLast(Date::compareTo)));
            for (Map item : value) {
                BigDecimal avbQty;
                BigDecimal reserveQty;
                BigDecimal qty;
                DynamicObject row = new DynamicObject(rows.getDynamicObjectType());
                row.set("id", (Object)index);
                row.set("itemid_id", (Object)this.getLongValue(item.getOrDefault("itemid", 0L)));
                row.set("materialid_id", (Object)this.getLongValue(item.getOrDefault("material", 0L)));
                row.set("auxptyid_id", (Object)this.getLongValue(item.getOrDefault("auxpty", 0L)));
                row.set("invtypeid_id", (Object)this.getLongValue(item.getOrDefault("invtype", 0L)));
                row.set("stockorgid_id", (Object)this.getLongValue(item.getOrDefault("org", 0L)));
                row.set("warehouseid_id", (Object)this.getLongValue(item.getOrDefault("warehouse", 0L)));
                row.set("unitid_id", (Object)this.getLongValue(item.getOrDefault("unit", 0L)));
                Date date = this.getDate(item.get("exparrdate"));
                if (index == 0) {
                    qty = BigDecimalUtil.toBigDecimal((Object)item.getOrDefault("qty", BigDecimal.ZERO));
                    reserveQty = BigDecimalUtil.toBigDecimal((Object)item.getOrDefault("reserveqty", BigDecimal.ZERO));
                    avbQty = BigDecimalUtil.toBigDecimal((Object)item.getOrDefault("avbbqty", BigDecimal.ZERO));
                } else {
                    qty = BigDecimal.ZERO;
                    reserveQty = BigDecimal.ZERO;
                    avbQty = BigDecimal.ZERO;
                }
                row.set("qty", (Object)qty);
                row.set("reserveqty", (Object)reserveQty);
                row.set("avbqty", (Object)avbQty);
                row.set("canoversaleqty", (Object)BigDecimalUtil.toBigDecimal((Object)item.getOrDefault("canoversaleqty", BigDecimal.ZERO)));
                row.set("exparrdate", (Object)date);
                row.set("keepertype", (Object)String.valueOf(item.getOrDefault("keepertype", "bos_org")));
                row.set("keeper_id", (Object)this.getLongValue(item.getOrDefault("keeper", 0L)));
                row.set("ownertype", (Object)String.valueOf(item.getOrDefault("ownertype", "bos_org")));
                row.set("owner_id", (Object)this.getLongValue(item.getOrDefault("owner", 0L)));
                BusinessDataServiceHelper.loadRefence((Object[])new Object[]{row}, (IDataEntityType)rows.getDynamicObjectType());
                rows.add(index, row);
                ++index;
            }
        }
    }

    private void beforeItemsF7(BeforeF7SelectEvent e, DynamicObject dataEntity, String key) {
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"saleorgid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salechannelid");
        long currencyId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"currency");
        if (branchId == 0L || currencyId == 0L) {
            NotificationUtil.showDefaultTipNotify((String)"\u9500\u552e\u95e8\u5e97\u6216\u7ed3\u7b97\u5e01\u522b\u4fe1\u606f\u5f02\u5e38\u3002", (IFormView)this.getView());
            e.setCancel(true);
            return;
        }
        long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"goodsid");
        SaleOrderItemF7Filter.beforeItemF7Filter((BeforeF7SelectEvent)e, (IFormView)this.getView(), (long)orgId, (long)branchId, (long)currencyId, (String)key, (boolean)false, (long)0L, (long)0L, (long)goodsId);
    }

    private void beforeStockOrgF7(BeforeF7SelectEvent e, DynamicObject dataEntity) {
        long saleOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"saleorgid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salechannelid");
        String invQueryRange = SystemParamUtil.getInvQueryRange((long)saleOrgId, (long)branchId);
        QFilter filter = F7Util.getStockOrgFilter((long)saleOrgId, (String)invQueryRange);
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(filter);
    }

    private void beforeStockF7(BeforeF7SelectEvent e, DynamicObject dataEntity) {
        DynamicObjectCollection stockOrgs = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"stockorgs");
        List stockOrgIds = MultiBaseDataUtil.getMultiF7PKValueList((DynamicObjectCollection)stockOrgs);
        if (CollectionUtils.isEmpty((Collection)stockOrgIds)) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u5f55\u5165\u5e93\u5b58\u7ec4\u7ec7\u4fe1\u606f\u3002", (IFormView)this.getView());
            e.setCancel(true);
            return;
        }
        List lstStockId = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"IWareHouseService", (String)"getAllSetupWarehouseIDs", (Object[])new Object[]{stockOrgIds});
        QFilter filter = new QFilter("id", "in", (Object)lstStockId);
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(filter);
    }

    private QFilter getPolicyBranchFilter(long branchId) {
        QFilter filter = new QFilter("shopscope", "=", (Object)"0");
        filter.or("shopscopeentity.shopid.id", "=", (Object)branchId);
        return filter;
    }

    private DataSet getBaseData(DynamicObject dataEntity) {
        DataSetBuilder dataSetBuilder = this.buildBaseDataSet();
        DynamicObjectCollection items = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"itemids");
        Set itemSet = items.stream().map(x -> DynamicObjectUtils.getDynamicObject((DynamicObject)x, (String)"fbasedataid")).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(itemSet)) {
            return dataSetBuilder.build();
        }
        DynamicObjectCollection stockOrgs = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"stockorgs");
        List stockOrgIds = MultiBaseDataUtil.getMultiF7PKValueList((DynamicObjectCollection)stockOrgs);
        for (DynamicObject item : itemSet) {
            for (Long stockOrgId : stockOrgIds) {
                dataSetBuilder.append(new Object[]{stockOrgId, DynamicObjectUtils.getPkValue((DynamicObject)item), DynamicObjectUtils.getPkValue((DynamicObject)item, (String)"material")});
            }
        }
        return dataSetBuilder.build();
    }

    private DataSet getOverSalePolicyData(DynamicObject dataEntity) {
        String selectFields = "id, resoustockid.stockorg.id as org, resoustockid.stock.id as warehouse, policyentity.material.id as material, policyentity.unit.id as unit, policyentity.invtype.id as invtype, policyentity.exparrdate as exparrdate, policyentity.canoversaleqty as canoversaleqty";
        QFilter filter = F7Utils.getCommonStatusFilter();
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salechannelid");
        filter.and(this.getPolicyBranchFilter(branchId));
        filter.and("oversaletype", "=", (Object)"1");
        filter.and("policyentity.iscontrol", "=", (Object)Boolean.TRUE);
        filter.and("policyentity.rowenable", "=", (Object)"1");
        filter.and("policyentity.begindt", "<=", (Object)TimeServiceHelper.now());
        filter.and("policyentity.enddt", ">=", (Object)TimeServiceHelper.now());
        return QueryServiceHelper.queryDataSet((String)"OverSaleData", (String)"ococic_oversalepolicy", (String)selectFields, (QFilter[])filter.toArray(), (String)"policyentity.exparrdate");
    }

    private DataSet getAvailableInvData(DynamicObject dataEntity) {
        DataSetBuilder dataSetBuilder = this.buildAvailableInvDataSet();
        List<Map<String, Object>> availableInvData = this.queryAvailableInventory(dataEntity);
        if (CollectionUtils.isEmpty(availableInvData)) {
            return dataSetBuilder.build();
        }
        Map<String, List<Map>> availableInvMap = availableInvData.stream().collect(Collectors.groupingBy(x -> StringUtils.join((Object[])this.getAvaGroupFields((Map<String, Object>)x), (char)'_')));
        for (Map.Entry<String, List<Map>> availableInvEntry : availableInvMap.entrySet()) {
            List<Map> value = availableInvEntry.getValue();
            Map availableInvItem = value.get(0);
            BigDecimal sumQty = BigDecimal.valueOf(value.stream().mapToDouble(x -> Double.parseDouble(x.get("qty").toString())).sum());
            BigDecimal sumAvbQty = BigDecimal.valueOf(value.stream().mapToDouble(x -> Double.parseDouble(x.get("avbbqty").toString())).sum());
            BigDecimal sumReserveQty = BigDecimal.valueOf(value.stream().mapToDouble(x -> Double.parseDouble(x.get("reserveqty").toString())).sum());
            dataSetBuilder.append(new Object[]{availableInvItem.get("org"), availableInvItem.get("warehouse"), availableInvItem.get("material"), availableInvItem.get("auxpty"), availableInvItem.get("invtype"), availableInvItem.get("unit"), availableInvItem.get("keepertype"), availableInvItem.get("keeper"), availableInvItem.get("ownertype"), availableInvItem.get("owner"), sumQty, sumAvbQty, sumReserveQty});
        }
        return dataSetBuilder.build();
    }

    private DataSetBuilder buildAvailableInvDataSet() {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        fieldList.add(new Field("org", (DataType)DataType.LongType));
        fieldList.add(new Field("warehouse", (DataType)DataType.LongType));
        fieldList.add(new Field("material", (DataType)DataType.LongType));
        fieldList.add(new Field("auxpty", (DataType)DataType.LongType));
        fieldList.add(new Field("invtype", (DataType)DataType.LongType));
        fieldList.add(new Field("unit", (DataType)DataType.LongType));
        fieldList.add(new Field("keepertype", (DataType)DataType.StringType));
        fieldList.add(new Field("keeper", (DataType)DataType.LongType));
        fieldList.add(new Field("ownertype", (DataType)DataType.StringType));
        fieldList.add(new Field("owner", (DataType)DataType.LongType));
        fieldList.add(new Field("qty", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("avbbqty", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("reserveqty", (DataType)DataType.BigDecimalType));
        RowMeta rowMeta = new RowMeta(fieldList.toArray(new Field[0]));
        return Algo.create((String)"invAccQueryData").createDataSetBuilder(rowMeta);
    }

    private DataSetBuilder buildBaseDataSet() {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        fieldList.add(new Field("org", (DataType)DataType.LongType));
        fieldList.add(new Field("itemid", (DataType)DataType.LongType));
        fieldList.add(new Field("material", (DataType)DataType.LongType));
        RowMeta rowMeta = new RowMeta(fieldList.toArray(new Field[0]));
        return Algo.create((String)"baseData").createDataSetBuilder(rowMeta);
    }

    private List<Map<String, Object>> getData() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DataSet baseData = this.getBaseData(dataEntity);
        DataSet availableInvData = this.getAvailableInvData(dataEntity);
        DataSet overSalePolicyData = this.getOverSalePolicyData(dataEntity);
        DataSet matchInvData = baseData.rightJoin(availableInvData).on("material", "material").on("org", "org").select(this.getSelectFieldsAboutBase(), this.getSelectFieldsAboutInv()).finish();
        DataSet matchData = matchInvData.leftJoin(overSalePolicyData).on("material", "material").on("org", "org").on("warehouse", "warehouse").on("invtype", "invtype").on("unit", "unit").select(this.getSelectFields(), this.getSelectFieldsAboutOverSale()).finish();
        if (matchData != null) {
            String[] fieldNames = matchData.getRowMeta().getFieldNames();
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(0);
            while (matchData.hasNext()) {
                Row row = matchData.next();
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                for (String fieldName : fieldNames) {
                    map.put(fieldName, row.get(fieldName));
                }
                list.add(map);
            }
            return list;
        }
        return new ArrayList<Map<String, Object>>();
    }

    private List<Map<String, Object>> queryAvailableInventory(DynamicObject dataEntity) {
        LinkedHashMap paramData = new LinkedHashMap(3);
        LinkedHashMap stockOrgData = new LinkedHashMap(1);
        DynamicObjectCollection stockOrgs = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"stockorgs");
        Set stockOrgIds = stockOrgs.stream().map(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"fbasedataid")).collect(Collectors.toSet());
        stockOrgData.put("id", stockOrgIds);
        paramData.put("org", stockOrgData);
        LinkedHashMap stockData = new LinkedHashMap(1);
        DynamicObjectCollection stocks = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"stocks");
        Set stockIds = stocks.stream().map(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"fbasedataid")).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(stockIds)) {
            stockData.put("id", stockIds);
            paramData.put("warehouse", stockData);
        }
        LinkedHashMap itemsData = new LinkedHashMap(1);
        DynamicObjectCollection items = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"itemids");
        Set materialIds = items.stream().map(x -> DynamicObjectUtils.getPkValue((DynamicObject)DynamicObjectUtils.getDynamicObject((DynamicObject)x, (String)"fbasedataid"), (String)"material")).collect(Collectors.toSet());
        itemsData.put("id", materialIds);
        paramData.put("material", itemsData);
        HashMap params = new HashMap(1);
        params.put("data", paramData);
        LOG.info("\u4f9b\u5e94\u94fe\u5e93\u5b58\u4f20\u53c2\uff1a" + JSONObject.toJSONString(params));
        List invAccQueryDataList = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"InvAccQueryService", (String)"invAccQueryExtForInner", (Object[])new Object[]{params});
        LOG.info("\u4f9b\u5e94\u94fe\u5e93\u5b58\u56de\u53c2\uff1a" + JSONObject.toJSONString((Object)invAccQueryDataList));
        return invAccQueryDataList;
    }

    private Object[] getGroupFields(Map<String, Object> data) {
        return new Object[]{data.get("org"), data.get("warehouse"), data.get("itemid"), data.get("auxpty"), data.get("invtype"), data.get("unit"), data.get("keepertype"), data.get("keeper"), data.get("ownertype"), data.get("owner")};
    }

    private Object[] getAvaGroupFields(Map<String, Object> data) {
        return new Object[]{data.get("org"), data.get("warehouse"), data.get("material"), data.get("auxpty"), data.get("invtype"), data.get("unit"), data.get("keepertype"), data.get("keeper"), data.get("ownertype"), data.get("owner")};
    }

    private String[] getSelectFieldsAboutBase() {
        return new String[]{"itemid"};
    }

    private String[] getSelectFieldsAboutInv() {
        return new String[]{"org", "warehouse", "material", "auxpty", "invtype", "unit", "keepertype", "keeper", "ownertype", "owner", "qty", "avbbqty", "reserveqty"};
    }

    private String[] getSelectFields() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(this.getSelectFieldsAboutBase()));
        list.addAll(Arrays.asList(this.getSelectFieldsAboutInv()));
        return list.toArray(new String[0]);
    }

    private String[] getSelectFieldsAboutOverSale() {
        return new String[]{"exparrdate", "canoversaleqty"};
    }

    private Date getDate(Object data) {
        if (!ObjectUtils.isEmpty((Object)data)) {
            return DateUtil.getDateFormat((String)String.valueOf(data));
        }
        return null;
    }

    private Long getLongValue(Object data) {
        return Long.valueOf(String.valueOf(data));
    }
}

