/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.inventory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocpos.common.util.CommonUtil;

public class SelectSrcBillEditPlugin
extends AbstractFormPlugin {
    private static final String OP_SAVEDATA = "savedata";
    private static final String KEY_BTN_QUERY = "btn_query";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btnQuery = (Button)this.getView().getControl(KEY_BTN_QUERY);
        btnQuery.addClickListener((ClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        long receiveBranchId = CommonUtil.formatObejctToLong((Object)formShowParameter.getCustomParam("receivebranchid"));
        this.getView().getModel().setItemValueByID("channel", (Object)receiveBranchId);
        this.getView().updateView("channel");
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)OP_SAVEDATA)) {
            DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
            DynamicObjectCollection docEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"entryentity");
            if (CollectionUtils.isEmpty((Collection)docEntry)) {
                return;
            }
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selRowIndexs = entryGrid.getSelectRows();
            ArrayList<Object> selRows = new ArrayList<Object>(0);
            for (int rowIndex : selRowIndexs) {
                selRows.add(docEntry.get(rowIndex));
            }
            if (selRows.size() > 0) {
                this.getView().returnDataToParent(selRows);
                this.getView().close();
            }
        }
    }

    public void click(EventObject e) {
        super.click(e);
        Control ctrl = (Control)e.getSource();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String billTypeId = formShowParameter.getCustomParam("billtypeid").toString();
        if (StringUtils.equals((CharSequence)ctrl.getKey(), (CharSequence)KEY_BTN_QUERY)) {
            this.queryBillData(billTypeId);
        }
    }

    private void queryBillData(String billTypeId) {
        DynamicObjectCollection docGoods;
        DynamicObjectCollection datas = null;
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        String billNo = (String)this.getModel().getValue("srcbillno");
        Date bizDate = (Date)this.getModel().getValue("bizdate");
        if (!StringUtils.isEmpty((CharSequence)billNo)) {
            filter.and("billno", "=", (Object)billNo);
        }
        if (!CollectionUtils.isEmpty((Collection)(docGoods = (DynamicObjectCollection)this.getModel().getValue("goods")))) {
            List lstMaterialId = docGoods.stream().map(x -> DynamicObjectUtils.getPkValue((DynamicObject)DynamicObjectUtils.getDynamicObject((DynamicObject)x, (String)"fbasedataid"), (String)"materialmasterid")).collect(Collectors.toList());
            filter.and("billentry.material.masterid", "in", lstMaterialId);
        }
        switch (billTypeId) {
            case "1153534418477108224": {
                FormShowParameter frmShowParameter = this.getView().getFormShowParameter();
                long orgId = CommonUtil.formatObejctToLong((Object)frmShowParameter.getCustomParam("orgid"));
                filter.and("billentry.remaintransinqty", ">", (Object)0);
                filter.and("inorg", "=", (Object)orgId);
                if (!ObjectUtils.isEmpty((Object)bizDate)) {
                    filter.and("biztime", "=", (Object)bizDate);
                }
                String fieldString = "id as billid,billentry.id as entryid,billtype.name as billtypename,billno,biztime as billdate,org.name as outorgname,inorg.name as inorgname,billentry.warehouse.name as warehousename,billentry.material.masterid.name as materialname,billentry.unit.name as unitname,billentry.qty as qty";
                datas = QueryServiceHelper.query((String)"im_transoutbill", (String)fieldString, (QFilter[])filter.toArray(), null);
                break;
            }
            case "1145072539484278784": {
                DynamicObject dataEntity = this.getModel().getDataEntity(true);
                if (dataEntity.getDate("startdate") != null) {
                    filter.and("biztime", ">=", (Object)dataEntity.getDate("startdate"));
                }
                if (dataEntity.getDate("enddate") != null) {
                    filter.and("biztime", "<", (Object)dataEntity.getDate("enddate"));
                }
                if (dataEntity.get("org") != null) {
                    filter.and("org", "=", dataEntity.getDynamicObject("org").getPkValue());
                }
                filter.and("billentry.rowclosestatus", "=", (Object)"A");
                filter.and(QFilter.of((String)"billentry.qty > billentry.joinqty", (Object[])new Object[0]));
                String fieldString = "id as billid,billno,biztime as billdate,billentry.id as entryid,billtype.name as billtypename,billentry.qty as qty,billentry.unit.name as unitname,billentry.warehouse.name as warehousename,billentry.material.masterid.name as materialname";
                datas = QueryServiceHelper.query((String)"pm_purorderbill", (String)fieldString, (QFilter[])filter.toArray(), null);
            }
        }
        this.fillEntry(datas);
    }

    private void fillEntry(DynamicObjectCollection datas) {
        if (datas == null || datas.size() == 0) {
            return;
        }
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        DynamicObjectCollection entryEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"entryentity");
        entryEntity.clear();
        DataEntityPropertyCollection properties = entryEntity.getDynamicObjectType().getProperties();
        for (DynamicObject data : datas) {
            DynamicObject entryRow = entryEntity.addNew();
            for (IDataEntityProperty property : properties) {
                String key = property.getName();
                if (!DynamicObjectUtils.contain((DynamicObject)data, (String)key)) continue;
                entryRow.set(key, data.get(key));
            }
        }
        this.getView().updateView("entryentity");
    }
}

