/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.inventory;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.BigDecimalUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;

public class StoreBuyPickFormPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_query", "btn_confirm"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        this.getView().getModel().setItemValueByID("org", parameter.getCustomParam("org"));
        this.query();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        String key = e.getProperty().getName();
        int rowIndex = valueSet[0].getRowIndex();
        switch (key) {
            case "receiveqty": {
                DynamicObject entry = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(rowIndex);
                BigDecimal qty = entry.getBigDecimal("qty");
                BigDecimal receiveQty = BigDecimalUtil.toBigDecimal((Object)newValue);
                if (receiveQty.compareTo(qty) <= 0) break;
                NotificationUtil.showDefaultTipNotify((String)"\u672c\u6b21\u5e94\u6536\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u6570\u91cf", (IFormView)this.getView());
                this.getView().getModel().setValue("receiveqty", valueSet[0].getOldValue(), rowIndex);
                break;
            }
        }
    }

    public void click(EventObject e) {
        super.click(e);
        Control ctrl = (Control)e.getSource();
        switch (ctrl.getKey()) {
            case "btn_query": {
                this.query();
                break;
            }
            case "btn_confirm": {
                this.returnDataToParent();
                break;
            }
        }
    }

    private void query() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        if (!StringUtils.isEmpty((Object)dataEntity.get("buybillno"))) {
            filter.and("billno", "=", dataEntity.get("buybillno"));
        }
        if (dataEntity.get("startdate") != null) {
            filter.and("biztime", ">=", dataEntity.get("startdate"));
            filter.and("biztime", "<", (Object)this.getDayAfter(dataEntity.getDate("enddate")));
        }
        if (dataEntity.get("org") != null) {
            filter.and("billentry.entryrecorg", "=", dataEntity.getDynamicObject("org").getPkValue());
        }
        filter.and("billentry.rowclosestatus", "=", (Object)"A");
        filter.and(QFilter.of((String)"billentry.qty > billentry.joinqty", (Object[])new Object[0]));
        DynamicObject[] purOrderBillList = BusinessDataServiceHelper.load((String)"pm_purorderbill", (String)this.getCheckSheetField(), (QFilter[])filter.toArray());
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        entryEntity.clear();
        for (DynamicObject purOrder : purOrderBillList) {
            for (DynamicObject billEntry : purOrder.getDynamicObjectCollection("billentry")) {
                if (billEntry.getLong("entryrecorg.id") != DynamicObjectUtils.getLong((DynamicObject)dataEntity.getDynamicObject("org"), (String)"id")) continue;
                DynamicObject entry = new DynamicObject(entryEntity.getDynamicObjectType());
                entry.set("billid", purOrder.getPkValue());
                entry.set("billno", purOrder.get("billno"));
                entry.set("billstatus", purOrder.get("billstatus"));
                entry.set("supplier", purOrder.get("supplier"));
                entry.set("biztype", purOrder.get("biztype"));
                entry.set("receiveorg", billEntry.get("entryrecorg"));
                entry.set("unit", billEntry.get("unit"));
                entry.set("receiveqty", (Object)billEntry.getBigDecimal("receiveqty").intValue());
                entry.set("qty", billEntry.get("qty"));
                entry.set("bizorg", purOrder.get("org"));
                entry.set("warehouse", billEntry.get("warehouse"));
                entry.set("material", billEntry.get("material"));
                entry.set("bizdate", purOrder.get("biztime"));
                entry.set("entryid", billEntry.get("id"));
                entryEntity.add((Object)entry);
            }
        }
        this.getView().updateView("entryentity");
    }

    private void returnDataToParent() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        DynamicObjectCollection docEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        int selectBillNum = this.getSelectBill(docEntry, selectRows);
        if (selectRows.length == 0) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u9009\u62e9\u8981\u5904\u7406\u7684\u6570\u636e\u3002", (IFormView)this.getView());
        } else if (selectBillNum > 1) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u9009\u62e9\u540c\u4e00\u6761\u8ba2\u5355\u8fdb\u884c\u5904\u7406\u3002", (IFormView)this.getView());
        } else {
            ArrayList<Object> selRows = new ArrayList<Object>(0);
            for (int selectRow : selectRows) {
                selRows.add(docEntry.get(selectRow));
            }
            if (selRows.size() > 0) {
                this.getView().returnDataToParent(selRows);
                this.getView().close();
            }
        }
    }

    private int getSelectBill(DynamicObjectCollection docEntry, int[] selectRows) {
        ArrayList<String> billList = new ArrayList<String>();
        for (int selectIndex : selectRows) {
            String billNo = ((DynamicObject)docEntry.get(selectIndex)).getString("billno");
            if (billList.contains(billNo)) continue;
            billList.add(billNo);
        }
        return billList.size();
    }

    private String getCheckSheetField() {
        return "id,billno,biztime,billstatus,supplier,biztype,org,billstatus,billentry.unit,billentry.id,billentry.receiveqty,billentry.warehouse,billentry.material,billentry.qty,billentry.entryrecorg";
    }

    private Date getDayAfter(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int days = calendar.get(5);
        calendar.set(5, days + 1);
        return calendar.getTime();
    }
}

