/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.inventory;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang.StringUtils;

public class StoreBuyTranReceiveBillConvertPlugin
extends AbstractConvertPlugIn {
    private static final String ENTRYENTITY = "entryentity";
    private static final String INVSCHEME = "invscheme";
    private static final String OUTINVTYPE = "outinvtype";
    private static final String OUTINVSTATUS = "outinvstatus";
    private static final String OUTOWNERTYPE = "outownertype";
    private static final String OUTKEEPERTYPE = "outkeepertype";
    private static final String OUTKEEPER = "outkeeper";
    private static final String INVTYPE = "invtype";
    private static final String INVSTATUS = "invstatus";
    private static final String OWNERTYPE = "ownertype";
    private static final String KEEPERTYPE = "keepertype";
    private static final String KEEPER = "keeper";
    private static final String DISCOUNTTYPE = "discounttype";

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        String tgtMainType = this.getTgtMainType().toString();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(tgtMainType);
        for (int i = 0; i < entitys.length; ++i) {
            ExtendedDataEntity entity = entitys[i];
            DynamicObject obj = entity.getDataEntity();
            DynamicObjectCollection entrycols = obj.getDynamicObjectCollection(ENTRYENTITY);
            if (entrycols.size() <= 0) continue;
            this.addprop(obj, entrycols);
        }
    }

    private void addprop(DynamicObject obj, DynamicObjectCollection entrycoll) {
        DynamicObject invScheme = BusinessDataServiceHelper.loadSingle((Object)obj.getString(INVSCHEME), (String)"im_invscheme");
        StoreBuyTranReceiveBillConvertPlugin.dealEntryScheme(obj, entrycoll, invScheme);
    }

    public static void dealEntryScheme(DynamicObject obj, DynamicObjectCollection entrycoll, DynamicObject invScheme) {
        boolean isInUpdate = invScheme.getBoolean("isinupdate");
        boolean isOutUpdate = invScheme.getBoolean("isoutupdate");
        String ownerType = null;
        String keeperType = null;
        DynamicObject keeper = null;
        DynamicObject invStatus = null;
        DynamicObject defaltInvType = null;
        if (isInUpdate) {
            ownerType = invScheme.getString(OWNERTYPE);
            keeperType = invScheme.getString(KEEPERTYPE);
            keeper = StoreBuyTranReceiveBillConvertPlugin.getKeepByType(obj, keeperType);
            invStatus = StoreBuyTranReceiveBillConvertPlugin.getDefaultInvStatus(invScheme);
            defaltInvType = StoreBuyTranReceiveBillConvertPlugin.getDefaltInvtype(invScheme);
        }
        String outOwnerType = null;
        String outKeeperType = null;
        DynamicObject outKeeper = null;
        DynamicObject outInvStatus = null;
        DynamicObject defaltOutInvType = null;
        if (isOutUpdate) {
            outOwnerType = invScheme.getString(OUTOWNERTYPE);
            outKeeperType = invScheme.getString(OUTKEEPERTYPE);
            outKeeper = StoreBuyTranReceiveBillConvertPlugin.getKeepByType(obj, outKeeperType);
            outInvStatus = StoreBuyTranReceiveBillConvertPlugin.getDefaultOutInvStatus(invScheme);
            defaltOutInvType = StoreBuyTranReceiveBillConvertPlugin.getDefaltOutInvtype(invScheme);
        }
        int size = entrycoll.size();
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            DynamicObject entry = (DynamicObject)entrycoll.get(rowIndex);
            if (isOutUpdate) {
                StoreBuyTranReceiveBillConvertPlugin.setValueIfNull(entry, OUTINVSTATUS, outInvStatus);
                StoreBuyTranReceiveBillConvertPlugin.setValueIfNull(entry, OUTINVTYPE, defaltOutInvType);
                StoreBuyTranReceiveBillConvertPlugin.setValueIfNull(entry, OUTOWNERTYPE, outOwnerType);
                StoreBuyTranReceiveBillConvertPlugin.setValueIfNull(entry, OUTKEEPERTYPE, outKeeperType);
                StoreBuyTranReceiveBillConvertPlugin.setValueIfNull(entry, OUTKEEPER, outKeeper);
            }
            if (!isInUpdate) continue;
            StoreBuyTranReceiveBillConvertPlugin.setValueIfNull(entry, INVSTATUS, invStatus);
            StoreBuyTranReceiveBillConvertPlugin.setValueIfNull(entry, INVTYPE, defaltInvType);
            StoreBuyTranReceiveBillConvertPlugin.setValueIfNull(entry, OWNERTYPE, ownerType);
            StoreBuyTranReceiveBillConvertPlugin.setValueIfNull(entry, KEEPERTYPE, keeperType);
            StoreBuyTranReceiveBillConvertPlugin.setValueIfNull(entry, KEEPER, keeper);
        }
    }

    private static DynamicObject getKeepByType(DynamicObject obj, String type) {
        return obj.getDynamicObject("org");
    }

    private static void setValueIfNull(DynamicObject obj, String key, Object defaultValue) {
        Object value = obj.get(key);
        if (value == null) {
            obj.set(key, defaultValue);
            return;
        }
        if (value instanceof String && StringUtils.isEmpty((String)((String)value))) {
            obj.set(key, defaultValue);
            return;
        }
    }

    public static DynamicObject getDefaultInvStatus(DynamicObject invScheme) {
        return StoreBuyTranReceiveBillConvertPlugin.getDefaultInvTypeOrStatus(invScheme, "invstatusentry", "invstatusisdefault", INVSTATUS);
    }

    public static DynamicObject getDefaultOutInvStatus(DynamicObject invScheme) {
        return StoreBuyTranReceiveBillConvertPlugin.getDefaultInvTypeOrStatus(invScheme, "outinvstatusentry", "outinvstatusisdefault", OUTINVSTATUS);
    }

    public static DynamicObject getDefaltInvtype(DynamicObject invScheme) {
        return StoreBuyTranReceiveBillConvertPlugin.getDefaultInvTypeOrStatus(invScheme, "invtypeentry", "invtypeisdefault", INVTYPE);
    }

    public static DynamicObject getDefaltOutInvtype(DynamicObject invScheme) {
        return StoreBuyTranReceiveBillConvertPlugin.getDefaultInvTypeOrStatus(invScheme, "outinvtypeentry", "outinvtypeisdefault", OUTINVTYPE);
    }

    private static DynamicObject getDefaultInvTypeOrStatus(DynamicObject invScheme, String invTypeOrStatusEntry, String invTypeOrStatusIsDefault, String invTypeOrStatus) {
        DynamicObjectCollection entries = invScheme.getDynamicObjectCollection(invTypeOrStatusEntry);
        DynamicObject defaultInvTypeOrStatus = null;
        if (entries != null && entries.size() > 0) {
            for (DynamicObject entry : entries) {
                if (!entry.getBoolean(invTypeOrStatusIsDefault)) continue;
                defaultInvTypeOrStatus = entry.getDynamicObject(invTypeOrStatus);
                break;
            }
            if (defaultInvTypeOrStatus == null) {
                defaultInvTypeOrStatus = ((DynamicObject)entries.get(0)).getDynamicObject(invTypeOrStatus);
            }
        }
        return defaultInvTypeOrStatus;
    }
}

