/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.inventory;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.AbstractConvertServiceArgs;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.DrawArgs;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.plugin.Plugin;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.botp.Push;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.botp.ReleaseConvertDataMutexPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.botp.ConvertService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocbase.common.util.OwnerUtils;
import kd.occ.ocbase.common.util.PosItemUtil;
import kd.occ.ocbase.common.util.pos.NotificationUtil;

public class StoreCheckEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit location = (BasedataEdit)this.getView().getControl("location");
        location.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"checksheet"});
        this.addItemClickListeners(new String[]{"advcontoolbarap", "adv_item", "adv_itembrand", "adv_itemclass"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        if (showParameter.getStatus() == OperationStatus.ADDNEW) {
            this.getModel().setItemValueByID("checker", (Object)UserServiceHelper.getCurrentUserId());
            this.getModel().setItemValueByID("branch", (Object)OwnerUtils.getDefaultOwnerId((boolean)true));
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        for (int size = this.getModel().getDataEntity(true).getDynamicObjectCollection("billentry").size(); size > 0; --size) {
            this.updateQtyAcc(size - 1);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctrl = (Control)evt.getSource();
        switch (ctrl.getKey()) {
            case "checksheet": {
                this.showCheckSheet();
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "adv_item": {
                this.showPage("ocdbd_iteminfo", "iteminfo");
                break;
            }
            case "adv_itemclass": {
                this.showPage("mdr_item_class", "itemclass");
                break;
            }
            case "adv_itembrand": {
                this.showPage("mdr_item_brand", "itembrand");
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if ("location".equals(event.getProperty().getName())) {
            int index = this.getModel().getEntryCurrentRowIndex("billentry");
            DynamicObject warehouse = ((DynamicObject)dataEntity.getDynamicObjectCollection("billentry").get(index)).getDynamicObject("warehouse");
            F7Utils.addF7Filter((BeforeF7SelectEvent)event, (QFilter)this.getLocationFilter(warehouse));
        }
    }

    private QFilter getLocationFilter(DynamicObject warehouse) {
        List<Object> locationid = new ArrayList();
        if (null == warehouse) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u7ef4\u62a4\u4ed3\u5e93\u4fe1\u606f", (IFormView)this.getView());
        } else {
            DynamicObjectCollection entryentity = warehouse.getDynamicObjectCollection("entryentity");
            locationid = entryentity.stream().map(a -> DynamicObjectUtils.getPkValue((DynamicObject)a, (String)"location")).collect(Collectors.toList());
        }
        return new QFilter("id", "in", locationid);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        int rowIndex = valueSet[0].getRowIndex();
        switch (key) {
            case "qty": {
                this.updateCheckQty(rowIndex);
                break;
            }
            case "warehouse": {
                this.updateInventory(rowIndex);
                this.updateLocation(rowIndex);
                break;
            }
            case "invtype": 
            case "invstatus": 
            case "keepertype": 
            case "keeper": 
            case "ownertype": 
            case "owner": 
            case "auxpty": {
                this.updateInventory(rowIndex);
                break;
            }
            case "checksheet": {
                Object newValue = valueSet[0].getNewValue();
                if (!ObjectUtils.isEmpty((Object)newValue)) break;
                this.getModel().deleteEntryData("billentry");
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String callBack;
        super.closedCallBack(e);
        if (e.getReturnData() == null) {
            return;
        }
        switch (callBack = e.getActionId()) {
            case "iteminfo": {
                this.fillItemEntity(e, "ocdbd_iteminfo");
                break;
            }
            case "itemclass": {
                this.fillItemEntity(e, "mdr_item_class");
                break;
            }
            case "itembrand": {
                this.fillItemEntity(e, "mdr_item_brand");
                break;
            }
            case "checksheet": {
                this.initInvcountBill(e);
                break;
            }
        }
    }

    private void initInvcountBill(ClosedCallBackEvent e) {
        this.doDraw(e);
        this.afterDraw();
        this.getView().updateView();
        this.getView().updateView("billentry");
    }

    private void doDraw(ClosedCallBackEvent e) {
        ListSelectedRow selectedRow = new ListSelectedRow();
        selectedRow.setPrimaryKeyValue(e.getReturnData());
        DrawArgs args = new DrawArgs();
        args.setSourceEntityNumber("im_invcountbill");
        args.setTargetEntityNumber("ocpos_store_check");
        args.addCustomParam("botp_requiredatamutex", String.valueOf(true));
        args.getSelectedRows().add(selectedRow);
        args.setTargetPageId(this.getView().getPageId());
        args.setRuleId("1154180558943728640");
        args.setBuildConvReport(true);
        ConvertOperationResult result = this.draw(args);
        if (!result.isSuccess() || result.getCachePageIds().size() == 0) {
            Push.showReport((IFormView)this.getView(), (AbstractConvertServiceArgs)args, (ConvertOperationResult)result);
        } else {
            IBillView billView = (IBillView)this.getView();
            IRefrencedataProvider refProvider = BusinessDataReader::loadRefence;
            List dataEntities = result.loadTargetDataObjects(refProvider, billView.getModel().getDataEntityType());
            this.addReleaseSourceDataMutexPlugin((IFormView)billView, result);
            ((IBillModel)billView.getModel()).push(dataEntities.get(0));
            billView.updateView();
            this.getView().sendFormAction((IFormView)billView);
            result.release(refProvider, billView.getModel().getDataEntityType());
        }
    }

    private void addReleaseSourceDataMutexPlugin(IFormView billView, ConvertOperationResult drawResult) {
        boolean exist = false;
        String plugInName = ReleaseConvertDataMutexPlugin.class.getName();
        for (Plugin plugin : billView.getFormShowParameter().getFormConfig().getPlugins()) {
            if (!StringUtils.equals((CharSequence)plugin.getClassName(), (CharSequence)plugInName)) continue;
            exist = true;
            break;
        }
        if (!exist) {
            billView.getFormShowParameter().addCustPlugin(plugInName);
            billView.cacheFormShowParameter();
        }
        ReleaseConvertDataMutexPlugin.addConvertDataMutex((IFormView)billView, (String)drawResult.getSourceEntityNumber(), (Collection)drawResult.getDataMutexSrcBillIds());
    }

    private ConvertOperationResult draw(DrawArgs args) {
        String argsJson = SerializationUtils.toJsonString((Object)args);
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)args.getSourceEntityNumber());
        String resultStr = (String)DispatchServiceHelper.invokeBOSService((String)dt.getAppId(), (String)ConvertService.class.getSimpleName(), (String)"draw", (Object[])new Object[]{argsJson});
        return (ConvertOperationResult)SerializationUtils.fromJsonString((String)resultStr, ConvertOperationResult.class);
    }

    private void afterDraw() {
        this.getModel().setItemValueByID("secchecker", (Object)UserServiceHelper.getCurrentUserId());
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("billentry");
        Iterator iterator = entryEntity.iterator();
        while (iterator.hasNext()) {
            DynamicObject entry = (DynamicObject)iterator.next();
            DynamicObject material = entry.getDynamicObject("material");
            DynamicObject item = this.getItemByMaterial(material);
            if (item == null) {
                iterator.remove();
                continue;
            }
            entry.set("goodsid", (Object)item);
            entry.set("itembrandid", item.get("itembrands"));
            entry.set("itemclassid", (Object)PosItemUtil.queryItemClass((DynamicObject)item));
            entry.set("barcode", (Object)this.getBarCodeInfo(item));
        }
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u7ef4\u62a4\u76d8\u70b9\u8868\u7269\u6599\u5bf9\u5e94\u5546\u54c1\u4fe1\u606f", (IFormView)this.getView());
            this.getModel().setValue("checksheet", null);
        }
    }

    private DynamicObject getItemByMaterial(DynamicObject material) {
        QFilter filter = F7Utils.getCommonStatusFilter();
        filter.and("material", "=", material.getDynamicObject("masterid").getPkValue());
        return BusinessDataServiceHelper.loadSingle((String)"ocdbd_iteminfo", (String)this.getItemInfoFeilds(), (QFilter[])filter.toArray());
    }

    private void updateLocation(int rowIndex) {
        this.getModel().setValue("location", null, rowIndex);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("billentry");
        DynamicObject entry = (DynamicObject)entryEntity.get(rowIndex);
        DynamicObject warehouse = entry.getDynamicObject("warehouse");
        if (warehouse == null) {
            return;
        }
        if (warehouse.getBoolean("isopenlocation")) {
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"location"});
            DynamicObject location = ((DynamicObject)warehouse.getDynamicObjectCollection("entryentity").get(0)).getDynamicObject("location");
            this.getModel().setValue("location", (Object)location, rowIndex);
        } else {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"location"});
        }
    }

    private void updateInventory(int rowIndex) {
        this.updateQtyAcc(rowIndex);
        this.updateCheckQty(rowIndex);
    }

    private void updateQtyAcc(int rowIndex) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("billentry");
        DynamicObject entry = (DynamicObject)entryEntity.get(rowIndex);
        DynamicObject[] realBalance = this.getRealBalance(entry);
        BigDecimal qty = Arrays.stream(realBalance).map(a -> DynamicObjectUtils.getBigDecimal((DynamicObject)a, (String)"qty")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal baseqty = Arrays.stream(realBalance).map(a -> DynamicObjectUtils.getBigDecimal((DynamicObject)a, (String)"baseqty")).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.getModel().setValue("qtyacc", (Object)qty, rowIndex);
        this.getModel().setValue("baseqtyacc", (Object)baseqty, rowIndex);
    }

    private void updateCheckQty(int rowIndex) {
        BigDecimal qtyacc;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("billentry");
        DynamicObject entry = (DynamicObject)entryEntity.get(rowIndex);
        BigDecimal qty = entry.getBigDecimal("qty");
        BigDecimal subtract = qty.subtract(qtyacc = entry.getBigDecimal("qtyacc"));
        if (subtract.compareTo(BigDecimal.ZERO) < 0) {
            this.getModel().setValue("lossqty", (Object)subtract.abs());
            this.getModel().setValue("gainqty", (Object)BigDecimal.ZERO);
        } else {
            this.getModel().setValue("gainqty", (Object)subtract);
            this.getModel().setValue("lossqty", (Object)BigDecimal.ZERO);
        }
    }

    private void showCheckSheet() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        HashMap<String, Comparable<Long>> customsParams = new HashMap<String, Comparable<Long>>(2);
        customsParams.put("org", Long.valueOf(DynamicObjectUtils.getPkValue((DynamicObject)dataEntity.getDynamicObject("org"))));
        customsParams.put("checkdate", DynamicObjectUtils.getDate((DynamicObject)dataEntity, (String)"checkdate"));
        FormShowParameter param = FormShowUtils.openNewForm((String)"\u76d8\u70b9\u8868", (String)"ocpos_storecheck_pick", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customsParams);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "checksheet"));
        this.getView().showForm(param);
    }

    public void fillItemEntity(ClosedCallBackEvent e, String formId) {
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)e.getReturnData();
        DynamicObjectCollection entry = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("billentry");
        List<Object> id = returnData.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        switch (formId) {
            case "ocdbd_iteminfo": {
                this.addItemInfo(entry, id);
                break;
            }
            case "mdr_item_class": {
                this.addItemClass(entry, id);
                break;
            }
            case "mdr_item_brand": {
                this.addItemBrand(entry, id);
                break;
            }
        }
        this.getView().updateView("billentry");
    }

    public void addItemBrand(DynamicObjectCollection itemEntitys, List<Object> id) {
        DynamicObject[] brandInfo;
        for (DynamicObject brand : brandInfo = BusinessDataServiceHelper.load((String)"mdr_item_brand", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", id)})) {
            DynamicObject item = new DynamicObject(itemEntitys.getDynamicObjectType());
            itemEntitys.add((Object)item);
        }
    }

    public void addItemClass(DynamicObjectCollection itemEntitys, List<Object> id) {
        DynamicObject[] classInfo;
        for (DynamicObject itemclass : classInfo = BusinessDataServiceHelper.load((String)"mdr_item_class", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", id)})) {
            DynamicObject itemEntity = new DynamicObject(itemEntitys.getDynamicObjectType());
            itemEntitys.add((Object)itemEntity);
        }
    }

    public void addItemInfo(DynamicObjectCollection entry, List<Object> itemId) {
        DynamicObject[] selectedItem = this.getItemEntity(itemId);
        List items = Arrays.stream(selectedItem).filter(a -> this.getMaterialInfoByItem((DynamicObject)a) != null).collect(Collectors.toList());
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject org = dataEntity.getDynamicObject("org");
        List materialId = items.stream().map(a -> DynamicObjectUtils.getPkValue((DynamicObject)a.getDynamicObject("material"))).collect(Collectors.toList());
        Set selectorSet = EntityMetadataCache.getDataEntityType((String)"im_inv_realbalance").getAllFields().keySet();
        QFilter filter = new QFilter("org", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)org));
        filter.and("material", "in", materialId);
        DynamicObject[] realBalance = BusinessDataServiceHelper.load((String)"im_inv_realbalance", (String)String.join((CharSequence)",", selectorSet), (QFilter[])filter.toArray());
        if (realBalance.length > 0) {
            for (DynamicObject balance : realBalance) {
                DynamicObject detail = new DynamicObject(entry.getDynamicObjectType());
                DynamicObject material = balance.getDynamicObject("material");
                detail.set("material", (Object)this.getMaterialInfo(material));
                DynamicObject itemInfo = this.getItem(material);
                detail.set("goodsid", (Object)itemInfo);
                detail.set("itembrandid", (Object)itemInfo.getDynamicObject("itembrands"));
                detail.set("itemclassid", (Object)PosItemUtil.queryItemClass((DynamicObject)itemInfo));
                detail.set("barcode", (Object)this.getBarCodeInfo(itemInfo));
                detail.set("unit", balance.get("unit"));
                detail.set("baseunit", balance.get("baseunit"));
                detail.set("auxunitid", balance.get("unit2nd"));
                detail.set("invtype", balance.get("invtype"));
                detail.set("invstatus", balance.get("invstatus"));
                detail.set("warehouse", balance.get("warehouse"));
                detail.set("location", balance.get("location"));
                detail.set("keepertype", balance.get("keepertype"));
                detail.set("keeper", balance.get("keeper"));
                detail.set("ownertype", balance.get("ownertype"));
                detail.set("owner", balance.get("owner"));
                detail.set("qtyacc", balance.get("qty"));
                detail.set("baseqtyacc", balance.get("baseqty"));
                detail.set("accountauxunitqty", balance.get("qty2nd"));
                detail.set("lot", balance.get("lotnum"));
                detail.set("producedate", balance.get("producedate"));
                detail.set("expirydate", balance.get("expirydate"));
                entry.add((Object)detail);
            }
        } else {
            for (DynamicObject good : items) {
                DynamicObject checkDetail = new DynamicObject(entry.getDynamicObjectType());
                checkDetail.set("goodsid", (Object)good);
                DynamicObject material = good.getDynamicObject("material");
                DynamicObject materialInventoryInfo = this.getMaterialInfoByItem(good);
                checkDetail.set("material", (Object)materialInventoryInfo);
                checkDetail.set("itembrandid", (Object)good.getDynamicObject("itembrands"));
                checkDetail.set("itemclassid", (Object)PosItemUtil.queryItemClass((DynamicObject)good));
                checkDetail.set("barcode", (Object)this.getBarCodeInfo(good));
                checkDetail.set("unit", materialInventoryInfo.get("inventoryunit"));
                checkDetail.set("baseunit", materialInventoryInfo.get("baseunit"));
                DynamicObject auxptyunit = material.getDynamicObject("auxptyunit");
                if (auxptyunit != null) {
                    checkDetail.set("auxunitid", (Object)BusinessDataServiceHelper.loadSingle((Object)auxptyunit.getPkValue(), (String)"bd_measureunits"));
                }
                entry.add((Object)checkDetail);
            }
        }
    }

    private DynamicObject[] getItemEntity(List<Object> itemId) {
        return BusinessDataServiceHelper.load((String)"ocdbd_iteminfo", (String)this.getItemInfoFeilds(), (QFilter[])new QFilter[]{new QFilter("id", "in", itemId)});
    }

    private DynamicObject getItem(DynamicObject material) {
        QFilter filter = F7Utils.getCommonStatusFilter();
        filter.and("material", "=", material.getPkValue());
        return BusinessDataServiceHelper.loadSingle((String)"ocdbd_iteminfo", (String)this.getItemInfoFeilds(), (QFilter[])filter.toArray());
    }

    private String getItemInfoFeilds() {
        return String.join((CharSequence)",", "material", "baseunit", "retailunit", "assistunit", "stockunit", "number", "itemclassentity.goodsclasssid", "retailprice", "itemclassentity.classstandardid", "itemclassentity", "itembrands");
    }

    private DynamicObject getBarCodeInfo(DynamicObject item) {
        return BusinessDataServiceHelper.loadSingle((String)"ocdbd_item_barcode", (String)"id", (QFilter[])new QFilter[]{new QFilter("item.id", "=", item.getPkValue())});
    }

    private DynamicObject getMaterialInfo(DynamicObject material) {
        return BusinessDataServiceHelper.loadSingle((String)"bd_materialinventoryinfo", (String)"masterid,inventoryunit,baseunit,enablelot,lotcoderule,enableserial,serialrule,enableshelflifemgr,shelflife", (QFilter[])new QFilter[]{new QFilter("masterid", "=", material.getPkValue())});
    }

    private DynamicObject getMaterialInfoByItem(DynamicObject item) {
        return BusinessDataServiceHelper.loadSingle((String)"bd_materialinventoryinfo", (String)"masterid,inventoryunit,baseunit,enablelot,lotcoderule,enableserial,serialrule,enableshelflifemgr,shelflife", (QFilter[])new QFilter[]{new QFilter("masterid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)item.getDynamicObject("material")))});
    }

    private DynamicObject[] getRealBalance(DynamicObject entry) {
        long auxpty;
        long owner;
        String ownertype;
        long keeper;
        String keepertype;
        long baseunit;
        long invstatus;
        long invtype;
        QFilter filter = new QFilter("material", "=", entry.getDynamicObject("material").getDynamicObject("masterid").getPkValue());
        long warehouse = DynamicObjectUtils.getPkValue((DynamicObject)entry.getDynamicObject("warehouse"));
        if (warehouse > 0L) {
            filter.and("warehouse", "=", (Object)warehouse);
        }
        if ((invtype = DynamicObjectUtils.getPkValue((DynamicObject)entry.getDynamicObject("invtype"))) > 0L) {
            filter.and("invtype", "=", (Object)invtype);
        }
        if ((invstatus = DynamicObjectUtils.getPkValue((DynamicObject)entry.getDynamicObject("invstatus"))) > 0L) {
            filter.and("invstatus", "=", (Object)invstatus);
        }
        if ((baseunit = DynamicObjectUtils.getPkValue((DynamicObject)entry.getDynamicObject("baseunit"))) > 0L) {
            filter.and("baseunit", "=", (Object)baseunit);
        }
        if (!StringUtils.isEmpty((CharSequence)(keepertype = entry.getString("keepertype")))) {
            filter.and("keepertype", "=", (Object)keepertype);
        }
        if ((keeper = DynamicObjectUtils.getPkValue((DynamicObject)entry.getDynamicObject("keeper"))) > 0L) {
            filter.and("keeper", "=", (Object)keeper);
        }
        if (!StringUtils.isEmpty((CharSequence)(ownertype = entry.getString("ownertype")))) {
            filter.and("ownertype", "=", (Object)ownertype);
        }
        if ((owner = DynamicObjectUtils.getPkValue((DynamicObject)entry.getDynamicObject("owner"))) > 0L) {
            filter.and("owner", "=", (Object)owner);
        }
        if ((auxpty = DynamicObjectUtils.getPkValue((DynamicObject)entry.getDynamicObject("auxpty"))) > 0L) {
            filter.and("auxpty", "=", (Object)auxpty);
        }
        return BusinessDataServiceHelper.load((String)"im_inv_realbalance", (String)"qty,baseqty", (QFilter[])filter.toArray());
    }

    private void showPage(String datasourceFormId, String callbacktag) {
        QFilter filter = F7Utils.getCommonStatusFilter();
        filter.and("material", ">", (Object)0L);
        ListShowParameter listParam = FormShowUtils.openChooseList(null, (String)datasourceFormId, (ShowType)ShowType.Modal, Arrays.asList(filter.toArray()), (boolean)true, (boolean)true);
        listParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callbacktag));
        this.getView().showForm((FormShowParameter)listParam);
    }
}

