/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.inventory;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.occ.ocbase.common.enums.EnableStatusEnum;
import kd.occ.ocbase.common.enums.StatusEnum;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.FormRuleUtils;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocbase.common.util.PosItemUtil;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.business.inventory.InventoryHelper;
import kd.occ.ocpos.business.inventory.MatchRuleOutHelper;
import kd.occ.ocpos.business.inventory.SerialNumberHelper;
import kd.occ.ocpos.business.inventory.ShelfLifeDateHelper;
import kd.occ.ocpos.common.saleorder.InventoryUtils;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.F7Util;
import kd.occ.ocpos.common.util.FormViewUtil;
import kd.occ.ocpos.common.util.OwnerUtil;

public class StoreDeliveryEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String[] SERIAL_NUMBER_OPS = new String[]{"checksnnumber", "entersnnumber", "importsnnumber"};
    private static final String[] FIELD_KEY_F7 = new String[]{"biztype", "deliverybranch", "deliveryorg", "dept", "warehouse", "location", "bizdept", "goodsid"};
    private static final Log LOG = LogFactory.getLog(StoreDeliveryEdit.class, (String)"ocpos");
    private List<RowDataEntity> dataEntities;

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initBillType();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        this.initBranch(dataEntity);
        DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"entryentity");
        int index = 0;
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            index = this.getModel().createNewEntryRow("entryentity");
        }
        this.initEntryValue(index);
        this.initDefOwnerAndKeeper(index);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setEnable(Boolean.FALSE, new String[]{"billtype"});
        this.setTransferPropertyCtrl();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        List allFieldKeys = this.getModel().getDataEntityType().getAllFields().values().stream().map(IMetadata::getName).collect(Collectors.toList());
        for (String fieldKey : FIELD_KEY_F7) {
            Control ctrl;
            if (!allFieldKeys.contains(fieldKey) || !((ctrl = this.getView().getControl(fieldKey)) instanceof BasedataEdit)) continue;
            ((BasedataEdit)ctrl).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
        int rowIndex = e.getRowIndex();
        Object source = e.getSource();
        if (source instanceof DateEdit) {
            DateEdit dateEdit = (DateEdit)source;
            switch (dateEdit.getKey()) {
                case "producedate": {
                    this.beforeProduceDatePostBack(e, rowIndex);
                    break;
                }
                case "expirydate": {
                    this.beforeExpiryDatePostBack(e, rowIndex);
                    break;
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        super.propertyChanged(e);
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null || changeSet.length <= 0) {
            return;
        }
        switch (fieldKey = e.getProperty().getName()) {
            case "goodsid": {
                this.goodsIdChanged(changeSet);
                break;
            }
            case "operator": {
                this.operatorChanged(changeSet);
                break;
            }
            case "deliverybranch": {
                this.deliveryBranchChanged(changeSet);
                break;
            }
            case "receivebranch": {
                this.receiveBranchChanged(changeSet);
                break;
            }
            case "biztype": {
                this.bizTypeChanged(changeSet);
                break;
            }
            case "transrelation": {
                this.transRelationChanged(changeSet);
                break;
            }
            case "transtype": {
                this.transTypeChanged(changeSet);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListFilterParameter filterParameter = ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter();
        switch (fieldKey) {
            case "biztype": {
                this.setBizTypeFilter(filterParameter);
                break;
            }
            case "deliverybranch": {
                this.setBranchFilter(filterParameter);
                break;
            }
            case "deliveryorg": {
                this.setOrgFilter(filterParameter);
                break;
            }
            case "dept": {
                this.setDeptFilter(filterParameter);
                break;
            }
            case "bizdept": {
                this.setBizDeptFilter(filterParameter);
                break;
            }
            case "goodsid": {
                this.setGoodsFilter(filterParameter);
                break;
            }
            case "warehouse": {
                this.setStockFilter(filterParameter);
                break;
            }
            case "location": {
                this.setPositionFilter(filterParameter, e.getRow());
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String opKey = e.getOperateKey();
        if (Arrays.asList(SERIAL_NUMBER_OPS).contains(opKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows != null && selectRows.length == 1) {
                DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"entryentity");
                SerialNumberHelper.handleSerialNumber((AbstractBillPlugIn)this, (DynamicObject)dataEntity, (DynamicObject)((DynamicObject)entryEntities.get(selectRows[0])), (String)opKey);
            }
        } else if (StringUtils.equals((CharSequence)opKey, (CharSequence)"searchinventory")) {
            this.showQueryInventory();
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        RowDataEntity[] rowDataEntities;
        super.afterAddRow(e);
        String entryKey = e.getEntryProp().getName();
        if (StringUtils.equals((CharSequence)entryKey, (CharSequence)"entryentity") && (rowDataEntities = e.getRowDataEntities()) != null && rowDataEntities.length > 0) {
            for (RowDataEntity rowDataEntity : rowDataEntities) {
                int rowIndex = rowDataEntity.getRowIndex();
                this.initEntryValue(rowIndex);
                this.initDefOwnerAndKeeper(rowIndex);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if (StringUtils.equals((CharSequence)callBackId, (CharSequence)"MaterialLifeDate")) {
            DynamicObjectCollection entryEntities = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)entryEntities)) {
                return;
            }
            String customValue = e.getCustomVaule();
            List alertMsgList = (List)SerializationUtils.fromJsonString((String)customValue, List.class);
            for (Map params : alertMsgList) {
                int rowIndex = (Integer)params.get("index");
                DynamicObject entryEntity = (DynamicObject)entryEntities.get(rowIndex);
                if (MessageBoxResult.Yes.equals((Object)e.getResult())) {
                    Date newProduceDate = DateUtil.getDateFormat((String)((String)params.get("newProduceDate")));
                    entryEntity.set("producedate", (Object)newProduceDate);
                    Date newExpiryDate = DateUtil.getDateFormat((String)((String)params.get("newExpiryDate")));
                    entryEntity.set("expirydate", (Object)newExpiryDate);
                } else {
                    entryEntity.set("producedate", null);
                    entryEntity.set("expirydate", null);
                }
                this.getView().updateView("producedate", rowIndex);
                this.getView().updateView("expirydate", rowIndex);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        if (StringUtils.equals((CharSequence)e.getActionId(), (CharSequence)"ocpos_importsn")) {
            NotificationUtil.showDefaultSuccessNotification((String)returnData.toString(), (IFormView)this.getView());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        String opKey = FormViewUtil.getOpKey((BeforeDoOperationEventArgs)e);
        if (Arrays.asList(SERIAL_NUMBER_OPS).contains(opKey)) {
            SerialNumberHelper.beforeHandleSerialNumber((AbstractBillPlugIn)this, (BeforeDoOperationEventArgs)e);
        } else if ("matchingruleout".equals(opKey)) {
            this.matchingRuleOut(e);
        }
    }

    private void matchingRuleOut(BeforeDoOperationEventArgs args) {
        EntryGrid control = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = control.getSelectRows();
        if (selectRows.length == 0) {
            NotificationUtil.showDefaultTipNotify((String)ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u5206\u5f55\u884c\u6570\u636e", (String)"StoreDeliveryEdit", (String)"occ-ocpos-formplugin", (Object[])new Object[0]), (IFormView)this.getView());
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("deliveryorg");
        ArrayList<Map<String, Object>> entryInfoList = new ArrayList<Map<String, Object>>(selectRows.length);
        ArrayList<String> ruleList = new ArrayList<String>(selectRows.length);
        for (int index : selectRows) {
            DynamicObject entry = this.getModel().getEntryRowEntity("entryentity", index);
            String confirmMsg = this.matchingRuleOutValidateAlertMsg(entry, index);
            if (!confirmMsg.isEmpty()) {
                NotificationUtil.showDefaultTipNotify((String)confirmMsg, (IFormView)this.getView());
                return;
            }
            DynamicObject material = entry.getDynamicObject("material");
            String rule = material.getString("outboundrules");
            ruleList.add(rule);
            BigDecimal qty = entry.getBigDecimal("qty");
            Map<String, Object> paramsMap = this.buildFilterParams(entry);
            paramsMap.put("org", org.getPkValue());
            List orderByRule = MatchRuleOutHelper.getOrderByRule((String)rule);
            ArrayList<QFilter> lotintrackFilter = new ArrayList<QFilter>(16);
            lotintrackFilter.add(new QFilter("material", "=", material.getPkValue()));
            lotintrackFilter.add(new QFilter("org", "=", org.getPkValue()));
            DataSet lotintracksSet = MatchRuleOutHelper.getLotinTracksDataSet(lotintrackFilter);
            Map singleEntryMap = MatchRuleOutHelper.getInsertEntryInfo((DataSet)lotintracksSet, (BigDecimal)qty, paramsMap, (List)orderByRule);
            entryInfoList.add(singleEntryMap);
        }
        this.dealWithEntry(entryInfoList, ruleList);
    }

    public void dealWithEntry(List<Map<String, Object>> insertEntryInfo, List<String> ruleList) {
        Boolean isEnough = Boolean.TRUE;
        EntryGrid control = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = control.getSelectRows();
        int selectRowIndex = 0;
        ArrayList<Map<String, Object>> paramList = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < insertEntryInfo.size(); ++i) {
            int index = selectRows[selectRowIndex];
            Map<String, Object> insertEntry = insertEntryInfo.get(i);
            BigDecimal qty = (BigDecimal)insertEntry.get("qty");
            BigDecimal invAccCounts = (BigDecimal)insertEntry.get("count");
            String materialName = (String)insertEntry.get("materialName");
            Integer precision = (Integer)insertEntry.get("precision");
            if (BigDecimal.ZERO.compareTo(invAccCounts) == 0) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7684\u7269\u6599,\u7269\u6599\u5e93\u5b58\u4e0d\u8db3\uff0c\u8bf7\u68c0\u67e5\u5f53\u524d\u5206\u5f55\u6570\u636e\u548c\u5373\u65f6\u5e93\u5b58", (String)"StoreDeliveryEdit", (String)"occ-ocpos-formplugin", (Object[])new Object[0]), index + 1));
                return;
            }
            if (qty.compareTo(invAccCounts) > 0) {
                isEnough = Boolean.FALSE;
                BigDecimal remainQty = qty.subtract(invAccCounts);
                if (precision != null) {
                    remainQty = remainQty.setScale((int)precision, 4);
                }
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("index", index);
                paramMap.put("remainQty", remainQty);
                paramMap.put("materialName", materialName);
                paramList.add(paramMap);
            }
            ++selectRowIndex;
        }
        if (!isEnough.booleanValue()) {
            this.showConfirm(insertEntryInfo, paramList, ruleList);
        } else {
            this.insertEntry(insertEntryInfo);
        }
    }

    public void insertEntry(List<Map<String, Object>> insertEntryInfo) {
        ArrayList<Map<Object, Object>> confirmList = new ArrayList<Map<Object, Object>>(16);
        int entryIndex = 0;
        IDataModel model = this.getModel();
        EntryGrid control = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = control.getSelectRows();
        int selectRowIndex = 0;
        int addRow = 0;
        for (int i = 0; i < insertEntryInfo.size(); ++i) {
            Map<String, Object> insertEntry = insertEntryInfo.get(i);
            int index = selectRows[selectRowIndex];
            List entryInfoList = (List)insertEntry.get("entryInfo");
            int size = entryInfoList.size();
            entryIndex = index + addRow;
            for (int j = 0; j < size; ++j) {
                if (j != 0) {
                    this.getModel().insertEntryRow("entryentity", entryIndex);
                    ++addRow;
                }
                Map map = (Map)entryInfoList.get(j);
                this.insertSingleEntry(map, entryIndex, model);
                Date produceDate = this.parseDate((String)map.get("producedate"));
                Date expiryDate = this.parseDate((String)map.get("expirydate"));
                DynamicObject materialInvInfo = (DynamicObject)model.getValue("material", entryIndex);
                HashMap<String, Comparable<Integer>> confirmMap = new HashMap<String, Comparable<Integer>>();
                confirmMap.put("entryIndex", Integer.valueOf(entryIndex));
                confirmMap.put("materialInvInfo", (Comparable<Integer>)materialInvInfo);
                confirmMap.put("expiryDate", expiryDate);
                confirmMap.put("produceDate", produceDate);
                confirmList.add(confirmMap);
                ++entryIndex;
            }
            ++selectRowIndex;
        }
        this.showExpiryDateConfirm(confirmList);
    }

    private Date parseDate(String dateStr) {
        Date date;
        if (StringUtils.isEmpty((CharSequence)dateStr)) {
            return null;
        }
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        try {
            date = sd.parse(dateStr);
        }
        catch (ParseException e) {
            LOG.error("\u65e5\u671f\u8f6c\u6362\u9519\u8bef", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\uff01", (String)"StoreDeliveryEdit", (String)"occ-ocpos-formplugin", (Object[])new Object[0]));
        }
        return date;
    }

    private void insertSingleEntry(Map<String, Object> map, int index, IDataModel model) {
        model.setValue("lotnumber", map.get("lotnumber"), index);
        model.setValue("producedate", (Object)this.parseDate((String)map.get("producedate")), index);
        model.setValue("expirydate", (Object)this.parseDate((String)map.get("expirydate")), index);
        model.setValue("warehouse", map.get("warehouse"), index);
    }

    private void showExpiryDateConfirm(List<Map<Object, Object>> confirmList) {
        ArrayList alertMsgList = new ArrayList(16);
        StringBuilder alertMsg = new StringBuilder();
        Date nowDate = new Date();
        for (int i = 0; i < confirmList.size(); ++i) {
            int dateOfOverdueForOut;
            Map<Object, Object> confirmMap = confirmList.get(i);
            int rowIndex = (Integer)confirmMap.get("entryIndex");
            DynamicObject materialInvInfo = (DynamicObject)confirmMap.get("materialInvInfo");
            Date newExpiryDate = (Date)confirmMap.get("expiryDate");
            Date newProduceDate = (Date)confirmMap.get("produceDate");
            if (newExpiryDate == null) {
                return;
            }
            String leadTimeUnit = materialInvInfo.getString("leadtimeunit");
            Date overdueDate = MatchRuleOutHelper.getDateOfOverdue((String)leadTimeUnit, (int)(dateOfOverdueForOut = materialInvInfo.getInt("dateofoverdueforout")), (Date)newExpiryDate);
            boolean dateOver = nowDate.after(overdueDate);
            if (!dateOver) continue;
            HashMap<String, Object> params = new HashMap<String, Object>();
            String newExpiryDateStr = this.getDateStr(newExpiryDate);
            String newProduceDateStr = this.getDateStr(newProduceDate);
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7684\u7269\u6599[%s]\u5230\u671f\u65e5\u671f\u4e3a[%s],", (String)"StoreDeliveryEdit", (String)"occ-ocpos-formplugin", (Object[])new Object[0]), rowIndex + 1, materialInvInfo.get("masterid.name"), newExpiryDateStr);
            alertMsg.append(msg);
            params.put("newProduceDate", newProduceDateStr);
            params.put("oldProduceDate", null);
            params.put("newExpiryDate", newExpiryDateStr);
            params.put("oldExpiryDate", null);
            params.put("index", rowIndex);
            params.put("deleteEntry", Boolean.TRUE);
            alertMsgList.add(params);
        }
        if (alertMsg.length() > 0) {
            ConfirmCallBackListener cb = new ConfirmCallBackListener("MaterialLifeDate", (IFormPlugin)this);
            alertMsg.append(ResManager.loadKDString((String)"\u5373\u5c06\u8fc7\u671f\u6216\u8005\u5df2\u7ecf\u8fc7\u671f\uff0c\u662f\u5426\u5141\u8bb8\u5f55\u5165\uff1f", (String)"StoreDeliveryEdit", (String)"occ-ocpos-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u5373\u5c06\u8fc7\u671f\u6216\u8005\u5df2\u7ecf\u8fc7\u671f\u7269\u6599", (String)"StoreDeliveryEdit", (String)"occ-ocpos-formplugin", (Object[])new Object[0]), alertMsg.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, cb, null, SerializationUtils.toJsonString(alertMsgList));
        }
    }

    private String getDateStr(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        String dateStr = sd.format(date);
        return dateStr;
    }

    private void showConfirm(List<Map<String, Object>> entryInfoList, List<Map<String, Object>> paramList, List<String> ruleList) {
        if (null != entryInfoList) {
            StringBuilder detailMsg = new StringBuilder();
            for (int i = 0; i < paramList.size(); ++i) {
                Map<String, Object> map = paramList.get(i);
                int index = (Integer)map.get("index");
                BigDecimal remainQty = (BigDecimal)map.get("remainQty");
                String materialName = (String)map.get("materialName");
                String outRule = MatchRuleOutHelper.getOutRule((String)ruleList.get(i));
                String msg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7684\u7269\u6599:%s %s, \u4e0d\u8db3\u6570\u91cf\u4e3a\uff1a%s;", (String)"StoreDeliveryEdit", (String)"occ-ocpos-formplugin", (Object[])new Object[0]), index + 1, materialName, outRule, remainQty);
                detailMsg.append(msg);
            }
            ConfirmCallBackListener cb = new ConfirmCallBackListener("bar_matchingrule", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7269\u6599\u5e93\u5b58\u4e0d\u8db3\uff0c\u662f\u5426\u6309\u73b0\u6709\u5e93\u5b58\u5339\u914d\uff1f", (String)"StoreDeliveryEdit", (String)"occ-ocpos-formplugin", (Object[])new Object[0]), detailMsg.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, cb, null, SerializationUtils.toJsonString(entryInfoList));
        }
    }

    private Map<String, Object> buildFilterParams(DynamicObject entry) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        DynamicObject auxpty = entry.getDynamicObject("auxpty");
        DynamicObject materialInvInfo = entry.getDynamicObject("material");
        DynamicObject material = materialInvInfo.getDynamicObject("masterid");
        DynamicObject baseunit = entry.getDynamicObject("baseunit");
        DynamicObject warehouse = entry.getDynamicObject("warehouse");
        DynamicObject locaition = entry.getDynamicObject("location");
        DynamicObject outinvtype = entry.getDynamicObject("outinvtype");
        DynamicObject outinvstatus = entry.getDynamicObject("outinvstatus");
        Object ownertype = entry.get("outownertype");
        DynamicObject owner = entry.getDynamicObject("outowner");
        Object keepertype = entry.get("outkeepertype");
        DynamicObject keeper = entry.getDynamicObject("outkeeper");
        DynamicObject unit = entry.getDynamicObject("unit");
        if (null != auxpty) {
            paramsMap.put("auxpty", auxpty.getPkValue());
        }
        if (null != warehouse) {
            paramsMap.put("warehouse", warehouse.getPkValue());
        }
        if (null != locaition) {
            paramsMap.put("location", locaition.getPkValue());
        }
        paramsMap.put("material", DynamicObjectUtils.getPkValue((DynamicObject)material));
        paramsMap.put("invstatus", DynamicObjectUtils.getPkValue((DynamicObject)outinvstatus));
        paramsMap.put("baseunit", DynamicObjectUtils.getPkValue((DynamicObject)baseunit));
        paramsMap.put("unit", DynamicObjectUtils.getPkValue((DynamicObject)unit));
        paramsMap.put("invtype", DynamicObjectUtils.getPkValue((DynamicObject)outinvtype));
        paramsMap.put("ownertype", ownertype);
        paramsMap.put("owner", DynamicObjectUtils.getPkValue((DynamicObject)owner));
        paramsMap.put("keepertype", keepertype);
        paramsMap.put("keeper", DynamicObjectUtils.getPkValue((DynamicObject)keeper));
        return paramsMap;
    }

    private String matchingRuleOutValidateAlertMsg(DynamicObject entry, int index) {
        String msg;
        DynamicObject material = entry.getDynamicObject("material");
        DynamicObject unit = entry.getDynamicObject("unit");
        BigDecimal qty = entry.getBigDecimal("qty");
        DynamicObject outInvType = entry.getDynamicObject("outinvtype");
        DynamicObject outInvStatus = entry.getDynamicObject("outinvstatus");
        Object outOwnerType = entry.get("outownertype");
        DynamicObject outOwner = entry.getDynamicObject("outowner");
        Object outKeeperType = entry.get("outkeepertype");
        DynamicObject outKeeper = entry.getDynamicObject("outkeeper");
        StringBuilder alertMsg = new StringBuilder();
        if (null == material || null == unit || null == outKeeper || null == outInvType || null == outInvStatus || null == outOwnerType || null == outOwner || null == outKeeperType || BigDecimal.ZERO.compareTo(qty) == 0) {
            if (null == material) {
                alertMsg.append(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801", (String)"StoreDeliveryEdit", (String)"occ-ocpos-formplugin", (Object[])new Object[0]));
            }
            if (null == unit) {
                this.appendSpaceMark(alertMsg);
                alertMsg.append(ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"StoreDeliveryEdit", (String)"occ-ocpos-formplugin", (Object[])new Object[0]));
            }
            if (BigDecimal.ZERO.compareTo(qty) == 0) {
                this.appendSpaceMark(alertMsg);
                alertMsg.append(ResManager.loadKDString((String)"\u6570\u91cf", (String)"StoreDeliveryEdit", (String)"occ-ocpos-formplugin", (Object[])new Object[0]));
            }
            if (null == outInvType) {
                this.appendSpaceMark(alertMsg);
                alertMsg.append(ResManager.loadKDString((String)"\u51fa\u5e93\u5e93\u5b58\u7c7b\u578b", (String)"StoreDeliveryEdit", (String)"occ-ocpos-formplugin", (Object[])new Object[0]));
            }
            if (null == outInvStatus) {
                this.appendSpaceMark(alertMsg);
                alertMsg.append(ResManager.loadKDString((String)"\u51fa\u5e93\u5e93\u5b58\u72b6\u6001", (String)"StoreDeliveryEdit", (String)"occ-ocpos-formplugin", (Object[])new Object[0]));
            }
            if (null == outOwnerType) {
                this.appendSpaceMark(alertMsg);
                alertMsg.append(ResManager.loadKDString((String)"\u51fa\u5e93\u8d27\u4e3b\u7c7b\u578b", (String)"StoreDeliveryEdit", (String)"occ-ocpos-formplugin", (Object[])new Object[0]));
            }
            if (null == outOwner) {
                this.appendSpaceMark(alertMsg);
                alertMsg.append(ResManager.loadKDString((String)"\u51fa\u5e93\u8d27\u4e3b", (String)"StoreDeliveryEdit", (String)"occ-ocpos-formplugin", (Object[])new Object[0]));
            }
            if (null == outKeeperType) {
                this.appendSpaceMark(alertMsg);
                alertMsg.append(ResManager.loadKDString((String)"\u51fa\u5e93\u4fdd\u7ba1\u8005\u7c7b\u578b", (String)"StoreDeliveryEdit", (String)"occ-ocpos-formplugin", (Object[])new Object[0]));
            }
            if (null == outKeeper) {
                this.appendSpaceMark(alertMsg);
                alertMsg.append(ResManager.loadKDString((String)"\u51fa\u5e93\u4fdd\u7ba1\u8005", (String)"StoreDeliveryEdit", (String)"occ-ocpos-formplugin", (Object[])new Object[0]));
            }
            alertMsg.append(ResManager.loadKDString((String)"\u4e0d\u80fd\u4e3a\u7a7a ", (String)"StoreDeliveryEdit", (String)"occ-ocpos-formplugin", (Object[])new Object[0]));
            msg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c", (String)"StoreDeliveryEdit", (String)"occ-ocpos-formplugin", (Object[])new Object[0]), index + 1);
            alertMsg.insert(0, msg);
        }
        if (alertMsg.length() > 0) {
            return alertMsg.toString();
        }
        if (material != null && !material.getBoolean("enablelot") && !material.getBoolean("enableshelflifemgr")) {
            msg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7269\u6599\u672a\u542f\u7528\u6279\u53f7\u7ba1\u7406\u6216\u672a\u542f\u7528\u4fdd\u8d28\u671f\u7ba1\u7406\uff0c\u65e0\u6cd5\u5339\u914d\u89c4\u5219\u51fa\u5e93", (String)"StoreDeliveryEdit", (String)"occ-ocpos-formplugin", (Object[])new Object[0]), index + 1);
            return msg;
        }
        if (material != null && StringUtils.isEmpty((CharSequence)material.getString("outboundrules"))) {
            msg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7269\u6599\u672a\u8bbe\u7f6e\u51fa\u5e93\u89c4\u5219", (String)"StoreDeliveryEdit", (String)"occ-ocpos-formplugin", (Object[])new Object[0]), index + 1);
            return msg;
        }
        return alertMsg.toString();
    }

    private void appendSpaceMark(StringBuilder alertMsg) {
        if (alertMsg.length() > 0) {
            alertMsg.append('\u3001');
        }
    }

    private void goodsIdChanged(ChangeData[] changeSet) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            return;
        }
        DynamicObject classStdApply = PosItemUtil.getClassStandardApply();
        DataSetBuilder goodsDataBuilder = this.getGoodsDataBuilder();
        HashSet<Long> materialIds = new HashSet<Long>(changeSet.length);
        for (ChangeData changeData : changeSet) {
            if (CommonUtil.checkChanged((ChangeData)changeData)) {
                return;
            }
            int index = changeData.getRowIndex();
            DynamicObject entryEntity = (DynamicObject)entryEntities.get(index);
            DynamicObject goods = (DynamicObject)changeData.getNewValue();
            DynamicObject goodsClass = null;
            if (goods != null) {
                goodsClass = PosItemUtil.queryItemClass((DynamicObject)classStdApply, (DynamicObject)goods);
            }
            entryEntity.set("goodsclass", (Object)goodsClass);
            long materialId = DynamicObjectUtils.getPkValue((DynamicObject)goods, (String)"material");
            materialIds.add(materialId);
            goodsDataBuilder.append(new Object[]{index, materialId});
        }
        if (!CollectionUtils.isEmpty(materialIds)) {
            DataSet goodsData = goodsDataBuilder.build();
            this.dataEntities = new ArrayList<RowDataEntity>();
            this.initMaterial(entryEntities, goodsData, materialIds);
            if (!CollectionUtils.isEmpty(this.dataEntities)) {
                DynamicProperty property = entryEntities.getDynamicObjectType().getProperty("material");
                FormRuleUtils.raiseFormRules((IFormView)this.getView(), this.dataEntities, (IDataEntityProperty)property);
            }
        }
        this.getView().updateView("entryentity");
    }

    private void operatorChanged(ChangeData[] changeSet) {
        long deptId = 0L;
        long operatorGroupId = 0L;
        DynamicObject operator = (DynamicObject)changeSet[0].getNewValue();
        if (operator != null) {
            operator = BusinessDataServiceHelper.loadSingleFromCache((Object)operator.getPkValue(), (String)"bd_operator");
            operatorGroupId = DynamicObjectUtils.getLong((DynamicObject)operator, (String)"operatorgrpid");
            deptId = this.getDeptId(operator);
        }
        this.getModel().setItemValueByID("dept", (Object)deptId);
        this.getModel().setItemValueByID("operatorgroup", (Object)operatorGroupId);
    }

    private void deliveryBranchChanged(ChangeData[] changeSet) {
        DynamicObject branch = (DynamicObject)changeSet[0].getNewValue();
        this.initInvOrg(branch);
        this.initCurrency(branch);
    }

    private void receiveBranchChanged(ChangeData[] changeSet) {
        DynamicObject branch = (DynamicObject)changeSet[0].getNewValue();
        this.initRecOrg(branch);
    }

    private void bizTypeChanged(ChangeData[] changeSet) {
        DynamicObject bizType = (DynamicObject)changeSet[0].getNewValue();
        long bizTypeId = DynamicObjectUtils.getPkValue((DynamicObject)bizType);
        this.initInvScheme(bizTypeId);
    }

    private void transRelationChanged(ChangeData[] changeSet) {
        String transRelation = (String)changeSet[0].getNewValue();
        this.setTransferPropertyCtrl();
        if (StringUtils.equals((CharSequence)transRelation, (CharSequence)"A")) {
            this.getModel().setValue("transtype", (Object)"A");
        } else {
            this.getModel().setValue("transtype", (Object)"B");
        }
    }

    private void transTypeChanged(ChangeData[] changeSet) {
        String transType = (String)changeSet[0].getNewValue();
        this.setTransferPropertyCtrl();
        if (StringUtils.equals((CharSequence)transType, (CharSequence)"A")) {
            this.getModel().setValue("receivebranch", this.getModel().getValue("deliverybranch"));
            this.getModel().setValue("receiveorg", this.getModel().getValue("deliveryorg"));
            this.getModel().setValue("receivedate", this.getModel().getValue("deliverydate"));
        }
    }

    private void initBillType() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map customParams = parameter.getCustomParams();
        long billTypeId = CommonUtil.formatObejctToLong((Object)customParams.getOrDefault("billtype", 1173164380335041536L));
        this.getModel().setItemValueByID("billtype", (Object)billTypeId);
        this.initBizTypeAndInvScheme(billTypeId);
        this.initTransferProperty(billTypeId);
    }

    private void initBizTypeAndInvScheme(long billTypeId) {
        if (billTypeId == 1173164380335041536L) {
            this.getModel().setItemValueByID("biztype", (Object)739548857603766272L);
            this.getModel().setValue("invschemeid", (Object)739551937573353472L);
        } else if (billTypeId == 1173164848679414784L) {
            this.getModel().setItemValueByID("biztype", (Object)422889961931423744L);
            this.getModel().setValue("invschemeid", (Object)694636568769627136L);
        } else {
            this.getModel().setItemValueByID("biztype", (Object)0L);
            this.getModel().setValue("invschemeid", (Object)0L);
        }
    }

    private void initInvScheme(long bizTypeId) {
        DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype");
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)billType);
        String billFormId = billTypeId == 1173164848679414784L ? "im_transoutbill" : "im_otheroutbill";
        long invSchemeId = InventoryHelper.getInvSchemeByEntityAndBizType((String)billFormId, (long)bizTypeId);
        this.getModel().setValue("invschemeid", (Object)invSchemeId);
    }

    private void initTransferProperty(long bizTypeId) {
        if (bizTypeId != 1173164848679414784L) {
            return;
        }
        this.getModel().setValue("transtype", (Object)"B");
        this.getModel().setValue("transrelation", (Object)"C");
        this.getModel().setValue("transit", (Object)"A");
    }

    private void initBranch(DynamicObject dataEntity) {
        long defaultOwnerId = OwnerUtil.getDefaultOwnerId();
        this.getModel().setItemValueByID("deliverybranch", (Object)defaultOwnerId);
        this.getModel().setItemValueByID("receivebranch", (Object)defaultOwnerId);
        DynamicObject branch = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"deliverybranch");
        this.initInvOrg(branch);
        this.initCurrency(branch);
    }

    private void initCurrency(DynamicObject branch) {
        long currencyId = DynamicObjectUtils.getPkValue((DynamicObject)branch, (String)"currency");
        this.getModel().setItemValueByID("currency", (Object)currencyId);
    }

    private void initInvOrg(DynamicObject branch) {
        long invOrgId = this.getInvOrgId(branch);
        this.getModel().setItemValueByID("deliveryorg", (Object)invOrgId);
    }

    private void initRecOrg(DynamicObject branch) {
        long invOrgId = this.getInvOrgId(branch);
        this.getModel().setItemValueByID("receiveorg", (Object)invOrgId);
    }

    private void initEntryValue(int ... rows) {
        boolean initialized = this.getModel().isInitialized();
        if (rows == null || rows.length == 0) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long invSchemeId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)"invschemeid");
        DynamicObject invScheme = BusinessDataServiceHelper.loadSingle((Object)invSchemeId, (String)"im_invscheme");
        if (invScheme == null) {
            return;
        }
        boolean isInUpdate = DynamicObjectUtils.getBoolean((DynamicObject)invScheme, (String)"isinupdate");
        boolean isOutUpdate = DynamicObjectUtils.getBoolean((DynamicObject)invScheme, (String)"isoutupdate");
        String ownerType = "bos_org";
        String keeperType = "bos_org";
        Object invStatusId = null;
        Object invTypeId = null;
        if (isInUpdate) {
            ownerType = DynamicObjectUtils.getString((DynamicObject)invScheme, (String)"ownertype");
            keeperType = DynamicObjectUtils.getString((DynamicObject)invScheme, (String)"keepertype");
            DynamicObject invStatus = InventoryHelper.getDefaultInvStatus((DynamicObject)invScheme);
            DynamicObject invType = InventoryHelper.getDefaultInvType((DynamicObject)invScheme);
            invStatusId = invStatus == null ? null : invStatus.getPkValue();
            invTypeId = invType == null ? null : invType.getPkValue();
        }
        String outOwnerType = "bos_org";
        String outKeeperType = "bos_org";
        Object outInvStatusId = null;
        Object outInvTypeId = null;
        if (isOutUpdate) {
            outOwnerType = DynamicObjectUtils.getString((DynamicObject)invScheme, (String)"outownertype");
            outKeeperType = DynamicObjectUtils.getString((DynamicObject)invScheme, (String)"outkeepertype");
            DynamicObject outInvStatus = InventoryHelper.getDefaultOutInvStatus((DynamicObject)invScheme);
            DynamicObject outInvType = InventoryHelper.getDefaultOutInvType((DynamicObject)invScheme);
            outInvStatusId = outInvStatus == null ? null : outInvStatus.getPkValue();
            outInvTypeId = outInvType == null ? null : outInvType.getPkValue();
        }
        for (int row : rows) {
            if (!initialized) {
                this.getModel().beginInit();
            }
            this.getModel().setValue("inowner", null, row);
            this.getModel().setValue("inkeeper", null, row);
            this.getModel().setValue("inownertype", (Object)ownerType, row);
            this.getModel().setValue("inkeepertype", (Object)keeperType, row);
            this.getModel().setValue("outowner", null, row);
            this.getModel().setValue("outkeeper", null, row);
            this.getModel().setValue("outownertype", (Object)outOwnerType, row);
            this.getModel().setValue("outkeepertype", (Object)outKeeperType, row);
            this.getModel().setValue("ininvstatus", invStatusId, row);
            this.getModel().setValue("ininvtype", invTypeId, row);
            this.getModel().setValue("outinvstatus", outInvStatusId, row);
            this.getModel().setValue("outinvtype", outInvTypeId, row);
            if (initialized) continue;
            this.getModel().endInit();
            this.getView().updateView("inowner", row);
            this.getView().updateView("inkeeper", row);
            this.getView().updateView("inownertype", row);
            this.getView().updateView("inkeepertype", row);
            this.getView().updateView("ininvstatus", row);
            this.getView().updateView("ininvtype", row);
            this.getView().updateView("outowner", row);
            this.getView().updateView("inkeeper", row);
            this.getView().updateView("outownertype", row);
            this.getView().updateView("outkeepertype", row);
            this.getView().updateView("outinvstatus", row);
            this.getView().updateView("outinvtype", row);
        }
    }

    private void initMaterial(DynamicObjectCollection entryEntities, DataSet goodsData, Set<Long> materialIds) {
        QFilter filter = F7Util.getMaterialInvFilter();
        filter.and("masterid.id", "in", materialIds);
        DataSet materialInvData = QueryServiceHelper.queryDataSet((String)"materialmasterid", (String)"bd_materialinventoryinfo", (String)"id, masterid.id as masterid", (QFilter[])filter.toArray(), null);
        DataSet data = goodsData.fullJoin(materialInvData).on("material", "masterid").select(new String[]{"index", "id"}).finish();
        if (data != null) {
            DataSet dataSet = data.select(this.getGoodsMaterialInvInfoFields());
            this.getModel().beginInit();
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                int index = row.getInteger("index");
                long materialInvId = row.getLong("id");
                if (materialInvId == 0L) continue;
                this.getModel().setValue("material", (Object)materialInvId, index);
                this.dataEntities.add((RowDataEntity)new ChangeData(index, (DynamicObject)entryEntities.get(index), (Object)0L, (Object)materialInvId));
            }
            this.getModel().endInit();
        }
    }

    private void initDefOwnerAndKeeper(int row) {
        boolean initialized = this.getModel().isInitialized();
        if (!initialized) {
            this.getModel().beginInit();
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"deliveryorg");
        long customerId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"customer");
        DynamicObject entryEntity = this.getModel().getEntryRowEntity("entryentity", row);
        String outKeeperType = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"outkeepertype");
        Long defaultOutKeeperId = null;
        if (!StringUtils.isEmpty((CharSequence)outKeeperType)) {
            defaultOutKeeperId = InventoryHelper.getDefaultOutKeeper((String)outKeeperType, (long)orgId, (long)customerId);
        }
        this.getModel().setValue("outkeeper", (Object)defaultOutKeeperId, row);
        String outOwnerType = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"outkeepertype");
        Long defaultOutOwnerId = null;
        if (!StringUtils.isEmpty((CharSequence)outOwnerType)) {
            defaultOutOwnerId = InventoryHelper.getDefaultOutOwner((String)outOwnerType, (long)orgId, (long)customerId);
        }
        this.getModel().setValue("outowner", (Object)defaultOutOwnerId, row);
        String keeperType = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"inkeepertype");
        Long defaultKeeperId = null;
        if (!StringUtils.isEmpty((CharSequence)keeperType)) {
            defaultKeeperId = InventoryHelper.getDefaultKeeper((String)keeperType, (long)orgId, (long)customerId);
        }
        this.getModel().setValue("inkeeper", (Object)defaultKeeperId, row);
        String ownerType = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"inownertype");
        Long defaultOwnerId = null;
        if (!StringUtils.isEmpty((CharSequence)ownerType)) {
            defaultOwnerId = InventoryHelper.getDefaultOwner((String)ownerType, (long)orgId, (long)customerId);
        }
        this.getModel().setValue("inowner", (Object)defaultOwnerId, row);
        if (!initialized) {
            this.getModel().endInit();
            this.getView().updateView("outkeeper", row);
            this.getView().updateView("outowner", row);
            this.getView().updateView("inkeeper", row);
            this.getView().updateView("inowner", row);
        }
    }

    private void setTransferPropertyCtrl() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"billtype");
        if (billTypeId != 1173164848679414784L) {
            return;
        }
        String transRelation = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"transrelation");
        boolean isDeliveryBranchMustInput = !StringUtils.equals((CharSequence)transRelation, (CharSequence)"C");
        FormViewUtil.setMustInput((IFormView)this.getView(), (boolean)isDeliveryBranchMustInput, (String[])new String[]{"deliverybranch"});
        String transType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"transtype");
        boolean isStoreIn = StringUtils.equals((CharSequence)transType, (CharSequence)"A");
        this.getView().setEnable(Boolean.valueOf(!isStoreIn), new String[]{"receivebranch", "receiveorg", "receivedate"});
    }

    private void setBizTypeFilter(ListFilterParameter filterParameter) {
        QFilter filter;
        DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype");
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)billType);
        if (billTypeId == 1173164848679414784L) {
            filter = new QFilter("billentity.billform", "=", (Object)"im_transoutbill");
        } else {
            filter = new QFilter("billentity.billform", "=", (Object)"im_otheroutbill");
            filter.and("number", "<>", (Object)"380");
        }
        filter.and("status", "=", (Object)StatusEnum.AUDIT.getValue());
        filter.and("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        filterParameter.setQFilters(Collections.singletonList(filter));
    }

    private void setBranchFilter(ListFilterParameter filterParameter) {
        QFilter filter = F7Util.getBranchIdFilter();
        filterParameter.setFilter(filter);
    }

    private void setOrgFilter(ListFilterParameter filterParameter) {
        QFilter filter;
        DynamicObject branch = (DynamicObject)this.getModel().getValue("deliverybranch");
        if (branch == null) {
            filter = F7Utils.getEveFalseFilter();
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u5f55\u5165\u53d1\u8d27\u95e8\u5e97\u3002", (IFormView)this.getView());
        } else {
            List<Long> invOrgIds = this.getInvOrgIds(branch);
            filter = new QFilter("id", "in", invOrgIds);
        }
        filterParameter.setFilter(filter);
    }

    private void setDeptFilter(ListFilterParameter filterParameter) {
        DynamicObject operator = (DynamicObject)this.getModel().getValue("operator");
        if (operator != null) {
            List<Long> deptIds = this.getDeptIds(operator);
            QFilter filter = new QFilter("id", "in", deptIds);
            filterParameter.setFilter(filter);
        }
    }

    private void setStockFilter(ListFilterParameter filterParameter) {
        QFilter filter;
        DynamicObject org = (DynamicObject)this.getModel().getValue("deliveryorg");
        if (org == null) {
            filter = F7Utils.getEveFalseFilter();
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u5f55\u5165\u53d1\u8d27\u7ec4\u7ec7\u3002", (IFormView)this.getView());
        } else {
            long orgId = DynamicObjectUtils.getPkValue((DynamicObject)org);
            List<Long> invOrgIds = Collections.singletonList(orgId);
            List lstStockId = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"IWareHouseService", (String)"getAllSetupWarehouseIDs", (Object[])new Object[]{invOrgIds});
            LOG.info("\u4ed3\u5e93id\u96c6\u5408\uff1a" + JSONObject.toJSONString((Object)lstStockId));
            filter = new QFilter("id", "in", (Object)lstStockId);
        }
        filterParameter.setFilter(filter);
    }

    private void setPositionFilter(ListFilterParameter filterParameter, int index) {
        QFilter filter;
        DynamicObject stock = (DynamicObject)this.getModel().getValue("warehouse", index);
        if (stock == null) {
            filter = F7Utils.getEveFalseFilter();
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u5f55\u5165\u4ed3\u5e93\u3002", (IFormView)this.getView());
        } else {
            long stockId = DynamicObjectUtils.getPkValue((DynamicObject)stock);
            filter = F7Util.getErpStockPositionidFilter((long)stockId);
        }
        filterParameter.setFilter(filter);
    }

    private void setBizDeptFilter(ListFilterParameter filterParameter) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("deliveryorg");
        if (org == null) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u586b\u5199\u53d1\u8d27\u7ec4\u7ec7\u3002", (IFormView)this.getView());
            QFilter filter = F7Utils.getEveFalseFilter();
            filterParameter.setFilter(filter);
            return;
        }
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)org);
        List deptIds = OrgUnitServiceHelper.getAdminOrgRelation(Collections.singletonList(orgId), (boolean)true);
        if (!CollectionUtils.isEmpty((Collection)deptIds)) {
            QFilter filter = new QFilter("id", "in", (Object)deptIds);
            filterParameter.setFilter(filter);
        }
    }

    private void setGoodsFilter(ListFilterParameter filterParameter) {
        QFilter filter = F7Util.getMaterialFilter((String)"material");
        if (filter == null) {
            this.getView().showErrorNotification("\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u3002");
            filter = F7Utils.getEveFalseFilter();
        }
        filterParameter.setFilter(filter);
    }

    private void beforeProduceDatePostBack(BeforeFieldPostBackEvent e, int rowIndex) {
        String calculationForEndDate;
        int shelfLife;
        Date date = DateUtil.getDateFormat((String)CommonUtil.formatStringToEmpty((Object)e.getValue()));
        if (date == null) {
            return;
        }
        DynamicObject entryEntity = this.getModel().getEntryRowEntity("entryentity", rowIndex);
        DynamicObject materialInvInfo = DynamicObjectUtils.getDynamicObject((DynamicObject)entryEntity, (String)"material");
        if (!DynamicObjectUtils.getBoolean((DynamicObject)materialInvInfo, (String)"enableshelflifemgr")) {
            return;
        }
        Date oldProduceDate = DynamicObjectUtils.getDate((DynamicObject)entryEntity, (String)"producedate");
        Date oldExpiryDate = DynamicObjectUtils.getDate((DynamicObject)entryEntity, (String)"expirydate");
        DynamicObject goods = DynamicObjectUtils.getDynamicObject((DynamicObject)entryEntity, (String)"goodsid");
        String goodsName = DynamicObjectUtils.getString((DynamicObject)goods, (String)"name");
        String shelfLifeUnit = DynamicObjectUtils.getString((DynamicObject)materialInvInfo, (String)"shelflifeunit");
        Date expiryDate = ShelfLifeDateHelper.shelfLifeDateCal((String)shelfLifeUnit, (int)(shelfLife = DynamicObjectUtils.getInt((DynamicObject)materialInvInfo, (String)"shelflife")), (Date)date, (String)(calculationForEndDate = DynamicObjectUtils.getString((DynamicObject)materialInvInfo, (String)"calculationforenddate")));
        if (expiryDate.before(date)) {
            String newExpiryDateStr = DateUtil.getDateFormat((Date)expiryDate);
            String newProduceDateStr = DateUtil.getDateFormat((Date)date);
            String msg = String.format("\u7b2c%s\u884c\u7684\u7269\u6599[%s]\u6839\u636e\u751f\u4ea7\u65e5\u671f\u8ba1\u7b97\u51fa\u7684\u5230\u671f\u65e5\u671f[%s]\u5c0f\u4e8e\u751f\u4ea7\u65e5\u671f[%s]\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165,\u8bf7\u786e\u8ba4\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u4fdd\u8d28\u671f\u5230\u671f\u65e5\u8ba1\u7b97\u65b9\u5f0f\u548c\u4fdd\u8d28\u671f\u8bbe\u7f6e", rowIndex + 1, goodsName, newExpiryDateStr, newProduceDateStr);
            this.getView().showErrorNotification(msg);
            this.getView().updateView("producedate", rowIndex);
            e.setCancel(true);
            return;
        }
        this.showExpiryDateConfirm(rowIndex, materialInvInfo, oldExpiryDate, expiryDate, oldProduceDate, date, goodsName);
    }

    private void beforeExpiryDatePostBack(BeforeFieldPostBackEvent e, int rowIndex) {
        Date date = DateUtil.getDateFormat((String)CommonUtil.formatStringToEmpty((Object)e.getValue()));
        if (date == null) {
            return;
        }
        DynamicObject entryEntity = this.getModel().getEntryRowEntity("entryentity", rowIndex);
        DynamicObject materialInvInfo = DynamicObjectUtils.getDynamicObject((DynamicObject)entryEntity, (String)"material");
        if (!DynamicObjectUtils.getBoolean((DynamicObject)materialInvInfo, (String)"enableshelflifemgr")) {
            return;
        }
        Date oldProduceDate = DynamicObjectUtils.getDate((DynamicObject)entryEntity, (String)"producedate");
        Date oldExpiryDate = DynamicObjectUtils.getDate((DynamicObject)entryEntity, (String)"expirydate");
        DynamicObject goods = DynamicObjectUtils.getDynamicObject((DynamicObject)entryEntity, (String)"goodsid");
        String goodsName = DynamicObjectUtils.getString((DynamicObject)goods, (String)"name");
        String shelfLifeUnit = DynamicObjectUtils.getString((DynamicObject)materialInvInfo, (String)"shelflifeunit");
        int shelfLife = DynamicObjectUtils.getInt((DynamicObject)materialInvInfo, (String)"shelflife");
        String calculationForEndDate = DynamicObjectUtils.getString((DynamicObject)materialInvInfo, (String)"calculationforenddate");
        Date produceDate = oldProduceDate;
        if (!StringUtils.equals((CharSequence)"2", (CharSequence)calculationForEndDate)) {
            produceDate = ShelfLifeDateHelper.shelfLifeDateCal((String)shelfLifeUnit, (int)(shelfLife * -1), (Date)date, (String)calculationForEndDate);
        } else if (produceDate != null && date.before(produceDate)) {
            if (oldExpiryDate != null && oldExpiryDate.before(produceDate)) {
                oldExpiryDate = null;
            }
            String newExpiryDateStr = DateUtil.getDateFormat((Date)date);
            String newProduceDateStr = DateUtil.getDateFormat((Date)produceDate);
            String msg = String.format("\u7b2c%s\u884c\u7684\u5546\u54c1[%s]\u5230\u671f\u65e5\u671f[%s]\u5c0f\u4e8e\u751f\u4ea7\u65e5\u671f[%s]\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165,\u8bf7\u786e\u8ba4\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u4fdd\u8d28\u671f\u5230\u671f\u65e5\u8ba1\u7b97\u65b9\u5f0f\u548c\u4fdd\u8d28\u671f\u8bbe\u7f6e", rowIndex + 1, goodsName, newExpiryDateStr, newProduceDateStr);
            NotificationUtil.showDefaultTipNotify((String)msg, (IFormView)this.getView());
            this.getView().updateView("expirydate", rowIndex);
            e.setCancel(true);
            return;
        }
        this.showExpiryDateConfirm(rowIndex, materialInvInfo, oldExpiryDate, date, oldProduceDate, produceDate, goodsName);
    }

    private void showQueryInventory() {
        DynamicObjectCollection entryEntities;
        EntryGrid entryGrid;
        int[] selectRows;
        long currencyId;
        HashMap<String, Object> customParams = new HashMap<String, Object>(5);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"deliverybranch");
        customParams.put("owner", branchId);
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"deliveryorg");
        if (orgId > 0L) {
            customParams.put("stockOrgId", Collections.singletonList(orgId));
        }
        if ((currencyId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"currency")) > 0L) {
            customParams.put("currency", currencyId);
        }
        if ((selectRows = (entryGrid = (EntryGrid)this.getView().getControl("entryentity")).getSelectRows()) != null && selectRows.length > 0 && !CollectionUtils.isEmpty((Collection)(entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"entryentity")))) {
            HashSet<Long> itemIds = new HashSet<Long>();
            for (int selectRow : selectRows) {
                DynamicObject entryRow = (DynamicObject)entryEntities.get(selectRow);
                long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)entryRow, (String)"goodsid");
                if (goodsId <= 0L) continue;
                itemIds.add(goodsId);
            }
            customParams.put("itemIdSet", itemIds);
        }
        customParams.put("extQTyShow", Boolean.TRUE);
        ListShowParameter listShowParameter = FormShowUtils.openNewList((String)"", (String)"ocpos_valiableinv_stand", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void showExpiryDateConfirm(int rowIndex, DynamicObject materialInvInfo, Date oldExpiryDate, Date newExpiryDate, Date oldProduceDate, Date newProduceDate, String goodsName) {
        String leadTimeUnit = materialInvInfo.getString("leadtimeunit");
        int dateOfOverdueForOut = materialInvInfo.getInt("dateofoverdueforout");
        Date overdueDate = ShelfLifeDateHelper.getDateOfOverdue((String)leadTimeUnit, (int)dateOfOverdueForOut, (Date)newExpiryDate);
        Date nowDate = TimeServiceHelper.today();
        boolean dateOver = nowDate.after(overdueDate);
        ArrayList alertMsgList = new ArrayList(2);
        if (dateOver) {
            HashMap<String, Object> params = new HashMap<String, Object>(5);
            String newProduceDateStr = newProduceDate != null ? DateUtil.getDateFormat((Date)newProduceDate) : null;
            params.put("newProduceDate", newProduceDateStr);
            String oldProduceDateStr = oldProduceDate != null ? DateUtil.getDateFormat((Date)oldProduceDate) : null;
            params.put("oldProduceDate", oldProduceDateStr);
            String newExpiryDateStr = newExpiryDate != null ? DateUtil.getDateFormat((Date)newExpiryDate) : null;
            params.put("newExpiryDate", newExpiryDateStr);
            String oldExpiryDateStr = oldExpiryDate != null ? DateUtil.getDateFormat((Date)oldExpiryDate) : null;
            params.put("oldExpiryDate", oldExpiryDateStr);
            params.put("index", rowIndex);
            alertMsgList.add(params);
            ConfirmCallBackListener cb = new ConfirmCallBackListener("MaterialLifeDate", (IFormPlugin)this);
            String msg = String.format("\u7b2c%s\u884c\u7684\u7269\u6599[%s]\u5230\u671f\u65e5\u671f\u4e3a[%s],\u5373\u5c06\u8fc7\u671f\u6216\u8005\u5df2\u7ecf\u8fc7\u671f\uff0c\u662f\u5426\u5141\u8bb8\u5f55\u5165\uff1f", rowIndex + 1, goodsName, newExpiryDateStr);
            this.getView().showConfirm(msg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, cb, null, SerializationUtils.toJsonString(alertMsgList));
        } else {
            this.getModel().beginInit();
            this.getModel().setValue("producedate", (Object)newProduceDate, rowIndex);
            this.getModel().setValue("expirydate", (Object)newExpiryDate, rowIndex);
            this.getModel().endInit();
            this.getView().updateView("producedate", rowIndex);
            this.getView().updateView("expirydate", rowIndex);
        }
    }

    private long getDeptId(DynamicObject operator) {
        long deptId = 0L;
        List<Long> deptIds = this.getDeptIds(operator);
        if (!CollectionUtils.isEmpty(deptIds)) {
            deptId = deptIds.get(0);
        }
        return deptId;
    }

    private long getInvOrgId(DynamicObject branch) {
        long saleOrgId = DynamicObjectUtils.getPkValue((DynamicObject)branch, (String)"saleorg");
        return InventoryUtils.getDefaultInvOrgId((long)saleOrgId);
    }

    private List<Long> getDeptIds(DynamicObject operator) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"deliveryorg");
        List deptIds = OrgUnitServiceHelper.getAllToOrg((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (String)OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType(), (Long)orgId);
        long operatorId = DynamicObjectUtils.getPkValue((DynamicObject)operator, (String)"operatorid");
        List userDeptIds = UserServiceHelper.getUserDepartment((long)operatorId, (boolean)false);
        if (!CollectionUtils.isEmpty((Collection)deptIds) && !CollectionUtils.isEmpty((Collection)userDeptIds)) {
            userDeptIds.retainAll(deptIds);
            return userDeptIds;
        }
        return userDeptIds;
    }

    private List<Long> getInvOrgIds(DynamicObject branch) {
        long saleOrgId = DynamicObjectUtils.getPkValue((DynamicObject)branch, (String)"saleorg");
        return InventoryUtils.getInvOrgIds((long)saleOrgId);
    }

    private DataSetBuilder getGoodsDataBuilder() {
        ArrayList<Field> fields = new ArrayList<Field>(2);
        fields.add(new Field("index", (DataType)DataType.IntegerType));
        fields.add(new Field("material", (DataType)DataType.LongType));
        RowMeta meta = new RowMeta(fields.toArray(new Field[0]));
        return Algo.create((String)"goodsid").createDataSetBuilder(meta);
    }

    private String getGoodsMaterialInvInfoFields() {
        Object[] fields = new String[]{"index", "case when id is null then 0 else id end as id"};
        return StringUtils.join((Object[])fields, (char)',');
    }
}

