/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.inventory;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.AbstractConvertServiceArgs;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.DrawArgs;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.plugin.Plugin;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.botp.Push;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.botp.ReleaseConvertDataMutexPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.botp.ConvertService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.occ.ocbase.common.enums.EnableStatusEnum;
import kd.occ.ocbase.common.enums.StatusEnum;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocbase.common.util.PosItemUtil;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.business.commonhelper.AmountHelper;
import kd.occ.ocpos.business.commonhelper.CurrencyHelper;
import kd.occ.ocpos.business.inventory.InventoryHelper;
import kd.occ.ocpos.common.saleorder.InventoryUtils;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.F7Util;
import kd.occ.ocpos.common.util.OwnerUtil;
import kd.occ.ocpos.common.vo.AmountInfo;

public class StorePurRefundApplyPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String CUR_AMTPRECISION = "amtprecision";
    private static final String ADDRESSF7 = "addressf7";
    private static final String PROVIDERADDRESSF7 = "provideraddressf7";
    public static final String OP_CHOOSEBILL = "choosebill";
    public static final String ACTION_CHOOSEBILLCLOSE = "choosebillclose";

    public void registerListener(EventObject e) {
        BasedataEdit goods;
        BasedataEdit branch;
        BasedataEdit bizType;
        BasedataEdit owner;
        super.registerListener(e);
        BasedataEdit entrySettleOrg = (BasedataEdit)this.getView().getControl("entrysettleorg");
        if (entrySettleOrg != null) {
            entrySettleOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((owner = (BasedataEdit)this.getView().getControl("owner")) != null) {
            owner.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((bizType = (BasedataEdit)this.getView().getControl("biztype")) != null) {
            bizType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((branch = (BasedataEdit)this.getView().getControl("branch")) != null) {
            branch.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((goods = (BasedataEdit)this.getView().getControl("goods")) != null) {
            goods.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (this.getControl("address") != null) {
            this.addClickListeners(new String[]{"address"});
        }
        if (this.getControl("provideraddress") != null) {
            this.addClickListeners(new String[]{"provideraddress"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map map;
        super.afterCreateNewData(e);
        this.initBranch();
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            return;
        }
        long lOrgId = DynamicObjectUtils.getPkValue((DynamicObject)org);
        Map currencyAndExRateMap = CurrencyHelper.getCurrencyAndExRateTable((Long)lOrgId);
        if (currencyAndExRateMap != null) {
            model.setValue("currency", currencyAndExRateMap.get("baseCurrencyID"));
            model.setValue("settlecurrency", currencyAndExRateMap.get("baseCurrencyID"));
            model.setValue("exchangerate", (Object)BigDecimal.ONE);
            model.setValue("exratetable", currencyAndExRateMap.get("exchangeRateTableID"));
        }
        if ((map = OrgUnitServiceHelper.getCompanyByOrg((Long)lOrgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE)) != null) {
            model.setValue("settleorg", map.get("id"));
        }
        long invOrgId = 0L;
        DynamicObject branch = (DynamicObject)this.getModel().getValue("branch");
        if (branch != null) {
            invOrgId = this.getInvOrgId(branch);
        }
        this.getModel().setItemValueByID("org", (Object)invOrgId);
        int entryCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < entryCount; ++i) {
            this.initSettleOrg(i);
            this.initOwner(i);
            model.setValue("entryinvorg", (Object)invOrgId, i);
            model.setValue("entrypurorg", (Object)lOrgId, i);
            this.initEntryValue(i);
            this.setDefaultOwnerAndKeeper(i);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        IDataModel model = this.getModel();
        int rowIndex = e.getRow();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        ArrayList<Long> supperLinkManIds = new ArrayList<Long>(0);
        DynamicObject supplier = (DynamicObject)model.getValue("supplier");
        DynamicObjectCollection supperLinkMans = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)supplier, (String)"entry_linkman");
        DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
        DynamicObject masterMaterial = material == null ? null : material.getDynamicObject("masterid");
        DynamicObject providerSupplier = (DynamicObject)model.getValue("providersupplier");
        switch (fieldKey) {
            case "entrysettleorg": {
                DynamicObject purOrg = (DynamicObject)model.getValue("purorg");
                if (purOrg == null) {
                    NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (IFormView)this.getView());
                    e.setCancel(true);
                    return;
                }
                DynamicObject entryReqOrg = (DynamicObject)model.getValue("entryreqorg", rowIndex);
                Long entryReqOrgId = null;
                if (entryReqOrg != null) {
                    entryReqOrgId = (Long)entryReqOrg.getPkValue();
                }
                QFilter settleOrgF7 = this.getSettleOrgF7(DynamicObjectUtils.getPkValue((DynamicObject)purOrg), entryReqOrgId);
                showParameter.getListFilterParameter().getQFilters().add(settleOrgF7);
                break;
            }
            case "owner": {
                String ownerType = (String)model.getValue("ownertype", rowIndex);
                if (!"bos_org".equals(ownerType)) break;
                DynamicObject purOrg2 = (DynamicObject)model.getValue("purorg");
                if (purOrg2 == null) {
                    NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (IFormView)this.getView());
                    e.setCancel(true);
                    return;
                }
                DynamicObject entryReqOrg2 = (DynamicObject)model.getValue("entryreqorg", rowIndex);
                Long entryReqOrgId2 = null;
                if (entryReqOrg2 != null) {
                    entryReqOrgId2 = DynamicObjectUtils.getPkValue((DynamicObject)entryReqOrg2);
                }
                QFilter settleOrgF72 = this.getSettleOrgF7(DynamicObjectUtils.getPkValue((DynamicObject)purOrg2), entryReqOrgId2);
                showParameter.getListFilterParameter().getQFilters().add(settleOrgF72);
                break;
            }
            case "branch": {
                this.setBranchFilter(showParameter.getListFilterParameter());
                break;
            }
            case "addressf7": {
                if (supplier == null) {
                    NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u9009\u62e9\u4f9b\u5e94\u5546\u3002", (IFormView)this.getView());
                    e.setCancel(true);
                    break;
                }
                QFilter id1 = new QFilter("supplierid", "in", (Object)supplier.getPkValue().toString());
                QFilter id2 = new QFilter("invalid", "=", (Object)Boolean.FALSE);
                showParameter.getListFilterParameter().setQFilters(Arrays.asList(id1, id2));
                break;
            }
            case "provideraddressf7": {
                if (providerSupplier == null) {
                    NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u9009\u62e9\u9001\u8d27\u65b9\u3002", (IFormView)this.getView());
                    e.setCancel(true);
                    break;
                }
                QFilter id1 = new QFilter("supplierid", "in", (Object)providerSupplier.getPkValue().toString());
                QFilter id2 = new QFilter("invalid", "=", (Object)Boolean.FALSE);
                showParameter.getListFilterParameter().setQFilters(Arrays.asList(id1, id2));
                break;
            }
            case "supplier": {
                QFilter filter = this.getBizfunctionAndHoldFilter("supplier");
                if (filter == null) break;
                showParameter.getListFilterParameter().getQFilters().add(filter);
                break;
            }
            case "providersupplier": 
            case "invoicesupplier": 
            case "receivesupplier": {
                if (supplier == null) {
                    NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u9009\u62e9\u4f9b\u5e94\u5546\u3002", (IFormView)this.getView());
                    e.setCancel(true);
                    return;
                }
                QFilter bizFuncAndHoldFilter = this.getBizfunctionAndHoldFilter(fieldKey);
                if (bizFuncAndHoldFilter == null) break;
                showParameter.getListFilterParameter().getQFilters().add(bizFuncAndHoldFilter);
                break;
            }
            case "linkman": {
                if (supplier == null || DynamicObjectUtils.getPkValue((DynamicObject)supplier) == 0L) {
                    NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u9009\u62e9\u4f9b\u5e94\u5546\u3002", (IFormView)this.getView());
                    e.setCancel(true);
                    return;
                }
                for (DynamicObject suppLinkMan : supperLinkMans) {
                    boolean invalid = DynamicObjectUtils.getBoolean((DynamicObject)suppLinkMan, (String)"invalid");
                    if (invalid) continue;
                    supperLinkManIds.add(DynamicObjectUtils.getPkValue((DynamicObject)suppLinkMan));
                }
                QFilter suppFilter = new QFilter("supplierid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)supplier));
                QFilter linkManIds = new QFilter("id", "in", supperLinkManIds);
                showParameter.getListFilterParameter().getQFilters().add(suppFilter.and(linkManIds));
                break;
            }
            case "providerlinkman": {
                if (providerSupplier == null) {
                    NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u9009\u62e9\u9001\u8d27\u65b9\u3002", (IFormView)this.getView());
                    e.setCancel(true);
                    return;
                }
                for (DynamicObject suppLinkMan : supperLinkMans) {
                    boolean invalid = DynamicObjectUtils.getBoolean((DynamicObject)suppLinkMan, (String)"invalid");
                    if (invalid) continue;
                    supperLinkManIds.add(DynamicObjectUtils.getPkValue((DynamicObject)suppLinkMan));
                }
                QFilter supFilter = new QFilter("supplierid", "=", providerSupplier.getPkValue());
                QFilter ids = new QFilter("id", "in", supperLinkManIds);
                showParameter.getListFilterParameter().getQFilters().add(supFilter.and(ids));
                break;
            }
            case "unit": {
                if (masterMaterial == null) {
                    NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u4fe1\u606f\u3002", (IFormView)this.getView());
                    e.setCancel(true);
                    break;
                }
                DynamicObject baseUnit = (DynamicObject)model.getValue("baseunit", rowIndex);
                long srcMuId = baseUnit == null ? 0L : DynamicObjectUtils.getPkValue((DynamicObject)baseUnit);
                long masterMaterialId = DynamicObjectUtils.getPkValue((DynamicObject)masterMaterial);
                List unitIds = BaseDataServiceHelper.getAssistMUListResult((Long)masterMaterialId, (Long)srcMuId, (String)"1");
                QFilter qFilter = new QFilter("id", "in", (Object)unitIds);
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
            case "taxrateid": {
                Date bizTime = (Date)model.getValue("biztime");
                QFilter activeFilter = new QFilter("activedate", "<=", (Object)bizTime);
                QFilter expFilter = new QFilter("expdate", ">", (Object)bizTime);
                expFilter = QFilter.isNull((String)"expdate").or(expFilter);
                QFilter qFilter = expFilter.and(activeFilter);
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
            case "goods": {
                this.setGoodsFilter(showParameter.getListFilterParameter());
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        String fieldKey = e.getProperty().getName();
        block45: for (ChangeData changeData : changeSet = e.getChangeSet()) {
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            int rowIndex = changeData.getRowIndex();
            if (newValue == null && oldValue == null) {
                return;
            }
            if (newValue != null && newValue.equals(oldValue)) {
                return;
            }
            if (oldValue instanceof DynamicObject && newValue instanceof DynamicObject && ((DynamicObject)oldValue).getPkValue().equals(((DynamicObject)newValue).getPkValue())) {
                return;
            }
            if (oldValue instanceof BigDecimal && newValue instanceof BigDecimal && ((BigDecimal)oldValue).compareTo((BigDecimal)newValue) == 0) {
                return;
            }
            switch (fieldKey) {
                case "entrysettleorg": {
                    this.changeEntrySettleOrg(rowIndex);
                    continue block45;
                }
                case "supplier": {
                    this.changeSupplier();
                    continue block45;
                }
                case "entryinvorg": 
                case "entryreqorg": {
                    this.changeOwner(rowIndex);
                    continue block45;
                }
                case "currency": 
                case "exratetable": 
                case "exratedate": {
                    this.changeCurOrTable();
                    continue block45;
                }
                case "settlecurrency": {
                    this.changeSettleCurrency(oldValue, newValue);
                    continue block45;
                }
                case "exchangerate": 
                case "istax": {
                    this.setPriceAndPriceAndTaxEnable();
                    this.calAllAmount();
                    continue block45;
                }
                case "goods": {
                    this.changeGoods(changeSet);
                    continue block45;
                }
                case "material": {
                    this.changeMaterial(newValue, rowIndex);
                    continue block45;
                }
                case "ispresent": {
                    this.changeIsPresent(newValue, rowIndex);
                    continue block45;
                }
                case "addressf7": {
                    DynamicObject addressF7 = (DynamicObject)changeSet[0].getNewValue();
                    this.getModel().setValue("address", (Object)addressF7.getString("detailaddress"));
                    continue block45;
                }
                case "provideraddressf7": {
                    DynamicObject providerAddressF7 = (DynamicObject)changeSet[0].getNewValue();
                    this.getModel().setValue("provideraddress", (Object)providerAddressF7.getString("detailaddress"));
                    continue block45;
                }
                case "auxqty": {
                    this.changeAuxQty(newValue, rowIndex);
                    continue block45;
                }
                case "qty": {
                    this.changeQty(newValue, rowIndex);
                    continue block45;
                }
                case "unit": {
                    this.changeUnit(newValue, rowIndex);
                    continue block45;
                }
                case "price": 
                case "taxrate": 
                case "priceandtax": {
                    this.calAmount(rowIndex);
                    continue block45;
                }
                case "taxrateid": {
                    this.changeTaxRateID(newValue, rowIndex);
                    continue block45;
                }
                case "discounttype": 
                case "discountrate": {
                    this.changeDiscountField(fieldKey, oldValue, rowIndex);
                    continue block45;
                }
            }
        }
    }

    public void click(EventObject evt) {
        BasedataEdit addressF7;
        super.click(evt);
        Control c = (Control)evt.getSource();
        if (c.getKey().equalsIgnoreCase("provideraddress")) {
            BasedataEdit providerAddressF7 = (BasedataEdit)this.getControl(PROVIDERADDRESSF7);
            if (providerAddressF7 != null) {
                providerAddressF7.click();
            }
        } else if (c.getKey().equalsIgnoreCase("address") && (addressF7 = (BasedataEdit)this.getControl(ADDRESSF7)) != null) {
            addressF7.click();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)ACTION_CHOOSEBILLCLOSE)) {
            Object returnData = e.getReturnData();
            if (ObjectUtils.isEmpty((Object)returnData)) {
                return;
            }
            if (returnData instanceof List) {
                List selRows = (List)returnData;
                this.drawConvertBill(selRows);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        if ("billentry".equals(entryName)) {
            for (RowDataEntity rowDataEntity : rowDataEntities) {
                int rowIndex = rowDataEntity.getRowIndex();
                this.initSettleOrg(rowIndex);
                this.initOwner(rowIndex);
                this.initEntryValue(rowIndex);
                this.setDefaultOwnerAndKeeper(rowIndex);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String opKey = e.getOperateKey();
        if (StringUtils.equals((CharSequence)opKey, (CharSequence)OP_CHOOSEBILL)) {
            this.showSrcBillForm();
        }
    }

    private void initSettleOrg(int rowIndex) {
        DynamicObject entrySettleOrg;
        IDataModel model = this.getModel();
        if (model.getValue("entrysettleorg", rowIndex) == null) {
            DynamicObject settleOrg = (DynamicObject)model.getValue("settleorg");
            if (settleOrg != null) {
                long entrySettleOrgId = Long.parseLong(settleOrg.getPkValue().toString());
                model.setValue("entrysettleorg", (Object)entrySettleOrgId, rowIndex);
            } else {
                model.setValue("entrysettleorg", null, rowIndex);
            }
        }
        if (model.getValue("entrypayorg", rowIndex) == null && (entrySettleOrg = (DynamicObject)model.getValue("entrysettleorg")) != null) {
            Long entryPayOrg = OrgUnitServiceHelper.getToOrg((String)"10", (String)"08", (Long)DynamicObjectUtils.getPkValue((DynamicObject)entrySettleOrg), (boolean)true);
            model.setValue("entrypayorg", (Object)entryPayOrg, rowIndex);
        }
    }

    private void initOwner(int rowIndex) {
        String ownerType;
        IDataModel model = this.getModel();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long bizType = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"biztype");
        if (bizType == 691915699186345984L) {
            model.setValue("ownertype", (Object)"bd_supplier", rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"ownertype"});
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"owner"});
        }
        if ("bd_supplier".equals(ownerType = (String)model.getValue("ownertype", rowIndex))) {
            DynamicObject supplier = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"supplier");
            model.setValue("owner", (Object)DynamicObjectUtils.getPkValue((DynamicObject)supplier), rowIndex);
        } else if ("bos_org".equals(ownerType)) {
            String owner;
            Map pageCache = this.getPageCache().getAll();
            if (pageCache != null && StringUtils.isNotBlank((CharSequence)(owner = (String)pageCache.get("owner")))) {
                model.setValue("owner", (Object)owner, rowIndex);
                return;
            }
            DynamicObject settleOrg = (DynamicObject)model.getValue("settleorg");
            DynamicObject entryReqOrg = (DynamicObject)model.getValue("entryreqorg", rowIndex);
            DynamicObject entryInvOrg = (DynamicObject)model.getValue("entryinvorg", rowIndex);
            if (entryReqOrg != null && settleOrg != null && entryInvOrg != null) {
                Long purOrgSettleOrgID = (Long)settleOrg.getPkValue();
                Long entryInvOrgID = DynamicObjectUtils.getPkValue((DynamicObject)entryInvOrg);
                Long entryReqOrgID = DynamicObjectUtils.getPkValue((DynamicObject)entryReqOrg);
                Map reqSettleMap = OrgUnitServiceHelper.getCompanyByOrg((Long)entryReqOrgID, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
                Map recSettleMap = OrgUnitServiceHelper.getCompanyByOrg((Long)entryInvOrgID, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
                if (reqSettleMap != null && reqSettleMap.get("id") != null && recSettleMap != null && recSettleMap.get("id") != null) {
                    Object reqSettleID = reqSettleMap.get("id");
                    Object recSettleID = recSettleMap.get("id");
                    if (recSettleID.equals(purOrgSettleOrgID) && !reqSettleID.equals(recSettleID)) {
                        model.setValue("owner", reqSettleID, rowIndex);
                        this.getPageCache().put("owner", reqSettleID.toString());
                    } else {
                        model.setValue("owner", (Object)purOrgSettleOrgID, rowIndex);
                        this.getPageCache().put("owner", purOrgSettleOrgID.toString());
                    }
                }
            }
        }
    }

    private void initBranch() {
        long defaultOwnerId = OwnerUtil.getDefaultOwnerId();
        this.getModel().setItemValueByID("branch", (Object)defaultOwnerId);
    }

    private void initEntryValue(int ... rows) {
        boolean initialized = this.getModel().isInitialized();
        if (rows == null || rows.length == 0) {
            return;
        }
        DynamicObject invScheme = BusinessDataServiceHelper.loadSingle((Object)688329125542283264L, (String)"im_invscheme");
        if (invScheme == null) {
            return;
        }
        boolean isInUpdate = DynamicObjectUtils.getBoolean((DynamicObject)invScheme, (String)"isinupdate");
        String ownerType = "bos_org";
        String keeperType = "bos_org";
        Object invStatusId = null;
        Object invTypeId = null;
        if (isInUpdate) {
            ownerType = DynamicObjectUtils.getString((DynamicObject)invScheme, (String)"ownertype");
            keeperType = DynamicObjectUtils.getString((DynamicObject)invScheme, (String)"keepertype");
            DynamicObject invStatus = InventoryHelper.getDefaultInvStatus((DynamicObject)invScheme);
            DynamicObject invType = InventoryHelper.getDefaultInvType((DynamicObject)invScheme);
            invStatusId = invStatus == null ? null : invStatus.getPkValue();
            invTypeId = invType == null ? null : invType.getPkValue();
        }
        for (int row : rows) {
            if (!initialized) {
                this.getModel().beginInit();
            }
            this.getModel().setValue("owner", null, row);
            this.getModel().setValue("keeper", null, row);
            this.getModel().setValue("ownertype", (Object)ownerType, row);
            this.getModel().setValue("keepertype", (Object)keeperType, row);
            this.getModel().setValue("outowner", null, row);
            this.getModel().setValue("outkeeper", null, row);
            this.getModel().setValue("outownertype", (Object)ownerType, row);
            this.getModel().setValue("outkeepertype", (Object)keeperType, row);
            this.getModel().setValue("invstatus", invStatusId, row);
            this.getModel().setValue("invtype", invTypeId, row);
            this.getModel().setValue("outinvstatus", invStatusId, row);
            this.getModel().setValue("outinvtype", invTypeId, row);
            if (initialized) continue;
            this.getModel().endInit();
            this.getView().updateView("owner", row);
            this.getView().updateView("keeper", row);
            this.getView().updateView("ownertype", row);
            this.getView().updateView("keepertype", row);
            this.getView().updateView("invstatus", row);
            this.getView().updateView("invtype", row);
            this.getView().updateView("outowner", row);
            this.getView().updateView("keeper", row);
            this.getView().updateView("outownertype", row);
            this.getView().updateView("outkeepertype", row);
            this.getView().updateView("outinvstatus", row);
            this.getView().updateView("outinvtype", row);
        }
    }

    private void setDefaultOwnerAndKeeper(int row) {
        boolean initialized = this.getModel().isInitialized();
        if (!initialized) {
            this.getModel().beginInit();
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"org");
        DynamicObject entryEntity = this.getModel().getEntryRowEntity("billentry", row);
        String outKeeperType = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"outkeepertype");
        Long defaultOutKeeperId = null;
        if (!StringUtils.isEmpty((CharSequence)outKeeperType)) {
            defaultOutKeeperId = InventoryHelper.getDefaultOutKeeper((String)outKeeperType, (long)orgId, (long)0L);
        }
        this.getModel().setValue("outkeeper", (Object)defaultOutKeeperId, row);
        String outOwnerType = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"outkeepertype");
        Long defaultOutOwnerId = null;
        if (!StringUtils.isEmpty((CharSequence)outOwnerType)) {
            defaultOutOwnerId = InventoryHelper.getDefaultOutOwner((String)outOwnerType, (long)orgId, (long)0L);
        }
        this.getModel().setValue("outowner", (Object)defaultOutOwnerId, row);
        String keeperType = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"keepertype");
        Long defaultKeeperId = null;
        if (!StringUtils.isEmpty((CharSequence)keeperType)) {
            defaultKeeperId = InventoryHelper.getDefaultKeeper((String)keeperType, (long)orgId, (long)0L);
        }
        this.getModel().setValue("keeper", (Object)defaultKeeperId, row);
        String ownerType = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"ownertype");
        Long defaultOwnerId = null;
        if (!StringUtils.isEmpty((CharSequence)ownerType)) {
            defaultOwnerId = InventoryHelper.getDefaultOwner((String)ownerType, (long)orgId, (long)0L);
        }
        this.getModel().setValue("owner", (Object)defaultOwnerId, row);
        if (!initialized) {
            this.getModel().endInit();
            this.getView().updateView("outkeeper", row);
            this.getView().updateView("outowner", row);
            this.getView().updateView("keeper", row);
            this.getView().updateView("owner", row);
        }
    }

    private void showSrcBillForm() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"org");
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"billtype");
        HashMap<String, Object> customParams = new HashMap<String, Object>(0);
        customParams.put("billtypeid", billTypeId);
        customParams.put("orgid", orgId);
        customParams.put("formid", "ocpos_store_receive");
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"\u9009\u62e9\u6e90\u5355", (String)"ocpos_store_selpurchase", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        parameter.setShowTitle(true);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_CHOOSEBILLCLOSE));
        this.getView().showForm(parameter);
    }

    private void changeEntrySettleOrg(int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObject entrySettleOrg = (DynamicObject)model.getValue("entrysettleorg");
        Long entrySettleOrgId = DynamicObjectUtils.getPkValue((DynamicObject)entrySettleOrg);
        if (entrySettleOrgId > 0L) {
            Long entryPayOrg = OrgUnitServiceHelper.getToOrg((String)"10", (String)"08", (Long)entrySettleOrgId, (boolean)true);
            model.setValue("entrypayorg", (Object)entryPayOrg, rowIndex);
        } else {
            model.setValue("entrypayorg", null, rowIndex);
        }
        String ownerType = (String)model.getValue("ownertype");
        if ("bos_org".equals(ownerType)) {
            model.setValue("owner", (Object)entrySettleOrgId, rowIndex);
        }
    }

    private void changeSupplier() {
        IDataModel model = this.getModel();
        String ownerType = (String)model.getValue("ownertype");
        if ("bd_supplier".equals(ownerType)) {
            DynamicObject supplier = (DynamicObject)model.getValue("supplier");
            long supplierId = DynamicObjectUtils.getPkValue((DynamicObject)supplier);
            int entryRowCount = model.getEntryRowCount("billentry");
            for (int i = 0; i < entryRowCount; ++i) {
                model.setValue("owner", (Object)supplierId, i);
            }
        }
    }

    private void changeOwner(int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObject settleOrg = (DynamicObject)model.getValue("settleorg");
        DynamicObject entryReqOrg = (DynamicObject)model.getValue("entryreqorg", rowIndex);
        DynamicObject entryInvOrg = (DynamicObject)model.getValue("entryinvorg", rowIndex);
        if (settleOrg != null && entryReqOrg != null) {
            Long purOrgSettleOrgID = DynamicObjectUtils.getPkValue((DynamicObject)settleOrg);
            Long entryInvOrgID = DynamicObjectUtils.getPkValue((DynamicObject)entryInvOrg);
            Long entryReqOrgID = DynamicObjectUtils.getPkValue((DynamicObject)entryReqOrg);
            Map reqSettleMap = OrgUnitServiceHelper.getCompanyByOrg((Long)entryInvOrgID, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
            Map recSettleMap = OrgUnitServiceHelper.getCompanyByOrg((Long)entryReqOrgID, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
            if (reqSettleMap != null && reqSettleMap.get("id") != null && recSettleMap != null && recSettleMap.get("id") != null) {
                Object reqSettleID = reqSettleMap.get("id");
                Object recSettleID = recSettleMap.get("id");
                if (reqSettleID.equals(purOrgSettleOrgID) && !reqSettleID.equals(recSettleID)) {
                    model.setValue("owner", reqSettleID, rowIndex);
                    return;
                }
            }
            model.setValue("owner", (Object)DynamicObjectUtils.getPkValue((DynamicObject)settleOrg), rowIndex);
        }
    }

    private void changeIsPresent(Object newValue, int rowIndex) {
        boolean isPresent;
        if (newValue instanceof Boolean && (isPresent = ((Boolean)newValue).booleanValue())) {
            IDataModel model = this.getModel();
            BigDecimal oldTotalAmount = (BigDecimal)model.getValue("totalamount");
            BigDecimal oldTotalTaxAmount = (BigDecimal)model.getValue("totaltaxamount");
            BigDecimal oldTotalAmountAndTax = (BigDecimal)model.getValue("totalallamount");
            BigDecimal amount = (BigDecimal)model.getValue("amount", rowIndex);
            BigDecimal taxAmount = (BigDecimal)model.getValue("taxamount", rowIndex);
            BigDecimal amountAndTax = (BigDecimal)model.getValue("amountandtax", rowIndex);
            model.beginInit();
            model.setValue("price", (Object)BigDecimal.ZERO, rowIndex);
            model.setValue("priceandtax", (Object)BigDecimal.ZERO, rowIndex);
            model.setValue("taxrate", (Object)BigDecimal.ZERO, rowIndex);
            model.setValue("taxrateid", null, rowIndex);
            model.setValue("discountrate", (Object)BigDecimal.ZERO, rowIndex);
            model.setValue("amount", (Object)BigDecimal.ZERO, rowIndex);
            model.setValue("taxamount", (Object)BigDecimal.ZERO, rowIndex);
            model.setValue("discountamount", (Object)BigDecimal.ZERO, rowIndex);
            model.setValue("amountandtax", (Object)BigDecimal.ZERO, rowIndex);
            model.setValue("curamount", (Object)BigDecimal.ZERO, rowIndex);
            model.setValue("curtaxamount", (Object)BigDecimal.ZERO, rowIndex);
            model.setValue("curamountandtax", (Object)BigDecimal.ZERO, rowIndex);
            model.setValue("discounttype", (Object)"NULL", rowIndex);
            model.endInit();
            IFormView view = this.getView();
            view.updateView("price", rowIndex);
            view.updateView("priceandtax", rowIndex);
            view.updateView("taxrate", rowIndex);
            view.updateView("taxrateid", rowIndex);
            view.updateView("discountrate", rowIndex);
            view.updateView("amount", rowIndex);
            view.updateView("taxamount", rowIndex);
            view.updateView("discountamount", rowIndex);
            view.updateView("amountandtax", rowIndex);
            view.updateView("curamount", rowIndex);
            view.updateView("curtaxamount", rowIndex);
            view.updateView("curamountandtax", rowIndex);
            view.updateView("discounttype", rowIndex);
            model.setValue("totalamount", (Object)oldTotalAmount.subtract(amount));
            model.setValue("totaltaxamount", (Object)oldTotalTaxAmount.subtract(taxAmount));
            model.setValue("totalallamount", (Object)oldTotalAmountAndTax.subtract(amountAndTax));
        }
    }

    private void changeGoods(ChangeData[] changeSet) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"billentry");
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            return;
        }
        DynamicObject classStdApply = PosItemUtil.getClassStandardApply();
        for (ChangeData changeData : changeSet) {
            if (CommonUtil.checkChanged((ChangeData)changeData)) {
                return;
            }
            DynamicObject goods = (DynamicObject)changeData.getNewValue();
            if (goods == null) continue;
            DynamicObject goodsClass = PosItemUtil.queryItemClass((DynamicObject)classStdApply, (DynamicObject)goods);
            int rowIndex = changeData.getRowIndex();
            ((DynamicObject)entryEntities.get(rowIndex)).set("goodsclass", (Object)goodsClass);
        }
        this.getView().updateView("billentry");
    }

    private void changeMaterial(Object newValue, int rowIndex) {
        DynamicObject material;
        IDataModel model = this.getModel();
        model.setValue("materialmasterid", null, rowIndex);
        model.setValue("materialversion", null, rowIndex);
        model.setValue("auxpty", null, rowIndex);
        model.setValue("unit", null, rowIndex);
        model.setValue("auxunit", null, rowIndex);
        model.setValue("baseunit", null, rowIndex);
        model.setValue("qty", (Object)BigDecimal.ZERO, rowIndex);
        model.setValue("auxqty", (Object)BigDecimal.ZERO, rowIndex);
        model.setValue("baseqty", (Object)BigDecimal.ZERO, rowIndex);
        model.setValue("price", (Object)BigDecimal.ZERO, rowIndex);
        model.setValue("priceandtax", (Object)BigDecimal.ZERO, rowIndex);
        model.setValue("taxrateid", null, rowIndex);
        model.setValue("taxrate", (Object)BigDecimal.ZERO, rowIndex);
        model.setValue("discounttype", (Object)"NULL", rowIndex);
        model.setValue("discountrate", (Object)BigDecimal.ZERO, rowIndex);
        model.setValue("discountamount", (Object)BigDecimal.ZERO, rowIndex);
        model.setValue("amount", (Object)BigDecimal.ZERO, rowIndex);
        model.setValue("taxamount", (Object)BigDecimal.ZERO, rowIndex);
        model.setValue("amountandtax", (Object)BigDecimal.ZERO, rowIndex);
        model.setValue("curamount", (Object)BigDecimal.ZERO, rowIndex);
        model.setValue("curtaxamount", (Object)BigDecimal.ZERO, rowIndex);
        model.setValue("curamountandtax", (Object)BigDecimal.ZERO, rowIndex);
        DynamicObject dynamicObject = material = newValue instanceof DynamicObject ? (DynamicObject)newValue : null;
        if (material != null) {
            DynamicObject supplier;
            DynamicObject defaultTaxRate;
            DynamicObject purchaseUnit;
            DynamicObject master = DynamicObjectUtils.getDynamicObject((DynamicObject)material, (String)"masterid");
            if (master != null) {
                DynamicObject baseUnit;
                model.setValue("materialmasterid", master.getPkValue(), rowIndex);
                DynamicObject auxPtyUnit = DynamicObjectUtils.getDynamicObject((DynamicObject)master, (String)"auxptyunit");
                if (auxPtyUnit != null) {
                    model.setValue("auxunit", (Object)DynamicObjectUtils.getPkValue((DynamicObject)auxPtyUnit), rowIndex);
                }
                if ((baseUnit = DynamicObjectUtils.getDynamicObject((DynamicObject)master, (String)"baseunit")) != null) {
                    model.setValue("baseunit", (Object)DynamicObjectUtils.getPkValue((DynamicObject)baseUnit), rowIndex);
                }
            }
            if ((purchaseUnit = DynamicObjectUtils.getDynamicObject((DynamicObject)material, (String)"purchaseunit")) != null) {
                model.setValue("unit", (Object)DynamicObjectUtils.getPkValue((DynamicObject)purchaseUnit), rowIndex);
            }
            if ((defaultTaxRate = this.getDefaultTaxRate(supplier = (DynamicObject)model.getValue("supplier"), master)) != null) {
                model.setValue("taxrateid", defaultTaxRate.getPkValue(), rowIndex);
                model.setValue("taxrate", (Object)DynamicObjectUtils.getBigDecimal((DynamicObject)defaultTaxRate, (String)"taxrate"), rowIndex);
            }
        } else {
            model.setValue("taxrateid", null, rowIndex);
            model.setValue("taxrate", null, rowIndex);
        }
    }

    private void changeCurOrTable() {
        IDataModel model = this.getModel();
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        DynamicObject settleCurrency = (DynamicObject)model.getValue("settlecurrency");
        DynamicObject exRateTable = (DynamicObject)model.getValue("exratetable");
        Date bizTime = (Date)model.getValue("exratedate");
        if (currency != null && settleCurrency != null && exRateTable != null && bizTime != null) {
            model.setValue("exchangerate", (Object)CurrencyHelper.getExChangeRate((Long)DynamicObjectUtils.getPkValue((DynamicObject)settleCurrency), (Long)DynamicObjectUtils.getPkValue((DynamicObject)currency), (Long)DynamicObjectUtils.getPkValue((DynamicObject)exRateTable), (Date)bizTime));
        } else {
            model.setValue("exchangerate", null);
        }
    }

    private void setPriceAndPriceAndTaxEnable() {
        boolean isTax = (Boolean)this.getModel().getValue("istax");
        if (isTax) {
            this.getView().setEnable(Boolean.TRUE, -1, new String[]{"priceandtax"});
            this.getView().setEnable(Boolean.FALSE, -1, new String[]{"price"});
        } else {
            this.getView().setEnable(Boolean.TRUE, -1, new String[]{"price"});
            this.getView().setEnable(Boolean.FALSE, -1, new String[]{"priceandtax"});
        }
    }

    private void changeSettleCurrency(Object oldValue, Object newValue) {
        this.changeCurOrTable();
        this.getView().updateView("exchangerate");
        if (oldValue instanceof DynamicObject && newValue instanceof DynamicObject) {
            DynamicObject oldSettleCurrency = (DynamicObject)oldValue;
            DynamicObject newSettleCurrency = (DynamicObject)newValue;
            String CUR_PRICEPRECISION = "priceprecision";
            if (oldSettleCurrency.getInt(CUR_PRICEPRECISION) == newSettleCurrency.getInt(CUR_PRICEPRECISION) && oldSettleCurrency.getInt(CUR_AMTPRECISION) == newSettleCurrency.getInt(CUR_AMTPRECISION)) {
                return;
            }
        }
        this.calAllAmount();
    }

    private void calAllAmount() {
        IDataModel model = this.getModel();
        boolean isTax = (Boolean)model.getValue("istax");
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        int currencyAmtPrecision = currency == null ? 10 : currency.getInt(CUR_AMTPRECISION);
        DynamicObject settleCurrency = (DynamicObject)model.getValue("settlecurrency");
        int settleAmtPrecision = settleCurrency == null ? 10 : settleCurrency.getInt(CUR_AMTPRECISION);
        BigDecimal exChangeRate = (BigDecimal)model.getValue("exchangerate");
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalTaxAmount = BigDecimal.ZERO;
        BigDecimal totalAmountAndTax = BigDecimal.ZERO;
        DynamicObjectCollection entrys = model.getDataEntity(true).getDynamicObjectCollection("billentry");
        if (entrys != null && !entrys.isEmpty()) {
            DataEntityPropertyCollection properties = ((DynamicObject)entrys.get(0)).getDynamicObjectType().getProperties();
            DynamicProperty qtyP = (DynamicProperty)properties.get((Object)"qty");
            DynamicProperty priceP = (DynamicProperty)properties.get((Object)"price");
            DynamicProperty priceAndTaxP = (DynamicProperty)properties.get((Object)"priceandtax");
            DynamicProperty taxRateP = (DynamicProperty)properties.get((Object)"taxrate");
            DynamicProperty discountTypeP = (DynamicProperty)properties.get((Object)"discounttype");
            DynamicProperty discountRateP = (DynamicProperty)properties.get((Object)"discountrate");
            DynamicProperty amountP = (DynamicProperty)properties.get((Object)"amount");
            DynamicProperty discountAmountP = (DynamicProperty)properties.get((Object)"discountamount");
            DynamicProperty taxAmountP = (DynamicProperty)properties.get((Object)"taxamount");
            DynamicProperty amountAndTaxP = (DynamicProperty)properties.get((Object)"amountandtax");
            DynamicProperty curAmountP = (DynamicProperty)properties.get((Object)"curamount");
            DynamicProperty curTaxAmountP = (DynamicProperty)properties.get((Object)"curtaxamount");
            DynamicProperty curAmountAndTaxP = (DynamicProperty)properties.get((Object)"curamountandtax");
            model.beginInit();
            for (DynamicObject entry : entrys) {
                BigDecimal qty = (BigDecimal)qtyP.getValueFast((Object)entry);
                BigDecimal price = (BigDecimal)priceP.getValueFast((Object)entry);
                BigDecimal priceAndTax = (BigDecimal)priceAndTaxP.getValueFast((Object)entry);
                BigDecimal taxRate = (BigDecimal)taxRateP.getValueFast((Object)entry);
                String discountType = (String)discountTypeP.getValueFast((Object)entry);
                BigDecimal discountRate = (BigDecimal)discountRateP.getValueFast((Object)entry);
                AmountInfo amountInfo = new AmountInfo();
                amountInfo.setTax(isTax);
                amountInfo.setQty(qty);
                amountInfo.setPrice(price);
                amountInfo.setPriceAndTax(priceAndTax);
                amountInfo.setTaxRate(taxRate);
                amountInfo.setDiscountType(discountType);
                amountInfo.setDiscountRate(discountRate);
                amountInfo.setExChangeRate(exChangeRate);
                amountInfo.setSettleAmtPrecision(settleAmtPrecision);
                amountInfo.setCurrencyAmtPrecision(currencyAmtPrecision);
                AmountHelper.getAmount((AmountInfo)amountInfo);
                if (isTax) {
                    priceP.setValueFast((Object)entry, (Object)amountInfo.getPrice());
                } else {
                    priceAndTaxP.setValueFast((Object)entry, (Object)amountInfo.getPriceAndTax());
                }
                amountP.setValueFast((Object)entry, (Object)amountInfo.getAmount());
                discountAmountP.setValueFast((Object)entry, (Object)amountInfo.getDiscountAmount());
                taxAmountP.setValueFast((Object)entry, (Object)amountInfo.getTaxAmount());
                amountAndTaxP.setValueFast((Object)entry, (Object)amountInfo.getAmountAndTax());
                curAmountP.setValueFast((Object)entry, (Object)amountInfo.getCurAmount());
                curTaxAmountP.setValueFast((Object)entry, (Object)amountInfo.getCurTaxAmount());
                curAmountAndTaxP.setValueFast((Object)entry, (Object)amountInfo.getCurAmountAndTax());
            }
            model.endInit();
            this.getView().updateView("billentry");
            model.setValue("totalamount", (Object)totalAmount);
            model.setValue("totaltaxamount", (Object)totalTaxAmount);
            model.setValue("totalallamount", (Object)totalAmountAndTax);
        }
    }

    private QFilter getSettleOrgF7(Long orgId, Long reqOrgId) {
        QFilter qFilter1 = null;
        Long purSettleOrgId = this.getSettleOrgByOrg(orgId);
        if (purSettleOrgId != null) {
            qFilter1 = new QFilter("id", "=", (Object)purSettleOrgId);
        }
        QFilter qFilter2 = null;
        Long reqSettleOrgId = this.getSettleOrgByOrg(reqOrgId);
        if (reqSettleOrgId != null) {
            qFilter2 = new QFilter("id", "=", (Object)reqSettleOrgId);
        }
        if (qFilter1 == null) {
            return qFilter2;
        }
        if (qFilter2 == null) {
            return qFilter1;
        }
        return qFilter1.or(qFilter2);
    }

    private Long getSettleOrgByOrg(Long orgId) {
        if (orgId != null) {
            String settleOrgValue = this.getPageCache().get(orgId + "settleorg");
            if (StringUtils.isBlank((CharSequence)settleOrgValue)) {
                Map map = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
                if (map != null && map.get("id") != null) {
                    Long settleOrgId = (Long)map.get("id");
                    this.getPageCache().put(orgId + "settleorg", settleOrgId.toString());
                    return settleOrgId;
                }
            } else {
                return Long.valueOf(settleOrgValue);
            }
        }
        return null;
    }

    private long getInvOrgId(DynamicObject branch) {
        long saleOrgId = DynamicObjectUtils.getPkValue((DynamicObject)branch, (String)"saleorg");
        return InventoryUtils.getDefaultInvOrgId((long)saleOrgId);
    }

    private void setBranchFilter(ListFilterParameter filterParameter) {
        QFilter filter = F7Util.getBranchIdFilter();
        filterParameter.setFilter(filter);
    }

    private DynamicObject getDefaultTaxRate(DynamicObject supplier, DynamicObject master) {
        DynamicObject taxRate = null;
        if (master != null && master.getDynamicObject("taxrate") != null) {
            taxRate = master.getDynamicObject("taxrate");
        }
        if (taxRate == null && supplier != null) {
            taxRate = supplier.getDynamicObject("taxrate");
        }
        if (taxRate != null) {
            Long taxRateId = (Long)taxRate.getPkValue();
            taxRate = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_taxrate", (String)"id, taxrate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taxRateId)});
        }
        return taxRate;
    }

    private QFilter getBizfunctionAndHoldFilter(String fieldKey) {
        switch (fieldKey) {
            case "providersupplier": 
            case "supplier": {
                QFilter purchasehold = new QFilter("purchasehold", "=", (Object)Boolean.FALSE);
                QFilter bizfunction = QFilter.like((String)"bizfunction", (String)"1");
                return purchasehold.and(bizfunction);
            }
            case "invoicesupplier": {
                QFilter invoicehold = new QFilter("invoicehold", "=", (Object)Boolean.FALSE);
                QFilter bizfunction = QFilter.like((String)"bizfunction", (String)"2");
                return invoicehold.and(bizfunction);
            }
            case "receivesupplier": {
                QFilter payhold = new QFilter("payhold", "=", (Object)Boolean.FALSE);
                QFilter bizfunction = QFilter.like((String)"bizfunction", (String)"3");
                return payhold.and(bizfunction);
            }
        }
        return null;
    }

    private void changeAuxQty(Object newValue, int rowIndex) {
        if (newValue instanceof BigDecimal) {
            IDataModel model = this.getModel();
            BigDecimal auxQty = (BigDecimal)newValue;
            DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
            DynamicObject auxUnit = (DynamicObject)model.getValue("auxunit", rowIndex);
            if (material == null || auxUnit == null) {
                return;
            }
            DynamicObject master = material.getDynamicObject("masterid");
            DynamicObject baseUnit = (DynamicObject)model.getValue("baseqty", rowIndex);
            DynamicObject unit = (DynamicObject)model.getValue("unit", rowIndex);
            if (baseUnit == null && master != null && (baseUnit = master.getDynamicObject("baseunit")) != null) {
                model.setValue("baseunit", (Object)DynamicObjectUtils.getPkValue((DynamicObject)baseUnit), rowIndex);
            }
            if (baseUnit != null && unit != null && master != null) {
                Long masterId = (Long)master.getPkValue();
                String unitConvertDir = master.getString("unitconvertdir");
                if ("B".equals(unitConvertDir) || "C".equals(unitConvertDir)) {
                    BigDecimal baseQty = this.getDesQtyConv(masterId, DynamicObjectUtils.getPkValue((DynamicObject)auxUnit), auxQty, baseUnit);
                    BigDecimal qty = this.getDesQtyConv(masterId, DynamicObjectUtils.getPkValue((DynamicObject)baseUnit), baseQty, unit);
                    model.beginInit();
                    model.setValue("baseqty", (Object)baseQty, rowIndex);
                    model.setValue("qty", (Object)qty, rowIndex);
                    model.endInit();
                    this.getView().updateView("baseqty", rowIndex);
                    this.getView().updateView("qty", rowIndex);
                    this.calAmount(rowIndex);
                }
            }
        }
    }

    private void changeUnit(Object newValue, int rowIndex) {
        if (newValue instanceof DynamicObject) {
            DynamicObject unit = (DynamicObject)newValue;
            IDataModel model = this.getModel();
            DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
            BigDecimal qty = (BigDecimal)model.getValue("qty", rowIndex);
            int precision = this.getPrecision(unit);
            int precisionAccount = this.getPrecisionType(unit);
            qty = qty.setScale(precision, precisionAccount);
            model.beginInit();
            model.setValue("qty", (Object)qty, rowIndex);
            model.endInit();
            if (material != null && qty != null && qty.compareTo(BigDecimal.ZERO) != 0) {
                DynamicObject master = material.getDynamicObject("masterid");
                DynamicObject baseUnit = (DynamicObject)model.getValue("baseunit", rowIndex);
                DynamicObject auxUnit = (DynamicObject)model.getValue("auxunit", rowIndex);
                model.beginInit();
                if (baseUnit == null && master != null && (baseUnit = master.getDynamicObject("baseunit")) != null) {
                    model.setValue("baseunit", baseUnit.getPkValue(), rowIndex);
                }
                if (baseUnit != null && master != null) {
                    String unitConvertDir;
                    Long masterId = (Long)master.getPkValue();
                    BigDecimal baseQty = this.getDesQtyConv(masterId, DynamicObjectUtils.getPkValue((DynamicObject)unit), qty, baseUnit);
                    model.setValue("baseqty", (Object)baseQty, rowIndex);
                    if (auxUnit != null && ("A".equals(unitConvertDir = master.getString("unitconvertdir")) || "C".equals(unitConvertDir))) {
                        BigDecimal auxQty = this.getDesQtyConv(masterId, DynamicObjectUtils.getPkValue((DynamicObject)baseUnit), baseQty, auxUnit);
                        model.setValue("auxqty", (Object)auxQty, rowIndex);
                    }
                }
                model.endInit();
                this.getView().updateView("baseunit", rowIndex);
                this.getView().updateView("baseqty", rowIndex);
                this.getView().updateView("auxqty", rowIndex);
                this.getView().updateView("qty", rowIndex);
            }
        }
    }

    private void changeTaxRateID(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        if (newValue instanceof DynamicObject) {
            DynamicObject taxRate = (DynamicObject)newValue;
            model.setValue("taxrate", (Object)DynamicObjectUtils.getBigDecimal((DynamicObject)taxRate, (String)"taxrate"), rowIndex);
        } else {
            model.setValue("taxrate", (Object)BigDecimal.ZERO, rowIndex);
        }
    }

    private BigDecimal getDesQtyConv(Long materialId, Long srcUnit, BigDecimal srcQty, DynamicObject desUnit) {
        BigDecimal desQty = BigDecimal.ZERO;
        if (materialId != null && srcUnit != null && desUnit != null && srcQty != null && srcQty.compareTo(BigDecimal.ZERO) != 0) {
            Long desUnitID = DynamicObjectUtils.getPkValue((DynamicObject)desUnit);
            if (srcUnit.equals(desUnitID)) {
                desQty = srcQty;
            } else {
                DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnit, (Long)desUnitID);
                if (muConv != null) {
                    int numberator = muConv.getInt("numerator");
                    int denominator = muConv.getInt("denominator");
                    if (denominator != 0) {
                        desQty = srcQty.multiply(new BigDecimal(numberator)).divide(new BigDecimal(denominator), this.getPrecision(desUnit), this.getPrecisionType(desUnit));
                    }
                }
            }
        }
        return desQty;
    }

    private int getPrecision(DynamicObject unit) {
        int precision = 10;
        if (unit != null) {
            precision = unit.getInt("precision");
        }
        return precision;
    }

    private int getPrecisionType(DynamicObject unit) {
        int precisionType = 4;
        if (unit != null && StringUtils.isNotBlank((Object)unit.get("precisionaccount"))) {
            int precisionAccount = unit.getInt("precisionaccount");
            switch (precisionAccount) {
                case 1: {
                    precisionType = 4;
                    break;
                }
                case 2: {
                    precisionType = 1;
                    break;
                }
                case 3: {
                    precisionType = 0;
                    break;
                }
            }
        }
        return precisionType;
    }

    private void calAmount(int rowIndex) {
        IDataModel model = this.getModel();
        boolean isTax = (Boolean)model.getValue("istax");
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        int currencyAmtPrecision = currency == null ? 10 : currency.getInt(CUR_AMTPRECISION);
        DynamicObject settleCurrency = (DynamicObject)model.getValue("settlecurrency");
        int settleAmtPrecision = settleCurrency == null ? 10 : settleCurrency.getInt(CUR_AMTPRECISION);
        BigDecimal exChangeRate = (BigDecimal)model.getValue("exchangerate");
        BigDecimal qty = (BigDecimal)model.getValue("qty", rowIndex);
        BigDecimal price = (BigDecimal)model.getValue("price", rowIndex);
        BigDecimal priceAndTax = (BigDecimal)model.getValue("priceandtax", rowIndex);
        BigDecimal taxRate = (BigDecimal)model.getValue("taxrate", rowIndex);
        String discountType = (String)model.getValue("discounttype", rowIndex);
        BigDecimal discountRate = (BigDecimal)model.getValue("discountrate", rowIndex);
        AmountInfo amountInfo = new AmountInfo();
        amountInfo.setTax(isTax);
        amountInfo.setQty(qty);
        amountInfo.setPrice(price);
        amountInfo.setPriceAndTax(priceAndTax);
        amountInfo.setTaxRate(taxRate);
        amountInfo.setDiscountType(discountType);
        amountInfo.setDiscountRate(discountRate);
        amountInfo.setExChangeRate(exChangeRate);
        amountInfo.setSettleAmtPrecision(settleAmtPrecision);
        amountInfo.setCurrencyAmtPrecision(currencyAmtPrecision);
        AmountHelper.getAmount((AmountInfo)amountInfo);
        model.beginInit();
        if (isTax) {
            model.setValue("price", (Object)amountInfo.getPrice(), rowIndex);
        } else {
            model.setValue("priceandtax", (Object)amountInfo.getPriceAndTax(), rowIndex);
        }
        BigDecimal oldAmount = (BigDecimal)model.getValue("amount", rowIndex);
        BigDecimal oldTaxAmount = (BigDecimal)model.getValue("taxamount", rowIndex);
        BigDecimal oldAmountAndTax = (BigDecimal)model.getValue("amountandtax", rowIndex);
        BigDecimal amount = amountInfo.getAmount();
        BigDecimal taxAmount = amountInfo.getTaxAmount();
        BigDecimal amountAndTax = amountInfo.getAmountAndTax();
        model.setValue("amount", (Object)amount, rowIndex);
        model.setValue("taxamount", (Object)taxAmount, rowIndex);
        model.setValue("amountandtax", (Object)amountAndTax, rowIndex);
        model.setValue("discountamount", (Object)amountInfo.getDiscountAmount(), rowIndex);
        model.setValue("curamount", (Object)amountInfo.getCurAmount(), rowIndex);
        model.setValue("curtaxamount", (Object)amountInfo.getCurTaxAmount(), rowIndex);
        model.setValue("curamountandtax", (Object)amountInfo.getCurAmountAndTax(), rowIndex);
        model.endInit();
        this.updateEntryAmountField(rowIndex);
        BigDecimal totalAmount = (BigDecimal)model.getValue("totalamount");
        BigDecimal totalTaxAmount = (BigDecimal)model.getValue("totaltaxamount");
        BigDecimal totalAllAmount = (BigDecimal)model.getValue("totalallamount");
        totalAmount = totalAmount.subtract(oldAmount).add(amount);
        totalTaxAmount = totalTaxAmount.subtract(oldTaxAmount).add(taxAmount);
        totalAllAmount = totalAllAmount.subtract(oldAmountAndTax).add(amountAndTax);
        model.setValue("totalamount", (Object)totalAmount);
        model.setValue("totaltaxamount", (Object)totalTaxAmount);
        model.setValue("totalallamount", (Object)totalAllAmount);
    }

    private void changeQty(Object newValue, int rowIndex) {
        if (newValue instanceof BigDecimal) {
            IDataModel model = this.getModel();
            BigDecimal qty = (BigDecimal)newValue;
            DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
            DynamicObject unit = (DynamicObject)model.getValue("unit", rowIndex);
            if (material == null || unit == null) {
                return;
            }
            DynamicObject master = material.getDynamicObject("masterid");
            DynamicObject baseUnit = (DynamicObject)model.getValue("baseunit", rowIndex);
            DynamicObject auxUnit = (DynamicObject)model.getValue("auxunit", rowIndex);
            model.beginInit();
            if (baseUnit == null && master != null && (baseUnit = master.getDynamicObject("baseunit")) != null) {
                model.setValue("baseunit", (Object)DynamicObjectUtils.getPkValue((DynamicObject)baseUnit), rowIndex);
            }
            if (baseUnit != null && master != null) {
                String unitConvertDir;
                long masterId = DynamicObjectUtils.getPkValue((DynamicObject)master);
                BigDecimal baseQty = this.getDesQtyConv(masterId, DynamicObjectUtils.getPkValue((DynamicObject)unit), qty, baseUnit);
                model.setValue("baseqty", (Object)baseQty, rowIndex);
                if (auxUnit != null && ("A".equals(unitConvertDir = master.getString("unitconvertdir")) || "C".equals(unitConvertDir))) {
                    BigDecimal auxQty = this.getDesQtyConv(masterId, DynamicObjectUtils.getPkValue((DynamicObject)baseUnit), baseQty, auxUnit);
                    model.setValue("auxqty", (Object)auxQty, rowIndex);
                }
            }
            model.endInit();
            this.getView().updateView("baseunit", rowIndex);
            this.getView().updateView("baseqty", rowIndex);
            this.getView().updateView("auxqty", rowIndex);
            this.calAmount(rowIndex);
        }
    }

    private void setGoodsFilter(ListFilterParameter filterParameter) {
        QFilter qFilter = new QFilter("masterid.status", "=", (Object)StatusEnum.AUDIT.getValue());
        qFilter.and("masterid.enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        qFilter.and(F7Utils.getCommonStatusFilter());
        DynamicObjectCollection materialInv = QueryServiceHelper.query((String)"bd_materialpurchaseinfo", (String)"id", (QFilter[])qFilter.toArray());
        QFilter filter = new QFilter("material", "in", materialInv.stream().map(x -> x.get("id")).collect(Collectors.toList()));
        filterParameter.setFilter(filter);
    }

    private void changeDiscountField(String fieldName, Object oldValue, int rowIndex) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String discountType = (String)model.getValue("discounttype", rowIndex);
        BigDecimal discountRate = (BigDecimal)model.getValue("discountrate", rowIndex);
        if (discountRate != null && "A".equals(discountType)) {
            view.setEnable(Boolean.TRUE, rowIndex, new String[]{"discountrate"});
            if (discountRate.compareTo(new BigDecimal(100)) > 0 || discountRate.compareTo(BigDecimal.ZERO) < 0) {
                model.beginInit();
                model.setValue(fieldName, oldValue, rowIndex);
                model.endInit();
                view.updateView(fieldName, rowIndex);
                NotificationUtil.showDefaultTipNotify((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u6298\u6263\u7387\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u503c\u8303\u56f4\u4e3a[0,100]\u3002", (IFormView)this.getView());
                return;
            }
        } else if (discountRate != null && "B".equals(discountType)) {
            view.setEnable(Boolean.TRUE, rowIndex, new String[]{"discountrate"});
            BigDecimal priceAndTax = (BigDecimal)model.getValue("priceandtax", rowIndex);
            if (discountRate.compareTo(priceAndTax) > 0) {
                model.beginInit();
                model.setValue(fieldName, oldValue, rowIndex);
                model.endInit();
                view.updateView(fieldName, rowIndex);
                NotificationUtil.showDefaultTipNotify((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u5355\u4f4d\u6298\u6263\u989d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (IFormView)this.getView());
                return;
            }
        } else {
            view.setEnable(Boolean.FALSE, rowIndex, new String[]{"discountrate"});
            model.beginInit();
            model.setValue("discountrate", null, rowIndex);
            model.endInit();
            view.updateView("discountrate", rowIndex);
        }
        this.calAmount(rowIndex);
    }

    private void updateEntryAmountField(int rowIndex) {
        IFormView view = this.getView();
        view.updateView("price", rowIndex);
        view.updateView("priceandtax", rowIndex);
        view.updateView("amount", rowIndex);
        view.updateView("taxamount", rowIndex);
        view.updateView("discountamount", rowIndex);
        view.updateView("amountandtax", rowIndex);
        view.updateView("curamount", rowIndex);
        view.updateView("curtaxamount", rowIndex);
        view.updateView("curamountandtax", rowIndex);
    }

    private void drawConvertBill(List<DynamicObject> selRows) {
        if (selRows == null || selRows.size() == 0) {
            NotificationUtil.showDefaultTipNotify((String)"\u672a\u9009\u62e9\u4efb\u4f55\u6e90\u5355\u6570\u636e\u3002", (IFormView)this.getView());
            return;
        }
        String sourceEntity = "ocpos_store_receive";
        String targetEntity = "ocpos_store_purrefapply";
        String entryEntity = "billentry";
        try {
            ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(0);
            for (DynamicObject row : selRows) {
                ListSelectedRow selectedRow = new ListSelectedRow((Object)DynamicObjectUtils.getLong((DynamicObject)row, (String)"billid"));
                selectedRow.setEntryEntityKey(entryEntity);
                selectedRow.setEntryPrimaryKeyValue((Object)DynamicObjectUtils.getLong((DynamicObject)row, (String)"entryid"));
                selectedRows.add(selectedRow);
            }
            DrawArgs args = new DrawArgs();
            args.setSourceEntityNumber(sourceEntity);
            args.setTargetEntityNumber(targetEntity);
            args.addCustomParam("botp_requiredatamutex", String.valueOf(true));
            args.getSelectedRows().addAll(selectedRows);
            args.setTargetPageId(this.getView().getPageId());
            args.setRuleId("1170867801737500672");
            args.setBuildConvReport(true);
            ConvertOperationResult result = this.draw(args);
            if (!result.isSuccess() || result.getCachePageIds().size() == 0) {
                Push.showReport((IFormView)this.getView(), (AbstractConvertServiceArgs)args, (ConvertOperationResult)result);
            } else {
                IBillView billView = (IBillView)this.getView();
                IRefrencedataProvider refProvider = BusinessDataReader::loadRefence;
                List dataEntities = result.loadTargetDataObjects(refProvider, billView.getModel().getDataEntityType());
                this.addReleaseSourceDataMutexPlugin((IFormView)billView, result);
                ((IBillModel)billView.getModel()).push(dataEntities.get(0));
                billView.updateView();
                this.getView().sendFormAction((IFormView)billView);
                result.release(refProvider, billView.getModel().getDataEntityType());
            }
        }
        catch (Exception ex) {
            NotificationUtil.showDefaultTipNotify((String)ex.getMessage(), (IFormView)this.getView());
        }
    }

    private ConvertOperationResult draw(DrawArgs args) {
        String argsJson = SerializationUtils.toJsonString((Object)args);
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)args.getSourceEntityNumber());
        String resultStr = (String)DispatchServiceHelper.invokeBOSService((String)dt.getAppId(), (String)ConvertService.class.getSimpleName(), (String)"draw", (Object[])new Object[]{argsJson});
        return (ConvertOperationResult)SerializationUtils.fromJsonString((String)resultStr, ConvertOperationResult.class);
    }

    private void addReleaseSourceDataMutexPlugin(IFormView billView, ConvertOperationResult drawResult) {
        boolean exist = false;
        String plugInName = ReleaseConvertDataMutexPlugin.class.getName();
        for (Plugin plugin : billView.getFormShowParameter().getFormConfig().getPlugins()) {
            if (!StringUtils.equals((CharSequence)plugin.getClassName(), (CharSequence)plugInName)) continue;
            exist = true;
            break;
        }
        if (!exist) {
            billView.getFormShowParameter().addCustPlugin(plugInName);
            billView.cacheFormShowParameter();
        }
        ReleaseConvertDataMutexPlugin.addConvertDataMutex((IFormView)billView, (String)drawResult.getSourceEntityNumber(), (Collection)drawResult.getDataMutexSrcBillIds());
    }
}

